/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util.asn1;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.faceless.util.asn1.ASN1InputStream;
import org.faceless.util.asn1.ASN1Object;

public class ASN1String
extends ASN1Object {
    private static final long serialVersionUID = 1024092566983673736L;
    private final byte[] a;
    private final int b;
    private static String c;
    private static String d;
    private static String e;

    public ASN1String(Calendar calendar, boolean bl) {
        String string;
        Calendar calendar2 = Calendar.getInstance(new SimpleTimeZone(0, "UTC"));
        calendar2.setTime(calendar.getTime());
        int n2 = calendar2.get(1);
        int n3 = calendar2.get(2) + 1;
        int n4 = calendar2.get(5);
        int n5 = calendar2.get(11);
        int n6 = calendar2.get(12);
        int n7 = calendar2.get(13);
        DecimalFormat decimalFormat = new DecimalFormat("00");
        if (bl) {
            string = decimalFormat.format(n2 % 100) + decimalFormat.format(n3) + decimalFormat.format(n4) + decimalFormat.format(n5) + decimalFormat.format(n6) + decimalFormat.format(n7) + "Z";
        } else {
            string = decimalFormat.format(n2) + decimalFormat.format(n3) + decimalFormat.format(n4) + decimalFormat.format(n5) + decimalFormat.format(n6) + decimalFormat.format(n7);
            int n8 = calendar2.get(14);
            if (n8 != 0) {
                String string2 = decimalFormat.format(n8);
                while (string2.endsWith("0")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                string = string + "." + string2;
            }
            string = string + "Z";
        }
        try {
            this.a = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.b = 23;
    }

    public ASN1String(BitSet bitSet) {
        int n2;
        this.a = new byte[(bitSet.length() + 7 >> 3) + 1];
        this.b = 3;
        this.a[0] = (byte)((8 - bitSet.length() % 8) % 8);
        int n3 = n2 = bitSet.length() - 1;
        while (true) {
            block3: {
                if (n3 < 0) break;
                if (!bitSet.get(n3)) break block3;
                int n4 = (n2 - n3 >> 3) + 1;
                int n5 = 7 - (n2 - n3 & 7);
                int n6 = n4;
                this.a[n6] = (byte)(this.a[n6] | 1 << n5);
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ASN1String(String string, int n2) {
        int n3;
        char[] cArray;
        String string2;
        this.b = n2;
        if (n2 == 12) {
            try {
                this.a = string.getBytes("UTF-8");
                return;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        if (n2 == 30) {
            try {
                this.a = string.getBytes("UTF-16BE");
                return;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        if (n2 == 28) {
            try {
                this.a = string.getBytes("UTF-32");
                return;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        if (n2 == 22) {
            string2 = c;
        } else if (n2 == 26) {
            cArray = d.toCharArray();
            for (n3 = 0; n3 < 32; ++n3) {
                cArray[n3] = '\u0000';
            }
            string2 = new String(cArray);
        } else if (n2 == 18) {
            cArray = new char[256];
            for (n3 = 48; n3 <= 57; n3 = (int)((char)(n3 + 1))) {
                cArray[n3] = n3;
            }
            cArray[32] = 32;
            string2 = new String(cArray);
        } else if (n2 == 20 || n2 == 23 || n2 == 24 || n2 == 21) {
            string2 = e;
        } else {
            if (n2 != 19) {
                throw new IllegalArgumentException("Invalid type " + n2);
            }
            string2 = d;
        }
        this.a = new byte[string.length()];
        int i2 = 0;
        while (i2 < string.length()) {
            int n5;
            n3 = string.charAt(i2);
            int n4 = n5 = n3 == 0 ? 0 : string2.indexOf(n3);
            if (n5 < 0) {
                throw new IllegalArgumentException("Illegal character 0x" + Integer.toHexString(n3));
            }
            this.a[i2] = (byte)n5;
            ++i2;
        }
        return;
    }

    public ASN1String(byte[] byArray) {
        this(byArray, 4);
    }

    private ASN1String(byte[] byArray, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.a = (byte[])byArray.clone();
        this.b = n2;
    }

    public int getType() {
        return this.b;
    }

    int b() {
        return this.a.length;
    }

    void a(OutputStream outputStream) throws IOException {
        outputStream.write(this.a, 0, this.a.length);
    }

    static ASN1Object a(ASN1InputStream aSN1InputStream, int n2, int n3) throws IOException {
        byte[] byArray = new byte[n2];
        aSN1InputStream.readFully(byArray, 0, n2);
        return new ASN1String(byArray, n3);
    }

    public byte[] getBytes() {
        return (byte[])this.a.clone();
    }

    public ASN1Object getEncodedObject() {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(this.a);
            ASN1Object aSN1Object = aSN1InputStream.readObject();
            aSN1InputStream.close();
            return aSN1Object;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public BitSet getBitSet() {
        if (this.b == 3) {
            int n2 = (this.a.length - 1) * 8 - this.a[0];
            BitSet bitSet = new BitSet(n2);
            for (int i2 = n2; i2 >= 0; --i2) {
                int n3 = (n2 - i2 >> 3) + 1;
                int n4 = 7 - (n2 - i2 & 7);
                if ((this.a[n3] & 1 << n4) == 0) continue;
                bitSet.set(i2);
                continue;
            }
            return bitSet;
        }
        throw new IllegalStateException("Not a BITSTRING");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Calendar getCalendar() {
        if (this.b != 23 && this.b != 24) {
            throw new IllegalStateException("Not a UTCTime or GeneralizedTime");
        }
        String string = this.toString();
        if (this.b == 23) {
            char c2 = string.charAt(0);
            string = (c2 == '7' || c2 == '8' || c2 == '9' ? "19" : "20") + string;
        }
        Object var2_3 = null;
        int n2 = string.length();
        if (string.endsWith("Z")) {
            SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
            string = string.substring(0, n2 - 1);
        } else if (string.charAt(n2 - 5) == '+' || string.charAt(n2 - 5) == '-') {
            int n3 = (Integer.parseInt(string.substring(n2 - 4, n2 - 2)) * 60 + Integer.parseInt(string.substring(n2 - 2, n2))) * (string.charAt(n2 - 5) == '-' ? -1 : 1);
            SimpleTimeZone simpleTimeZone = new SimpleTimeZone(n3 * 60000, "ZZZ");
            string = string.substring(0, n2 - 5);
        } else {
            if (this.b == 23) {
                throw new IllegalStateException("No Timezone on UTCTime \"" + string + "\"");
            }
            TimeZone timeZone = TimeZone.getDefault();
        }
        float f2 = 0.0f;
        if (this.b == 24 && (string.indexOf(".") >= 0 || string.indexOf(",") >= 0)) {
            int n4 = Math.max(string.indexOf("."), string.indexOf(","));
            f2 = Float.parseFloat("0" + string.substring(n4));
            string = string.substring(0, n4);
        }
        if (string.length() == 12) {
            string = string + "00";
        }
        try {
            void var2_7;
            Date date = new SimpleDateFormat("yyyyMMddHHmmss").parse(string);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.setTimeZone((TimeZone)var2_7);
            calendar.set(14, Math.round(f2 * 1000.0f));
            return calendar;
        }
        catch (ParseException parseException) {
            throw (IllegalArgumentException)new IllegalArgumentException("Can't parse " + this.toString() + " (" + string + ")").initCause(parseException);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getString() {
        block35: {
            if (this.b != 22 && this.b != 19 && this.b != 23 && this.b != 18 && this.b != 26) {
                try {
                    if (this.b == 24) {
                    }
                    break block35;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw unsupportedEncodingException;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw unsupportedEncodingException;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw unsupportedEncodingException;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw unsupportedEncodingException;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw unsupportedEncodingException;
                }
            }
            try {
                return new String(this.a, 0, this.a.length, "US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
        }
        if (this.b == 12) {
            try {
                return new String(this.a, 0, this.a.length, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        if (this.b == 30) {
            try {
                return new String(this.a, 0, this.a.length, "UTF-16BE");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        if (this.b == 28) {
            try {
                return new String(this.a, 0, this.a.length, "UTF-32");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        if (this.b == 20) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (true) {
                if (n2 >= this.a.length) {
                    return stringBuffer.toString();
                }
                stringBuffer.append(e.charAt(this.a[n2] & 0xFF));
                ++n2;
            }
        }
        try {
            return new String(this.a, 0, this.a.length, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        if (this.b == 4 || this.b == 3) {
            StringBuffer stringBuffer = new StringBuffer(this.a.length * 2 + 1);
            stringBuffer.append('#');
            int n2 = 0;
            while (true) {
                if (n2 >= this.a.length) {
                    return stringBuffer.toString();
                }
                if ((this.a[n2] & 0xF0) == 0) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(Integer.toHexString(this.a[n2] & 0xFF));
                ++n2;
            }
        }
        if (this.b != 22 && this.b != 19 && this.b != 23 && this.b != 18 && this.b != 26 && this.b != 24 && this.b != 12 && this.b != 20 && this.b != 30 && this.b != 28) {
            return "<string" + this.b + ">";
        }
        return this.getString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (object instanceof ASN1String) {
            if (!Arrays.equals(((ASN1String)object).a, this.a)) return false;
            if (((ASN1String)object).b != this.b) return false;
            return true;
        }
        if (object instanceof String) {
            return object.equals(this.toString());
        }
        if (!(object instanceof byte[])) return false;
        return Arrays.equals(this.a, (byte[])object);
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            n2 = 31 * n2 + this.a[i2];
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        int n2;
        e = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"\u0000\u0000%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\u0000]\u0000_\u0000abcdefghijklmnopqrstuvwxyz\u0000|\u0000\u0000\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3$\u00a5#\u00a7\u00a4\u0000\u0000\u00ab\u0000\u0000\u0000\u0000\u00b0\u00b1\u00b2\u00b3\u00d7\u00b5\u00b6\u00b7\u00f7\u0000\u0000\u00bb\u00bc\u00bd\u00be\u00bf\u0000\u0300\u0301\u0302\u0303\u0304\u0306\u0307\u0308\u0000\u030a\u0327\u0332\u030b\u0328\u030c\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u2126\u00c6\u00d0\u00aa\u0126\u0000\u0132\u013f\u0141\u00d8\u0152\u00ba\u00de\u0166\u014a\u0149\u0138\u00e6\u0111\u00f0\u0127\u0131\u0133\u0140\u0142\u00f8\u0153\u00df\u00fe\u0167\u014b\u0000";
        char[] cArray = new char[256];
        for (n2 = 0; n2 < 128; n2 = (int)((char)(n2 + 1))) {
            if ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 '()+,-./:=?".indexOf(n2) < 0) continue;
            cArray[n2] = n2;
        }
        d = new String(cArray);
        n2 = 0;
        while (true) {
            if (n2 >= 128) {
                c = new String(cArray);
                return;
            }
            cArray[n2] = n2;
            n2 = (char)(n2 + 1);
        }
    }
}

