/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util.asn1;

import org.faceless.util.asn1.ASN1Object;
import org.faceless.util.asn1.ASN1Oid;
import org.faceless.util.asn1.ASN1Sequence;
import org.faceless.util.asn1.ASN1String;
import org.faceless.util.asn1.ASN1TaggedObject;
import org.faceless.util.asn1.EnvelopedData;
import org.faceless.util.asn1.SignedData;
import org.faceless.util.asn1.TSTInfo;

public class ContentInfo
extends ASN1Sequence {
    private static final long serialVersionUID = -6367633499409775315L;

    public static ContentInfo getInstance(ASN1Object aSN1Object) {
        return aSN1Object instanceof ContentInfo ? (ContentInfo)aSN1Object : new ContentInfo(aSN1Object);
    }

    private ContentInfo(ASN1Object aSN1Object) {
        super(((ASN1Sequence)aSN1Object).values);
    }

    public ContentInfo(ASN1Oid aSN1Oid, ASN1Object aSN1Object) {
        this.add(aSN1Oid);
        if (aSN1Object != null) {
            this.add(new ASN1TaggedObject(0, true, aSN1Object));
        }
    }

    public ASN1Oid getContentType() {
        return (ASN1Oid)this.get(0);
    }

    public ASN1Object getContent() {
        if (this.size() > 1) {
            ASN1Oid aSN1Oid = (ASN1Oid)this.get(0);
            ASN1Object aSN1Object = ((ASN1TaggedObject)this.get(1)).get();
            if (aSN1Oid.equals(ASN1Oid.SIGNEDDATA)) {
                return SignedData.a(aSN1Object);
            }
            if (aSN1Oid.equals(ASN1Oid.ENVELOPEDDATA)) {
                return EnvelopedData.a(aSN1Object);
            }
            if (aSN1Oid.equals(ASN1Oid.ID_CT_TSTINFO)) {
                return TSTInfo.a(((ASN1String)aSN1Object).getEncodedObject());
            }
            return aSN1Object;
        }
        return null;
    }
}

