/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util.asn1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import org.faceless.util.asn1.ASN1InputStream;
import org.faceless.util.asn1.ASN1Integer;
import org.faceless.util.asn1.ASN1Object;
import org.faceless.util.asn1.ASN1Oid;
import org.faceless.util.asn1.ASN1Sequence;
import org.faceless.util.asn1.ASN1Set;
import org.faceless.util.asn1.ASN1TaggedObject;
import org.faceless.util.asn1.ContentInfo;
import org.faceless.util.asn1.SignerInfo;
import org.faceless.util.asn1.a;

public class SignedData
extends ASN1Sequence {
    private static final long serialVersionUID = -4675973710673906398L;
    private static CertificateFactory a;
    private X509Certificate[] b;

    static SignedData a(ASN1Object aSN1Object) {
        SignedData signedData = aSN1Object instanceof SignedData ? (SignedData)aSN1Object : new SignedData(aSN1Object);
        return signedData;
    }

    private SignedData(ASN1Object aSN1Object) {
        super(((ASN1Sequence)aSN1Object).values);
    }

    public SignedData(ContentInfo contentInfo, X509Certificate[] x509CertificateArray, X509CRL[] x509CRLArray, SignerInfo signerInfo) throws CertificateEncodingException, CRLException {
        this(contentInfo, x509CertificateArray, x509CRLArray, new SignerInfo[]{signerInfo});
    }

    public SignedData(ContentInfo contentInfo, X509Certificate[] x509CertificateArray, X509CRL[] x509CRLArray, SignerInfo[] signerInfoArray) throws CertificateEncodingException, CRLException {
        block17: {
            int n2;
            block16: {
                ArrayList<ASN1Sequence> arrayList = new ArrayList<ASN1Sequence>();
                for (int i2 = 0; i2 < signerInfoArray.length; ++i2) {
                    n2 = 0;
                    for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                        ASN1Sequence aSN1Sequence = (ASN1Sequence)arrayList.get(i3);
                        int n3 = aSN1Sequence.get(0) == signerInfoArray[i2].getDigestAlgorithm() ? 1 : 0;
                        n2 |= n3;
                    }
                    if (n2 != 0) continue;
                    arrayList.add(new ASN1Sequence(signerInfoArray[i2].getDigestAlgorithm(), NULL));
                    continue;
                }
                this.add(new ASN1Integer(SignedData.a(x509CertificateArray, x509CRLArray, contentInfo, signerInfoArray)));
                this.add(new ASN1Set(arrayList));
                this.add(contentInfo);
                if (x509CertificateArray == null || x509CertificateArray.length <= 0) break block16;
                ASN1Object[] aSN1ObjectArray = new a[x509CertificateArray.length];
                for (n2 = 0; n2 < x509CertificateArray.length; ++n2) {
                    aSN1ObjectArray[n2] = new a(x509CertificateArray[n2].getEncoded());
                }
                this.add(new ASN1TaggedObject(0, false, new ASN1Set(aSN1ObjectArray)));
                this.b = (X509Certificate[])x509CertificateArray.clone();
            }
            if (x509CRLArray == null || x509CRLArray.length <= 0) break block17;
            ASN1Object[] aSN1ObjectArray = new a[x509CertificateArray.length];
            for (n2 = 0; n2 < x509CRLArray.length; ++n2) {
                aSN1ObjectArray[n2] = new a(x509CRLArray[n2].getEncoded());
            }
            this.add(new ASN1TaggedObject(1, false, new ASN1Set(aSN1ObjectArray)));
        }
        this.add(new ASN1Set(signerInfoArray));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int a(X509Certificate[] x509CertificateArray, X509CRL[] x509CRLArray, ContentInfo contentInfo, SignerInfo[] signerInfoArray) throws CertificateEncodingException, CRLException {
        ASN1Object aSN1Object;
        ASN1InputStream aSN1InputStream;
        int n2;
        int n3 = 0;
        boolean bl = false;
        for (n2 = 0; x509CertificateArray != null && n2 < x509CertificateArray.length; ++n2) {
            try {
                aSN1InputStream = new ASN1InputStream(x509CertificateArray[n2].getEncoded());
                aSN1Object = aSN1InputStream.readObject();
                if (aSN1Object instanceof ASN1TaggedObject) {
                    n3 = Math.max(n3, ((ASN1TaggedObject)aSN1Object).getTag());
                }
                aSN1InputStream.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (n2 = 0; x509CRLArray != null && n2 < x509CRLArray.length; ++n2) {
            try {
                aSN1InputStream = new ASN1InputStream(x509CRLArray[n2].getEncoded());
                aSN1Object = aSN1InputStream.readObject();
                bl |= aSN1Object instanceof ASN1TaggedObject;
                aSN1InputStream.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (n3 == 3 || bl) {
            return 5;
        }
        if (n3 == 2) {
            return 4;
        }
        if (n3 == 1) {
            return 3;
        }
        if (contentInfo == null || !contentInfo.getContentType().equals(ASN1Oid.DATA)) {
            return 3;
        }
        n2 = 0;
        while (n2 < signerInfoArray.length) {
            if (signerInfoArray[n2].getVersion() == 3) {
                return 3;
            }
            ++n2;
        }
        return 1;
    }

    public int getVersion() {
        return ((ASN1Integer)this.get(0)).intValue();
    }

    public ASN1Set getDigestAlgorithms() {
        return (ASN1Set)this.get(1);
    }

    public ContentInfo getContentInfo() {
        return ContentInfo.getInstance(this.get(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized X509Certificate getCertificate(int n2) throws CertificateException {
        ASN1Object aSN1Object;
        if (n2 < 0) throw new ArrayIndexOutOfBoundsException(Integer.toString(n2));
        if (n2 > this.getNumCertificates()) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(n2));
        }
        if (this.b[n2] != null) return this.b[n2];
        ASN1Set aSN1Set = this.getTaggedObject(0).getImplicitSet();
        if (aSN1Set == null) {
            throw new IllegalArgumentException("No Certificates");
        }
        if (this.b == null) {
            this.b = new X509Certificate[aSN1Set.size()];
        }
        do {
            if ((aSN1Object = aSN1Set.get(n2)) instanceof ASN1Sequence) continue;
            aSN1Object = null;
            ++n2;
        } while (aSN1Object == null);
        Class<SignedData> clazz = SignedData.class;
        // MONITORENTER : org.faceless.util.asn1.SignedData.class
        if (a == null) {
            a = CertificateFactory.getInstance("X.509");
        }
        // MONITOREXIT : clazz
        this.b[n2] = (X509Certificate)a.generateCertificate(new ByteArrayInputStream(aSN1Object.getEncoded()));
        return this.b[n2];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int getNumCertificates() {
        if (this.b == null) {
            int n2 = 0;
            ASN1Set aSN1Set = this.getTaggedObject(0).getImplicitSet();
            for (int n3 = 0; n3 < aSN1Set.size(); ++n3) {
                if (!(aSN1Set.get(n3) instanceof ASN1Sequence)) continue;
                ++n2;
            }
            this.b = new X509Certificate[n2];
        }
        return this.b.length;
    }

    public int getNumCRLs() {
        ASN1Set aSN1Set = this.d();
        int n2 = aSN1Set == null ? 0 : aSN1Set.size();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509CRL getCRL(int n2) throws CertificateException, CRLException {
        ASN1Object aSN1Object = this.d().get(n2);
        Class<SignedData> clazz = SignedData.class;
        synchronized (SignedData.class) {
            if (a == null) {
                a = CertificateFactory.getInstance("X.509");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return (X509CRL)a.generateCRL(new ByteArrayInputStream(aSN1Object.getEncoded()));
        }
    }

    private ASN1Set d() {
        return this.getTaggedObject(1).getImplicitSet();
    }

    public int getNumSignerInfos() {
        ASN1Set aSN1Set = this.e();
        int n2 = aSN1Set == null ? 0 : aSN1Set.size();
        return n2;
    }

    private ASN1Set e() {
        return (ASN1Set)this.get(this.size() - 1);
    }

    public SignerInfo getSignerInfo(int n2) {
        return SignerInfo.a(this.e().get(n2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public X509Certificate getCertificate(SignerInfo signerInfo) throws CertificateException {
        X500Principal x500Principal = signerInfo.getIssuer();
        BigInteger bigInteger = signerInfo.getSerialNumber();
        int n2 = this.getNumCertificates();
        int i2 = 0;
        while (i2 < n2) {
            X509Certificate x509Certificate = this.getCertificate(i2);
            if (x509Certificate.getSerialNumber().equals(bigInteger) && x509Certificate.getIssuerX500Principal().equals(x500Principal)) {
                return x509Certificate;
            }
            ++i2;
        }
        return null;
    }

    public String toString() {
        try {
            return "{signedData: version=" + this.getVersion() + " algos=" + this.getDigestAlgorithms() + " certs=" + this.getNumCertificates() + "=" + this.getCertificate(0) + " crls=" + this.d() + " si=" + this.getSignerInfo(0) + "}";
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

