/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util.asn1;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import org.faceless.util.asn1.ASN1Boolean;
import org.faceless.util.asn1.ASN1Integer;
import org.faceless.util.asn1.ASN1Object;
import org.faceless.util.asn1.ASN1Oid;
import org.faceless.util.asn1.ASN1Sequence;
import org.faceless.util.asn1.ASN1Set;
import org.faceless.util.asn1.ASN1String;
import org.faceless.util.asn1.TimeStampRequest;

public class TSTInfo
extends ASN1Sequence {
    private static final long serialVersionUID = -8144918689286583665L;

    static TSTInfo a(ASN1Object aSN1Object) {
        return aSN1Object instanceof TSTInfo ? (TSTInfo)aSN1Object : new TSTInfo(aSN1Object);
    }

    private TSTInfo(ASN1Object aSN1Object) {
        super(((ASN1Sequence)aSN1Object).values);
    }

    public int getVersion() {
        return ((ASN1Integer)this.get(0)).intValue();
    }

    public ASN1Oid getPolicy() {
        return (ASN1Oid)this.get(1);
    }

    public ASN1Oid getAlgorithm() {
        return (ASN1Oid)this.getSequence(2).getSequence(0).get(0);
    }

    public byte[] getDigest() {
        return ((ASN1String)this.getSequence(2).get(1)).getBytes();
    }

    public BigInteger getSerialNumber() {
        return ((ASN1Integer)this.get(3)).get();
    }

    public Calendar getTime() {
        return ((ASN1String)this.get(4)).getCalendar();
    }

    public boolean getOrdering() {
        for (int i2 = 5; i2 < this.size(); ++i2) {
            if (!(this.get(i2) instanceof ASN1Boolean)) continue;
            return this.get(i2) == ASN1Boolean.TRUE;
        }
        return false;
    }

    public BigInteger getNonce() {
        for (int i2 = 5; i2 < this.size(); ++i2) {
            if (!(this.get(i2) instanceof ASN1Integer)) continue;
            return ((ASN1Integer)this.get(i2)).get();
        }
        return null;
    }

    public String getTSA() {
        ASN1String aSN1String = (ASN1String)this.getTaggedObject(0).get();
        return aSN1String == null ? null : aSN1String.toString();
    }

    public ASN1Set getExtensions() {
        return this.getTaggedObject(1).getImplicitSet();
    }

    public boolean matches(TimeStampRequest timeStampRequest) {
        return this.getAlgorithm().equals(timeStampRequest.getAlgorithm()) && Arrays.equals(this.getDigest(), timeStampRequest.getDigest()) && (timeStampRequest.getNonce() == null ? this.getNonce() == null : timeStampRequest.getNonce().equals(this.getNonce())) && (timeStampRequest.getPolicy() == null || timeStampRequest.getPolicy().equals(this.getPolicy()));
    }
}

