/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util.dom;

import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.faceless.util.dom.NDocument;
import org.faceless.util.dom.NNode;
import org.faceless.util.dom.NText;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class NElement
extends NNode {
    private final Element b;

    NElement(NDocument nDocument, Element element) {
        super(nDocument);
        this.b = element;
    }

    Node a() {
        return this.b;
    }

    public String getName() {
        return this.b.getNodeName();
    }

    public String getLocalName() {
        String string = this.b.getLocalName();
        return string == null || string.length() == 0 ? this.getName() : string;
    }

    public String getTextDescendents() {
        StringBuffer stringBuffer = null;
        for (Node node = this.b.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Text)) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append(node.getNodeValue());
        }
        return stringBuffer == null ? null : stringBuffer.toString();
    }

    public String getAttribute(String string) {
        Attr attr = this.b.getAttributeNode(string);
        return attr == null ? null : attr.getValue();
    }

    public Map getAttributes() {
        final NamedNodeMap namedNodeMap = this.b.getAttributes();
        return new AbstractMap(){

            public Set entrySet() {
                return new AbstractSet(){

                    public int size() {
                        return namedNodeMap.getLength();
                    }

                    public Iterator iterator() {
                        return new Iterator(){
                            int a;

                            public Object next() {
                                final Attr attr = (Attr)namedNodeMap.item(this.a++);
                                return new Map.Entry(){

                                    public Object getKey() {
                                        return attr.getName();
                                    }

                                    public Object getValue() {
                                        return attr.getValue();
                                    }

                                    public Object setValue(Object object) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }

                            public boolean hasNext() {
                                boolean bl = this.a < namedNodeMap.getLength();
                                return bl;
                            }

                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }
        };
    }

    public String getAttribute(String string, String string2) {
        Attr attr = this.b.getAttributeNodeNS(string, string2);
        return attr == null ? null : attr.getValue();
    }

    public void setAttribute(String string, String string2) {
        if (string2 == null) {
            this.b.removeAttribute(string);
        } else {
            this.b.setAttribute(string, string2);
        }
    }

    public void setAttribute(String string, String string2, String string3) {
        if (string3 == null) {
            this.b.removeAttributeNS(string, string2);
        } else {
            this.b.setAttributeNS(string, string2, string3);
        }
    }

    public String getURI() {
        return this.b.getNamespaceURI();
    }

    public String getPrefix() {
        return this.b.getPrefix();
    }

    public List getChildren() {
        return new e_(new Matcher(){

            public boolean matches(NNode nNode) {
                return true;
            }
        });
    }

    public List getChildren(Matcher matcher) {
        return new e_(matcher);
    }

    public List getElements(final String string) {
        return new e_(new Matcher(){

            public boolean matches(NNode nNode) {
                return nNode instanceof NElement && ((NElement)nNode).getName().equals(string);
            }
        });
    }

    public List getElements() {
        return new e_(new Matcher(){

            public boolean matches(NNode nNode) {
                return nNode instanceof NElement;
            }
        });
    }

    public List getDescendentElements(String string) {
        final NodeList nodeList = this.b.getElementsByTagName(string);
        return new AbstractList(){

            public int size() {
                return nodeList.getLength();
            }

            public Object get(int n2) {
                return NElement.this.a.a(nodeList.item(n2));
            }
        };
    }

    public int size() {
        return this.b.getChildNodes().getLength();
    }

    public NElement getElement(int n2) {
        return (NElement)this.getChildren().get(n2);
    }

    public NText getText(int n2) {
        return (NText)this.getChildren().get(n2);
    }

    public int getIndex() {
        Node node = this.b.getParentNode();
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                if (nodeList.item(i2) != this.b) continue;
                return i2;
            }
        }
        return -1;
    }

    public NElement getFirstElement() {
        Node node;
        for (node = this.b.getFirstChild(); node != null && !(node instanceof Element); node = node.getNextSibling()) {
        }
        return (NElement)(node == null ? null : this.a.a(node));
    }

    public NElement getLastElement() {
        Node node;
        for (node = this.b.getLastChild(); node != null && !(node instanceof Element); node = node.getNextSibling()) {
        }
        return (NElement)(node == null ? null : this.a.a(node));
    }

    public Element getWrapped() {
        return this.b;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        if (this.getPrefix() != null) {
            stringBuffer.append(this.getPrefix() + ":");
        }
        stringBuffer.append(this.getName());
        NamedNodeMap namedNodeMap = this.b.getAttributes();
        if (namedNodeMap.getLength() > 0) {
            for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                Attr attr = (Attr)namedNodeMap.item(i2);
                if (attr.getPrefix() != null) {
                    stringBuffer.append(attr.getPrefix() + ":");
                }
                stringBuffer.append(" ");
                stringBuffer.append(attr.getNodeName());
                stringBuffer.append("=\"");
                stringBuffer.append(attr.getNodeValue());
                stringBuffer.append("\"");
            }
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    private final class e_
    extends AbstractList {
        private final NodeList a;
        private final Matcher b;

        e_(Matcher matcher) {
            this.a = NElement.this.b.getChildNodes();
            this.b = matcher;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean a(NNode nNode) {
            if (nNode == null) return false;
            if (!this.b.matches(nNode)) return false;
            return true;
        }

        public int size() {
            int n2 = 0;
            for (int i2 = 0; i2 < this.a.getLength(); ++i2) {
                Node node = this.a.item(i2);
                NNode nNode = NElement.this.a.a(node);
                if (!this.a(nNode)) continue;
                ++n2;
                continue;
            }
            return n2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object get(int n2) {
            int n3 = n2;
            if (n2 < 0) {
                throw new ArrayIndexOutOfBoundsException(n2);
            }
            int i2 = 0;
            while (true) {
                if (i2 >= this.a.getLength()) {
                    throw new ArrayIndexOutOfBoundsException(n3);
                }
                Node node = this.a.item(i2);
                NNode nNode = NElement.this.a.a(node);
                if (this.a(nNode) && n2-- == 0) {
                    return nNode;
                }
                ++i2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object set(int n2, Object object) {
            int i2 = 0;
            while (true) {
                if (i2 >= this.a.getLength()) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                Node node = this.a.item(i2);
                NNode nNode = NElement.this.a.a(node);
                if (this.a(nNode) && n2-- == 0) {
                    NElement.this.b.replaceChild(node, ((NNode)object).a());
                    return nNode;
                }
                ++i2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void add(int n2, Object object) {
            int i2 = 0;
            while (true) {
                if (i2 >= this.a.getLength()) {
                    if (n2 != 0) throw new ArrayIndexOutOfBoundsException();
                    NElement.this.b.appendChild(((NNode)object).a());
                    return;
                }
                Node node = this.a.item(i2);
                NNode nNode = NElement.this.a.a(node);
                if (this.a(nNode) && n2-- == 0) {
                    NElement.this.b.insertBefore(((NNode)object).a(), node);
                }
                ++i2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object remove(int n2) {
            int i2 = 0;
            while (true) {
                if (i2 >= this.a.getLength()) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                Node node = this.a.item(i2);
                NNode nNode = NElement.this.a.a(node);
                if (this.a(nNode) && n2-- == 0) {
                    NElement.this.b.removeChild(node);
                    return nNode;
                }
                ++i2;
            }
        }
    }

    public static interface Matcher {
        public boolean matches(NNode var1);
    }
}

