/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.graph;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.faceless.graph.AxesGraph;
import org.faceless.graph.formatter.NullFormatter;
import org.faceless.graph.math.Curve;
import org.faceless.graph.math.FunctionCurve;

public abstract class AbstractLineGraph
extends AxesGraph {
    private SortedMap w;
    private double x;
    private double y;
    private double z;
    private double A;
    private double B;
    protected double minx;
    protected double maxx;
    protected double minval = Double.POSITIVE_INFINITY;
    protected double maxval;

    protected AbstractLineGraph() {
        this.y = Double.POSITIVE_INFINITY;
        this.minx = Double.POSITIVE_INFINITY;
        this.maxval = Double.NEGATIVE_INFINITY;
        this.z = Double.NEGATIVE_INFINITY;
        this.maxx = Double.NEGATIVE_INFINITY;
        this.w = new TreeMap();
        this.optionCurveDepth(1.0);
        this.optionFunctionSmoothness(30.0);
        this.optionMaxDataPoints(100);
        this.optionZFormatter(new NullFormatter());
        this.setPieEdgeDegrees(30.0);
    }

    public void setCurve(String string, Curve curve, Color color) {
        this.w.put(new Integer(this.key.setKey(string, color)), curve);
    }

    public void setCurve(String string, Curve curve) {
        this.w.put(new Integer(this.key.find(string)), curve);
    }

    public void optionMinX(double d2) {
        this.y = d2;
    }

    public void optionMaxX(double d2) {
        this.z = d2;
    }

    public void optionFunctionSmoothness(double d2) {
        this.A = d2;
    }

    public void optionMaxDataPoints(int n2) {
        this.B = n2;
    }

    public void optionCurveDepth(double d2) {
        this.x = d2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private double[] f() {
        double d2;
        TreeSet<Double> treeSet = new TreeSet<Double>();
        TreeSet<Double> treeSet2 = new TreeSet<Double>();
        boolean bl = false;
        Iterator<Object> iterator = this.w.keySet().iterator();
        double d3 = this.y;
        double d4 = this.z;
        while (iterator.hasNext()) {
            double[] dArray;
            Curve curve = (Curve)this.w.get(iterator.next());
            d3 = Math.min(d3, curve.getMin());
            d4 = Math.max(d4, curve.getMax());
            if (curve instanceof FunctionCurve) {
                bl = true;
            }
            if ((dArray = curve.steps()).length == 0) {
                this.xfloat = true;
            }
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                if (Math.floor(dArray[i2]) != dArray[i2]) {
                    this.xfloat = true;
                }
                treeSet.add(new Double(dArray[i2]));
                treeSet2.add(new Double(dArray[i2]));
            }
        }
        if (Double.isInfinite(d3) || Double.isInfinite(d4)) {
            if (bl) {
                throw new IllegalStateException("Can't plot graph over infinite range - must set MinX and MaxX");
            }
            return new double[0];
        }
        double d5 = 1.0 / ((double)treeSet.size() / this.B - 1.0) + 1.0;
        ArrayList arrayList = new ArrayList(treeSet);
        for (d2 = d5 / 2.0; d2 < (double)arrayList.size() && (double)treeSet.size() > this.B; d2 += d5) {
            treeSet.remove(arrayList.get((int)Math.round(d2)));
        }
        treeSet2.add(new Double(d3));
        treeSet2.add(new Double(d4));
        treeSet.add(new Double(d3));
        treeSet.add(new Double(d4));
        if (bl) {
            d2 = (d4 - d3) / this.A;
            int n2 = 1;
            while ((double)n2 < this.A) {
                treeSet.add(new Double(d3 + (double)n2 * d2));
                ++n2;
            }
        }
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        iterator = treeSet.iterator();
        Double d6 = null;
        while (iterator.hasNext()) {
            Double d7 = (Double)iterator.next();
            if (d6 == null) {
                d6 = d7;
                arrayList2.add(d7);
                continue;
            }
            double d8 = d7 - d6;
            double d9 = d8 / (d4 - d3);
            if (d9 >= 0.001 || d9 < -0.001) {
                arrayList2.add(d7);
                d6 = d7;
                continue;
            }
            boolean bl2 = treeSet2.contains(d7);
            boolean bl3 = treeSet2.contains(d6);
            if (bl2 && !bl3) {
                arrayList2.set(arrayList2.size() - 1, d7);
                continue;
            }
            if (!bl2 || !bl3) continue;
            arrayList2.add(d7);
        }
        double[] dArray = new double[arrayList2.size()];
        int n3 = 0;
        while (n3 < dArray.length) {
            dArray[n3] = (Double)arrayList2.get(n3);
            ++n3;
        }
        return dArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void a(Map map) {
        super.complete();
        double[] dArray = this.f();
        if (this.w.size() == 0 || dArray.length == 0) {
            return;
        }
        double d2 = this.a(dArray[0], dArray[dArray.length - 1]);
        double[] dArray2 = new double[dArray.length];
        for (int i2 = 0; i2 < dArray2.length; ++i2) {
            dArray2[i2] = Double.NaN;
        }
        this.minx = dArray[0];
        this.maxx = dArray[dArray.length - 1];
        Iterator iterator = this.w.keySet().iterator();
        while (true) {
            double[] dArray3;
            Curve curve;
            Integer n2;
            if (iterator.hasNext()) {
                n2 = (Integer)iterator.next();
                curve = (Curve)this.w.get(n2);
                dArray3 = new double[dArray.length];
            } else {
                if (!Double.isInfinite(this.absoluteminy)) {
                    this.minval = this.absoluteminy;
                }
                if (!Double.isInfinite(this.absolutemaxy)) {
                    this.maxval = this.absolutemaxy;
                }
                this.postDrawLines();
                if (!Double.isInfinite(this.minval)) {
                    this.axesminy = new Double(this.minval);
                }
                if (!Double.isInfinite(this.maxval)) {
                    this.axesmaxy = new Double(this.maxval);
                }
                this.axesminx = new Double(this.minx);
                this.axesmaxx = new Double(this.maxx);
                this.axesmaxz = new Double(0.0);
                this.axesminz = new Double(-d2);
                return;
            }
            for (int n3 = 0; n3 < dArray.length; ++n3) {
                double d3 = this.plotLine(n2, curve, n3 == 0 ? Double.NaN : dArray2[n3 - 1], dArray2[n3], n3 == 0 ? Double.NaN : dArray[n3 - 1], dArray[n3], d2, n3 == dArray.length - 1, map);
                if (!Double.isNaN(d3)) {
                    this.minval = Math.min(this.minval, d3);
                    this.maxval = Math.max(this.maxval, d3);
                    if (Math.floor(d3) != d3) {
                        this.yfloat = true;
                    }
                }
                dArray3[n3] = d3;
            }
            dArray2 = dArray3;
        }
    }

    protected void postDrawLines() {
    }

    private double a(double d2, double d3) {
        return Math.abs((d3 - d2) * 0.05 * this.x);
    }

    protected abstract double plotLine(int var1, Curve var2, double var3, double var5, double var7, double var9, double var11, boolean var13, Map var14);
}

