/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.graph;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import org.faceless.graph.BoundingBox;
import org.faceless.graph.Graph;
import org.faceless.graph.Point;
import org.faceless.graph.Style;
import org.faceless.graph.b;
import org.faceless.graph.e;
import org.faceless.graph.f;
import org.faceless.graph.formatter.FloatingPointFormatter;
import org.faceless.graph.formatter.Formatter;
import org.faceless.graph.formatter.IntegerFormatter;
import org.faceless.graph.g;
import org.faceless.graph.h;
import org.faceless.graph.l;
import org.faceless.graph.m;
import org.faceless.graph.n;
import org.faceless.util.PaintMixer;

public abstract class AxesGraph
extends Graph {
    private g n;
    private g o;
    protected Double axesminx = null;
    protected Double axesmaxx = null;
    protected Double axesminy = null;
    protected Double axesmaxy = null;
    protected Double axesminz = null;
    protected Double axesmaxz = null;
    protected double absolutemaxy;
    protected double absoluteminy;
    protected b data = new b();
    protected Style axesstyle;
    protected Style zwallstyle;
    protected Style ywallstyle;
    protected Style xwallstyle;
    protected Style yaxestextstyle;
    protected Style xaxestextstyle;
    protected Style zaxestextstyle;
    protected Style xaxeslabelstyle;
    protected Style yaxeslabelstyle;
    protected Style boxstyle;
    private boolean p;
    private boolean q;
    private boolean r;
    private boolean s;
    private boolean t;
    protected boolean zfloat = false;
    protected boolean yfloat = false;
    protected boolean xfloat = false;
    protected Formatter xformatter = null;
    protected Formatter yformatter = null;
    protected Formatter zformatter = null;
    private String u;
    private String v;

    protected AxesGraph() {
        Style style = new Style(Style.n);
        style.setLineThickness(1.0);
        this.optionAxisStyle(style);
        this.optionBoxColor(null);
        this.optionXAxisLabelStyle(new Style(Color.black, "Helvetica", 1, 10.0f));
        this.optionYAxisLabelStyle(new Style(Color.black, "Helvetica", 1, 10.0f));
        this.optionXAxisStyle(new Style(Color.black, "Helvetica", 0, 8.0f));
        this.optionYAxisStyle(new Style(Color.black, "Helvetica", 0, 8.0f));
        this.optionZAxisStyle(new Style(Color.black, "Helvetica", 0, 8.0f));
        this.optionFloorStyle(null);
        this.optionYWallStyle(null);
        this.optionZWallStyle(null);
        this.optionXAxisLabel("");
        this.optionYAxisLabel("");
        this.optionXAxisAtZero(false);
        this.optionYAxisAtZero(false);
        this.optionMinY(Double.NEGATIVE_INFINITY);
        this.optionMaxY(Double.POSITIVE_INFINITY);
        this.t = false;
        this.s = false;
        this.r = false;
    }

    public void optionXAxisLabel(String string) {
        this.u = string;
    }

    public void optionYAxisLabel(String string) {
        this.v = string;
    }

    public void optionXAxisLabelStyle(Style style) {
        this.xaxeslabelstyle = style == null ? null : style.a(this);
    }

    public void optionYAxisLabelStyle(Style style) {
        this.yaxeslabelstyle = style == null ? null : style.a(this);
    }

    public void optionXAxisAtZero(boolean bl) {
        this.q = bl;
    }

    public void optionYAxisAtZero(boolean bl) {
        this.p = bl;
    }

    public void optionXStretchToZero(boolean bl) {
        this.r = bl;
    }

    public void optionYStretchToZero(boolean bl) {
        this.s = bl;
    }

    public void optionFloorStyle(Style style) {
        this.xwallstyle = null;
        if (style != null) {
            this.xwallstyle = style.a(this);
            this.xwallstyle.setAlign(256);
            if (this.xwallstyle.a().allClear()) {
                this.xwallstyle.a().setAll();
            }
        }
    }

    public void optionYWallStyle(Style style) {
        this.ywallstyle = null;
        if (style != null) {
            this.ywallstyle = style.a(this);
            this.ywallstyle.setAlign(256);
            if (this.ywallstyle.a().allClear()) {
                this.ywallstyle.a().setAll();
            }
        }
    }

    public void optionZWallStyle(Style style) {
        this.zwallstyle = null;
        if (style != null) {
            this.zwallstyle = style.a(this);
            this.zwallstyle.setAlign(256);
            if (this.zwallstyle.a().allClear()) {
                this.zwallstyle.a().setAll();
            }
        }
    }

    public void optionXAxisStyle(Style style) {
        this.xaxestextstyle = style == null ? null : style.a(this);
    }

    public void optionYAxisStyle(Style style) {
        this.yaxestextstyle = style == null ? null : style.a(this);
    }

    public void optionZAxisStyle(Style style) {
        this.zaxestextstyle = style == null ? null : style.a(this);
    }

    public void optionYAxisTextRotation(double d2) {
        this.yaxestextstyle.setRotate(d2);
    }

    public void optionXAxisTextRotation(double d2) {
        this.xaxestextstyle.setRotate(d2);
    }

    public void optionXFormatter(Formatter formatter) {
        this.xformatter = formatter;
    }

    public void optionYFormatter(Formatter formatter) {
        this.yformatter = formatter;
    }

    public void optionZFormatter(Formatter formatter) {
        this.zformatter = formatter;
    }

    public void optionAxisStyle(Style style) {
        this.axesstyle = style == null ? null : style.a(this);
    }

    public void optionBoxColor(Color color) {
        this.boxstyle = color == null ? null : new Style(null, color).a(this);
    }

    public void optionMinY(double d2) {
        this.absoluteminy = d2;
    }

    public void optionMaxY(double d2) {
        this.absolutemaxy = d2;
    }

    protected void postcomplete() {
        Style style;
        int n2;
        double[] dArray;
        double[] dArray2;
        double d2;
        if (this.xaxeslabelstyle != null && this.xaxeslabelstyle.getAlign() == 0) {
            this.xaxeslabelstyle.setAlign(33);
        }
        if (this.yaxeslabelstyle != null && this.yaxeslabelstyle.getAlign() == 0) {
            this.yaxeslabelstyle.setAlign(33);
        }
        if (this.xaxestextstyle != null && this.xaxestextstyle.getAlign() == 0) {
            if (this.zrotation == 90.0) {
                this.xaxestextstyle.setAlign(18);
            } else if (this.xaxestextstyle.getRotate() < 20.0) {
                this.xaxestextstyle.setAlign(33);
            } else if (this.xaxestextstyle.getRotate() < 70.0) {
                this.xaxestextstyle.setAlign(9);
            } else {
                this.xaxestextstyle.setAlign(24);
            }
        }
        if (this.yaxestextstyle != null && this.yaxestextstyle.getAlign() == 0) {
            if (this.zrotation == 90.0) {
                this.yaxestextstyle.setAlign(36);
            } else if (this.yaxestextstyle.getRotate() < 20.0) {
                this.yaxestextstyle.setAlign(18);
            } else if (this.xaxestextstyle.getRotate() < 70.0) {
                this.yaxestextstyle.setAlign(6);
            } else {
                this.yaxestextstyle.setAlign(36);
            }
        }
        if (this.zaxestextstyle != null && this.zaxestextstyle.getAlign() == 0) {
            this.zaxestextstyle.setAlign(24);
        }
        if (this.axesminx == null) {
            this.axesminx = new Double(this.data.getMinX());
        }
        if (this.axesmaxx == null) {
            this.axesmaxx = new Double(this.data.getMaxX());
        }
        if (this.axesminy == null) {
            this.axesminy = new Double(this.data.getMinY());
        }
        if (this.axesmaxy == null) {
            this.axesmaxy = new Double(this.data.getMaxY());
        }
        if (this.axesminz == null) {
            this.axesminz = new Double(this.data.getMinZ());
        }
        if (this.axesmaxz == null) {
            this.axesmaxz = new Double(this.data.getMaxZ());
        }
        double d3 = this.r ? Math.min(0.0, this.axesminx) : this.axesminx;
        double d4 = this.r ? Math.max(0.0, this.axesmaxx) : this.axesmaxx;
        double d5 = this.s ? Math.min(0.0, this.axesminy) : this.axesminy;
        double d6 = this.s ? Math.max(0.0, this.axesmaxy) : this.axesmaxy;
        double d7 = this.t ? Math.min(0.0, this.axesminz) : this.axesminz;
        double d8 = d2 = this.t ? Math.max(0.0, this.axesmaxz) : this.axesmaxz;
        if (!Double.isInfinite(this.absolutemaxy)) {
            d6 = Math.max(this.absolutemaxy, d6);
        }
        if (d5 == d6) {
            d6 += 1.0;
        }
        if (d3 == d4) {
            d4 += 1.0;
        }
        if (d5 > d6) {
            throw new Error("MinY > MaxY!! miny=" + d5 + " maxy=" + d6);
        }
        if (d3 > d4) {
            throw new Error("MinX > MaxX!! minx=" + d3 + " maxx=" + d4);
        }
        IntegerFormatter integerFormatter = new IntegerFormatter();
        FloatingPointFormatter floatingPointFormatter = new FloatingPointFormatter();
        if (this.xformatter == null) {
            if (this instanceof AxesGraph) {
                this.xformatter = this.xfloat ? new FloatingPointFormatter() : new IntegerFormatter();
                this.xformatter.setFixedEnds(true);
            } else {
                Formatter formatter = this.xformatter = this.xfloat ? floatingPointFormatter : integerFormatter;
            }
        }
        if (this.yformatter == null) {
            Formatter formatter = this.yformatter = this.yfloat ? floatingPointFormatter : integerFormatter;
        }
        if (this.zformatter == null) {
            this.zformatter = this.zfloat ? floatingPointFormatter : integerFormatter;
        }
        double[] dArray3 = this.xformatter.steps(d3, d4);
        double[] dArray4 = this.yformatter.steps(d5, d6);
        double[] dArray5 = this.zformatter.steps(d7, d2);
        if (dArray4.length > 0 && !Double.isInfinite(this.absoluteminy) && dArray4[0] < this.absoluteminy) {
            dArray2 = new double[dArray4.length - 1];
            System.arraycopy(dArray4, 1, dArray2, 0, dArray2.length);
            dArray4 = dArray2;
        }
        if (dArray4.length > 0 && !Double.isInfinite(this.absolutemaxy) && dArray4[dArray4.length - 1] > this.absolutemaxy) {
            dArray2 = new double[dArray4.length - 1];
            System.arraycopy(dArray4, 0, dArray2, 0, dArray2.length);
            dArray4 = dArray2;
        }
        if (dArray3.length > 0) {
            d3 = dArray3[0];
            d4 = dArray3[dArray3.length - 1];
        } else {
            dArray3 = new double[]{d3, d4};
        }
        if (dArray4.length > 0) {
            if (Double.isInfinite(this.absoluteminy)) {
                d5 = dArray4[0];
            }
            if (Double.isInfinite(this.absolutemaxy)) {
                d6 = dArray4[dArray4.length - 1];
            }
        } else {
            dArray4 = new double[]{d5, d6};
        }
        if (dArray5.length > 0) {
            d7 = dArray5[0];
            d2 = dArray5[dArray5.length - 1];
        } else {
            dArray5 = new double[]{d7, d2};
        }
        double d9 = this.q ? Math.min(Math.max(d3, 0.0), d4) : d3;
        double d10 = this.p ? Math.min(Math.max(d5, 0.0), d6) : d5;
        this.n = new g("MAXYFACE", new Point(d3, d6, d7), new Point(d3, d6, d2), new Point(d4, d6, d2), new Point(d4, d6, d7), new Style(Color.black));
        this.o = new g("MINYFACE", new Point(d3, d5, d7), new Point(d3, d5, d2), new Point(d4, d5, d2), new Point(d4, d5, d7), new Style(Color.black));
        this.n.setInvisible();
        this.o.setInvisible();
        this.addElement(this.n);
        this.addElement(this.o);
        if (this.xaxestextstyle != null && dArray3.length > 0) {
            this.a(dArray3, d10, d2, (d6 - d5) / 100.0, this.xformatter);
        }
        if (this.yaxestextstyle != null && dArray4.length > 0) {
            this.b(dArray4, d9, d2, (d4 - d3) / 100.0, this.yformatter);
        }
        if (this.zaxestextstyle != null && dArray5.length > 0) {
            this.c(dArray5, d4, d10, (d4 - d3) / 100.0, this.zformatter);
        }
        if (this.boxstyle != null) {
            this.boxstyle.a().setAll();
            this.addElement(new e("Box", new Point(d4, d6, d2), new Point(d3, d5, d7), this.boxstyle));
        }
        this.addElement(new g("XAxis", new Point(d3, d10, d2), new Point(d4, d10, d2), this.axesstyle));
        this.addElement(new g("YAxis", new Point(d9, d5, d2), new Point(d9, d6, d2), this.axesstyle));
        this.addElement(new g("ZAxis", new Point(d4, d10, d2), new Point(d4, d10, d7), this.axesstyle));
        this.axesminx = new Double(d3);
        this.axesmaxx = new Double(d4);
        this.axesminy = new Double(d5);
        this.axesmaxy = new Double(d6);
        this.axesminz = new Double(d7);
        this.axesmaxz = new Double(d2);
        d7 -= (d2 - d7) * 0.001;
        d9 -= (d4 - d3) * 0.001;
        if (dArray4[0] != d5) {
            dArray = new double[dArray4.length + 1];
            System.arraycopy(dArray4, 0, dArray, 1, dArray4.length);
            dArray[0] = d5;
            dArray4 = dArray;
        }
        if (dArray4[dArray4.length - 1] != d6) {
            dArray = new double[dArray4.length + 1];
            System.arraycopy(dArray4, 0, dArray, 0, dArray4.length);
            dArray[dArray.length - 1] = d6;
            dArray4 = dArray;
        }
        if (this.zwallstyle != null) {
            for (int i2 = 0; i2 < dArray3.length - 1; ++i2) {
                for (n2 = 0; n2 < dArray4.length - 1; ++n2) {
                    style = this.zwallstyle;
                    if (i2 == 0 && !style.a().get(3)) {
                        style = (Style)style.clone();
                        style.a().set(3);
                    } else if (n2 == 0 && !style.a().get(2)) {
                        style = (Style)style.clone();
                        style.a().set(2);
                    } else if (i2 == dArray3.length - 2 && !style.a().get(1)) {
                        style = (Style)style.clone();
                        style.a().set(1);
                    } else if (n2 == dArray4.length - 2 && !style.a().get(0)) {
                        style = (Style)style.clone();
                        style.a().set(0);
                    }
                    this.addElement(new g("ZWall" + i2 + "," + n2, new Point(dArray3[i2], dArray4[n2 + 1], d7), new Point(dArray3[i2 + 1], dArray4[n2 + 1], d7), new Point(dArray3[i2 + 1], dArray4[n2], d7), new Point(dArray3[i2], dArray4[n2], d7), style));
                }
            }
        }
        if (this.ywallstyle != null) {
            for (int i3 = 0; i3 < dArray5.length - 1; ++i3) {
                for (n2 = 0; n2 < dArray4.length - 1; ++n2) {
                    style = this.ywallstyle;
                    if (n2 == 0 && !style.a().get(2)) {
                        style = (Style)style.clone();
                        style.a().set(2);
                    } else if (i3 == 0 && !style.a().get(3)) {
                        style = (Style)style.clone();
                        style.a().set(3);
                    } else if (n2 == dArray4.length - 2 && !style.a().get(0)) {
                        style = (Style)style.clone();
                        style.a().set(0);
                    } else if (i3 == dArray5.length - 2 && !style.a().get(1)) {
                        style = (Style)style.clone();
                        style.a().set(1);
                    }
                    this.addElement(new g("YWall" + i3 + "," + n2, new Point(d9, dArray4[n2], dArray5[i3 + 1]), new Point(d9, dArray4[n2 + 1], dArray5[i3 + 1]), new Point(d9, dArray4[n2 + 1], dArray5[i3]), new Point(d9, dArray4[n2], dArray5[i3]), style));
                }
            }
        }
        if (this.xwallstyle != null) {
            for (int i4 = 0; i4 < dArray3.length - 1; ++i4) {
                for (n2 = 0; n2 < dArray5.length - 1; ++n2) {
                    style = this.xwallstyle;
                    if (i4 == 0 && !style.a().get(3)) {
                        style = (Style)style.clone();
                        style.a().set(3);
                    } else if (n2 == 0 && !style.a().get(2)) {
                        style = (Style)style.clone();
                        style.a().set(2);
                    } else if (i4 == dArray3.length - 2 && !style.a().get(1)) {
                        style = (Style)style.clone();
                        style.a().set(1);
                    } else if (n2 == dArray5.length - 2 && !style.a().get(0)) {
                        style = (Style)style.clone();
                        style.a().set(0);
                    }
                    this.addElement(new g("XWall" + n2 + "," + i4, new Point(dArray3[i4 + 1], d10, dArray5[n2]), new Point(dArray3[i4 + 1], d10, dArray5[n2 + 1]), new Point(dArray3[i4], d10, dArray5[n2 + 1]), new Point(dArray3[i4], d10, dArray5[n2]), style));
                }
            }
        }
        this.prescalecomplete();
        double d11 = d6 - d5;
        double d12 = d4 - d3;
        m m2 = new m(0.0, 0.0, 0.0, 100.0, 100.0 * d12 / d11, 100.0, 0.0, 0.0, 0.0);
        this.canvas.transform(m2);
        boolean bl = this.canvas.getFixedAspect();
        this.canvas.setFixedAspect(true);
        this.canvas.scaleTo(new BoundingBox(new Point(0.0, 0.0), new Point(1000.0, 1000.0)));
        this.canvas.setFixedAspect(bl);
        super.postcomplete();
    }

    protected void prescalecomplete() {
    }

    protected void postpostcomplete() {
        BoundingBox boundingBox = this.canvas.getBoundingBox();
        if (this.zrotation == 0.0) {
            if (this.yaxeslabelstyle != null && this.v != null && this.v.length() > 0) {
                this.yaxeslabelstyle.setAlign(33);
                this.yaxeslabelstyle.setRotate(90.0);
                this.canvas.add(new h(this.v, new Point(boundingBox.getMinX() - boundingBox.getWidth() * 0.04, boundingBox.getMinY() + boundingBox.getHeight() / 2.0), this.yaxeslabelstyle));
            }
            if (this.xaxeslabelstyle != null && this.u != null && this.u.length() > 0) {
                this.xaxeslabelstyle.setAlign(33);
                this.xaxeslabelstyle.setRotate(0.0);
                this.canvas.add(new h(this.u, new Point(boundingBox.getMinX() + boundingBox.getWidth() / 2.0, boundingBox.getMinY() - boundingBox.getHeight() * 0.0), this.xaxeslabelstyle));
            }
        } else if (this.zrotation == 90.0) {
            if (this.xaxeslabelstyle != null && this.u != null && this.u.length() > 0) {
                this.xaxeslabelstyle.setAlign(33);
                this.xaxeslabelstyle.setRotate(90.0);
                this.canvas.add(new h(this.u, new Point(boundingBox.getMinX() - boundingBox.getWidth() * 0.04, boundingBox.getMinY() + boundingBox.getHeight() / 2.0), this.xaxeslabelstyle));
            }
            if (this.yaxeslabelstyle != null && this.v != null && this.v.length() > 0) {
                this.yaxeslabelstyle.setAlign(33);
                this.yaxeslabelstyle.setRotate(0.0);
                this.canvas.add(new h(this.v, new Point(boundingBox.getMinX() + boundingBox.getWidth() / 2.0, boundingBox.getMaxY() + boundingBox.getHeight() * 0.04), this.yaxeslabelstyle));
            }
        }
        super.postpostcomplete();
    }

    private void a(double[] dArray, double d2, double d3, double d4, Formatter formatter) {
        double d5 = formatter.isDiscrete() ? 0.5 : 0.0;
        for (int i2 = 0; i2 < (int)((double)dArray.length - d5); ++i2) {
            this.addElement(new g("XTick" + i2, new Point(dArray[i2] + d5, d2, d3), new Point(dArray[i2] + d5, d2 - d4, d3), this.axesstyle));
            this.addElement(new h(formatter.format(dArray[i2]), new Point(dArray[i2] + d5, d2 - d4 * (this.xaxestextstyle.getRotate() > 70.0 ? 2.2 : 1.4), d3), this.xaxestextstyle));
        }
    }

    private void b(double[] dArray, double d2, double d3, double d4, Formatter formatter) {
        double d5 = formatter.isDiscrete() ? 0.5 : 0.0;
        for (int i2 = 0; i2 < (int)((double)dArray.length - d5); ++i2) {
            this.addElement(new g("YTick" + i2, new Point(d2, dArray[i2] + d5, d3), new Point(d2 - d4, dArray[i2] + d5, d3), this.axesstyle));
            this.addElement(new h(formatter.format(dArray[i2]), new Point(d2 - d4 * 1.2, dArray[i2] + d5, d3), this.yaxestextstyle));
        }
    }

    private void c(double[] dArray, double d2, double d3, double d4, Formatter formatter) {
        double d5 = formatter.isDiscrete() ? 0.5 : 0.0;
        for (int i2 = 0; i2 < (int)((double)dArray.length - d5); ++i2) {
            this.addElement(new g("ZTick" + i2, new Point(d2, d3, dArray[i2] + d5), new Point(d2 + d4, d3, dArray[i2] + d5), this.axesstyle));
            this.addElement(new h(formatter.format(dArray[i2]), new Point(d2 + d4 * 3.0, d3, dArray[i2] + d5), this.zaxestextstyle));
        }
    }

    Paint a(l l2, String string, GradientPaint gradientPaint) {
        a_ a_2 = new a_(l2, gradientPaint);
        Paint paint = (Paint)this.a(a_2);
        if (paint == null) {
            float f2 = (float)this.n.plane().distance(this.o.plane());
            n n2 = l.intersectionVector(l2, this.n.plane());
            if (n2 == null) {
                float f3 = (float)Math.abs(l2.distance(this.o.plane()) / (double)f2);
                paint = PaintMixer.getColorAt(gradientPaint, f3);
            } else {
                n n3 = (n)n2.clone();
                if ((n2 = new n(n2.y(), -n2.x(), 0.0)).x() != 0.0 || n2.y() != 0.0) {
                    n2.normalize();
                    Point point = l.intersectionPoint(l2, this.o.plane());
                    Point point2 = new Point(this.o.getp(0).x(), this.o.getp(0).y(), this.n.getp(0).z());
                    double d2 = new n(this.n.getp(0), point2).len();
                    double d3 = f.atan(n2.x(), -n2.y()) - this.zrotation;
                    double d4 = d2 * Math.sin(d3 * Math.PI / 180.0);
                    n2.mul(d4);
                    Point point3 = point.moveByClone(n2);
                    paint = new GradientPaint((float)point.x(), (float)point.y(), gradientPaint.getColor1(), (float)point3.x(), (float)point3.y(), gradientPaint.getColor2());
                } else {
                    paint = gradientPaint.getColor1();
                }
            }
            this.a(a_2, paint);
        }
        return paint;
    }

    private class a_ {
        public final l plane;
        public final GradientPaint blend;

        public a_(l l2, GradientPaint gradientPaint) {
            this.plane = l2;
            this.blend = gradientPaint;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof a_ && object.hashCode() == this.hashCode();
        }

        public String toString() {
            return "" + this.plane + this.blend.hashCode();
        }
    }
}

