/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.graph;

import java.text.DecimalFormat;
import org.faceless.graph.m;
import org.faceless.graph.n;

public final class Point {
    double a;
    double b;
    double c;

    public Point(Double d2, Double d3, Double d4) {
        this((double)d2, (double)d3, (double)d4);
    }

    public Point(double d2, double d3) {
        this(d2, d3, 0.0);
    }

    public Point(double d2, double d3, double d4) {
        this.a = d2;
        this.b = d3;
        this.c = d4;
        if (Double.isNaN(d2 + d3 + d4)) {
            throw new Error("Created NaN Point: x=" + d2 + " y=" + d3 + " z=" + d4);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Point) {
            Point point = (Point)object;
            return this.a == point.a && this.b == point.b && this.c == point.c;
        }
        return false;
    }

    public int hashCode() {
        return (this.a + "," + this.b + "," + this.c).hashCode();
    }

    public double x() {
        return this.a;
    }

    public double y() {
        return this.b;
    }

    public double z() {
        return this.c;
    }

    public void transform(m m2) {
        Point point = m2.transform(this);
        this.a = point.x();
        this.b = point.y();
        this.c = point.z();
    }

    public void moveBy(n n2) {
        this.a += n2.x();
        this.b += n2.y();
        this.c += n2.z();
    }

    public Point moveByClone(n n2) {
        return new Point(this.a + n2.x(), this.b + n2.y(), this.c + n2.z());
    }

    public Object clone() {
        return new Point(this.a, this.b, this.c);
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat("#0.0");
        DecimalFormat decimalFormat2 = new DecimalFormat("#0");
        String string = "";
        string = string + (this.a == Math.floor(this.a) ? decimalFormat2.format(this.a) : decimalFormat.format(this.a)) + " ";
        string = string + (this.b == Math.floor(this.b) ? decimalFormat2.format(this.b) : decimalFormat.format(this.b)) + " ";
        string = string + (this.c == Math.floor(this.c) ? decimalFormat2.format(this.c) : decimalFormat.format(this.c));
        return "[" + string + "]";
    }
}

