/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.graph.formatter;

public abstract class Formatter {
    protected int density;
    private boolean a;
    public static final int NORMAL = 10;
    public static final int SPARSE = 5;
    public static final int MINIMAL = 2;

    protected Formatter() {
        this.setDensity(10);
        this.setFixedEnds(false);
    }

    public void setDensity(int n2) {
        this.density = Math.max(2, Math.min(20, n2));
    }

    public void setFixedEnds(boolean bl) {
        this.a = bl;
    }

    public abstract String format(double var1);

    public boolean isDiscrete() {
        return false;
    }

    public double[] steps(double d2, double d3) {
        double d4 = this.a(d2, d3);
        if (d4 == 0.0) {
            double[] dArray = new double[]{d2};
            return dArray;
        }
        double d5 = Math.floor(d2 / d4) * d4;
        double d6 = Math.ceil(d3 / d4) * d4;
        int n2 = (int)Math.floor((d6 + d4 / 5.0 - d5) / d4);
        double[] dArray = new double[n2 + 1];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = d5 + d4 * (double)i2;
        }
        dArray = this.fixMinMax(dArray, d2, d3, d4);
        return dArray;
    }

    double a(double d2, double d3) {
        double[] dArray = new double[]{0.0, 1.0, 2.0, 5.0, 5.0, 5.0, 5.0, 5.0, 10.0, 10.0, 10.0};
        double d4 = Math.abs(d3 - d2);
        if (d4 == 0.0) {
            return 0.0;
        }
        d4 /= (double)this.density;
        double d5 = 1.0;
        while (d4 < 1.0) {
            d5 *= 10.0;
            d4 *= 10.0;
        }
        while (d4 > 10.0) {
            d5 /= 10.0;
            d4 /= 10.0;
        }
        d4 = Math.round(d4);
        d4 = dArray[(int)d4] / d5;
        return d4;
    }

    protected final double[] fixMinMax(double[] dArray, double d2, double d3, double d4) {
        if (this.a) {
            if (d2 - dArray[0] < dArray[0] + d4 - d2) {
                dArray[0] = d2;
            } else {
                dArray[1] = d2;
                double[] dArray2 = new double[dArray.length - 1];
                System.arraycopy(dArray, 1, dArray2, 0, dArray2.length);
                dArray = dArray2;
            }
            int n2 = dArray.length - 1;
            if (dArray[n2] - d3 < d3 - dArray[n2] + d4) {
                dArray[n2] = d3;
            } else {
                dArray[n2 - 1] = d3;
                double[] dArray3 = new double[dArray.length - 1];
                System.arraycopy(dArray, 0, dArray3, 0, dArray3.length);
                dArray = dArray3;
            }
        }
        return dArray;
    }
}

