/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.graph.math;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.faceless.graph.math.Curve;

public class DataCurve
extends Curve {
    private SortedMap a = new TreeMap();
    private double b = Double.POSITIVE_INFINITY;
    private double c = Double.NEGATIVE_INFINITY;

    public double getMin() {
        return this.b;
    }

    public double getMax() {
        return this.c;
    }

    public boolean point(double d2) {
        return this.a.containsKey(new Double(d2));
    }

    public void set(double d2, double d3) {
        if (d2 < this.b) {
            this.b = d2;
        }
        if (d2 > this.c) {
            this.c = d2;
        }
        this.a.put(new Double(d2), new Double(d3));
    }

    public double[][] getForFit() {
        Double[] doubleArray = this.a.keySet().toArray(new Double[0]);
        double[][] dArray = new double[2][doubleArray.length];
        for (int i2 = 0; i2 < doubleArray.length; ++i2) {
            dArray[0][i2] = doubleArray[i2];
            dArray[1][i2] = (Double)this.a.get(doubleArray[i2]);
        }
        return dArray;
    }

    public double get(double d2) {
        Double[] doubleArray = this.a.keySet().toArray(new Double[0]);
        if (d2 < this.b || d2 > this.c) {
            return Double.NaN;
        }
        for (int i2 = 0; i2 < doubleArray.length - 1; ++i2) {
            double d3 = doubleArray[i2];
            if (d3 == d2) {
                return (Double)this.a.get(doubleArray[i2]);
            }
            double d4 = doubleArray[i2 + 1];
            if (d4 == d2) {
                return (Double)this.a.get(doubleArray[i2 + 1]);
            }
            if (!(d2 >= d3) || !(d2 < d4)) continue;
            double d5 = (Double)this.a.get(doubleArray[i2]);
            double d6 = (Double)this.a.get(doubleArray[i2 + 1]);
            double d7 = (d2 - d3) / (d4 - d3);
            double d8 = d5 + d7 * (d6 - d5);
            return d8;
        }
        return (Double)this.a.get(doubleArray[doubleArray.length - 1]);
    }

    public double[] steps() {
        ArrayList arrayList = new ArrayList(this.a.keySet());
        double[] dArray = new double[arrayList.size()];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = (Double)arrayList.get(i2);
        }
        return dArray;
    }

    public String toString() {
        String string = "[DC: ";
        Iterator iterator = this.a.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            string = string + k2 + "=" + this.a.get(k2) + " ";
        }
        return string + "]";
    }
}

