/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.graph.math;

import java.text.DecimalFormat;
import org.faceless.graph.math.DataCurve;
import org.faceless.graph.math.FunctionCurve;

public class Polynomial
extends FunctionCurve {
    private int a;
    private double[] b;
    private static double c = 0.05;

    public Polynomial(int n2, double[] dArray) {
        this.a = n2;
        this.b = new double[n2 + 1];
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            this.b[i2] = dArray[i2];
        }
    }

    public String toString() {
        String string = "";
        for (int i2 = this.a; i2 >= 0; --i2) {
            string = string + "(" + this.b[i2];
            if (i2 > 1) {
                string = string + "*X^" + i2;
            }
            if (i2 == 1) {
                string = string + "*X";
            }
            string = string + ") + ";
        }
        return "[Poly " + this.a + ": " + string.substring(0, string.length() - 3) + " ]";
    }

    public double get(double d2) {
        double d3 = 0.0;
        for (int i2 = 0; i2 <= this.a; ++i2) {
            d3 += this.b[i2] * Math.pow(d2, i2);
        }
        return d3;
    }

    public static void setFitTolerance(double d2) {
        c = d2;
    }

    public static Polynomial fit(DataCurve dataCurve) {
        double[][] dArray = dataCurve.getForFit();
        return Polynomial.fit(dArray[0], dArray[1]);
    }

    public static Polynomial fit(double[] dArray, double[] dArray2) {
        Polynomial polynomial;
        int n2 = 1;
        double d2 = 1.0;
        do {
            polynomial = Polynomial.fit(n2++, dArray, dArray2);
            d2 = polynomial.maxMatchError(dArray, dArray2);
        } while (n2 < 30 && d2 > c);
        return polynomial;
    }

    public static Polynomial fit(int n2, double[] dArray, double[] dArray2) {
        int n3;
        int n4 = dArray.length;
        double[] dArray3 = new double[n2 * 2];
        double[] dArray4 = new double[n2 + 1];
        double[][] dArray5 = new double[n2 + 1][n2 + 1];
        for (n3 = 0; n3 < dArray3.length; ++n3) {
            dArray3[n3] = 0.0;
        }
        for (n3 = 0; n3 < dArray4.length; ++n3) {
            dArray4[n3] = 0.0;
        }
        Polynomial.a("-3", n2, dArray5, dArray4, dArray3);
        for (n3 = 0; n3 < n4; ++n3) {
            double d2 = dArray[n3];
            double d3 = dArray2[n3];
            double d4 = d2;
            for (int i2 = 0; i2 < n2 * 2; ++i2) {
                int n5 = i2;
                dArray3[n5] = dArray3[n5] + d2;
                d2 *= d4;
                if (i2 > n2) continue;
                int n6 = i2;
                dArray4[n6] = dArray4[n6] + d3;
                d3 *= d4;
            }
        }
        Polynomial.a("-2", n2, dArray5, dArray4, dArray3);
        for (n3 = 0; n3 <= n2; ++n3) {
            for (int i3 = 0; i3 <= n2; ++i3) {
                dArray5[n3][i3] = n3 + i3 == 0 ? (double)n4 : dArray3[n3 + i3 - 1];
            }
        }
        Polynomial.a("-1", n2, dArray5, dArray4, dArray3);
        Polynomial.a(n2, dArray5, dArray4, dArray3);
        return new Polynomial(n2, dArray3);
    }

    public double maxMatchError(double[] dArray, double[] dArray2) {
        double d2 = 0.0;
        int n2 = dArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d3 = this.get(dArray[i2]);
            double d4 = dArray2[i2];
            d2 = Math.max(d2, Math.abs((d3 - d4) / d4));
        }
        return d2;
    }

    private static void a(int n2, double[][] dArray, double[] dArray2, double[] dArray3) {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            int n4;
            int n5 = n3;
            double d2 = Math.abs(dArray[n3][n3]);
            for (n4 = n3 + 1; n4 <= n2; ++n4) {
                if (!(Math.abs(dArray[n4][n3]) > d2)) continue;
                n5 = n4;
                d2 = Math.abs(dArray[n4][n3]);
            }
            if (d2 == 0.0) {
                throw new Error("Coefficient Matrix is Singular");
            }
            if (n5 != n3) {
                double d3;
                for (int i2 = n3; i2 <= n2; ++i2) {
                    d3 = dArray[n3][i2];
                    dArray[n3][i2] = dArray[n5][i2];
                    dArray[n5][i2] = d3;
                }
                d3 = dArray2[n3];
                dArray2[n3] = dArray2[n5];
                dArray2[n5] = d3;
            }
            double d4 = dArray[n3][n3];
            n4 = n3 + 1;
            while (n4 <= n2) {
                double[] dArray4 = dArray[n3];
                int n6 = n4++;
                dArray4[n6] = dArray4[n6] / d4;
            }
            int n7 = n3;
            dArray2[n7] = dArray2[n7] / d4;
            for (n4 = n3 + 1; n4 <= n2; ++n4) {
                for (int i3 = n3 + 1; i3 <= n2; ++i3) {
                    double[] dArray5 = dArray[n4];
                    int n8 = i3;
                    dArray5[n8] = dArray5[n8] - dArray[n4][n3] * dArray[n3][i3];
                }
                int n9 = n4;
                dArray2[n9] = dArray2[n9] - dArray[n4][n3] * dArray2[n3];
            }
        }
        dArray3[n2] = dArray2[n2] / dArray[n2][n2];
        for (n3 = n2 - 1; n3 >= 0; --n3) {
            double d5 = 0.0;
            for (int i4 = n3 + 1; i4 <= n2; ++i4) {
                d5 += dArray3[i4] * dArray[n3][i4];
            }
            dArray3[n3] = dArray2[n3] - d5;
        }
    }

    private static String a(double d2) {
        return new DecimalFormat(" #00000.000;-#00000.000").format(d2);
    }

    private static void a(String string, int n2, double[][] dArray, double[] dArray2, double[] dArray3) {
        int n3;
        String string2 = string + ": ";
        for (n3 = 0; n3 < n2; ++n3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                string2 = string2 + Polynomial.a(dArray[n3][i2]) + " ";
            }
            string2 = string2 + "       " + Polynomial.a(dArray2[n3]);
            string2 = string2 + "\n" + string + ": ";
        }
        string2 = string2 + " --> ";
        for (n3 = 0; n3 < (n2 - 1) * 2; ++n3) {
            string2 = string2 + n3 + "=" + Polynomial.a(dArray3[n3]) + " ";
        }
    }
}

