/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.graph.math;

import org.faceless.graph.math.DataCurve;
import org.faceless.graph.math.FunctionCurve;
import org.faceless.graph.math.Matrix;

public class Spline
extends FunctionCurve {
    double[] a;
    double[] b;
    double c = Double.POSITIVE_INFINITY;
    double d = Double.NEGATIVE_INFINITY;
    Matrix e;
    int f;
    public static final Matrix CATMULLROM = new Matrix(4, 4);
    public static final Matrix BSPLINE = new Matrix(4, 4);
    private static final Matrix g = new Matrix(4, 4);

    public Spline(Matrix matrix, DataCurve dataCurve) {
        if (matrix.getRows() != 4) {
            throw new IllegalArgumentException("Matrix must have 4 rows");
        }
        double[][] dArray = dataCurve.getForFit();
        this.a = new double[dArray[0].length + 2];
        this.b = new double[dArray[0].length + 2];
        int n2 = dArray[0].length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a[i2 + 1] = dArray[0][i2];
            this.b[i2 + 1] = dArray[1][i2];
        }
        double[] dArray2 = this.a;
        int n3 = 0;
        double d2 = dArray[0][0];
        double[] dArray3 = dArray[0];
        int n4 = n2 == 1 ? 0 : 1;
        dArray2[n3] = d2 - (dArray3[n4] - dArray[0][0]);
        double[] dArray4 = this.a;
        int n5 = this.a.length - 1;
        double d3 = dArray[0][dArray[0].length - 1];
        double d4 = dArray[0][dArray[0].length - 1];
        double[] dArray5 = dArray[0];
        int n6 = n2 == 1 ? 0 : dArray[0].length - 2;
        dArray4[n5] = d3 + (d4 - dArray5[n6]);
        double[] dArray6 = this.b;
        int n7 = 0;
        double d5 = dArray[1][0];
        double[] dArray7 = dArray[1];
        int n8 = n2 == 1 ? 0 : 1;
        dArray6[n7] = d5 - (dArray7[n8] - dArray[1][0]);
        double[] dArray8 = this.b;
        int n9 = this.b.length - 1;
        double d6 = dArray[1][dArray[1].length - 1];
        double d7 = dArray[1][dArray[1].length - 1];
        double[] dArray9 = dArray[1];
        int n10 = n2 == 1 ? 0 : dArray[1].length - 2;
        dArray8[n9] = d6 + (d7 - dArray9[n10]);
        this.e = matrix;
        this.f = matrix.getRows();
        this.c = dataCurve.getMin();
        this.d = dataCurve.getMax();
    }

    public Spline(Matrix matrix, double[] dArray, double[] dArray2) {
        if (matrix.getRows() != 4) {
            throw new IllegalArgumentException("Matrix must have 4 rows");
        }
        this.a = dArray;
        this.b = dArray2;
        this.e = matrix;
        this.f = matrix.getRows();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double get(double d2) {
        if (d2 < this.a[1] || d2 > this.a[this.a.length - this.f + 2]) {
            return Double.NaN;
        }
        int n2 = 1;
        while (n2 < this.a.length - this.f + 2) {
            if (d2 <= this.a[n2 + 1]) {
                return this.a(d2, n2);
            }
            ++n2;
        }
        return Double.NaN;
    }

    private double a(double d2, int n2) {
        double d3 = (d2 - this.a[n2]) / (this.a[n2 + 1] - this.a[n2]);
        Matrix matrix = new Matrix(this.f, 1);
        for (int i2 = 0; i2 < this.f; ++i2) {
            matrix.set(i2, 0, Math.pow(d3, this.f - i2 - 1));
        }
        Matrix matrix2 = new Matrix(2, this.f);
        for (int i3 = 0; i3 < this.f; ++i3) {
            matrix2.set(0, i3, this.a[i3 + n2 - 1]);
            matrix2.set(1, i3, this.b[i3 + n2 - 1]);
        }
        Matrix matrix3 = matrix.mul(this.e).mul(matrix2);
        return matrix3.get(1, 0);
    }

    public double getMin() {
        return this.c;
    }

    public double getMax() {
        return this.d;
    }

    public double[] steps() {
        double[] dArray = new double[this.a.length - 2];
        System.arraycopy(this.a, 1, dArray, 0, dArray.length);
        return dArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean point(double d2) {
        if (this.e == CATMULLROM) {
            for (int n2 = 0; n2 < this.a.length; ++n2) {
                if (this.a[n2] != d2) continue;
                return true;
            }
        }
        return false;
    }

    static {
        float f2 = 0.5f;
        CATMULLROM.set(0, 0, -f2);
        CATMULLROM.set(1, 0, 2.0f - f2);
        CATMULLROM.set(2, 0, f2 - 2.0f);
        CATMULLROM.set(3, 0, f2);
        CATMULLROM.set(0, 1, 2.0f * f2);
        CATMULLROM.set(1, 1, f2 - 3.0f);
        CATMULLROM.set(2, 1, 3.0f - f2 * 2.0f);
        CATMULLROM.set(3, 1, -f2);
        CATMULLROM.set(0, 2, -f2);
        CATMULLROM.set(1, 2, 0.0);
        CATMULLROM.set(2, 2, f2);
        CATMULLROM.set(3, 2, 0.0);
        CATMULLROM.set(0, 3, 0.0);
        CATMULLROM.set(1, 3, 1.0);
        CATMULLROM.set(2, 3, 0.0);
        CATMULLROM.set(3, 3, 0.0);
        BSPLINE.set(0, 0, -0.1666666716337204);
        BSPLINE.set(1, 0, 0.5);
        BSPLINE.set(2, 0, -0.5);
        BSPLINE.set(3, 0, 0.1666666716337204);
        BSPLINE.set(0, 1, 0.5);
        BSPLINE.set(1, 1, -1.0);
        BSPLINE.set(2, 1, 0.5);
        BSPLINE.set(3, 1, 0.0);
        BSPLINE.set(0, 2, -0.5);
        BSPLINE.set(1, 2, 0.0);
        BSPLINE.set(2, 2, 0.5);
        BSPLINE.set(3, 2, 0.0);
        BSPLINE.set(0, 3, 0.1666666716337204);
        BSPLINE.set(1, 3, 0.6666666865348816);
        BSPLINE.set(2, 3, 0.1666666716337204);
        BSPLINE.set(3, 3, 0.0);
        g.set(0, 0, -1.0);
        g.set(1, 0, 3.0);
        g.set(2, 0, -3.0);
        g.set(3, 0, 1.0);
        g.set(0, 1, 3.0);
        g.set(1, 1, -6.0);
        g.set(2, 1, 3.0);
        g.set(3, 1, 0.0);
        g.set(0, 2, -3.0);
        g.set(1, 2, 3.0);
        g.set(2, 2, 0.0);
        g.set(3, 2, 0.0);
        g.set(0, 3, 1.0);
        g.set(1, 3, 0.0);
        g.set(2, 3, 0.0);
        g.set(3, 3, 0.0);
    }
}

