/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.graph.output;

import Acme.JPM.Encoders.GifEncoder;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import org.faceless.graph.Graph;
import org.faceless.graph.output.ImageOutput;

public class GIFOutput
extends ImageOutput {
    private OutputStream k;
    private int l;
    private Color m;

    public GIFOutput(int n2, int n3, OutputStream outputStream) {
        this(n2, n3, Color.white, outputStream);
    }

    public GIFOutput(int n2, int n3, Color color, OutputStream outputStream) {
        super(n2, n3, color);
        if (color.getAlpha() != 255) {
            this.m = color;
        }
        this.l = 256;
        this.k = outputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setNumColors(int n2) {
        if (n2 >= 2 && n2 <= 256) {
            this.l = n2;
            return;
        }
        throw new IllegalArgumentException("Colors must be between 2 and 256");
    }

    public void render(Graph graph) throws IOException {
        super.render(graph);
        this.image = this.getReducedColorImage(this.l, this.m);
        GifEncoder gifEncoder = new GifEncoder(this.image, this.k);
        gifEncoder.encode();
        this.g.dispose();
    }
}

