/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.graph.output;

import java.awt.Paint;
import java.io.IOException;
import org.faceless.graph.BoundingBox;
import org.faceless.graph.Graph;
import org.faceless.graph.Point;
import org.faceless.graph.Style;

public abstract class Output {
    protected int textAlign = 12;

    protected Output() {
    }

    public abstract BoundingBox getTextBox(String var1, Style var2);

    public abstract BoundingBox getCanvas();

    public abstract boolean canRotate();

    public abstract boolean canPattern();

    public abstract void setColor(Paint var1);

    public abstract void setLineThickness(double var1);

    public abstract void setLineDash(double var1, double var3, double var5);

    public abstract void text(String var1, double var2, double var4, Style var6);

    public abstract void line(double var1, double var3, double var5, double var7);

    public abstract void poly(String var1, double[] var2, double[] var3, int var4);

    public abstract void render(Graph var1) throws IOException;

    public abstract Graph getGraph();

    protected final Point rotate(Point point, Point point2, double d2) {
        double d3 = point2.x() - point.x();
        double d4 = point2.y() - point.y();
        double d5 = d4 == 0.0 ? 1.5707963267948966 * (double)(d3 < 0.0 ? -1 : 1) : Math.atan(d3 / d4) + (d4 < 0.0 ? Math.PI : 0.0);
        double d6 = Math.sqrt(d3 * d3 + d4 * d4);
        d3 = Math.sin(d5 + (d2 *= Math.PI / 180)) * d6;
        d4 = Math.cos(d5 + d2) * d6;
        return new Point(point.x() + d3, point.y() + d4);
    }

    protected final Point getTextAnchor(double d2, double d3, double d4, double d5, int n2) {
        if ((n2 & 0x10) == 16) {
            d3 -= d5 / 2.0;
        } else if ((n2 & 1) == 1) {
            d3 -= d5;
        }
        if ((n2 & 0x20) == 32) {
            d2 -= d4 / 2.0;
        } else if ((n2 & 2) == 2) {
            d2 -= d4;
        }
        if ((this.textAlign & 1) == 1) {
            d3 += d5;
        }
        if ((this.textAlign & 0x10) == 16) {
            d3 += d5 / 2.0;
        }
        if ((this.textAlign & 2) == 2) {
            d2 += d4;
        }
        if ((this.textAlign & 0x20) == 32) {
            d2 += d4 / 2.0;
        }
        return new Point(d2, d3);
    }
}

