/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import org.faceless.pdf2.PDFAnnotation;
import org.faceless.pdf2.PDFCanvas;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.PDFStyle;
import org.faceless.pdf2.gc;
import org.faceless.pdf2.hc;
import org.faceless.pdf2.ic;
import org.faceless.pdf2.uc;
import org.faceless.pdf2.wc;
import org.faceless.pdf2.xc;

public class AnnotationShape
extends PDFAnnotation {
    private static String a(Shape shape) {
        if (shape instanceof Ellipse2D) {
            return "Circle";
        }
        if (shape instanceof RectangularShape) {
            return "Square";
        }
        if (shape instanceof Line2D) {
            return "Line";
        }
        if (shape instanceof Polygon) {
            return "Polygon";
        }
        float[] fArray = new float[6];
        int n2 = 0;
        int n3 = 0;
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        while (!flatteningPathIterator.isDone()) {
            n2 = flatteningPathIterator.currentSegment(fArray);
            if (n2 == 0) {
                ++n3;
            }
            flatteningPathIterator.next();
        }
        if (n3 > 1) {
            return "Ink";
        }
        if (n2 == 4) {
            return "Polygon";
        }
        return "PolyLine";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean s(String string) {
        if ("ClosedArrow".equals(string)) return true;
        if ("RClosedArrow".equals(string)) return true;
        if ("Square".equals(string)) return true;
        if ("Circle".equals(string)) return true;
        if ("Diamond".equals(string)) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean t(String string) {
        if ("Square".equals(string)) return true;
        if ("Circle".equals(string)) return true;
        if ("Diamond".equals(string)) return true;
        if ("OpenArrow".equals(string)) return true;
        if ("ClosedArrow".equals(string)) return true;
        if ("None".equals(string)) return true;
        if ("Butt".equals(string)) return true;
        if ("ROpenArrow".equals(string)) return true;
        if ("RClosedArrow".equals(string)) return true;
        if ("Slash".equals(string)) return true;
        return false;
    }

    protected AnnotationShape(ic ic2) {
        super(ic2);
    }

    public AnnotationShape() {
        super("UnknownShape");
    }

    public AnnotationShape(Shape shape) {
        this(shape, null, null);
    }

    public AnnotationShape(Shape shape, String string, String string2) {
        super("UnknownShape");
        this.setShape(shape);
        this.setFirstLineEnding(string);
        this.setLastLineEnding(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void setShape(Shape shape) {
        block29: {
            FlatteningPathIterator flatteningPathIterator;
            float[] fArray;
            uc uc2;
            uc uc3;
            block33: {
                FlatteningPathIterator flatteningPathIterator2;
                float[] fArray2;
                uc uc4;
                String string;
                block31: {
                    Rectangle2D rectangle2D;
                    block32: {
                        block30: {
                            block28: {
                                if (shape == null) {
                                    throw new NullPointerException("shape is null");
                                }
                                string = AnnotationShape.a(shape);
                                this.b("Subtype", wc.b(string));
                                this.e("L");
                                this.e("RD");
                                this.e("Vertices");
                                this.e("InkList");
                                if (!string.equals("Line") && !string.equals("PolyLine")) {
                                    this.e("LE");
                                } else {
                                    this.e("BE");
                                }
                                if (this.getPage() != null) {
                                    shape = this.getPage().A().createTransformedShape(shape);
                                }
                                if (!string.equals("Line")) break block28;
                                uc uc5 = new uc(4);
                                PathIterator pathIterator = shape.getPathIterator(null);
                                float[] fArray3 = new float[6];
                                pathIterator.currentSegment(fArray3);
                                uc5.c(xc.a(fArray3[0]));
                                uc5.c(xc.a(fArray3[1]));
                                pathIterator.next();
                                pathIterator.currentSegment(fArray3);
                                uc5.c(xc.a(fArray3[0]));
                                uc5.c(xc.a(fArray3[1]));
                                this.b("L", uc5);
                                this.a(this.b(shape, this.getStyle()));
                                break block29;
                            }
                            if (!string.equals("Polygon") && !string.equals("PolyLine")) break block30;
                            uc4 = new uc(10);
                            fArray2 = new float[6];
                            flatteningPathIterator2 = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
                            break block31;
                        }
                        if (!string.equals("Ink")) break block32;
                        uc3 = new uc(2);
                        uc2 = null;
                        fArray = new float[6];
                        flatteningPathIterator = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
                        break block33;
                    }
                    Rectangle2D rectangle2D2 = shape.getBounds2D();
                    PDFStyle pDFStyle = this.getStyle();
                    if (pDFStyle.getFormStyle() == 8 || pDFStyle.getFormStyle() == 9) {
                        rectangle2D = this.b(shape, this.getStyle());
                        if (!rectangle2D2.equals(rectangle2D)) {
                            float f2 = (float)(rectangle2D2.getMinX() - rectangle2D.getMinX());
                            float f3 = (float)(rectangle2D2.getMinY() - rectangle2D.getMinY());
                            float f4 = (float)(rectangle2D.getMaxX() - rectangle2D2.getMaxX());
                            float f5 = (float)(rectangle2D.getMaxY() - rectangle2D2.getMaxY());
                            this.b("RD", new uc(f2, f3, f4, f5));
                        }
                    } else {
                        rectangle2D = rectangle2D2;
                    }
                    this.a(rectangle2D);
                    break block29;
                }
                while (!flatteningPathIterator2.isDone()) {
                    int n2 = flatteningPathIterator2.currentSegment(fArray2);
                    switch (n2) {
                        case 0: 
                        case 1: {
                            uc4.c(xc.a(fArray2[0]));
                            uc4.c(xc.a(fArray2[1]));
                            break;
                        }
                        case 4: {
                            if (!string.equals("PolyLine") || uc4.o() <= 1) break;
                            uc4.c(uc4.d(0));
                            uc4.c(uc4.d(1));
                            break;
                        }
                    }
                    flatteningPathIterator2.next();
                }
                this.b("Vertices", uc4);
                this.a(this.b(shape, this.getStyle()));
                break block29;
            }
            while (!flatteningPathIterator.isDone()) {
                int n3 = flatteningPathIterator.currentSegment(fArray);
                switch (n3) {
                    case 0: {
                        uc2 = new uc(10);
                        uc3.c(uc2);
                    }
                    case 1: {
                        uc2.c(xc.a(fArray[0]));
                        uc2.c(xc.a(fArray[1]));
                        break;
                    }
                    case 4: {
                        if (uc2 == null || uc2.o() <= 1) break;
                        uc2.c(uc2.d(0));
                        uc2.c(uc2.d(1));
                        break;
                    }
                }
                flatteningPathIterator.next();
            }
            this.b("InkList", uc3);
            this.a(this.b(shape, this.getStyle()));
        }
        this.setRebuildRequired(true);
        this.l.firePropertyChange("shape", null, shape);
    }

    synchronized wc z() {
        return (wc)this.b("BlendMode");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Shape getShape() {
        if (!this.f("Subtype")) {
            return null;
        }
        String string = this.i("Subtype").o();
        AffineTransform affineTransform = this.getPage() != null ? this.getPage().B() : new AffineTransform();
        if (string.equals("Circle") || string.equals("Square")) {
            if (!this.f("Rect")) {
                return null;
            }
            float[] fArray = this.k("Rect").a((float[])null);
            if (this.f("RD")) {
                uc uc2 = this.k("RD");
                fArray[0] = fArray[0] + uc2.h(0).p();
                fArray[1] = fArray[1] + uc2.h(1).p();
                fArray[2] = fArray[2] - uc2.h(2).p();
                fArray[3] = fArray[3] - uc2.h(3).p();
            }
            affineTransform.transform(fArray, 0, fArray, 0, 2);
            fArray = uc.b(fArray);
            if (string.equals("Square")) {
                return new Rectangle2D.Float(fArray[0], fArray[1], fArray[2] - fArray[0], fArray[3] - fArray[1]);
            }
            return new Ellipse2D.Float(fArray[0], fArray[1], fArray[2] - fArray[0], fArray[3] - fArray[1]);
        }
        if (!string.equals("PolyLine") && !string.equals("Polygon")) {
            if (!string.equals("Ink")) {
                if (string.equals("Line")) {
                    float[] fArray = this.k("L").a((float[])null);
                    affineTransform.transform(fArray, 0, fArray, 0, 2);
                    return new Line2D.Float(fArray[0], fArray[1], fArray[2], fArray[3]);
                }
                return null;
            }
        } else {
            GeneralPath generalPath = new GeneralPath();
            float[] fArray = this.k("Vertices").a((float[])null);
            affineTransform.transform(fArray, 0, fArray, 0, fArray.length / 2);
            for (int i2 = 0; i2 < fArray.length; i2 += 2) {
                if (i2 == 0) {
                    generalPath.moveTo(fArray[i2], fArray[i2 + 1]);
                    continue;
                }
                generalPath.lineTo(fArray[i2], fArray[i2 + 1]);
            }
            if (string.equals("Polygon")) {
                generalPath.closePath();
            }
            return generalPath;
        }
        GeneralPath generalPath = new GeneralPath();
        uc uc3 = this.k("InkList");
        int n2 = 0;
        while (n2 < uc3.o()) {
            float[] fArray = uc3.g(n2).a((float[])null);
            affineTransform.transform(fArray, 0, fArray, 0, fArray.length / 2);
            for (int i3 = 0; i3 < fArray.length; i3 += 2) {
                if (i3 == 0) {
                    generalPath.moveTo(fArray[i3], fArray[i3 + 1]);
                    continue;
                }
                generalPath.lineTo(fArray[i3], fArray[i3 + 1]);
            }
            ++n2;
        }
        return generalPath;
    }

    private synchronized void b(String string, int n2) {
        block13: {
            if (string == null) {
                string = "None";
            }
            String string2 = this.i("Subtype").o();
            if (string2.equals("UnknownShape")) {
                throw new IllegalStateException("Shape not set");
            }
            if (!string2.equals("Line") && !string2.equals("PolyLine")) break block13;
            uc uc2 = this.k("LE");
            if (uc2 == null) {
                uc2 = new uc(2);
                uc2.c(wc.b("None"));
                uc2.c(wc.b("None"));
                this.b("LE", uc2);
            }
            String string3 = uc2.e(n2).o();
            if (!AnnotationShape.t(string)) {
                throw new IllegalArgumentException("Invalid ending \"" + string + "\"");
            }
            if (!string3.equals(string)) {
                uc2.b(n2, wc.b(string));
                this.a(this.b(this.getShape(), this.getStyle()));
                this.l.firePropertyChange("lineEnding" + n2, string3, string);
            }
        }
    }

    private synchronized String c(int n2) {
        if (this.f("LE")) {
            uc uc2 = this.k("LE");
            return uc2.e(n2).o();
        }
        return "None";
    }

    public String getFirstLineEnding() {
        return this.c(0);
    }

    public void setFirstLineEnding(String string) {
        this.b(string, 0);
    }

    public String getLastLineEnding() {
        return this.c(1);
    }

    public void setLastLineEnding(String string) {
        this.b(string, 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized PDFStyle getStyle() {
        Object object;
        ic ic3 = this.j("BS");
        ic ic2 = this.j("BE");
        if (ic3 == null) {
            ic3 = new ic();
        }
        PDFStyle pDFStyle = new PDFStyle();
        xc xc2 = ic3.l("W");
        if (xc2 != null) {
            pDFStyle.setLineWeighting(xc2.p());
        } else {
            pDFStyle.setLineWeighting(1.0f);
        }
        wc wc2 = ic3.i("S");
        if (wc2 != null && wc2.d("D")) {
            pDFStyle.setFormStyle(6);
            if (ic3.f("D")) {
                uc uc2 = ic3.k("D");
                object = uc2.a(new float[uc2.o()]);
            } else {
                object = new float[]{3.0f};
            }
            pDFStyle.setLineDash((float[])object, 0.0f);
        } else {
            pDFStyle.setFormStyle(0);
        }
        if (ic2 != null && ic2.f("S") && ic2.i("S").d("C") && (object = (Object)ic2.l("I")) != null) {
            int n2 = ((xc)object).o();
            if (n2 == 1) {
                pDFStyle.setFormStyle(8);
            } else if (n2 == 2) {
                pDFStyle.setFormStyle(9);
            }
        }
        pDFStyle.setLineColor(this.getColor());
        pDFStyle.setFillColor(null);
        if (!this.f("IC")) return pDFStyle;
        pDFStyle.setFillColor(this.k("IC").r());
        return pDFStyle;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void setStyle(PDFStyle pDFStyle) {
        if (this.i("Subtype").d("UnknownShape")) {
            throw new IllegalStateException("Shape not set");
        }
        ic ic2 = new ic("Border");
        ic ic3 = new ic();
        Shape shape = this.getShape();
        float f2 = pDFStyle.getLineWeighting();
        if (f2 == 1.0f || Float.isNaN(f2)) {
            ic2.e("W");
        } else {
            ic2.b("W", xc.a(f2));
        }
        this.a("BlendMode", wc.b(pDFStyle.o()));
        int n2 = pDFStyle.getFormStyle();
        float[] fArray = pDFStyle.getLineDashPattern();
        if (n2 == 6 || fArray != null) {
            if (fArray == null) {
                fArray = new float[]{3.0f};
            }
            ic2.b("S", wc.b("D"));
            ic2.b("D", new uc(fArray));
        } else {
            ic2.e("D");
            switch (n2) {
                case 8: {
                    ic2.e("S");
                    ic3.b("S", wc.b("C"));
                    ic3.b("I", xc.b(1));
                    break;
                }
                case 9: {
                    ic2.e("S");
                    ic3.b("S", wc.b("C"));
                    ic3.b("I", xc.b(2));
                    break;
                }
                default: {
                    ic2.b("S", wc.b("S"));
                }
            }
        }
        if (pDFStyle.getLineColor() instanceof Color) {
            this.setColor((Color)pDFStyle.getLineColor());
        } else {
            this.setColor(null);
        }
        if (pDFStyle.getFillColor() instanceof Color) {
            this.b("IC", new uc((Color)pDFStyle.getFillColor()));
        } else {
            this.e("IC");
        }
        if (ic2.p()) {
            this.e("BS");
        } else {
            this.b("BS", ic2);
        }
        if (ic3.p()) {
            this.e("BE");
        } else {
            this.b("BE", ic3);
        }
        this.setShape(shape);
        this.l.firePropertyChange("style", null, pDFStyle);
    }

    AffineTransform a(PDFPage pDFPage) {
        AffineTransform affineTransform = super.a(pDFPage);
        if (this.f("Vertices")) {
            AnnotationShape.a(this.k("Vertices"), affineTransform);
        }
        if (this.f("L")) {
            AnnotationShape.a(this.k("L"), affineTransform);
        }
        if (this.f("InkList")) {
            uc uc2 = this.k("InkList");
            for (int i2 = 0; i2 < uc2.o(); ++i2) {
                AnnotationShape.a(uc2.g(i2), affineTransform);
            }
        }
        return affineTransform;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Shape a(Shape shape, float f2, float f3) {
        if (f3 == 0.0f) {
            return shape;
        }
        double[] dArray = new double[6];
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = f3;
        Area area = new Area(shape);
        GeneralPath generalPath = new GeneralPath();
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(shape.getPathIterator(null), 2.0);
        while (true) {
            double d8;
            double d9;
            double d10;
            double d11;
            double d12;
            if (flatteningPathIterator.isDone()) {
                generalPath.append(area.getPathIterator(null), false);
                return generalPath;
            }
            int n2 = flatteningPathIterator.currentSegment(dArray);
            if (n2 == 0) {
                d2 = d4 = dArray[0];
                d3 = d5 = dArray[1];
            }
            if (n2 == 4) {
                dArray[0] = d2;
                dArray[1] = d3;
                n2 = 1;
            }
            if (n2 == 1 && (d12 = Math.sqrt((d11 = (d10 = dArray[0]) - d4) * d11 + (d9 = (d8 = dArray[1]) - d5) * d9)) > 0.001) {
                double d13;
                for (d13 = d6; d13 < d12; d13 += d7) {
                    if (d13 < 0.0) {
                        throw new Error();
                    }
                    double d14 = d4 + d13 / d12 * d11;
                    double d15 = d5 + d13 / d12 * d9;
                    area.add(new Area(new Ellipse2D.Double(d14 - (double)(f3 / 2.0f), d15 - (double)(f3 / 2.0f), f3, f3)));
                }
                d6 = d13 - d12;
                d4 = d10;
                d5 = d8;
            }
            flatteningPathIterator.next();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Shape a(Shape shape, PDFStyle pDFStyle) {
        String string = AnnotationShape.a(shape);
        if (!string.equals("Square") && !string.equals("Circle")) {
            if (!string.equals("Polygon")) return shape;
        }
        int n2 = pDFStyle.getFormStyle() == 8 ? 1 : (pDFStyle.getFormStyle() == 9 ? 2 : 0);
        if (n2 == 0) return shape;
        float f2 = pDFStyle.getLineWeighting();
        return this.a(shape, f2, n2 * 8);
    }

    private Rectangle2D b(Shape shape, PDFStyle pDFStyle) {
        float f2 = pDFStyle.getLineWeighting();
        String string = this.getFirstLineEnding();
        String string2 = this.getLastLineEnding();
        float[] fArray = AnnotationShape.a(string, shape, true);
        float[] fArray2 = AnnotationShape.a(string2, shape, false);
        Shape shape2 = AnnotationShape.a(string, f2, fArray);
        Shape shape3 = AnnotationShape.a(string2, f2, fArray2);
        BasicStroke basicStroke = new BasicStroke(f2, 0, 0);
        float f3 = 1.0f;
        shape = basicStroke.createStrokedShape(this.a(shape, pDFStyle));
        Rectangle2D rectangle2D = shape.getBounds2D();
        if (shape2 != null) {
            rectangle2D = rectangle2D.createUnion(basicStroke.createStrokedShape(shape2).getBounds2D());
        }
        if (shape3 != null) {
            rectangle2D = rectangle2D.createUnion(basicStroke.createStrokedShape(shape3).getBounds2D());
        }
        if (f3 != 0.0f) {
            rectangle2D.setRect(rectangle2D.getMinX() - (double)f3, rectangle2D.getMinY() - (double)f3, rectangle2D.getWidth() + (double)f3 + (double)f3, rectangle2D.getHeight() + (double)f3 + (double)f3);
        }
        return rectangle2D;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(Rectangle2D rectangle2D) {
        float[] fArray = this.f("Rect") ? this.k("Rect").a((float[])null) : null;
        float[] fArray2 = new float[]{(float)rectangle2D.getMinX(), (float)rectangle2D.getMinY(), (float)rectangle2D.getMaxX(), (float)rectangle2D.getMaxY()};
        if (fArray == null || Math.abs(fArray[2] - fArray[0] - (fArray2[2] - fArray2[0])) > 1.0f || Math.abs(fArray[3] - fArray[1] - (fArray2[3] - fArray2[1])) > 1.0f) {
            this.setRebuildRequired(true);
        }
        this.b("Rect", new uc(fArray2));
        PDFPage pDFPage = this.getPage();
        if (pDFPage != null) {
            this.a(pDFPage.C());
        }
        this.l.firePropertyChange("rectangle", fArray, fArray2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void rebuild() {
        Cloneable cloneable;
        int n2;
        Shape shape;
        String string = this.getType();
        if (this.getPage() == null || !this.f("C") && !this.f("IC") || string.equals("Line") && !this.f("C") || (shape = this.getShape()) == null) {
            return;
        }
        PDFStyle pDFStyle = this.getStyle();
        float f2 = pDFStyle.getLineWeighting();
        shape = this.getPage().A().createTransformedShape(this.a(shape, pDFStyle));
        String string2 = this.getFirstLineEnding();
        String string3 = this.getLastLineEnding();
        float[] fArray = AnnotationShape.a(string2, shape, true);
        float[] fArray2 = AnnotationShape.a(string3, shape, false);
        Shape shape2 = AnnotationShape.a(string2, f2, fArray);
        Shape shape3 = AnnotationShape.a(string3, f2, fArray2);
        PDFCanvas pDFCanvas = new PDFCanvas(0.0f, 0.0f);
        int n3 = pDFStyle.getFormStyle() == 8 ? 1 : (n2 = pDFStyle.getFormStyle() == 9 ? 2 : 0);
        if (n2 == 0 && (this.getType().equals("Square") || this.getType().equals("Circle"))) {
            cloneable = shape.getBounds2D();
            pDFCanvas.setStyle(pDFStyle);
            float f3 = (float)((RectangularShape)cloneable).getMinX();
            float f4 = (float)((RectangularShape)cloneable).getMinY();
            float f5 = (float)((RectangularShape)cloneable).getMaxX();
            float f6 = (float)((RectangularShape)cloneable).getMaxY();
            f3 += f2 / 2.0f;
            f4 += f2 / 2.0f;
            f5 -= f2 / 2.0f;
            f6 -= f2 / 2.0f;
            if (string.equals("Square")) {
                pDFCanvas.drawRectangle(f3, f4, f5, f6);
            } else {
                pDFCanvas.drawEllipse(f3, f4, f5, f6);
            }
        } else {
            PDFStyle pDFStyle2;
            cloneable = pDFStyle;
            if (string.equals("PolyLine") || string.equals("Line") || string.equals("Ink")) {
                cloneable = new PDFStyle(pDFStyle);
                ((PDFStyle)cloneable).setFillColor(null);
            }
            if (string.equals("Ink")) {
                shape = AnnotationShape.b(shape);
            }
            pDFCanvas.setStyle((PDFStyle)cloneable);
            pDFCanvas.drawShape(shape);
            pDFStyle.setLineDash(null, 0.0f);
            if (shape2 != null) {
                pDFStyle2 = pDFStyle;
                if (!AnnotationShape.s(string2)) {
                    pDFStyle2 = new PDFStyle(pDFStyle);
                    pDFStyle2.setFillColor(null);
                }
                pDFCanvas.setStyle(pDFStyle2);
                pDFCanvas.drawShape(shape2);
            }
            if (shape3 != null) {
                pDFStyle2 = pDFStyle;
                if (!AnnotationShape.s(string3)) {
                    pDFStyle2 = new PDFStyle(pDFStyle);
                    pDFStyle2.setFillColor(null);
                }
                pDFCanvas.setStyle(pDFStyle2);
                pDFCanvas.drawShape(shape3);
            }
        }
        pDFCanvas.flush();
        pDFCanvas.b("BBox", this.k("Rect"));
        cloneable = new ic();
        ((hc)cloneable).b("N", pDFCanvas);
        this.b("AP", (gc)cloneable);
        super.rebuild();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static float[] a(String string, Shape shape, boolean bl) {
        if (string == null || string.equals("None")) {
            return null;
        }
        float[] fArray = new float[4];
        float[] fArray2 = new float[6];
        PathIterator pathIterator = shape.getPathIterator(null);
        int n2 = bl ? 2 : 0;
        int n3 = 2 - n2;
        pathIterator.currentSegment(fArray2);
        fArray[n2] = fArray2[0];
        fArray[n2 + 1] = fArray2[1];
        pathIterator.next();
        pathIterator.currentSegment(fArray2);
        fArray[n3] = fArray2[0];
        fArray[n3 + 1] = fArray2[1];
        pathIterator.next();
        if (!bl) {
            while (!pathIterator.isDone()) {
                pathIterator.currentSegment(fArray2);
                fArray[n2] = fArray[n3];
                fArray[n2 + 1] = fArray[n3 + 1];
                fArray[n3] = fArray2[0];
                fArray[n3 + 1] = fArray2[1];
                pathIterator.next();
            }
        }
        return fArray;
    }

    static Shape a(String string, float f2, float[] fArray) {
        if (string == null) {
            return null;
        }
        if (string.equals("Square")) {
            double d2 = AnnotationShape.a(fArray);
            double d3 = (double)f2 * 2.5;
            if (d3 < 2.5) {
                d3 = 2.5;
            }
            double d4 = fArray[2] - fArray[0] >= 0.0f ? d3 : -d3;
            double d5 = d4;
            double d6 = d2 + Math.toRadians(45.0);
            float f3 = (float)(Math.cos(d6) * d5);
            float f4 = (float)(Math.sin(d6) * d5);
            d6 = d2 + Math.toRadians(135.0);
            float f5 = (float)(Math.cos(d6) * d5);
            float f6 = (float)(Math.sin(d6) * d5);
            d6 = d2 + Math.toRadians(225.0);
            float f7 = (float)(Math.cos(d6) * d5);
            float f8 = (float)(Math.sin(d6) * d5);
            d6 = d2 + Math.toRadians(315.0);
            float f9 = (float)(Math.cos(d6) * d5);
            float f10 = (float)(Math.sin(d6) * d5);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(fArray[2] - f3, fArray[3] - f4);
            generalPath.lineTo(fArray[2] - f5, fArray[3] - f6);
            generalPath.lineTo(fArray[2] - f7, fArray[3] - f8);
            generalPath.lineTo(fArray[2] - f9, fArray[3] - f10);
            generalPath.closePath();
            return generalPath;
        }
        if (string.equals("Circle")) {
            float f11 = f2 * 2.5f;
            if (f11 < 1.0f) {
                f11 = 1.0f;
            }
            return new Ellipse2D.Float(fArray[2] - f11, fArray[3] - f11, f11 * 2.0f, f11 * 2.0f);
        }
        if (string.equals("Diamond")) {
            double d7 = AnnotationShape.a(fArray);
            double d8 = (double)f2 * 2.5;
            if (d8 < 2.5) {
                d8 = 2.5;
            }
            double d9 = fArray[2] - fArray[0] >= 0.0f ? d8 : -d8;
            double d10 = d9;
            double d11 = d7 - Math.toRadians(180.0);
            float f12 = (float)(Math.cos(d11) * d10);
            float f13 = (float)(Math.sin(d11) * d10);
            d11 = d7 - Math.toRadians(90.0);
            float f14 = (float)(Math.cos(d11) * d10);
            float f15 = (float)(Math.sin(d11) * d10);
            d11 = d7;
            float f16 = (float)(Math.cos(d11) * d10);
            float f17 = (float)(Math.sin(d11) * d10);
            d11 = d7 + Math.toRadians(90.0);
            float f18 = (float)(Math.cos(d11) * d10);
            float f19 = (float)(Math.sin(d11) * d10);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(fArray[2] - f12, fArray[3] - f13);
            generalPath.lineTo(fArray[2] - f14, fArray[3] - f15);
            generalPath.lineTo(fArray[2] - f16, fArray[3] - f17);
            generalPath.lineTo(fArray[2] - f18, fArray[3] - f19);
            generalPath.closePath();
            return generalPath;
        }
        if (string.equals("OpenArrow")) {
            double d12 = AnnotationShape.a(fArray);
            double d13 = d12 - Math.toRadians(30.0);
            double d14 = fArray[2] - fArray[0] >= 0.0f ? 10.0 : -10.0;
            double d15 = d14;
            float f20 = (float)(Math.cos(d13) * (d15 *= (double)f2));
            float f21 = (float)(Math.sin(d13) * d15);
            d13 = d12 + Math.toRadians(30.0);
            float f22 = (float)(Math.cos(d13) * d15);
            float f23 = (float)(Math.sin(d13) * d15);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(fArray[2] - f20, fArray[3] - f21);
            generalPath.lineTo(fArray[2], fArray[3]);
            generalPath.lineTo(fArray[2] - f22, fArray[3] - f23);
            return generalPath;
        }
        if (string.equals("ClosedArrow")) {
            double d16 = AnnotationShape.a(fArray);
            double d17 = d16 - Math.toRadians(30.0);
            double d18 = fArray[2] - fArray[0] >= 0.0f ? 10.0 : -10.0;
            double d19 = d18;
            float f24 = (float)(Math.cos(d17) * (d19 *= (double)f2));
            float f25 = (float)(Math.sin(d17) * d19);
            d17 = d16 + Math.toRadians(30.0);
            float f26 = (float)(Math.cos(d17) * d19);
            float f27 = (float)(Math.sin(d17) * d19);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(fArray[2] - f24, fArray[3] - f25);
            generalPath.lineTo(fArray[2], fArray[3]);
            generalPath.lineTo(fArray[2] - f26, fArray[3] - f27);
            generalPath.closePath();
            return generalPath;
        }
        if (string.equals("Butt")) {
            double d20 = AnnotationShape.a(fArray);
            double d21 = d20 - Math.toRadians(90.0);
            double d22 = fArray[2] - fArray[0] >= 0.0f ? 2.5 : -2.5;
            double d23 = d22;
            float f28 = (float)(Math.cos(d21) * (d23 *= (double)f2));
            float f29 = (float)(Math.sin(d21) * d23);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(fArray[2] - f28, fArray[3] - f29);
            generalPath.lineTo(fArray[2] + f28, fArray[3] + f29);
            return generalPath;
        }
        if (string.equals("ROpenArrow")) {
            double d24 = AnnotationShape.a(fArray);
            double d25 = d24 - Math.toRadians(30.0);
            double d26 = fArray[2] - fArray[0] >= 0.0f ? -10.0 : 10.0;
            double d27 = d26;
            float f30 = (float)(Math.cos(d25) * (d27 *= (double)f2));
            float f31 = (float)(Math.sin(d25) * d27);
            d25 = d24 + Math.toRadians(30.0);
            float f32 = (float)(Math.cos(d25) * d27);
            float f33 = (float)(Math.sin(d25) * d27);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(fArray[2] - f30, fArray[3] - f31);
            generalPath.lineTo(fArray[2], fArray[3]);
            generalPath.lineTo(fArray[2] - f32, fArray[3] - f33);
            return generalPath;
        }
        if (string.equals("RClosedArrow")) {
            double d28 = AnnotationShape.a(fArray);
            double d29 = d28 - Math.toRadians(30.0);
            double d30 = fArray[2] - fArray[0] >= 0.0f ? -10.0 : 10.0;
            double d31 = d30;
            float f34 = (float)(Math.cos(d29) * (d31 *= (double)f2));
            float f35 = (float)(Math.sin(d29) * d31);
            d29 = d28 + Math.toRadians(30.0);
            float f36 = (float)(Math.cos(d29) * d31);
            float f37 = (float)(Math.sin(d29) * d31);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(fArray[2] - f34, fArray[3] - f35);
            generalPath.lineTo(fArray[2], fArray[3]);
            generalPath.lineTo(fArray[2] - f36, fArray[3] - f37);
            generalPath.closePath();
            return generalPath;
        }
        if (string.equals("Slash")) {
            double d32 = AnnotationShape.a(fArray);
            double d33 = d32 - Math.toRadians(120.0);
            double d34 = fArray[2] - fArray[0] >= 0.0f ? 2.5 : -2.5;
            double d35 = d34;
            float f38 = (float)(Math.cos(d33) * (d35 *= (double)f2));
            float f39 = (float)(Math.sin(d33) * d35);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(fArray[2] - f38, fArray[3] - f39);
            generalPath.lineTo(fArray[2] + f38, fArray[3] + f39);
            return generalPath;
        }
        return null;
    }

    private static double a(float[] fArray) {
        float f2 = fArray[2] - fArray[0];
        float f3 = fArray[3] - fArray[1];
        return Math.atan(f3 / f2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static GeneralPath b(Shape shape) {
        GeneralPath generalPath2 = shape instanceof GeneralPath ? (GeneralPath)shape : new GeneralPath(shape);
        GeneralPath generalPath3 = new GeneralPath();
        float[] fArray = new float[6];
        ArrayList arrayList = new ArrayList();
        Object object = new FlatteningPathIterator(generalPath2.getPathIterator(null), 1.0);
        while (true) {
            if (object.isDone()) {
                if (arrayList == null) return generalPath3;
                object = AnnotationShape.a(arrayList.toArray(new Point2D.Float[0]));
                if (object == null) return generalPath3;
                generalPath3.append((Shape)object, false);
                return generalPath3;
            }
            int n2 = object.currentSegment(fArray);
            if (n2 == 4 && arrayList.size() > 1) {
                arrayList.add(arrayList.get(0));
            } else if (n2 == 0) {
                Shape shape2;
                if (arrayList != null && (shape2 = AnnotationShape.a(arrayList.toArray(new Point2D.Float[0]))) != null) {
                    generalPath3.append(shape2, false);
                }
                arrayList = new ArrayList();
                arrayList.add(new Point2D.Float(fArray[0], fArray[1]));
            } else {
                if (n2 != 1) throw new IllegalStateException("Curve?" + n2);
                arrayList.add(new Point2D.Float(fArray[0], fArray[1]));
            }
            object.next();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Shape a(Point2D.Float[] floatArray) {
        int n2;
        if (floatArray.length < 2) {
            return null;
        }
        if (floatArray.length == 2) {
            return new Line2D.Float(floatArray[0], floatArray[1]);
        }
        int n3 = floatArray.length - 1;
        double[] dArray = new double[n3 + 1];
        double[] dArray2 = new double[n3 + 1];
        double[] dArray3 = new double[n3 + 1];
        double[] dArray4 = new double[n3 + 1];
        double[] dArray5 = new double[n3 + 1];
        dArray[0] = 0.5;
        for (n2 = 1; n2 < n3; ++n2) {
            dArray[n2] = 1.0 / (4.0 - dArray[n2 - 1]);
        }
        dArray[n3] = 1.0 / (2.0 - dArray[n3 - 1]);
        dArray2[0] = 3.0 * (floatArray[1].getX() - floatArray[0].getX()) * dArray[0];
        dArray3[0] = 3.0 * (floatArray[1].getY() - floatArray[0].getY()) * dArray[0];
        for (n2 = 1; n2 <= n3; ++n2) {
            dArray2[n2] = (3.0 * (floatArray[n2 == n3 ? n2 : n2 + 1].getX() - floatArray[n2 - 1].getX()) - dArray2[n2 - 1]) * dArray[n2];
            dArray3[n2] = (3.0 * (floatArray[n2 == n3 ? n2 : n2 + 1].getY() - floatArray[n2 - 1].getY()) - dArray3[n2 - 1]) * dArray[n2];
        }
        dArray4[n3] = dArray2[n3];
        dArray5[n3] = dArray3[n3];
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            dArray4[n2] = dArray2[n2] - dArray[n2] * dArray4[n2 + 1];
            dArray5[n2] = dArray3[n2] - dArray[n2] * dArray5[n2 + 1];
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)floatArray[0].getX(), (float)floatArray[0].getY());
        int i2 = 0;
        while (i2 < n3) {
            double d4 = floatArray[i2].getX();
            double d5 = dArray4[i2];
            double d6 = 3.0 * (floatArray[i2 + 1].getX() - floatArray[i2].getX()) - 2.0 * dArray4[i2] - dArray4[i2 + 1];
            double d7 = 2.0 * (floatArray[i2].getX() - floatArray[i2 + 1].getX()) + dArray4[i2] + dArray4[i2 + 1];
            double d8 = floatArray[i2].getY();
            double d9 = dArray5[i2];
            double d10 = 3.0 * (floatArray[i2 + 1].getY() - floatArray[i2].getY()) - 2.0 * dArray5[i2] - dArray5[i2 + 1];
            double d11 = 2.0 * (floatArray[i2].getY() - floatArray[i2 + 1].getY()) + dArray5[i2] + dArray5[i2 + 1];
            for (double d12 = 0.0; d12 <= 1.0; d12 += 0.1) {
                double d13 = ((d7 * d12 + d6) * d12 + d5) * d12 + d4;
                double d14 = ((d11 * d12 + d10) * d12 + d9) * d12 + d8;
                generalPath.lineTo((float)d13, (float)d14);
            }
            ++i2;
        }
        return generalPath;
    }
}

