/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.math.BigInteger;
import java.text.DecimalFormat;
import org.faceless.pdf2.LayoutBox;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFCanvas;
import org.faceless.pdf2.PDFStyle;
import org.faceless.pdf2.StandardFont;
import org.faceless.pdf2.ab;
import org.faceless.pdf2.bb;
import org.faceless.pdf2.c;
import org.faceless.pdf2.cb;
import org.faceless.pdf2.db;
import org.faceless.pdf2.eb;

public class BarCode {
    private float a = 8.0f;
    private final String b;
    private final String c;
    private final int d;
    private double[] e;
    private int[] f;
    private float g;
    private float h;
    private float i;
    private float j;
    private float k;
    private float l;
    private boolean m;
    private Paint n;
    private static final String[] o = new String[]{"%U", "$A", "$B", "$C", "$D", "$E", "$F", "$G", "$H", "$I", "$J", "$K", "$L", "$M", "$N", "$O", "$P", "$Q", "$R", "$S", "$T", "$U", "$V", "$W", "$X", "$Y", "$Z", "%A", "%B", "%C", "%D", "%E", " ", "/A", "/B", "/C", "/D", "/E", "/F", "/G", "/H", "/I", "/J", "/K", "/L", "-", ".", "/O", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "/Z", "%F", "%G", "%H", "%I", "%J", "%V", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "%K", "%L", "%M", "%N", "%O", "%W", "+A", "+B", "+C", "+D", "+E", "+F", "+G", "+H", "+I", "+J", "+K", "+L", "+M", "+N", "+O", "+P", "+Q", "+R", "+S", "+T", "+U", "+V", "+W", "+X", "+Y", "+Z", "%P", "%Q", "%R", "%S", "%T"};
    private static int[][] p = new int[66][];
    public static final char MAXICODE_SHIFTA = '\ufff0';
    public static final char MAXICODE_SHIFTB = '\ufff1';
    public static final char MAXICODE_SHIFTC = '\ufff2';
    public static final char MAXICODE_SHIFTD = '\ufff3';
    public static final char MAXICODE_SHIFTE = '\ufff4';
    public static final char MAXICODE_TWOSHIFTA = '\ufff5';
    public static final char MAXICODE_THREESHIFTA = '\ufff6';
    public static final char MAXICODE_LATCHA = '\ufff7';
    public static final char MAXICODE_LATCHB = '\ufff8';
    public static final char MAXICODE_LOCK = '\ufff9';
    public static final char MAXICODE_GS = '\u001d';
    public static final char MAXICODE_RS = '\u001e';
    public static final char DATAMATRIX_LATCH_BASE256 = '\ueee7';
    public static final char DATAMATRIX_LATCH_C40 = '\ueee6';
    public static final char DATAMATRIX_LATCH_ANSIX12 = '\ueeee';
    public static final char DATAMATRIX_LATCH_TEXT = '\ueeef';
    public static final char DATAMATRIX_LATCH_EDIFACT = '\ueef0';
    public static final char DATAMATRIX_LATCH_ASCII = '\uee00';
    public static final char FNC1 = '\uefc1';
    public static final char FNC2 = '\uefc2';
    public static final char FNC3 = '\uefc3';
    public static final char FNC4 = '\uefc4';

    BarCode() {
        this.d = 0;
        this.b = null;
        this.c = null;
    }

    private BarCode(int n2, String string, String string2, double[] dArray, int n3, int n4) {
        this.d = n2;
        this.b = string;
        this.c = string2;
        this.e = dArray;
        this.g = n3;
        this.h = n4;
        this.a = 8.0f;
        this.j = this.getMinimumHeight();
    }

    private static BarCode a(String string, boolean bl, float f2, float f3, boolean bl2) {
        String string2 = BarCode.a(string, bl, bl2);
        BarCode barCode = new BarCode(1, string, string2, new double[]{f2, f2 * f3}, 10, 9);
        barCode.setShowText(true);
        return barCode;
    }

    private static BarCode a(String string, float f2, float f3, int n2) {
        String string2 = BarCode.a(string, n2);
        BarCode barCode = new BarCode(1, string, string2, new double[]{f2, f2 * f3}, 10, 10);
        barCode.setShowText(true);
        return barCode;
    }

    public static BarCode newInterleaved25(String string, boolean bl) {
        return BarCode.newInterleaved25(string, bl, 1.0f, 2.8f);
    }

    public static BarCode newInterleaved25(String string, boolean bl, float f2, float f3) {
        float f4 = f2;
        float f5 = f3;
        int n2 = bl ? 1 : 0;
        return BarCode.a(string, f4, f5, n2);
    }

    public static BarCode newDeutschePostLeitcode(int n2, int n3, int n4, int n5) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new DecimalFormat("00000").format(n2));
        stringBuffer.append(new DecimalFormat("000").format(n3));
        stringBuffer.append(new DecimalFormat("000").format(n4));
        stringBuffer.append(new DecimalFormat("00").format(n5));
        return BarCode.newDeutschePostCode(stringBuffer.toString());
    }

    public static BarCode newDeutschePostIdentcode(int n2, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new DecimalFormat("00").format(n2));
        stringBuffer.append(new DecimalFormat("000").format(n3));
        stringBuffer.append(new DecimalFormat("000000").format(n4));
        return BarCode.newDeutschePostCode(stringBuffer.toString());
    }

    public static BarCode newDeutschePostCode(String string) {
        return BarCode.a(string, 1.0f, 3.0f, 2);
    }

    public static BarCode newCode39(String string, boolean bl) {
        return BarCode.newCode39(string, bl, 1.0f, 2.8f);
    }

    public static BarCode newCode39(String string, boolean bl, float f2, float f3) {
        return BarCode.a(string, bl, f2, f3, false);
    }

    public static BarCode newCode39Extended(String string, boolean bl) {
        return BarCode.newCode39Extended(string, bl, 1.0f, 2.8f);
    }

    public static BarCode newCode39Extended(String string, boolean bl, float f2, float f3) {
        return BarCode.a(string, bl, f2, f3, true);
    }

    public static BarCode newCode93(String string, float f2) {
        String string2 = BarCode.a(string);
        BarCode barCode = new BarCode(1, string, string2, new double[]{f2, f2, f2 * 2.0f, f2 * 3.0f, f2 * 4.0f}, 10, 9);
        barCode.setShowText(true);
        return barCode;
    }

    public static BarCode newEAN13(String string) {
        return BarCode.newEAN13(string, 0.8);
    }

    public static BarCode newEAN13(String string, double d2) {
        string = BarCode.d(string);
        String string2 = BarCode.e(string);
        double d3 = 0.936 * d2;
        BarCode barCode = new BarCode(3, string, string2, new double[]{d3, d3, d3 * 2.0, d3 * 3.0, d3 * 4.0, d3 * 5.0, d3 * 6.0}, 11, 7);
        barCode.a(10.0 * d2);
        barCode.setShowText(true);
        return barCode;
    }

    public static BarCode newEAN8(String string) {
        return BarCode.newEAN8(string, 0.8);
    }

    public static BarCode newEAN8(String string, double d2) {
        string = BarCode.c(string);
        String string2 = BarCode.f(string);
        double d3 = 0.936 * d2;
        BarCode barCode = new BarCode(4, string, string2, new double[]{d3, d3, d3 * 2.0, d3 * 3.0, d3 * 4.0, d3 * 5.0, d3 * 6.0}, 11, 7);
        barCode.a(10.0 * d2);
        barCode.setShowText(true);
        return barCode;
    }

    public static BarCode newCodabar(String string, float f2) {
        String string2 = BarCode.h(string);
        double d2 = f2;
        BarCode barCode = new BarCode(2, string, string2, new double[]{d2, d2, d2 * 2.0, d2 * 3.0, d2 * 4.0, d2 * 5.0, d2 * 6.0}, 9, 9);
        barCode.a((double)(8.0f * f2));
        barCode.setShowText(true);
        return barCode;
    }

    public static BarCode newCode128(String string) {
        return BarCode.newCode128(string, 1.0);
    }

    public static BarCode newCode128(String string, double d2) {
        string = string.replace('\u0081', '\uefc1');
        string = string.replace('\u0082', '\uefc2');
        string = string.replace('\u0083', '\uefc3');
        string = string.replace('\u0084', '\uefc4');
        String string2 = BarCode.b(string);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n2 = "\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\uefc1\uefc2\uefc3\uefc4\u0091\u0092\u0093".indexOf(string.charAt(i2));
            if (n2 < 0) continue;
            string = string.substring(0, i2) + " " + string.substring(i2 + 1);
        }
        double d3 = d2;
        BarCode barCode = new BarCode(2, string, string2, new double[]{d3, d3, d3 * 2.0, d3 * 3.0, d3 * 4.0}, 10, 10);
        barCode.a(8.0 * d2);
        barCode.setShowText(true);
        return barCode;
    }

    public static BarCode newPostnet(String string) {
        String string2 = BarCode.i(string);
        BarCode barCode = new BarCode(6, string, string2, new double[]{3.13, 1.4}, 0, 0);
        barCode.j = 9.0f;
        barCode.f = new int[]{128, 255};
        return barCode;
    }

    public static BarCode newRM4SCC(String string) {
        String string2 = BarCode.j(string);
        BarCode barCode = new BarCode(5, string, string2, new double[]{2.8, 1.4}, 6, 6);
        barCode.j = 25.0f;
        barCode.i = 6.0f;
        barCode.f = new int[]{24130, 160, 24224, 255};
        return barCode;
    }

    public static BarCode newIntelligentMail(String string) {
        String string2 = BarCode.k(string);
        BarCode barCode = new BarCode(5, string, string2, new double[]{3.3, 1.4}, 9, 9);
        barCode.j = 14.5f;
        barCode.i = 2.02f;
        barCode.f = new int[]{21845, 170, 21930, 255};
        return barCode;
    }

    public static BarCode newPDF417(String string) {
        return BarCode.newPDF417(string, 1.0f, -1, 0);
    }

    public static BarCode newPDF417(String string, float f2, int n2, int n3) {
        db db2 = new db(string, n2, f2, n3);
        return db2;
    }

    public static BarCode newPDF417(byte[] byArray, float f2, int n2, int n3) {
        db db2 = new db(byArray, n2, f2, n3);
        return db2;
    }

    public static BarCode newMaxiCode(String string, boolean bl) {
        cb cb2 = new cb(string, bl);
        return cb2;
    }

    public static BarCode newMaxiCode(int n2, String string, int n3, String string2) {
        cb cb2 = new cb(n2, string, n3, string2);
        return cb2;
    }

    public static BarCode newMaxiCode(int n2, String string, String string2, String string3) {
        return BarCode.newMaxiCode(n2, string, cb.l(string2), string3);
    }

    public static BarCode newQRCode(String string, double d2, int n2, int n3) {
        if (n2 == 1) {
            n2 = 1;
        } else if (n2 == 2) {
            n2 = 0;
        } else if (n2 == 3) {
            n2 = 3;
        } else if (n2 == 4) {
            n2 = 2;
        } else {
            throw new IllegalArgumentException("Invalid ECC level " + n2);
        }
        return new eb(string, n2, n3, (float)(d2 / 25.4 * 72.0));
    }

    public static BarCode newQRCode(byte[] byArray, double d2, int n2, int n3) {
        if (n2 == 1) {
            n2 = 1;
        } else if (n2 == 2) {
            n2 = 0;
        } else if (n2 == 3) {
            n2 = 3;
        } else if (n2 == 4) {
            n2 = 2;
        } else {
            throw new IllegalArgumentException("Invalid ECC level " + n2);
        }
        return new eb(byArray, n2, n3, (float)(d2 / 25.4 * 72.0));
    }

    public static BarCode newQRCode(String string, String string2, double d2, int n2, int n3) {
        if (n2 == 1) {
            n2 = 1;
        } else if (n2 == 2) {
            n2 = 0;
        } else if (n2 == 3) {
            n2 = 3;
        } else if (n2 == 4) {
            n2 = 2;
        } else {
            throw new IllegalArgumentException("Invalid ECC level " + n2);
        }
        return new eb(string, string2, n2, n3, (float)(d2 / 25.4 * 72.0));
    }

    public static BarCode newDataMatrixCode(String string) {
        return BarCode.newDataMatrixCode(string, 0, 0);
    }

    public static BarCode newDataMatrixCode(String string, int n2, int n3) {
        return new bb(string, n2, n3);
    }

    public static BarCode newDataMatrixCode(byte[] byArray, int n2, int n3) {
        return new bb(byArray, n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BarCode newDataMatrixCode(String string, int n2, int n3, char c2) {
        if (c2 != '\ueee7' && c2 != '\ueee6' && c2 != '\ueeef' && c2 != '\uee00' && c2 != '\ueeee' && c2 != '\ueef0') {
            throw new IllegalArgumentException("Invalid encoder");
        }
        string = c2 + string;
        return BarCode.newDataMatrixCode(string, n2, n3);
    }

    public static BarCode newAztecCode(String string) {
        ab ab2 = new ab();
        ab2.l(string);
        return ab2;
    }

    private void a(double d2) {
        this.a = (float)d2;
    }

    public void setInkBleed(double d2, double d3) {
        this.k = (float)d2;
        this.l = (float)d3;
    }

    public void setColor(Paint paint) {
        this.n = paint;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float getWidth() {
        if (this.d == 5 || this.d == 6) {
            int n2 = 0;
            int n3 = 0;
            while (true) {
                if (n3 >= this.c.length()) {
                    return (float)((double)n2 * this.e[0] + (double)this.g + (double)this.h);
                }
                char c2 = this.c.charAt(n3);
                if (c2 != ' ') {
                    ++n2;
                }
                ++n3;
            }
        }
        double d2 = (double)(this.g + this.h) * this.e[0];
        for (int i2 = 0; i2 < this.c.length(); ++i2) {
            char c3 = this.c.charAt(i2);
            if (c3 == ' ') continue;
            d2 += this.e[c3 - 48];
        }
        if (this.d == 3 && this.b.length() > 13 || this.d == 4 && this.b.length() > 8) {
            d2 += this.e[0] * 9.0;
        }
        return (float)d2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setWidth(float f2) {
        if (this.d == 3 || this.d == 5 || this.d == 6 || this.d == 4) {
            if (!((double)Math.abs(f2 - this.getWidth()) > 0.01)) return;
            throw new IllegalStateException("Can't change width on this type of BarCode");
        }
        float f3 = f2 / this.getWidth();
        int n2 = 0;
        while (true) {
            if (n2 >= this.e.length) {
                float f4 = this.getMinimumHeight();
                if (!(this.j < f4)) return;
                this.j = f4;
                return;
            }
            int n3 = n2++;
            this.e[n3] = this.e[n3] * (double)f3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float getMinimumHeight() {
        float f2;
        if (this.d == 6) return this.j;
        if (this.d == 5) {
            return this.j;
        }
        if (this.d == 3) {
            f2 = (float)(this.e[0] * 68.56);
            return this.a(f2);
        }
        if (this.d == 4) {
            f2 = (float)(this.e[0] * 40.65);
            return this.a(f2);
        }
        float f3 = (float)((double)(this.g + this.h) * this.e[0]);
        f2 = Math.max(18.0f, (this.getWidth() - f3) * 0.15f);
        return this.a(f2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setShowText(boolean bl) {
        this.m = bl && this.d != 5 && this.d != 6 && this.d != 0;
    }

    public float getHeight() {
        return this.a(this.j);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private float a(float f2) {
        float f3;
        if (this.d == 3 || this.d == 4) {
            float f4;
            if (this.m) {
                f4 = f2 + this.a;
                return f4;
            }
            f4 = f2 * 1.1f;
            return f4;
        }
        if (this.m) {
            f3 = f2 + this.a * 1.2f;
            return f3;
        }
        f3 = f2;
        return f3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setHeight(float f2) {
        if (this.d == 6 || this.d == 5) {
            if (!((double)Math.abs(f2 - this.getMinimumHeight()) > 0.1)) return;
            throw new IllegalStateException("Can't set height on this type of code");
        }
        if (this.d == 3 || this.d == 4) {
            this.j = this.m ? f2 - this.a : f2 / 1.1f;
            return;
        }
        this.j = this.m ? f2 - this.a * 1.2f : f2;
    }

    public PDFCanvas getCanvas() {
        PDFCanvas pDFCanvas = new PDFCanvas(this.getWidth(), this.getHeight());
        PDFStyle pDFStyle = new PDFStyle();
        Paint paint = this.n == null ? org.faceless.pdf2.c.o : this.n;
        pDFStyle.setFillColor(paint);
        pDFStyle.setStrokeAdjustment(true);
        pDFCanvas.setStyle(pDFStyle);
        pDFCanvas.H();
        this.doBarcodeOutput(pDFCanvas);
        pDFCanvas.flush();
        return pDFCanvas;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferedImage getBufferedImage(double d2, Paint paint) {
        int n2 = 0;
        int n3 = 0;
        if (d2 == 0.0) {
            d2 = this instanceof cb ? 2.5 : (this instanceof eb || this instanceof db || this instanceof bb ? 1.0 : 1.0 / this.e[0]);
        }
        boolean bl = paint == null || !(paint instanceof Color) || ((Color)paint).getAlpha() != 0;
        BufferedImage bufferedImage = new BufferedImage((int)Math.round((double)this.getWidth() * d2) + n2 * 2, (int)Math.round((double)this.getHeight() * d2) + n3 * 2, Color.white.equals(paint) && (this.n == null || Color.black.equals(this.n)) ? 12 : (bl ? 2 : 1));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        graphics2D.transform(new AffineTransform(d2, 0.0, 0.0, d2, (double)n2, (double)n3));
        graphics2D.setPaint(this.n == null ? Color.black : this.n);
        this.doBarcodeOutput(graphics2D);
        if (!PDF.isLicensed()) {
            graphics2D.setTransform(new AffineTransform());
            Font font = new Font("SansSerif", 1, Math.min(bufferedImage.getHeight() / 2, bufferedImage.getWidth() / 6));
            graphics2D.setFont(font);
            Shape shape = font.createGlyphVector(graphics2D.getFontRenderContext(), "DEMO").getOutline(((float)bufferedImage.getWidth() - (float)font.getSize() * 3.1f) / 2.0f, (float)bufferedImage.getHeight() / 1.9f);
            graphics2D.setColor(Color.white);
            graphics2D.transform(AffineTransform.getTranslateInstance(-1.0, -1.0));
            graphics2D.fill(shape);
            graphics2D.transform(AffineTransform.getTranslateInstance(2.0, 0.0));
            graphics2D.fill(shape);
            graphics2D.transform(AffineTransform.getTranslateInstance(0.0, 2.0));
            graphics2D.fill(shape);
            graphics2D.transform(AffineTransform.getTranslateInstance(-2.0, 0.0));
            graphics2D.fill(shape);
            graphics2D.transform(AffineTransform.getTranslateInstance(1.0, -1.0));
            graphics2D.setColor(Color.black);
            graphics2D.fill(shape);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doBarcodeOutput(Object object) {
        if (PDF.s("BarCode")) {
            PDF.k.debug("BarCode", "value=\"" + this.b + "\" bars=\"" + this.c + "\"");
        }
        if (this.d == 5 || this.d == 6) {
            double d2 = this.g;
            float f2 = this.getHeight() - this.i * 2.0f;
            int n2 = 0;
            while (n2 < this.c.length()) {
                char c2 = this.c.charAt(n2);
                if (c2 != ' ') {
                    float f3 = (float)(this.f[c2 - 48] >> 8) / 255.0f;
                    float f4 = (float)(this.f[c2 - 48] & 0xFF) / 255.0f;
                    this.dorect(object, (float)d2 - this.k / 2.0f, f3 * f2 + this.i - this.l / 2.0f, (float)this.e[1] + this.k, f4 * f2 + this.l);
                    d2 += this.e[0];
                }
                ++n2;
            }
            return;
        }
        double d3 = (double)this.g * this.e[0];
        int n3 = 0;
        int n4 = 0;
        int n5 = this.d == 3 ? 96 : (this.d == 4 ? 68 : 0);
        float f5 = this.getWidth();
        for (int i2 = 0; i2 < this.c.length(); ++i2) {
            float f6;
            float f7;
            int n6;
            block36: {
                block34: {
                    block35: {
                        char c3 = this.c.charAt(i2);
                        if (c3 == ' ') continue;
                        n6 = c3 - 48;
                        n3 += n6;
                        f7 = this.j;
                        f6 = 0.0f;
                        if (this.d != 3) break block34;
                        if (n3 >= 4 && (n3 <= 91 || n3 >= n5) && (n3 <= 45 || n3 >= 50)) break block35;
                        f7 = (float)((double)f7 * 1.1);
                        break block36;
                    }
                    if (n3 == n5) {
                        f5 = (float)(d3 + (double)this.h * this.e[1]);
                        d3 += this.e[1] * 9.0;
                        break block36;
                    } else if (n3 > n5) {
                        f6 = this.a;
                        f7 -= this.a;
                    }
                    break block36;
                }
                if (this.d == 4) {
                    if (n3 < 4 || n3 > 64 && n3 < n5 || n3 > 31 && n3 < 36) {
                        f7 = (float)((double)f7 * 1.1);
                    } else if (n3 == n5) {
                        f5 = (float)(d3 + (double)this.h * this.e[1]);
                        d3 += this.e[1] * 9.0;
                    } else if (n3 > n5) {
                        f6 = this.a;
                        f7 -= this.a;
                    }
                }
            }
            if (!(n4 & true)) {
                this.dorect(object, (float)d3 - this.k / 2.0f, this.getHeight() - f6 - f7 - this.l / 2.0f, (float)this.e[n6] + this.k, f7 + this.l);
            }
            d3 += this.e[n6];
            ++n4;
        }
        if (!this.m) return;
        PDFStyle pDFStyle = new PDFStyle();
        pDFStyle.setFont(new StandardFont(4), this.a);
        if (this.d == 3) {
            this.a(object, this.b.substring(0, 1), 0.0f, this.a, this.a, this.n, 1, 50.0f);
            this.a(object, this.b.substring(1, 7), f5 * 0.14f, this.a, this.a, this.n, 1, 50.0f);
            this.a(object, this.b.substring(7, 13), f5 * 0.545f, this.a, this.a, this.n, 1, 50.0f);
            if (this.b.length() <= 13) return;
            f5 = (float)((double)f5 + this.e[1] * (double)(9.0f - this.h + (float)(n3 - n5) / 2.0f));
            this.a(object, this.b.substring(13), f5, this.getHeight(), this.a, this.n, 4, 50.0f);
            return;
        }
        if (this.d == 4) {
            this.a(object, this.b.substring(0, 4), f5 * 0.18f, this.a, this.a, this.n, 1, 50.0f);
            this.a(object, this.b.substring(4, 8), f5 * 0.56f, this.a, this.a, this.n, 1, 50.0f);
            if (this.b.length() <= 8) return;
            f5 = (float)((double)f5 + this.e[1] * (double)(9.0f - this.h + (float)(n3 - n5) / 2.0f));
            this.a(object, this.b.substring(8), f5, this.getHeight(), this.a, this.n, 4, 50.0f);
            return;
        }
        this.a(object, this.b, f5 / 2.0f, this.a * 1.1f, this.a, this.n, 4, 0.0f);
    }

    protected void dorect(Object object, float f2, float f3, float f4, float f5) {
        if (object instanceof PDFCanvas) {
            PDFCanvas pDFCanvas = (PDFCanvas)object;
            pDFCanvas.a(f2);
            pDFCanvas.D();
            pDFCanvas.a(f3);
            pDFCanvas.D();
            pDFCanvas.a(f4);
            pDFCanvas.D();
            pDFCanvas.a(f5);
            pDFCanvas.s(" re f\n");
        } else if (object instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)object;
            if (f5 < 0.0f) {
                f3 += f5;
                f5 = -f5;
            }
            graphics2D.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF));
            graphics2D.fill(new Rectangle2D.Float(f2, this.getHeight() - f3 - f5, f4, f5));
            graphics2D.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        }
    }

    private void a(Object object, String string, float f2, float f3, float f4, Paint paint, int n2, float f5) {
        if (object instanceof PDFCanvas) {
            PDFCanvas pDFCanvas = (PDFCanvas)object;
            LayoutBox layoutBox = new LayoutBox(n2 == 4 ? 0.0f : pDFCanvas.getWidth());
            PDFStyle pDFStyle = new PDFStyle();
            pDFStyle.setFont(new StandardFont(4), f4);
            pDFStyle.setTextAlign(n2);
            pDFStyle.setTrackKerning(f5);
            layoutBox.addText(string, pDFStyle, null);
            pDFCanvas.drawLayoutBox(layoutBox, f2, f3);
        } else if (object instanceof Graphics2D) {
            Shape shape;
            Graphics2D graphics2D = (Graphics2D)object;
            Font font = new Font("SansSerif", 0, 1).deriveFont(f4 * 0.9f);
            GlyphVector glyphVector = font.createGlyphVector(graphics2D.getFontRenderContext(), string);
            if (n2 == 4) {
                shape = glyphVector.getOutline();
                f2 = (float)((double)f2 - shape.getBounds2D().getWidth() / 2.0);
            }
            shape = glyphVector.getOutline(f2, this.getHeight() - f3 + f4 * 0.85f);
            graphics2D.fill(shape);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String a(String string) {
        char c2;
        int n2;
        int n3;
        int n4;
        String[] stringArray = new String[]{"131112 ", "111213 ", "111312 ", "111411 ", "121113 ", "121212 ", "121311 ", "111114 ", "131211 ", "141111 ", "211113 ", "211212 ", "211311 ", "221112 ", "221211 ", "231111 ", "112113 ", "112212 ", "112311 ", "122112 ", "132111 ", "111123 ", "111222 ", "111321 ", "121122 ", "131121 ", "212112 ", "212211 ", "211122 ", "211221 ", "221121 ", "222111 ", "112122 ", "112221 ", "122121 ", "123111 ", "121131 ", "311112 ", "311211 ", "321111 ", "112131 ", "113121 ", "211131 ", "121221 ", "312111 ", "311121 ", "122211 ", "111141 ", "114111 "};
        StringBuffer stringBuffer = new StringBuffer();
        for (n4 = 0; n4 < string.length(); ++n4) {
            n3 = string.charAt(n4);
            n2 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%".indexOf(n3);
            if (n2 < 0) {
                if (n3 > 127) {
                    throw new IllegalArgumentException("Unknown CODE93 character U+" + Integer.toHexString(n2));
                }
                String string2 = o[n3];
                n3 = string2.charAt(0);
                switch (n3) {
                    case 36: {
                        stringBuffer.append('+');
                        break;
                    }
                    case 37: {
                        stringBuffer.append(',');
                        break;
                    }
                    case 47: {
                        stringBuffer.append('-');
                        break;
                    }
                    case 43: {
                        stringBuffer.append('.');
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(string);
                    }
                }
                n2 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%".indexOf(string2.charAt(1));
                if (n2 < 0) {
                    throw new IllegalArgumentException(string);
                }
            }
            stringBuffer.append((char)n2);
        }
        n4 = 0;
        n3 = 0;
        for (n2 = 0; n2 < stringBuffer.length(); n4 += ((stringBuffer.length() - n2 - 1) % 20 + 1) * c2, n3 += ((stringBuffer.length() - n2) % 15 + 1) * c2, ++n2) {
            c2 = stringBuffer.charAt(n2);
        }
        stringBuffer.append((char)(n4 %= 47));
        n3 = (n3 + n4) % 47;
        stringBuffer.append((char)n3);
        string = stringBuffer.toString();
        stringBuffer.setLength(0);
        stringBuffer.append("111141 ");
        n2 = 0;
        while (true) {
            if (n2 >= string.length()) {
                stringBuffer.append("111141 ");
                stringBuffer.append("1");
                return stringBuffer.toString();
            }
            stringBuffer.append(stringArray[string.charAt(n2)]);
            stringBuffer.append(' ');
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String a(String string, boolean bl, boolean bl2) {
        int n4;
        int n2;
        String[] stringArray = new String[]{"0001101000 ", "1001000010 ", "0011000010 ", "1011000000 ", "0001100010 ", "1001100000 ", "0011100000 ", "0001001010 ", "1001001000 ", "0011001000 ", "1000010010 ", "0010010010 ", "1010010000 ", "0000110010 ", "1000110000 ", "0010110000 ", "0000011010 ", "1000011000 ", "0010011000 ", "0000111000 ", "1000000110 ", "0010000110 ", "1010000100 ", "0000100110 ", "1000100100 ", "0010100100 ", "0000001110 ", "1000001100 ", "0010001100 ", "0000101100 ", "1100000010 ", "0110000010 ", "1110000000 ", "0100100010 ", "1100100000 ", "0110100000 ", "0100001010 ", "1100001000 ", "0110001000 ", "0101010000 ", "0101000100 ", "0100010100 ", "0001010100 ", "0100101000 "};
        if (bl2) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < string.length(); ++i2) {
                n2 = string.charAt(i2);
                if (n2 > 127) {
                    throw new IllegalArgumentException("Unknown CODE39X character '" + string.charAt(i2) + "'");
                }
                stringBuffer.append(o[n2]);
            }
            string = stringBuffer.toString();
        }
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray["0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%*".indexOf(42)]);
        for (n2 = 0; n2 < string.length(); n3 += n4, ++n2) {
            n4 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%*".indexOf(string.charAt(n2));
            if (n4 == -1 || n4 == 43) {
                throw new IllegalArgumentException("Unknown CODE39 character '" + string.charAt(n2) + "'");
            }
            stringBuffer.append(stringArray[n4]);
        }
        if (bl) {
            stringBuffer.append(stringArray[n3 % 43]);
        }
        stringBuffer.append(stringArray["0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%*".indexOf(42)]);
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String a(String string, int n2) {
        int n3;
        int n4;
        int n5;
        String[] stringArray = new String[]{"00110 ", "10001 ", "01001 ", "11000 ", "00101 ", "10100 ", "01100 ", "00011 ", "10010 ", "01010 "};
        String string2 = string;
        for (n5 = 0; n5 < string.length(); ++n5) {
            if (string.charAt(n5) != ' ') continue;
            string = string.substring(0, n5) + string.substring(n5-- + 1);
        }
        if ((string.length() & 1) == 1 == (n2 == 0)) {
            string = "0" + string;
        }
        if (n2 != 0) {
            if (string.length() % 2 == 0) {
                string = "0" + string;
            }
            n5 = 0;
            for (n4 = 0; n4 < string.length(); ++n4) {
                n3 = string.charAt(n4) - 48;
                if (n2 == 1) {
                    n5 += n4 % 2 == 0 ? n3 * 3 : n3 * 1;
                    continue;
                }
                if (n2 != 2) continue;
                n5 += n4 % 2 == 0 ? n3 * 4 : n3 * 9;
            }
            n5 = (10 - n5 % 10) % 10;
            string = string + (char)(n5 + 48);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("0000");
        n4 = 0;
        while (true) {
            if (n4 >= string.length()) {
                stringBuffer.append("100");
                return stringBuffer.toString();
            }
            n3 = string.charAt(n4) - 48;
            int n8 = string.charAt(n4 + 1) - 48;
            if (n3 < 0 || n3 > 9 || n8 < 0 || n8 > 9) {
                throw new IllegalArgumentException("Invalid Interleaved  2/5 code \"" + string2 + "\"");
            }
            for (int i2 = 0; i2 < 5; ++i2) {
                stringBuffer.append(stringArray[n3].charAt(i2));
                stringBuffer.append(stringArray[n8].charAt(i2));
            }
            n4 += 2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String b(String string) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        String[] stringArray = new String[]{" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[/]^_\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\uefc3\uefc2\u0094\u0093\u0092\uefc4\uefc1", " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[/]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f\uefc3\uefc2\u0094\u0093\uefc4\u0091\uefc1", "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789\u0092\u0091\uefc1"};
        String[] stringArray2 = new String[]{"212222 ", "222122 ", "222221 ", "121223 ", "121322 ", "131222 ", "122213 ", "122312 ", "132212 ", "221213 ", "221312 ", "231212 ", "112232 ", "122132 ", "122231 ", "113222 ", "123122 ", "123221 ", "223211 ", "221132 ", "221231 ", "213212 ", "223112 ", "312131 ", "311222 ", "321122 ", "321221 ", "312212 ", "322112 ", "322211 ", "212123 ", "212321 ", "232121 ", "111323 ", "131123 ", "131321 ", "112313 ", "132113 ", "132311 ", "211313 ", "231113 ", "231311 ", "112133 ", "112331 ", "132131 ", "113123 ", "113321 ", "133121 ", "313121 ", "211331 ", "231131 ", "213113 ", "213311 ", "213131 ", "311123 ", "311321 ", "331121 ", "312113 ", "312311 ", "332111 ", "314111 ", "221411 ", "431111 ", "111224 ", "111422 ", "121124 ", "121421 ", "141122 ", "141221 ", "112214 ", "112412 ", "122114 ", "122411 ", "142112 ", "142211 ", "241211 ", "221114 ", "413111 ", "241112 ", "134111 ", "111242 ", "121142 ", "121241 ", "114212 ", "124112 ", "124211 ", "411212 ", "421112 ", "421211 ", "212141 ", "214121 ", "412121 ", "111143 ", "111341 ", "131141 ", "114113 ", "114311 ", "411113 ", "411311 ", "113141 ", "114131 ", "311141 ", "411131 ", "211412 ", "211214 ", "211232 ", "2331112 "};
        int[] nArray = new int[string.length()];
        block51: for (n6 = 0; n6 < nArray.length; ++n6) {
            n5 = string.charAt(n6);
            if (n5 >= 145 && n5 <= 147) {
                n4 = n5 - 145;
                if (n6 == 0) {
                    nArray[n6] = 1 << n4;
                }
                while (n6 < string.length() - 1) {
                    char c2 = string.charAt(n6 + 1);
                    n5 = c2;
                    if (c2 >= '\u0090' || stringArray[n4].indexOf(n5) < 0) continue block51;
                    nArray[++n6] = 1 << n4;
                }
                continue;
            }
            if (n5 != 148) continue;
            throw new IllegalArgumentException("Illegal character 0x" + Integer.toHexString(n5) + " in Code128 barcode");
        }
        for (n6 = 0; n6 < nArray.length; ++n6) {
            if (nArray[n6] != 0) continue;
            n5 = string.charAt(n6);
            n4 = stringArray[0].indexOf(n5) >= 0 ? 1 : 0;
            n3 = stringArray[1].indexOf(n5) >= 0 ? 1 : 0;
            n2 = n5 >= 48 && n5 <= 57 ? 1 : 0;
            nArray[n6] = (n4 != 0 ? 1 : 0) | (n3 != 0 ? 2 : 0) | (n2 != 0 ? 4 : 0);
            if (nArray[n6] != 0) continue;
            throw new IllegalArgumentException("Illegal character 0x" + Integer.toHexString(n5) + " in Code128 barcode");
        }
        n6 = -1;
        for (n5 = 0; n5 <= nArray.length; ++n5) {
            if (n5 < nArray.length && (nArray[n5] & 4) == 4) {
                if (n6 >= 0) continue;
                n6 = n5;
                continue;
            }
            if (n6 < 0) continue;
            if ((n5 - n6 & 1) == 1) {
                if (n5 == nArray.length) {
                    nArray[n6] = 3;
                } else {
                    nArray[n5 - 1] = 3;
                    --n5;
                }
            }
            for (n4 = ++n6; n4 < n5; ++n4) {
                nArray[n4] = 4;
            }
            n6 = -1;
        }
        for (n5 = 0; n5 < nArray.length; ++n5) {
            if (string.charAt(n5) != '\uefc1' || (n5 <= 0 || nArray[n5 - 1] != 4) && (n5 >= nArray.length - 1 || nArray[n5 + 1] != 4)) continue;
            nArray[n5] = 4;
        }
        n6 = -1;
        n5 = 0;
        while (true) {
            block82: {
                block83: {
                    block80: {
                        block81: {
                            if (n5 > nArray.length) break block80;
                            if (n5 >= nArray.length || (nArray[n5] & 4) != 4) break block81;
                            if (n6 < 0) {
                                n6 = n5;
                            }
                            break block82;
                        }
                        if (n6 < 0) break block82;
                        n4 = 0;
                        break block83;
                    }
                    n5 = 1;
                    break;
                }
                for (n3 = n6; n3 < n5; n4 += string.charAt(n3) == '\uefc1' ? 2 : 1, ++n3) {
                }
                if (n4 < 4) {
                    for (n3 = n6; n3 < n5; ++n3) {
                        nArray[n3] = 3;
                    }
                }
                n6 = -1;
            }
            ++n5;
        }
        for (n4 = 0; n4 <= nArray.length; ++n4) {
            int n7 = n3 = n4 == nArray.length ? 4 : nArray[n4];
            if (n3 == 3) continue;
            if (n3 == 4) {
                n3 = n5;
            }
            for (n2 = n4 - 1; n2 >= 0 && nArray[n2] == 3; --n2) {
                nArray[n2] = n3;
            }
            n5 = n3 == 4 ? 1 : n3;
        }
        StringBuffer stringBuffer = new StringBuffer();
        n3 = 0;
        n2 = 0;
        int n8 = 0;
        while (true) {
            block86: {
                int n9;
                boolean bl;
                int n10;
                char c3;
                block85: {
                    block84: {
                        if (n8 >= string.length()) {
                            stringBuffer.append(stringArray2[n2 % 103]);
                            stringBuffer.append(stringArray2[106]);
                            return stringBuffer.toString();
                        }
                        c3 = string.charAt(n8);
                        n10 = nArray[n8] == 1 ? 0 : (nArray[n8] == 2 ? 1 : (nArray[n8] == 4 ? 2 : -1));
                        bl = false;
                        if (n8 != 0) break block84;
                        n5 = n10;
                        n9 = n10 + 103;
                        stringBuffer.append(stringArray2[n9]);
                        n2 += n9;
                        if (c3 < '\u0091' || c3 > '\u0093') break block85;
                        break block86;
                    }
                    if (n10 != n5) {
                        if (n8 < nArray.length - 1 && nArray[n8 - 1] == nArray[n8 + 1] && (nArray[n8 - 1] & 3) != 0 && (nArray[n8] & 3) != 0) {
                            n9 = stringArray[n5].indexOf(148);
                            stringBuffer.append(stringArray2[n9]);
                            n2 += ++n3 * n9;
                            bl = true;
                        } else if (n10 != n5) {
                            n9 = stringArray[n5].indexOf((char)(145 + n10));
                            stringBuffer.append(stringArray2[n9]);
                            n2 += ++n3 * n9;
                        }
                    }
                }
                n9 = n10 == 2 ? (c3 == '\uefc1' ? 102 : (c3 - 48) * 10 + (string.charAt(++n8) - 48)) : stringArray[n10].indexOf(c3);
                stringBuffer.append(stringArray2[n9]);
                n2 += ++n3 * n9;
                if (c3 >= '\u0091' && c3 <= '\u0093') {
                    n5 = c3 - 145;
                } else if (!bl) {
                    n5 = n10;
                }
            }
            ++n8;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String c(String string) {
        int n2;
        int n3 = string.length();
        if (n3 != 7 && n3 != 8 && n3 != 9 && n3 != 10 && n3 != 12) {
            if (n3 != 13) throw new IllegalArgumentException("EAN-8 code must be 7, 8, 9, 10, 12 or 13 digits");
        }
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (string.charAt(n2) < '0') throw new IllegalArgumentException("Illegal character '" + string.charAt(n2) + "' in EAN-8 barcode");
            if (string.charAt(n2) <= '9') continue;
            throw new IllegalArgumentException("Illegal character '" + string.charAt(n2) + "' in EAN-8 barcode");
        }
        n2 = (string.charAt(0) - 48 + (string.charAt(2) - 48) + (string.charAt(4) - 48) + (string.charAt(6) - 48)) * 3;
        n2 += string.charAt(1) - 48 + (string.charAt(3) - 48) + (string.charAt(5) - 48);
        n2 = (10 - n2 % 10) % 10;
        if (n3 == 7) return string.substring(0, 7) + (char)(n2 + 48) + string.substring(7);
        if (n3 == 9) return string.substring(0, 7) + (char)(n2 + 48) + string.substring(7);
        if (n3 == 12) return string.substring(0, 7) + (char)(n2 + 48) + string.substring(7);
        if (string.charAt(7) - 48 == n2) return string;
        throw new IllegalArgumentException("EAN-8 checkdigit is incorrect - should be " + n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String d(String string) {
        int n2;
        int n3 = string.length();
        if (n3 != 12 && n3 != 13 && n3 != 14 && n3 != 15 && n3 != 17) {
            if (n3 != 18) throw new IllegalArgumentException("EAN-13 must be 12, 13, 14, 15, 17 or 18 digits");
        }
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (string.charAt(n2) < '0') throw new IllegalArgumentException("Illegal character '" + string.charAt(n2) + "' in EAN-13 barcode");
            if (string.charAt(n2) <= '9') continue;
            throw new IllegalArgumentException("Illegal character '" + string.charAt(n2) + "' in EAN-13 barcode");
        }
        n2 = (string.charAt(1) - 48 + (string.charAt(3) - 48) + (string.charAt(5) - 48) + (string.charAt(7) - 48) + (string.charAt(9) - 48) + (string.charAt(11) - 48)) * 3 + (string.charAt(0) - 48) + (string.charAt(2) - 48) + (string.charAt(4) - 48) + (string.charAt(6) - 48) + (string.charAt(8) - 48) + (string.charAt(10) - 48);
        n2 = (10 - n2 % 10) % 10;
        if (n3 == 12) return string.substring(0, 12) + n2 + string.substring(12);
        if (n3 == 14) return string.substring(0, 12) + n2 + string.substring(12);
        if (n3 == 17) return string.substring(0, 12) + n2 + string.substring(12);
        if (string.charAt(12) - 48 == n2) return string;
        throw new IllegalArgumentException("EAN-13 checkdigit is incorrect - should be " + n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String e(String string) {
        String[][] stringArrayArray = new String[][]{{"1123 ", "1222 ", "2212 ", "1141 ", "2311 ", "1321 ", "4111 ", "2131 ", "3121 ", "2113 "}, {"3211 ", "2221 ", "2122 ", "1411 ", "1132 ", "1231 ", "1114 ", "1312 ", "1213 ", "3112 "}, {"3211 ", "2221 ", "2122 ", "1411 ", "1132 ", "1231 ", "1114 ", "1312 ", "1213 ", "3112 "}};
        String[] stringArray = new String[]{"11111 ", "10100 ", "10010 ", "10001 ", "01100 ", "00110 ", "00011 ", "01010 ", "01001 ", "00101 "};
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("111 ");
        int n2 = 1;
        while (true) {
            if (n2 >= 13) {
                stringBuffer.append("111 ");
                if (string.length() <= 13) return stringBuffer.toString();
                stringBuffer.append("1 " + BarCode.g(string.substring(13)));
                return stringBuffer.toString();
            }
            int n4 = n2 == 1 ? 1 : (n2 < 7 ? stringArray[string.charAt(0) - 48].charAt(n2 - 2) - 48 : 2);
            stringBuffer.append(stringArrayArray[n4][string.charAt(n2) - 48]);
            if (n2 == 6) {
                stringBuffer.append("11111 ");
            }
            ++n2;
        }
    }

    private static String f(String string) {
        int n2;
        String[] stringArray = new String[]{"3211 ", "2221 ", "2122 ", "1411 ", "1132 ", "1231 ", "1114 ", "1312 ", "1213 ", "3112 "};
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("111 ");
        for (n2 = 0; n2 < 4; ++n2) {
            stringBuffer.append(stringArray[string.charAt(n2) - 48]);
        }
        stringBuffer.append("11111 ");
        for (n2 = 4; n2 < 8; ++n2) {
            stringBuffer.append(stringArray[string.charAt(n2) - 48]);
        }
        stringBuffer.append("111 ");
        if (string.length() > 8) {
            stringBuffer.append("1 " + BarCode.g(string.substring(8)));
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String g(String string) {
        String[][] stringArrayArray = new String[][]{{"1123 ", "1222 ", "2212 ", "1141 ", "2311 ", "1321 ", "4111 ", "2131 ", "3121 ", "2113 "}, {"3211 ", "2221 ", "2122 ", "1411 ", "1132 ", "1231 ", "1114 ", "1312 ", "1213 ", "3112 "}};
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("112 ");
            if (string.length() == 2) {
                int n2 = Integer.parseInt(string) % 4;
                stringBuffer.append(stringArrayArray[n2 == 0 || n2 == 1 ? 1 : 0][string.charAt(0) - 48]);
                stringBuffer.append("11 ");
                stringBuffer.append(stringArrayArray[n2 == 0 || n2 == 2 ? 1 : 0][string.charAt(1) - 48]);
                return stringBuffer.toString();
            }
            if (string.length() != 5) throw new NumberFormatException();
            Integer.parseInt(string);
            int n3 = ((string.charAt(0) - 48 + (string.charAt(2) - 48) + (string.charAt(4) - 48)) * 3 + (string.charAt(1) - 48 + string.charAt(3) - 48) * 9) % 10;
            int n4 = (new int[]{7, 11, 13, 14, 19, 25, 28, 21, 22, 26})[n3];
            int n5 = 0;
            while (n5 < 5) {
                if (n5 > 0) {
                    stringBuffer.append("11 ");
                }
                stringBuffer.append(stringArrayArray[n4 >> 4 - n5 & 1][string.charAt(n5) - 48]);
                ++n5;
            }
            return stringBuffer.toString();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Value must be 2 or 5 digits");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String h(String string) {
        String[] stringArray = new String[]{"101010011 ", "101011001 ", "101001011 ", "110010101 ", "101101001 ", "110101001 ", "100101011 ", "100101101 ", "100110101 ", "110100101 ", "101001101 ", "101100101 ", "1101011011 ", "1101101011 ", "1101101101 ", "1011011011 ", "1011001001 ", "1010010011 ", "1001001011 ", "1010011001 ", "1011001001 ", "1001001011 ", "1010010011 ", "1010011001 "};
        if ("ABCDTN*E".indexOf(string.charAt(0)) < 0 || "ABCDTN*E".indexOf(string.charAt(string.length() - 1)) < 0) {
            throw new IllegalArgumentException("Codabar must start and end with A, B, C, D, T, N, * or E");
        }
        for (int n2 = 1; n2 < string.length() - 1; ++n2) {
            if ("0123456789-$:/.+".indexOf(string.charAt(n2)) >= 0) continue;
            throw new IllegalArgumentException("Illegal character '" + string.charAt(n2) + "' in Codabar barcode");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            stringBuffer.append(stringArray["0123456789-$:/.+ABCDTN*E".indexOf(string.charAt(i2))]);
        }
        string = stringBuffer.toString();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n3 = 0;
        int n4 = 1;
        while (n4 < string.length()) {
            if (stringBuffer.charAt(n4) != stringBuffer.charAt(n3)) {
                stringBuffer2.append((char)(n4 - n3 + 48));
                n3 = n4;
            }
            ++n4;
        }
        return stringBuffer2.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String i(String string) {
        String[] stringArray = new String[]{"11000 ", "00011 ", "00101 ", "00110 ", "01001 ", "01010 ", "01100 ", "10001 ", "10010 ", "10100 "};
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("1");
        int i2 = 0;
        while (true) {
            if (i2 >= string.length()) {
                stringBuffer.append(stringArray[(10 - n2 % 10) % 10]);
                stringBuffer.append(1);
                return stringBuffer.toString();
            }
            int n3 = string.charAt(i2) - 48;
            if (n3 < 0 || n3 > 9) {
                throw new IllegalArgumentException("PostNet barcode can only display digits");
            }
            stringBuffer.append(stringArray[n3]);
            n2 += n3;
            ++i2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String j(String string) {
        String[] stringArray = new String[]{"0033", "0123", "0132", "1023", "1032", "1122", "0213", "0303", "0312", "1203", "1212", "1302", "0231", "0321", "0330", "1221", "1230", "1320", "2013", "2103", "2112", "3003", "3012", "3102", "2031", "2121", "2130", "3021", "3030", "3120", "2211", "2301", "2310", "3201", "3210", "3300"};
        String string2 = "ZUVWXY501234B6789AHCDEFGNIJKLMTOPQRS";
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("2 ");
        int n4 = 0;
        while (true) {
            int n5;
            int n6;
            int n7;
            if (n4 < string.length()) {
                n7 = string.charAt(n4);
                if (!(n7 >= 48 && n7 <= 57 || n7 >= 65 && n7 <= 90)) {
                    throw new IllegalArgumentException("RM4SCC barcode can only display digits and upper-case letters");
                }
                stringBuffer.append(stringArray[n7 -= n7 >= 65 ? 55 : 48] + " ");
                n6 = 0;
                n5 = 0;
            } else {
                stringBuffer.append(stringArray[n4 - ((n4 = (int)string2.charAt(n2 % 6 * 6 + n3 % 6)) >= 65 ? 55 : 48)]);
                stringBuffer.append(" 3");
                return stringBuffer.toString();
            }
            for (int i2 = 0; i2 < 3; ++i2) {
                int n8 = stringArray[n7].charAt(i2) - 48;
                if (n8 == 1 || n8 == 3) {
                    n5 += i2 == 0 ? 4 : (i2 == 1 ? 2 : 1);
                }
                if (n8 != 2 && n8 != 3) continue;
                n6 += i2 == 0 ? 4 : (i2 == 1 ? 2 : 1);
            }
            n2 += n6 == 6 ? 0 : n6;
            n3 += n5 == 6 ? 0 : n5;
            ++n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String k(String string) {
        int n2;
        int n3;
        Object object;
        int n4 = string.length();
        if (n4 != 20 && n4 != 25 && n4 != 29 && n4 != 31) {
            throw new IllegalArgumentException("Invalid Intelligent Mail barcode data: " + string);
        }
        String string2 = string.substring(0, 20);
        String string3 = string.substring(20);
        BigInteger bigInteger = null;
        switch (string3.length()) {
            case 0: {
                bigInteger = BigInteger.valueOf(0L);
                break;
            }
            case 5: {
                bigInteger = new BigInteger(string3).add(BigInteger.valueOf(1L));
                break;
            }
            case 9: {
                bigInteger = new BigInteger(string3).add(BigInteger.valueOf(100001L));
                break;
            }
            case 11: {
                bigInteger = new BigInteger(string3).add(BigInteger.valueOf(1000100001L));
                break;
            }
        }
        BigInteger bigInteger2 = BigInteger.valueOf(10L);
        BigInteger bigInteger3 = BigInteger.valueOf(5L);
        for (int n5 = 0; n5 < 20; ++n5) {
            object = n5 == 1 ? bigInteger3 : bigInteger2;
            bigInteger = bigInteger.multiply((BigInteger)object).add(new BigInteger(string2.substring(n5, n5 + 1)));
        }
        byte[] byArray = bigInteger.toByteArray();
        object = new byte[13];
        System.arraycopy(byArray, 0, object, 13 - byArray.length, byArray.length);
        int n6 = BarCode.a((byte[])object);
        BigInteger bigInteger5 = BigInteger.valueOf(636L);
        BigInteger bigInteger6 = BigInteger.valueOf(1365L);
        BigInteger[] bigIntegerArray = new BigInteger[10];
        bigIntegerArray[9] = bigInteger.mod(bigInteger5);
        bigInteger = bigInteger.divide(bigInteger5);
        for (int i2 = 8; i2 > 0; bigInteger = bigInteger.divide(bigInteger6), --i2) {
            bigIntegerArray[i2] = bigInteger.mod(bigInteger6);
        }
        bigIntegerArray[0] = bigInteger;
        bigIntegerArray[9] = bigIntegerArray[9].multiply(BigInteger.valueOf(2L));
        if ((n6 >> 10 & 1) == 1) {
            bigIntegerArray[0] = bigIntegerArray[0].add(BigInteger.valueOf(659L));
        }
        int[] nArray = new int[10];
        int[] nArray2 = BarCode.a(5, 1287);
        int[] nArray3 = BarCode.a(2, 78);
        for (n3 = 0; n3 < 10; ++n3) {
            n2 = bigIntegerArray[n3].intValue();
            nArray[n3] = n2 < 1287 ? nArray2[n2] : nArray3[n2 - 1287];
        }
        for (n3 = 0; n3 < 10; ++n3) {
            if ((n6 >> n3 & 1) != 1) continue;
            nArray[n3] = BarCode.b(nArray[n3]);
        }
        StringBuffer stringBuffer = new StringBuffer();
        n2 = 1;
        while (n2 <= 65) {
            int[] nArray4 = p[n2];
            stringBuffer.append((nArray[nArray4[0]] >> nArray4[1] & 1) + (nArray[nArray4[2]] >> nArray4[3] & 1) * 2);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static int a(byte[] byArray) {
        int n2 = 3893;
        int n3 = 2047;
        int n4 = BarCode.a(byArray[0]) << 5;
        int n5 = 2;
        while (true) {
            block9: {
                block7: {
                    if (n5 >= 8) break;
                    if (((n3 ^ n4) & 0x400) == 0) break block7;
                    n3 = n3 << 1 ^ n2;
                    break block9;
                }
                n3 <<= 1;
            }
            n3 &= 0x7FF;
            n4 <<= 1;
            ++n5;
        }
        block5: for (n5 = 1; n5 < 13; ++n5) {
            n4 = BarCode.a(byArray[n5]) << 3;
            int n6 = 0;
            while (true) {
                block10: {
                    block8: {
                        if (n6 >= 8) continue block5;
                        if (((n3 ^ n4) & 0x400) == 0) break block8;
                        n3 = n3 << 1 ^ n2;
                        break block10;
                    }
                    n3 <<= 1;
                }
                n3 &= 0x7FF;
                n4 <<= 1;
                ++n6;
            }
        }
        return n3;
    }

    private static int a(int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < 16; ++i2) {
            n3 <<= 1;
            n3 |= n2 & 1;
            n2 >>= 1;
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int b(int n2) {
        int n3 = 0;
        int n4 = 12;
        while (n4 >= 0) {
            if ((n2 >> n4 & 1) == 0) {
                ++n3;
            }
            if (n4 > 0) {
                n3 <<= 1;
            }
            --n4;
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int[] a(int n2, int n3) {
        int n4 = 0;
        int n5 = n3 - 1;
        int[] nArray = new int[n3];
        int i2 = 0;
        while (i2 < 8192) {
            int n7;
            int n6 = 0;
            for (n7 = 0; n7 < 13; n6 += (i2 & 1 << n7) != 0 ? 1 : 0, ++n7) {
            }
            if (n6 == n2 && (n7 = BarCode.a(i2) >> 3) >= i2) {
                if (i2 == n7) {
                    nArray[n5--] = i2;
                } else {
                    nArray[n4++] = i2;
                    nArray[n4++] = n7;
                }
            }
            ++i2;
        }
        return nArray;
    }

    private static int a(byte n2) {
        int n3 = n2;
        if (n3 < 0) {
            n3 += 256;
        }
        return n3;
    }

    static {
        BarCode.p[1] = new int[]{7, 2, 4, 3};
        BarCode.p[2] = new int[]{1, 10, 0, 0};
        BarCode.p[3] = new int[]{9, 12, 2, 8};
        BarCode.p[4] = new int[]{5, 5, 6, 11};
        BarCode.p[5] = new int[]{8, 9, 3, 1};
        BarCode.p[6] = new int[]{0, 1, 5, 12};
        BarCode.p[7] = new int[]{2, 5, 1, 8};
        BarCode.p[8] = new int[]{4, 4, 9, 11};
        BarCode.p[9] = new int[]{6, 3, 8, 10};
        BarCode.p[10] = new int[]{3, 9, 7, 6};
        BarCode.p[11] = new int[]{5, 11, 1, 4};
        BarCode.p[12] = new int[]{8, 5, 2, 12};
        BarCode.p[13] = new int[]{9, 10, 0, 2};
        BarCode.p[14] = new int[]{7, 1, 6, 7};
        BarCode.p[15] = new int[]{3, 6, 4, 9};
        BarCode.p[16] = new int[]{0, 3, 8, 6};
        BarCode.p[17] = new int[]{6, 4, 2, 7};
        BarCode.p[18] = new int[]{1, 1, 9, 9};
        BarCode.p[19] = new int[]{7, 10, 5, 2};
        BarCode.p[20] = new int[]{4, 0, 3, 8};
        BarCode.p[21] = new int[]{6, 2, 0, 4};
        BarCode.p[22] = new int[]{8, 11, 1, 0};
        BarCode.p[23] = new int[]{9, 8, 3, 12};
        BarCode.p[24] = new int[]{2, 6, 7, 7};
        BarCode.p[25] = new int[]{5, 1, 4, 10};
        BarCode.p[26] = new int[]{1, 12, 6, 9};
        BarCode.p[27] = new int[]{7, 3, 8, 0};
        BarCode.p[28] = new int[]{5, 8, 9, 7};
        BarCode.p[29] = new int[]{4, 6, 2, 10};
        BarCode.p[30] = new int[]{3, 4, 0, 5};
        BarCode.p[31] = new int[]{8, 4, 5, 7};
        BarCode.p[32] = new int[]{7, 11, 1, 9};
        BarCode.p[33] = new int[]{6, 0, 9, 6};
        BarCode.p[34] = new int[]{0, 6, 4, 8};
        BarCode.p[35] = new int[]{2, 1, 3, 2};
        BarCode.p[36] = new int[]{5, 9, 8, 12};
        BarCode.p[37] = new int[]{4, 11, 6, 1};
        BarCode.p[38] = new int[]{9, 5, 7, 4};
        BarCode.p[39] = new int[]{3, 3, 1, 2};
        BarCode.p[40] = new int[]{0, 7, 2, 0};
        BarCode.p[41] = new int[]{1, 3, 4, 1};
        BarCode.p[42] = new int[]{6, 10, 3, 5};
        BarCode.p[43] = new int[]{8, 7, 9, 4};
        BarCode.p[44] = new int[]{2, 11, 5, 6};
        BarCode.p[45] = new int[]{0, 8, 7, 12};
        BarCode.p[46] = new int[]{4, 2, 8, 1};
        BarCode.p[47] = new int[]{5, 10, 3, 0};
        BarCode.p[48] = new int[]{9, 3, 0, 9};
        BarCode.p[49] = new int[]{6, 5, 2, 4};
        BarCode.p[50] = new int[]{7, 8, 1, 7};
        BarCode.p[51] = new int[]{5, 0, 4, 5};
        BarCode.p[52] = new int[]{2, 3, 0, 10};
        BarCode.p[53] = new int[]{6, 12, 9, 2};
        BarCode.p[54] = new int[]{3, 11, 1, 6};
        BarCode.p[55] = new int[]{8, 8, 7, 9};
        BarCode.p[56] = new int[]{5, 4, 0, 11};
        BarCode.p[57] = new int[]{1, 5, 2, 2};
        BarCode.p[58] = new int[]{9, 1, 4, 12};
        BarCode.p[59] = new int[]{8, 3, 6, 6};
        BarCode.p[60] = new int[]{7, 0, 3, 7};
        BarCode.p[61] = new int[]{4, 7, 7, 5};
        BarCode.p[62] = new int[]{0, 12, 1, 11};
        BarCode.p[63] = new int[]{2, 9, 9, 0};
        BarCode.p[64] = new int[]{6, 8, 5, 3};
        BarCode.p[65] = new int[]{3, 10, 8, 2};
    }
}

