/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.faceless.pdf2.AnnotationFile;
import org.faceless.pdf2.AnnotationLink;
import org.faceless.pdf2.AnnotationText;
import org.faceless.pdf2.Event;
import org.faceless.pdf2.Form;
import org.faceless.pdf2.FormElement;
import org.faceless.pdf2.FormSignature;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFAction;
import org.faceless.pdf2.PDFAnnotation;
import org.faceless.pdf2.PDFBookmark;
import org.faceless.pdf2.PDFFont;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.WidgetAnnotation;
import org.faceless.pdf2.gc;
import org.faceless.pdf2.hc;
import org.faceless.pdf2.ic;
import org.faceless.pdf2.kc;
import org.faceless.pdf2.mc;
import org.faceless.pdf2.oc;
import org.faceless.pdf2.sb;
import org.faceless.pdf2.sc;
import org.faceless.pdf2.uc;
import org.faceless.pdf2.wc;
import org.faceless.pdf2.y;
import org.faceless.pdf2.yd;

public class OutputProfile {
    private BitSet a;
    private BitSet b;
    private BitSet c;
    private String d;
    private boolean e;
    private uc f;
    public static final OutputProfile Default = new OutputProfile("Default", new Feature[0], new Feature[0]);
    public static final OutputProfile Acrobat4Compatible = new OutputProfile("Acrobat 4.x Compatible", new Feature[]{Feature.XMPMetaData, Feature.Transparency, Feature.ImageTransparency, Feature.Acrobat5Encryption, Feature.FilterJPX, Feature.FilterJBIG2, Feature.ImageDepth16, Feature.OptionalContent, Feature.UTF16Encoding, Feature.Acrobat6Encryption, Feature.AESEncryption, Feature.PDFVersion14, Feature.PDFVersion15, Feature.PDFVersion16, Feature.PDFVersion17, Feature.PDFVersion17e3, Feature.PDFVersion17e5, Feature.PDFVersion17e8, Feature.h}, new Feature[0]);
    public static final OutputProfile Acrobat5Compatible = new OutputProfile("Acrobat 5.x Compatible", new Feature[]{Feature.FilterJPX, Feature.ImageDepth16, Feature.OptionalContent, Feature.UTF16Encoding, Feature.Acrobat6Encryption, Feature.AESEncryption, Feature.PDFVersion15, Feature.PDFVersion16, Feature.PDFVersion17, Feature.PDFVersion17e3, Feature.PDFVersion17e5, Feature.PDFVersion17e8, Feature.h}, new Feature[]{Feature.FilterJBIG2});
    public static final OutputProfile Acrobat6Compatible = new OutputProfile("Acrobat 6.x Compatible", new Feature[]{Feature.AESEncryption, Feature.PDFVersion16, Feature.PDFVersion17, Feature.PDFVersion17e3, Feature.PDFVersion17e5, Feature.PDFVersion17e8, Feature.h}, new Feature[]{Feature.CompressedXRef, Feature.FilterJBIG2});
    public static final OutputProfile Acrobat7Compatible = new OutputProfile("Acrobat 7.x Compatible", new Feature[]{Feature.WeakAES256Encryption, Feature.AES256Encryption, Feature.PDFVersion17, Feature.PDFVersion17e3, Feature.PDFVersion17e5, Feature.PDFVersion17e8, Feature.h}, new Feature[]{Feature.CompressedXRef, Feature.FilterJBIG2});
    public static final OutputProfile Acrobat8Compatible = new OutputProfile("Acrobat 8.x Compatible", new Feature[]{Feature.WeakAES256Encryption, Feature.AES256Encryption, Feature.PDFVersion17e3, Feature.PDFVersion17e5, Feature.PDFVersion17e8, Feature.h}, new Feature[]{Feature.CompressedXRef, Feature.FilterJBIG2});
    public static final OutputProfile Acrobat9Compatible = new OutputProfile("Acrobat 9.x Compatible", new Feature[]{Feature.PDFVersion17e8, Feature.h, Feature.AES256Encryption}, new Feature[]{Feature.CompressedXRef, Feature.FilterJBIG2});
    public static final OutputProfile AcrobatXCompatible = new OutputProfile("Acrobat X Compatible", new Feature[]{Feature.h}, new Feature[]{Feature.CompressedXRef, Feature.FilterJBIG2});
    public static final OutputProfile NoCompression = new OutputProfile("Uncompressed", new Feature[]{Feature.RegularCompression}, new Feature[0]);
    public static final OutputProfile ImageOnly = new OutputProfile("Image Only", new Feature[0], new Feature[]{Feature.ImagePluginHeader});
    public static final OutputProfile PDFX1a_2001 = new OutputProfile("PDF/X-1a:2001", new Feature[]{Feature.AnnotationsInPage, Feature.RenderingIntent, Feature.AltColorSpaceDeviceRGB, Feature.AltColorSpaceICC, Feature.AltColorSpaceLab, Feature.AltColorSpaceCalRGB, Feature.AltColorSpaceCalGray, Feature.AlternateImagePrints, Feature.ColorSpaceDeviceRGB, Feature.DeviceCMYKWithGrayIntent, Feature.HasRGBOutputIntent, Feature.ColorSpaceICC, Feature.ColorSpaceLab, Feature.ColorSpaceCalRGB, Feature.ColorSpaceCalGray, Feature.Actions, Feature.ActionsInBookmarks, Feature.BadTrapNetAnnotation, Feature.JavaScript, Feature.Encryption, Feature.PostScriptXObject, Feature.FontStandard14, Feature.FontType1Unembedded, Feature.FontTrueTypeUnembedded, Feature.CIDFontTrueTypeUnembedded, Feature.CIDFontType1Unembedded, Feature.HalftoneName, Feature.HalftoneNot1or5, Feature.FilterLZW, Feature.FilterInlineLZW, Feature.BadBoxNesting, Feature.z, Feature.PDFVersion14, Feature.PDFVersion15, Feature.PDFVersion16, Feature.PDFVersion17, Feature.PDFVersion17e3, Feature.PDFVersion17e5, Feature.PDFVersion17e8, Feature.h, Feature.BothTrimAndArtBox, Feature.MissingTrimAndArtBox, Feature.OPI, Feature.TransferFunction, Feature.TransferFunctionIsDefault, Feature.TransferFunctionIsIdentity, Feature.TransferFunctionIsOther, Feature.Transparency, Feature.ImageTransparency, Feature.EmbeddedFiles, Feature.FontEmbeddingRestrictions, Feature.InvalidColorProfile, Feature.HasMultipleOutputIntents, Feature.FilterJPX, Feature.FilterJBIG2, Feature.OptionalContent, Feature.ImageDepth16, Feature.UTF16Encoding}, new Feature[]{Feature.HasCreationDate, Feature.HasDocID, Feature.InfoMeetsPDFX1a_2001, Feature.HasModDate, Feature.HasOutputIntent, Feature.HasOutputIntentGTS_PDFX, Feature.HasTitle, Feature.HasTrapped, Feature.UncompressedXRef});
    public static final OutputProfile PDFX1a_2003 = new OutputProfile("PDF/X-1a:2003", new Feature[]{Feature.AnnotationsInPage, Feature.AltColorSpaceDeviceRGB, Feature.AltColorSpaceICC, Feature.AltColorSpaceLab, Feature.AltColorSpaceCalRGB, Feature.AltColorSpaceCalGray, Feature.ColorSpaceDeviceRGB, Feature.ColorSpaceICC, Feature.ColorSpaceLab, Feature.ColorSpaceCalRGB, Feature.ColorSpaceCalGray, Feature.HasRGBOutputIntent, Feature.DeviceCMYKWithGrayIntent, Feature.AlternateImagePrints, Feature.Actions, Feature.ActionsInBookmarks, Feature.BadTrapNetAnnotation, Feature.JavaScript, Feature.Encryption, Feature.PostScriptXObject, Feature.FontStandard14, Feature.FontType1Unembedded, Feature.FontTrueTypeUnembedded, Feature.CIDFontTrueTypeUnembedded, Feature.CIDFontType1Unembedded, Feature.HalftoneName, Feature.HalftoneNot1or5, Feature.FilterLZW, Feature.FilterInlineLZW, Feature.BadBoxNesting, Feature.z, Feature.PDFVersion15, Feature.PDFVersion16, Feature.PDFVersion17, Feature.PDFVersion17e3, Feature.PDFVersion17e5, Feature.PDFVersion17e8, Feature.h, Feature.BothTrimAndArtBox, Feature.MissingTrimAndArtBox, Feature.OPI, Feature.TransferFunctionIsDefault, Feature.TransferFunctionIsIdentity, Feature.TransferFunctionIsOther, Feature.TransferFunction, Feature.Transparency, Feature.ImageTransparency, Feature.FontEmbeddingRestrictions, Feature.ViewBoxNotBleedBox, Feature.EmbeddedFiles, Feature.InvalidColorProfile, Feature.HasMultipleOutputIntents, Feature.FilterJPX, Feature.FilterJBIG2, Feature.OptionalContent, Feature.ImageDepth16, Feature.UTF16Encoding}, new Feature[]{Feature.HasCreationDate, Feature.HasDocID, Feature.InfoMeetsPDFX1a_2003, Feature.HasModDate, Feature.HasOutputIntent, Feature.HasOutputIntentGTS_PDFX, Feature.HasTitle, Feature.HasTrapped, Feature.UncompressedXRef});
    public static final OutputProfile PDFX3_2002 = new OutputProfile("PDF/X-3:2002", new Feature[]{Feature.AnnotationsInPage, Feature.AlternateImagePrints, Feature.Actions, Feature.ActionsInBookmarks, Feature.JavaScript, Feature.BadTrapNetAnnotation, Feature.Encryption, Feature.DeviceGrayWithRGBIntent, Feature.DeviceRGBWithCMYKIntent, Feature.DeviceCMYKWithRGBIntent, Feature.DeviceCMYKWithGrayIntent, Feature.ICCProfileNotOutput, Feature.ICCProfileBadColorComponentCount, Feature.PostScriptXObject, Feature.FontStandard14, Feature.FontType1Unembedded, Feature.FontTrueTypeUnembedded, Feature.CIDFontTrueTypeUnembedded, Feature.CIDFontType1Unembedded, Feature.HalftoneName, Feature.HalftoneNot1or5, Feature.FilterLZW, Feature.FilterInlineLZW, Feature.BadBoxNesting, Feature.z, Feature.PDFVersion14, Feature.PDFVersion15, Feature.PDFVersion16, Feature.PDFVersion17, Feature.PDFVersion17e3, Feature.PDFVersion17e5, Feature.PDFVersion17e8, Feature.h, Feature.BothTrimAndArtBox, Feature.MissingTrimAndArtBox, Feature.OPI, Feature.TransferFunctionIsDefault, Feature.TransferFunctionIsIdentity, Feature.TransferFunctionIsOther, Feature.TransferFunction, Feature.Transparency, Feature.ImageTransparency, Feature.FontEmbeddingRestrictions, Feature.EmbeddedFiles, Feature.InvalidColorProfile, Feature.HasMultipleOutputIntents, Feature.FilterJPX, Feature.FilterJBIG2, Feature.OptionalContent, Feature.ImageDepth16, Feature.UTF16Encoding}, new Feature[]{Feature.HasCreationDate, Feature.HasDocID, Feature.InfoMeetsPDFX3_2002, Feature.HasModDate, Feature.HasOutputIntent, Feature.HasOutputIntentGTS_PDFX, Feature.HasTitle, Feature.HasTrapped, Feature.UncompressedXRef});
    public static final OutputProfile PDFX3_2003;
    public static final OutputProfile PDFX3_2003_Acrobat;
    public static final OutputProfile NotPDFX;
    public static final OutputProfile PDFA1b_2005;
    public static final OutputProfile PDFA1b_2005_Acrobat;

    OutputProfile(String string) {
        this.d = string;
        this.a = new BitSet();
        this.b = new BitSet();
        this.c = new BitSet();
    }

    OutputProfile(String string, Feature[] featureArray, Feature[] featureArray2) {
        this(string);
        int n2;
        if (featureArray != null) {
            for (n2 = 0; n2 < featureArray.length; ++n2) {
                this.setDenied(featureArray[n2]);
            }
        }
        if (featureArray2 != null) {
            for (n2 = 0; n2 < featureArray2.length; ++n2) {
                this.setRequired(featureArray2[n2]);
            }
        }
        this.e = true;
    }

    public OutputProfile(OutputProfile outputProfile, String string, String string2, String string3, String string4, ICC_Profile iCC_Profile) {
        block5: {
            kc kc2;
            block6: {
                this(outputProfile, null);
                if ("sRGB".equals(string) && string4 == null) {
                    string4 = "sRGB iEC61966-2.1";
                }
                this.d = outputProfile.d + " (" + string + ")";
                this.f = new uc(1);
                kc2 = null;
                if (string == null) break block5;
                if (!this.b.get(Feature.HasOutputIntentGTS_PDFX.c)) break block6;
                kc2 = new kc("GTS_PDFX", string, string2, string3, string4, iCC_Profile);
                this.f.c(kc2);
            }
            if (this.b.get(Feature.HasOutputIntentGTS_PDFA.c)) {
                kc2 = new kc("GTS_PDFA", string, string2, string3, string4, iCC_Profile);
                this.f.c(kc2);
            }
            if (this.b.get(Feature.HasOutputIntentGTS_PDFA1.c)) {
                kc2 = new kc("GTS_PDFA1", string, string2, string3, string4, iCC_Profile);
                this.f.c(kc2);
            }
        }
    }

    public OutputProfile(OutputProfile outputProfile) {
        this(outputProfile, outputProfile.d + " (Copy)");
    }

    OutputProfile(OutputProfile outputProfile, String string) {
        this.a = (BitSet)outputProfile.a.clone();
        this.b = (BitSet)outputProfile.b.clone();
        this.c = (BitSet)outputProfile.c.clone();
        this.d = string == null ? outputProfile.d : string;
        this.e = false;
        OutputProfile outputProfile2 = this;
        uc uc2 = outputProfile.a() == null ? null : (uc)outputProfile.a().a(new IdentityHashMap());
        outputProfile2.f = uc2;
    }

    public boolean isSet(Feature feature) {
        return this.c.get(feature.c);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDenied(Feature feature) {
        if (this.b.get(feature.c) || this.c.get(feature.c)) {
            throw new IllegalStateException("Denied Feature \"" + feature.e + "\" required or already set in \"" + this.d + "\" output profile");
        }
        if (this.e) {
            throw new IllegalStateException("Cannot modify a static OutputProfile - copy it first");
        }
        this.a.set(feature.c);
    }

    public void setRequired(Feature feature) {
        if (this.a.get(feature.c)) {
            throw new IllegalStateException("Required Feature \"" + feature.e + "\" not allowed in \"" + this.d + "\" output profile");
        }
        if (this.e) {
            throw new IllegalStateException("Cannot modify a static OutputProfile - copy it first");
        }
        this.b.set(feature.c);
    }

    public void clearDenied(Feature feature) {
        if (this.e) {
            throw new IllegalStateException("Cannot modify a static OutputProfile - copy it first");
        }
        this.a.clear(feature.c);
    }

    public void clearRequired(Feature feature) {
        if (this.e) {
            throw new IllegalStateException("Cannot modify a static OutputProfile - copy it first");
        }
        this.b.clear(feature.c);
    }

    public boolean isDenied(Feature feature) {
        return this.a.get(feature.c);
    }

    public boolean isRequired(Feature feature) {
        return this.b.get(feature.c);
    }

    synchronized void clear(Feature feature) {
        if (this.c.get(feature.c)) {
            this.c.clear(feature.c);
            feature.c(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void set(Feature feature) {
        if (this.a.get(feature.c)) {
            throw new IllegalStateException("Feature \"" + feature.e + "\" not allowed in \"" + this.d + "\" output profile");
        }
        if (!this.a(feature)) return;
        if (!PDF.s("OutputProfileFeatureOrigin")) return;
        PDF.k.debug("OutputProfileFeatureOrigin", "Set \"" + feature.e + "\"", new Exception());
    }

    synchronized boolean a(Feature feature) {
        if (this.e) {
            throw new IllegalStateException("Cannot modify a static OutputProfile - copy it first");
        }
        if (!this.c.get(feature.c)) {
            this.c.set(feature.c);
            feature.b(this);
            return true;
        }
        return false;
    }

    public String getProfileName() {
        return this.d;
    }

    void a(OutputProfile outputProfile) {
        for (int i2 = 0; i2 < Feature.ALL.length; ++i2) {
            Feature feature = Feature.ALL[i2];
            if (!outputProfile.isSet(feature)) continue;
            this.set(feature);
            continue;
        }
    }

    uc a() {
        return this.f;
    }

    void a(uc uc2) {
        this.f = uc2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Feature[] isCompatibleWith(OutputProfile outputProfile) {
        ArrayList<Feature> arrayList = new ArrayList<Feature>();
        for (int i2 = 0; i2 < Feature.ALL.length; ++i2) {
            Feature feature = Feature.ALL[i2];
            if ((!this.isSet(feature) || !outputProfile.isDenied(feature)) && (this.isSet(feature) || !outputProfile.isRequired(feature)) || feature.a(this)) continue;
            arrayList.add(feature);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Feature[] featureArray = arrayList.toArray(new Feature[0]);
        return featureArray;
    }

    int b() {
        int n2 = 3;
        for (int i2 = 0; i2 < Feature.ALL.length; ++i2) {
            Feature feature = Feature.ALL[i2];
            if (feature.d <= n2 || !this.isSet(feature)) continue;
            n2 = feature.d;
        }
        return n2;
    }

    private kc a(String string) {
        if (this.f == null) {
            return null;
        }
        int n2 = 0;
        while (true) {
            block9: {
                if (n2 >= this.f.o()) break;
                if (!(this.f.d(n2) instanceof kc)) break block9;
                kc kc2 = (kc)this.f.d(n2);
                if (kc2.i("S").d(string)) {
                    return kc2;
                }
            }
            ++n2;
        }
        return null;
    }

    public ICC_Profile getOutputIntentDestinationProfile(String string) {
        ICC_Profile iCC_Profile = this.a(string) == null ? null : this.a(string).x();
        return iCC_Profile;
    }

    public String getOutputConditionIdentifier(String string) {
        String string2 = this.a(string) == null ? null : this.a(string).t();
        return string2;
    }

    public String getOutputCondition(String string) {
        String string2 = this.a(string) == null ? null : this.a(string).u();
        return string2;
    }

    public String getOutputIntentInfo(String string) {
        String string2 = this.a(string) == null ? null : this.a(string).w();
        return string2;
    }

    public String getOutputConditionRegistry(String string) {
        String string2 = this.a(string) == null ? null : this.a(string).v();
        return string2;
    }

    public Set getFontInfo() {
        return null;
    }

    void a(FontInfo fontInfo) {
        Set set = this.getFontInfo();
        if (set != null) {
            set.add(fontInfo);
        }
    }

    public String toString() {
        String string = "";
        String string2 = "";
        String string3 = "";
        for (int i2 = 0; i2 < Feature.ALL.length; ++i2) {
            Feature feature = Feature.ALL[i2];
            if (this.isDenied(feature)) {
                string = string + ", " + feature;
            }
            if (this.isSet(feature)) {
                string2 = string2 + ", " + feature;
            }
            if (!this.isRequired(feature)) continue;
            string3 = string3 + ", " + feature;
        }
        if (string.length() != 0) {
            string = " DENIED={" + string.substring(2) + "}";
        }
        if (string3.length() != 0) {
            string3 = " REQUIRED={" + string3.substring(2) + "}";
        }
        if (string2.length() != 0) {
            string2 = " SET={" + string2.substring(2) + "}";
        }
        return "[" + this.d + ":" + string + string3 + string2 + "]";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void checkColorMatchesOutputIntent(int n2, Feature feature) {
        this.set(Feature.v);
        if (n2 == 1) {
            if (this.isSet(Feature.HasGrayOutputIntent)) return;
            if (this.isSet(Feature.HasUnembeddedOutputIntent)) return;
            if (feature == Feature.s) {
                this.set(Feature.AnnotationColorMismatchesIntent);
                return;
            }
            if (this.isSet(Feature.HasRGBOutputIntent)) {
                this.set(Feature.DeviceGrayWithRGBIntent);
                return;
            }
            if (!this.isSet(Feature.HasCMYKOutputIntent)) return;
            this.set(Feature.DeviceGrayWithCMYKIntent);
            return;
        }
        if (n2 == 3) {
            if (this.isSet(Feature.HasRGBOutputIntent)) return;
            if (this.isSet(Feature.HasUnembeddedOutputIntent)) return;
            if (feature == Feature.t) {
                this.set(Feature.AnnotationColorMismatchesIntent);
                return;
            }
            if (this.isSet(Feature.HasGrayOutputIntent)) {
                this.set(Feature.DeviceRGBWithGrayIntent);
                return;
            }
            if (!this.isSet(Feature.HasCMYKOutputIntent)) return;
            this.set(Feature.DeviceRGBWithCMYKIntent);
            return;
        }
        if (n2 != 4) return;
        if (this.isSet(Feature.HasCMYKOutputIntent)) return;
        if (this.isSet(Feature.HasUnembeddedOutputIntent)) return;
        if (feature == Feature.u) {
            this.set(Feature.AnnotationColorMismatchesIntent);
            return;
        }
        if (this.isSet(Feature.HasGrayOutputIntent)) {
            this.set(Feature.DeviceCMYKWithGrayIntent);
            return;
        }
        if (!this.isSet(Feature.HasRGBOutputIntent)) return;
        this.set(Feature.DeviceCMYKWithRGBIntent);
    }

    static {
        PDFX3_2003_Acrobat = PDFX3_2003 = new OutputProfile("PDF/X-3:2003", new Feature[]{Feature.AnnotationsInPage, Feature.AlternateImagePrints, Feature.Actions, Feature.ActionsInBookmarks, Feature.JavaScript, Feature.BadTrapNetAnnotation, Feature.Encryption, Feature.DeviceGrayWithRGBIntent, Feature.DeviceRGBWithCMYKIntent, Feature.DeviceCMYKWithRGBIntent, Feature.DeviceCMYKWithGrayIntent, Feature.ICCProfileNotOutput, Feature.ICCProfileBadColorComponentCount, Feature.PostScriptXObject, Feature.FontStandard14, Feature.FontType1Unembedded, Feature.FontTrueTypeUnembedded, Feature.CIDFontTrueTypeUnembedded, Feature.CIDFontType1Unembedded, Feature.HalftoneName, Feature.HalftoneNot1or5, Feature.FilterLZW, Feature.FilterInlineLZW, Feature.BadBoxNesting, Feature.z, Feature.PDFVersion15, Feature.PDFVersion16, Feature.PDFVersion17, Feature.PDFVersion17e3, Feature.PDFVersion17e5, Feature.PDFVersion17e8, Feature.h, Feature.BothTrimAndArtBox, Feature.MissingTrimAndArtBox, Feature.OPI, Feature.TransferFunctionIsDefault, Feature.TransferFunctionIsIdentity, Feature.TransferFunctionIsOther, Feature.TransferFunction, Feature.Transparency, Feature.ImageTransparency, Feature.FontEmbeddingRestrictions, Feature.ViewBoxNotBleedBox, Feature.EmbeddedFiles, Feature.InvalidColorProfile, Feature.HasMultipleOutputIntents, Feature.FilterJPX, Feature.FilterJBIG2, Feature.OptionalContent, Feature.ImageDepth16, Feature.UTF16Encoding}, new Feature[]{Feature.HasCreationDate, Feature.HasDocID, Feature.InfoMeetsPDFX3_2003, Feature.HasModDate, Feature.HasOutputIntent, Feature.HasOutputIntentGTS_PDFX, Feature.HasTitle, Feature.HasTrapped, Feature.UncompressedXRef});
        NotPDFX = new OutputProfile("Not PDF/X", new Feature[]{Feature.InfoMeetsPDFX1a_2001, Feature.InfoMeetsPDFX1a_2003, Feature.InfoMeetsPDFX3_2003, Feature.InfoMeetsPDFX3_2002, Feature.HasOutputIntentGTS_PDFX}, new Feature[0]);
        PDFA1b_2005 = new OutputProfile("PDF/A-1b:2005", new Feature[]{Feature.HeaderNotAtStart, Feature.TrailerNotAtEnd, Feature.NoFourByteComment, Feature.FileIsDamaged, Feature.ImperfectWhitespace, Feature.StreamLengthIncorrect, Feature.NoEOLStream, Feature.OddHexString, Feature.DocIDMismatch, Feature.FilterLZW, Feature.FilterInlineLZW, Feature.FFilter, Feature.OptionalContent, Feature.Encryption, Feature.EmbeddedFiles, Feature.OPI, Feature.AlternateImage, Feature.InterpolatedImage, Feature.RenderingIntentUnknown, Feature.UnknownStreamOperator, Feature.PostScriptXObject, Feature.ReferenceXObject, Feature.TransferFunctionIsOther, Feature.TransferFunctionIsIdentity, Feature.BXEXOperator, Feature.InvalidFont, Feature.CIDSystemInfoAndCMapNotCompatible, Feature.CIDFontTrueTypeWithoutCIDToGIDMap, Feature.CMapEmbeddedWithInvalidWMode, Feature.UnembeddedCMap, Feature.FontType1SubsetWithoutCharset, Feature.CIDFontSubsetWithoutCIDSet, Feature.FontWithMissingGlyphs, Feature.FontWidthsNotConsistent, Feature.NonSymbolicTrueTypeWithoutMacRomanOrWinAnsiEncoding, Feature.SymbolicTrueTypeWithEncodingEntry, Feature.SymbolicTrueTypeWithoutOneEncoding, Feature.FontStandard14, Feature.FontType1Unembedded, Feature.FontTrueTypeUnembedded, Feature.CIDFontTrueTypeUnembedded, Feature.CIDFontType1Unembedded, Feature.FontEmbeddingRestrictions, Feature.NeedAppearancesNotFalse, Feature.ActionImportData, Feature.JavaScript, Feature.ICCProfileVersion4, Feature.ICCProfileVersion3, Feature.ICCProfileBadColorComponentCount, Feature.ActionLaunch, Feature.ActionMovie, Feature.ActionResetForm, Feature.ActionSound, Feature.ActionNamedOther, Feature.ActionUnknown, Feature.ActionsOnWidgets, Feature.ActionGoToBadPage, Feature.AdditionalActions, Feature.AnnotationSound, Feature.AnnotationMovie, Feature.AnnotationTransparency, Feature.AnnotationPrintFlagNotSet, Feature.AnnotationHiddenFlagSet, Feature.AnnotationInvisibleFlagSet, Feature.AnnotationNoViewFlagSet, Feature.AnnotationTextNoZoomFlagNotSet, Feature.AnnotationTextNoRotateFlagNotSet, Feature.AnnotationWithUnpredictableAppearance, Feature.BadXMPMetaData, Feature.XMPMetaDataIsFiltered, Feature.XMPMetaDataInfoMismatch, Feature.XMPMetaDataXpacketFormatError, Feature.i, Feature.k, Feature.l, Feature.m, Feature.n, Feature.o, Feature.p, Feature.q, Feature.IntegerOverflow, Feature.ArrayOverflow, Feature.DictionaryOverflow, Feature.StringOverflow, Feature.NameOverflow, Feature.Device9ColorSpace, Feature.AnnotationPolygon, Feature.AnnotationPolyLine, Feature.AnnotationCaret, Feature.AnnotationScreen, Feature.AnnotationWatermark, Feature.Annotation3D, Feature.AnnotationProjection, Feature.AnnotationRichMedia, Feature.AnnotationUnknown, Feature.Transparency, Feature.ImageTransparency, Feature.TransparencyGroup, Feature.ComplexBlendMode, Feature.InvalidColorProfile, Feature.DeviceRGBWithCMYKIntent, Feature.DeviceRGBWithGrayIntent, Feature.DeviceCMYKWithRGBIntent, Feature.DeviceCMYKWithGrayIntent, Feature.AnnotationColorMismatchesIntent, Feature.HasMultipleDifferentOutputIntents, Feature.HasUnembeddedOutputIntent}, new Feature[]{Feature.HasDocID, Feature.InfoMeetsPDFA1b_2005, Feature.XMPMetaData, Feature.HasOutputIntentGTS_PDFA1});
        PDFA1b_2005_Acrobat = new OutputProfile(PDFA1b_2005, "PDF/A-1b:2005 (Acrobat)");
        OutputProfile.PDFA1b_2005_Acrobat.b.clear(Feature.HasOutputIntentGTS_PDFA1.c);
        OutputProfile.PDFA1b_2005_Acrobat.b.set(Feature.HasOutputIntentGTS_PDFA.c);
    }

    public static class Feature {
        public static final Feature[] ALL;
        static List a;
        private static int b;
        final int c;
        final int d;
        final String e;
        final String f;
        final boolean g;
        public static final Feature PDFVersion10;
        public static final Feature PDFVersion11;
        public static final Feature PDFVersion12;
        public static final Feature PDFVersion13;
        public static final Feature PDFVersion14;
        public static final Feature PDFVersion15;
        public static final Feature PDFVersion16;
        public static final Feature PDFVersion17;
        public static final Feature PDFVersion17e3;
        public static final Feature PDFVersion17e5;
        public static final Feature PDFVersion17e8;
        static final Feature h;
        public static final Feature HasDocID;
        public static final Feature DocIDMismatch;
        public static final Feature HasTitle;
        public static final Feature HasAuthor;
        public static final Feature HasSubject;
        public static final Feature HasProducer;
        public static final Feature HasCreator;
        public static final Feature HasCreationDate;
        public static final Feature HasModDate;
        public static final Feature HasTrapped;
        public static final Feature Linearized;
        public static final Feature MultipleRevisions;
        public static final Feature UncompressedXRef;
        public static final Feature CompressedXRef;
        public static final Feature Bookmarks;
        public static final Feature Thumbnails;
        public static final Feature PageLabels;
        public static final Feature Articles;
        public static final Feature TaggedPDF;
        public static final Feature LanguageSpecified;
        public static final Feature ReaderExtensions;
        public static final Feature XMPMetaData;
        public static final Feature BadXMPMetaData;
        public static final Feature XMPMetaDataIsFiltered;
        public static final Feature XMPMetaDataInfoMismatch;
        public static final Feature XMPMetaDataXpacketFormatError;
        static final Feature i;
        static final Feature j;
        static final Feature k;
        static final Feature l;
        static final Feature m;
        static final Feature n;
        static final Feature o;
        static final Feature p;
        static final Feature q;
        public static final Feature Actions;
        public static final Feature AdditionalActions;
        public static final Feature ActionsOnDocument;
        public static final Feature ActionsOnPages;
        public static final Feature ActionsOnWidgets;
        public static final Feature ActionsOnFields;
        public static final Feature ActionsInBookmarks;
        public static final Feature JavaScript;
        public static final Feature ActionLaunch;
        public static final Feature ActionSound;
        public static final Feature ActionMovie;
        public static final Feature ActionImportData;
        public static final Feature ActionResetForm;
        public static final Feature ActionNamedOther;
        public static final Feature ActionUnknown;
        public static final Feature ActionGoToBadPage;
        public static final Feature Annotations;
        public static final Feature AnnotationsInPage;
        public static final Feature AnnotationMovie;
        public static final Feature AnnotationSound;
        public static final Feature AnnotationNote;
        public static final Feature AnnotationLink;
        public static final Feature AnnotationText;
        public static final Feature AnnotationLine;
        public static final Feature AnnotationSquare;
        public static final Feature AnnotationCircle;
        public static final Feature AnnotationPolygon;
        public static final Feature AnnotationPolyLine;
        public static final Feature AnnotationHighlight;
        public static final Feature AnnotationUnderline;
        public static final Feature AnnotationSquiggly;
        public static final Feature AnnotationStrikeOut;
        public static final Feature AnnotationStamp;
        public static final Feature AnnotationCaret;
        public static final Feature AnnotationInk;
        public static final Feature AnnotationPopup;
        public static final Feature AnnotationFile;
        public static final Feature AnnotationWidget;
        public static final Feature AnnotationScreen;
        public static final Feature AnnotationPrinterMark;
        public static final Feature AnnotationTrapNet;
        public static final Feature AnnotationWatermark;
        public static final Feature Annotation3D;
        public static final Feature AnnotationProjection;
        public static final Feature AnnotationRichMedia;
        public static final Feature AnnotationUnknown;
        public static final Feature BadTrapNetAnnotation;
        public static final Feature AnnotationTransparency;
        public static final Feature TransparencyGroup;
        public static final Feature AnnotationPrintFlagNotSet;
        public static final Feature AnnotationHiddenFlagSet;
        public static final Feature AnnotationInvisibleFlagSet;
        public static final Feature AnnotationNoViewFlagSet;
        public static final Feature AnnotationTextNoZoomFlagNotSet;
        public static final Feature AnnotationTextNoRotateFlagNotSet;
        public static final Feature AnnotationWithUnpredictableAppearance;
        public static final Feature FreeFormLink;
        public static final Feature EmbeddedFiles;
        public static final Feature MissingTrimAndArtBox;
        public static final Feature BothTrimAndArtBox;
        public static final Feature OptionalContent;
        public static final Feature BadBoxNesting;
        public static final Feature PageTemplates;
        public static final Feature FilterFlate;
        public static final Feature FilterCCITT;
        public static final Feature FilterASCII85;
        public static final Feature FilterASCIIHex;
        public static final Feature FilterRLE;
        public static final Feature FilterLZW;
        public static final Feature FilterInlineFlate;
        public static final Feature FilterInlineCCITT;
        public static final Feature FilterInlineASCII85;
        public static final Feature FilterInlineASCIIHex;
        public static final Feature FilterInlineRLE;
        public static final Feature FilterInlineLZW;
        public static final Feature FilterInlineDCT;
        public static final Feature FFilter;
        public static final Feature FilterDCT;
        public static final Feature FilterJPX;
        public static final Feature FilterJBIG2;
        public static final Feature FilterNoneOnLargeStream;
        public static final Feature ImageDepth1;
        public static final Feature ImageDepth2;
        public static final Feature ImageDepth4;
        public static final Feature ImageDepth8;
        public static final Feature ImageDepth16;
        public static final Feature ImageTransparency;
        public static final Feature ComplexBlendMode;
        public static final Feature CMYKJPEG;
        public static final Feature FullPageImage;
        public static final Feature Encryption;
        public static final Feature Acrobat5Encryption;
        public static final Feature Acrobat6Encryption;
        public static final Feature AESEncryption;
        public static final Feature WeakAES256Encryption;
        public static final Feature AES256Encryption;
        public static final Feature PublicKeyEncryption;
        public static final Feature NonStandardEncryption;
        public static final Feature ColorSpaceICC;
        public static final Feature ICCProfileVersion4;
        public static final Feature ICCProfileVersion3;
        public static final Feature ICCProfileVersion2;
        public static final Feature ICCProfileVersion1;
        public static final Feature ICCProfileNotOutput;
        public static final Feature ICCProfileBadColorComponentCount;
        public static final Feature ColorSpaceDeviceGray;
        public static final Feature ColorSpaceDeviceRGB;
        public static final Feature ColorSpaceDeviceCMYK;
        public static final Feature ColorSpaceCalGray;
        public static final Feature ColorSpaceCalRGB;
        public static final Feature ColorSpaceDeviceN;
        public static final Feature ColorSpaceSeparation;
        public static final Feature ColorSpaceIndexed;
        public static final Feature ColorSpaceLab;
        public static final Feature ColorSpacePattern;
        public static final Feature AltColorSpaceDeviceGray;
        public static final Feature AltColorSpaceDeviceRGB;
        public static final Feature AltColorSpaceDeviceCMYK;
        public static final Feature AltColorSpaceCalRGB;
        public static final Feature AltColorSpaceCalGray;
        public static final Feature AltColorSpaceLab;
        public static final Feature AltColorSpaceICC;
        public static final Feature RedGreenBlueSeparation;
        public static final Feature CyanSeparation;
        public static final Feature MagentaSeparation;
        public static final Feature YellowSeparation;
        public static final Feature BlackSeparation;
        static final Feature r;
        static final Feature s;
        static final Feature t;
        static final Feature u;
        public static final Feature DeviceGrayWithRGBIntent;
        public static final Feature DeviceGrayWithCMYKIntent;
        public static final Feature DeviceRGBWithGrayIntent;
        public static final Feature DeviceRGBWithCMYKIntent;
        public static final Feature DeviceCMYKWithGrayIntent;
        public static final Feature DeviceCMYKWithRGBIntent;
        public static final Feature AnnotationColorMismatchesIntent;
        static final Feature v;
        public static final Feature FontStandard14;
        public static final Feature FontCompactEmbedded;
        public static final Feature FontType1Embedded;
        public static final Feature FontTrueTypeEmbedded;
        public static final Feature FontOpenTypeEmbedded;
        public static final Feature FontType3;
        public static final Feature FontMultipleMaster;
        public static final Feature FontType1Unembedded;
        public static final Feature FontTrueTypeUnembedded;
        static final Feature w;
        public static final Feature FontType0;
        public static final Feature CIDFontType1Embedded;
        public static final Feature CIDSystemInfoAndCMapNotCompatible;
        public static final Feature UnembeddedCMap;
        public static final Feature CIDFontType1Unembedded;
        public static final Feature CIDFontTrueTypeEmbedded;
        public static final Feature CIDFontTrueTypeUnembedded;
        public static final Feature CIDFontCompactEmbedded;
        public static final Feature CIDFontOpenTypeEmbedded;
        public static final Feature FontEmbeddingRestrictions;
        public static final Feature CMapEmbeddedWithInvalidWMode;
        public static final Feature FontType1SubsetWithoutCharset;
        public static final Feature FontWidthsNotConsistent;
        public static final Feature NonSymbolicTrueTypeWithoutMacRomanOrWinAnsiEncoding;
        public static final Feature SymbolicTrueTypeWithEncodingEntry;
        public static final Feature SymbolicTrueTypeWithoutOneEncoding;
        public static final Feature CIDFontSubsetWithoutCIDSet;
        public static final Feature UTF16Encoding;
        public static final Feature FontWithMissingGlyphs;
        public static final Feature InvalidFont;
        public static final Feature FontWithoutMetadata;
        public static final Feature CIDFontTrueTypeWithoutCIDToGIDMap;
        public static final Feature Transparency;
        public static final Feature BXEXOperator;
        public static final Feature InlineImage;
        public static final Feature Hairline;
        public static final Feature ZeroWidthLine;
        public static final Feature ShadingPattern;
        public static final Feature PostScriptXObject;
        public static final Feature ReferenceXObject;
        public static final Feature HalftoneName;
        public static final Feature HalftoneNot1or5;
        public static final Feature TransferFunctionIsIdentity;
        public static final Feature TransferFunctionIsDefault;
        public static final Feature TransferFunctionIsOther;
        public static final Feature TransferFunction;
        public static final Feature OPI;
        public static final Feature RenderingIntent;
        public static final Feature AlternateImagePrints;
        public static final Feature StreamContainsFormXObject;
        public static final Feature StreamContainsPathOperators;
        public static final Feature StreamContainsText;
        public static final Feature RenderingIntentUnknown;
        public static final Feature UnknownStreamOperator;
        public static final Feature AlternateImage;
        public static final Feature InterpolatedImage;
        public static final Feature Form;
        public static final Feature NeedAppearancesNotFalse;
        public static final Feature DigitallySigned;
        public static final Feature AuthorSignature;
        public static final Feature XFAForm;
        public static final Feature XFAForm20;
        public static final Feature XFAForm22;
        public static final Feature XFAForm24;
        public static final Feature XFAForm25;
        public static final Feature XFAForm26;
        public static final Feature XFAForm27;
        public static final Feature XFAForm28;
        public static final Feature XFAForm30;
        public static final Feature XFAForm31;
        public static final Feature HasOutputIntent;
        public static final Feature HasOutputIntentGTS_PDFX;
        public static final Feature HasOutputIntentGTS_PDFA1;
        public static final Feature HasOutputIntentGTS_PDFA;
        public static final Feature HasGrayOutputIntent;
        public static final Feature HasRGBOutputIntent;
        public static final Feature HasCMYKOutputIntent;
        public static final Feature HasUnknownOutputIntent;
        public static final Feature UnknownOutputIntentRegistry;
        public static final Feature HasUnembeddedOutputIntent;
        public static final Feature UnknownOutputIntentRegistryWithoutProfile;
        public static final Feature HasMultipleOutputIntents;
        public static final Feature HasMultipleDifferentOutputIntents;
        public static final Feature InfoMeetsPDFX1a_2001;
        public static final Feature InfoMeetsPDFX1a_2003;
        public static final Feature InfoMeetsPDFX3_2002;
        public static final Feature InfoMeetsPDFX3_2003;
        public static final Feature InfoMeetsPDFA1b_2005;
        public static final Feature InfoMeetsPDFA1b_2005_Acrobat7;
        public static final Feature InfoMeetsPDFA1a_2005;
        public static final Feature ViewBoxNotBleedBox;
        public static final Feature ImagePluginHeader;
        public static final Feature RegularCompression;
        public static final Feature MaximumCompression;
        public static final Feature MergeResources;
        public static final Feature PurgeResources;
        public static final Feature FileIsDamaged;
        public static final Feature ContentIsDamaged;
        public static final Feature ImperfectWhitespace;
        public static final Feature StreamLengthIncorrect;
        public static final Feature ImageLengthIncorrect;
        public static final Feature NoEOLStream;
        public static final Feature OddHexString;
        public static final Feature HeaderNotAtStart;
        public static final Feature TrailerNotAtEnd;
        public static final Feature NoFourByteComment;
        public static final Feature ArrayOverflow;
        public static final Feature DictionaryOverflow;
        public static final Feature IntegerOverflow;
        public static final Feature NameOverflow;
        public static final Feature StringOverflow;
        public static final Feature Device9ColorSpace;
        public static final Feature Device33ColorSpace;
        public static final Feature InvalidColorProfile;
        public static final Feature SinglePixelImage;
        static final Feature x;
        static final Feature y;
        static final Feature z;
        static final Feature A;
        static final Feature B;
        static final Feature C;
        static final Feature D;
        static final Feature E;

        Feature(String string, int n2, boolean bl) {
            this(string, "The PDF is/has " + string, n2, bl);
        }

        Feature(String string, String string2, int n2, boolean bl) {
            this.e = string;
            this.f = string2;
            this.d = n2;
            this.g = bl;
            this.c = b++;
            a.add(this);
        }

        public String toString() {
            return this.e;
        }

        public final String getDescription() {
            return this.f;
        }

        boolean a(OutputProfile outputProfile) {
            return false;
        }

        boolean a() {
            return this.g;
        }

        void b(OutputProfile outputProfile) {
        }

        void c(OutputProfile outputProfile) {
        }

        Exception a(PDF pDF, OutputProfile outputProfile) {
            try {
                String string = this.c(pDF, outputProfile);
                if (string != null) {
                    PDF.k.warning("OP1", "Document was altered to remove \"" + this.e + "\": " + string);
                }
                outputProfile.clear(this);
                return null;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (unsupportedOperationException.getCause() == null) {
                    return unsupportedOperationException;
                }
                return (Exception)unsupportedOperationException.getCause();
            }
        }

        Exception b(PDF pDF, OutputProfile outputProfile) {
            try {
                String string = this.d(pDF, outputProfile);
                if (string != null) {
                    PDF.k.warning("OP1", "Document was altered to add \"" + this.e + "\": " + string);
                }
                outputProfile.set(this);
                return null;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Exception exception;
                block7: {
                    exception = unsupportedOperationException;
                    if (PDF.p < 4 || unsupportedOperationException.getCause() == null) break block7;
                    exception = (Exception)unsupportedOperationException.getCause();
                }
                return exception;
            }
        }

        String c(PDF pDF, OutputProfile outputProfile) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        String d(PDF pDF, OutputProfile outputProfile) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected final int removePDFActions(PDF pDF, boolean bl, String[] stringArray) {
            int n2 = 0;
            int n3 = 0;
            block10: while (n3 < Event.ALL.length) {
                PDFAction pDFAction = pDF.getAction(Event.ALL[n3]);
                PDFAction pDFAction2 = null;
                while (true) {
                    String string;
                    boolean bl2;
                    boolean bl3;
                    if (pDFAction != null) {
                        bl3 = stringArray != null;
                        bl2 = Event.ALL[n3] != Event.OPEN;
                        string = pDFAction.t();
                    } else {
                        ++n3;
                        continue block10;
                    }
                    for (int i2 = 0; bl3 && i2 < stringArray.length; ++i2) {
                        bl3 = !string.equals(stringArray[i2]);
                    }
                    if (!(bl && !bl2 || bl3)) {
                        if (pDFAction2 == null) {
                            pDF.setAction(Event.ALL[n3], pDFAction.getNext());
                        } else {
                            pDFAction2.setNext(pDFAction.getNext());
                        }
                        ++n2;
                    } else {
                        pDFAction2 = pDFAction;
                    }
                    pDFAction = pDFAction.getNext();
                }
                break;
            }
            return n2;
        }

        /*
         * Loose catch block
         */
        protected final int removePageActions(PDF pDF, String[] stringArray) {
            int n2 = 0;
            int n3 = pDF.getNumberOfPages();
            for (int i2 = 0; i2 < n3; ++i2) {
                PDFPage pDFPage = pDF.getPage(i2);
                block15: for (int i3 = 0; i3 < Event.ALL.length; ++i3) {
                    PDFAction pDFAction = pDFPage.getAction(Event.ALL[i3]);
                    PDFAction pDFAction2 = null;
                    while (true) {
                        block29: {
                            block22: {
                                block24: {
                                    block23: {
                                        block28: {
                                            boolean bl;
                                            block19: {
                                                block18: {
                                                    block25: {
                                                        if (pDFAction == null) continue block15;
                                                        if (stringArray == null) break block18;
                                                        break block25;
                                                        catch (UnsupportedOperationException unsupportedOperationException) {
                                                            throw unsupportedOperationException;
                                                        }
                                                    }
                                                    bl = true;
                                                    break block19;
                                                }
                                                bl = false;
                                            }
                                            boolean bl2 = bl;
                                            String string = pDFAction.t();
                                            int n4 = 0;
                                            while (true) {
                                                boolean bl3;
                                                block21: {
                                                    block20: {
                                                        block27: {
                                                            block26: {
                                                                if (!bl2) break;
                                                                if (n4 >= stringArray.length) break;
                                                                break block26;
                                                                catch (UnsupportedOperationException unsupportedOperationException) {
                                                                    throw unsupportedOperationException;
                                                                }
                                                            }
                                                            if (string.equals(stringArray[n4])) break block20;
                                                            break block27;
                                                            catch (UnsupportedOperationException unsupportedOperationException) {
                                                                throw unsupportedOperationException;
                                                            }
                                                        }
                                                        bl3 = true;
                                                        break block21;
                                                    }
                                                    bl3 = false;
                                                }
                                                bl2 = bl3;
                                                ++n4;
                                            }
                                            if (bl2) break block22;
                                            if (pDFAction2 != null) break block23;
                                            break block28;
                                            catch (UnsupportedOperationException unsupportedOperationException) {
                                                throw unsupportedOperationException;
                                            }
                                        }
                                        pDFPage.setAction(Event.ALL[i3], pDFAction.getNext());
                                        break block24;
                                    }
                                    pDFAction2.setNext(pDFAction.getNext());
                                }
                                ++n2;
                                break block29;
                            }
                            pDFAction2 = pDFAction;
                        }
                        pDFAction = pDFAction.getNext();
                    }
                }
            }
            return n2;
        }

        /*
         * Loose catch block
         */
        protected final int removeFieldActions(PDF pDF, String[] stringArray) {
            int n2;
            block25: {
                n2 = 0;
                if (!pDF.j("Root").f("AcroForm")) break block25;
                Iterator iterator = pDF.getForm().getElements().values().iterator();
                while (iterator.hasNext()) {
                    FormElement formElement = (FormElement)iterator.next();
                    block15: for (int i2 = 0; i2 < Event.ALL.length; ++i2) {
                        PDFAction pDFAction = formElement.getAction(Event.ALL[i2]);
                        PDFAction pDFAction2 = null;
                        while (true) {
                            block30: {
                                block22: {
                                    block24: {
                                        block23: {
                                            block29: {
                                                boolean bl;
                                                block19: {
                                                    block18: {
                                                        block26: {
                                                            if (pDFAction == null) continue block15;
                                                            if (stringArray == null) break block18;
                                                            break block26;
                                                            catch (UnsupportedOperationException unsupportedOperationException) {
                                                                throw unsupportedOperationException;
                                                            }
                                                        }
                                                        bl = true;
                                                        break block19;
                                                    }
                                                    bl = false;
                                                }
                                                boolean bl2 = bl;
                                                String string = pDFAction.t();
                                                int n3 = 0;
                                                while (true) {
                                                    boolean bl3;
                                                    block21: {
                                                        block20: {
                                                            block28: {
                                                                block27: {
                                                                    if (!bl2) break;
                                                                    if (n3 >= stringArray.length) break;
                                                                    break block27;
                                                                    catch (UnsupportedOperationException unsupportedOperationException) {
                                                                        throw unsupportedOperationException;
                                                                    }
                                                                }
                                                                if (string.equals(stringArray[n3])) break block20;
                                                                break block28;
                                                                catch (UnsupportedOperationException unsupportedOperationException) {
                                                                    throw unsupportedOperationException;
                                                                }
                                                            }
                                                            bl3 = true;
                                                            break block21;
                                                        }
                                                        bl3 = false;
                                                    }
                                                    bl2 = bl3;
                                                    ++n3;
                                                }
                                                if (bl2) break block22;
                                                if (pDFAction2 != null) break block23;
                                                break block29;
                                                catch (UnsupportedOperationException unsupportedOperationException) {
                                                    throw unsupportedOperationException;
                                                }
                                            }
                                            formElement.setAction(Event.ALL[i2], pDFAction.getNext());
                                            break block24;
                                        }
                                        pDFAction2.setNext(pDFAction.getNext());
                                    }
                                    ++n2;
                                    break block30;
                                }
                                pDFAction2 = pDFAction;
                            }
                            pDFAction = pDFAction.getNext();
                        }
                    }
                }
            }
            return n2;
        }

        /*
         * Loose catch block
         */
        protected final int removeAnnotationActions(PDF pDF, String[] stringArray, boolean bl) {
            int n2 = 0;
            int n3 = pDF.getNumberOfPages();
            for (int i2 = 0; i2 < n3; ++i2) {
                PDFPage pDFPage = pDF.getPage(i2);
                List list = pDFPage.getAnnotations();
                block31: for (int i3 = 0; i3 < list.size(); ++i3) {
                    PDFAction pDFAction;
                    PDFAnnotation pDFAnnotation;
                    block51: {
                        pDFAnnotation = (PDFAnnotation)list.get(i3);
                        if (!(pDFAnnotation instanceof WidgetAnnotation)) break block51;
                        block32: for (int i4 = 0; i4 < Event.ALL.length; ++i4) {
                            pDFAction = ((WidgetAnnotation)pDFAnnotation).getAction(Event.ALL[i4]);
                            PDFAction pDFAction2 = null;
                            while (true) {
                                block56: {
                                    block41: {
                                        block43: {
                                            block42: {
                                                block55: {
                                                    boolean bl2;
                                                    block38: {
                                                        block37: {
                                                            block52: {
                                                                if (pDFAction == null) continue block32;
                                                                if (stringArray == null) break block37;
                                                                break block52;
                                                                catch (UnsupportedOperationException unsupportedOperationException) {
                                                                    throw unsupportedOperationException;
                                                                }
                                                            }
                                                            bl2 = true;
                                                            break block38;
                                                        }
                                                        bl2 = false;
                                                    }
                                                    boolean bl3 = bl2;
                                                    String string = pDFAction.t();
                                                    int n4 = 0;
                                                    while (true) {
                                                        boolean bl4;
                                                        block40: {
                                                            block39: {
                                                                block54: {
                                                                    block53: {
                                                                        if (!bl3) break;
                                                                        if (n4 >= stringArray.length) break;
                                                                        break block53;
                                                                        catch (UnsupportedOperationException unsupportedOperationException) {
                                                                            throw unsupportedOperationException;
                                                                        }
                                                                    }
                                                                    if (string.equals(stringArray[n4])) break block39;
                                                                    break block54;
                                                                    catch (UnsupportedOperationException unsupportedOperationException) {
                                                                        throw unsupportedOperationException;
                                                                    }
                                                                }
                                                                bl4 = true;
                                                                break block40;
                                                            }
                                                            bl4 = false;
                                                        }
                                                        bl3 = bl4;
                                                        ++n4;
                                                    }
                                                    if (bl3) break block41;
                                                    if (pDFAction2 != null) break block42;
                                                    break block55;
                                                    catch (UnsupportedOperationException unsupportedOperationException) {
                                                        throw unsupportedOperationException;
                                                    }
                                                }
                                                ((WidgetAnnotation)pDFAnnotation).setAction(Event.ALL[i4], pDFAction.getNext());
                                                break block43;
                                            }
                                            pDFAction2.setNext(pDFAction.getNext());
                                        }
                                        ++n2;
                                        break block56;
                                    }
                                    pDFAction2 = pDFAction;
                                }
                                pDFAction = pDFAction.getNext();
                            }
                        }
                        continue;
                    }
                    if (bl || !(pDFAnnotation instanceof AnnotationLink)) continue;
                    PDFAction pDFAction3 = ((AnnotationLink)pDFAnnotation).getAction();
                    pDFAction = null;
                    while (true) {
                        block61: {
                            block48: {
                                block50: {
                                    block49: {
                                        block60: {
                                            boolean bl5;
                                            block45: {
                                                block44: {
                                                    block57: {
                                                        if (pDFAction3 == null) continue block31;
                                                        if (stringArray == null) break block44;
                                                        break block57;
                                                        catch (UnsupportedOperationException unsupportedOperationException) {
                                                            throw unsupportedOperationException;
                                                        }
                                                    }
                                                    bl5 = true;
                                                    break block45;
                                                }
                                                bl5 = false;
                                            }
                                            boolean bl6 = bl5;
                                            String string = pDFAction3.t();
                                            int n5 = 0;
                                            while (true) {
                                                boolean bl7;
                                                block47: {
                                                    block46: {
                                                        block59: {
                                                            block58: {
                                                                if (!bl6) break;
                                                                if (n5 >= stringArray.length) break;
                                                                break block58;
                                                                catch (UnsupportedOperationException unsupportedOperationException) {
                                                                    throw unsupportedOperationException;
                                                                }
                                                            }
                                                            if (string.equals(stringArray[n5])) break block46;
                                                            break block59;
                                                            catch (UnsupportedOperationException unsupportedOperationException) {
                                                                throw unsupportedOperationException;
                                                            }
                                                        }
                                                        bl7 = true;
                                                        break block47;
                                                    }
                                                    bl7 = false;
                                                }
                                                bl6 = bl7;
                                                ++n5;
                                            }
                                            if (bl6) break block48;
                                            if (pDFAction != null) break block49;
                                            break block60;
                                            catch (UnsupportedOperationException unsupportedOperationException) {
                                                throw unsupportedOperationException;
                                            }
                                        }
                                        ((AnnotationLink)pDFAnnotation).setAction(pDFAction3.getNext());
                                        break block50;
                                    }
                                    pDFAction.setNext(pDFAction3.getNext());
                                }
                                ++n2;
                                break block61;
                            }
                            pDFAction = pDFAction3;
                        }
                        pDFAction3 = pDFAction3.getNext();
                    }
                }
            }
            return n2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected int removeBookmarkActions(List list, String[] stringArray) {
            int n2 = 0;
            int i2 = 0;
            block7: while (i2 < list.size()) {
                PDFBookmark pDFBookmark = (PDFBookmark)list.get(i2);
                PDFAction pDFAction = pDFBookmark.getAction();
                PDFAction pDFAction2 = null;
                while (true) {
                    String string;
                    boolean bl2;
                    if (pDFAction != null) {
                        bl2 = stringArray != null;
                        string = pDFAction.t();
                    } else {
                        n2 += this.removeBookmarkActions(pDFBookmark.getBookmarks(), stringArray);
                        ++i2;
                        continue block7;
                    }
                    for (int n3 = 0; bl2 && n3 < stringArray.length; ++n3) {
                        bl2 = !string.equals(stringArray[n3]);
                    }
                    if (!bl2) {
                        if (pDFAction2 == null) {
                            pDFBookmark.setAction(pDFAction.getNext());
                        } else {
                            pDFAction2.setNext(pDFAction.getNext());
                        }
                        ++n2;
                    } else {
                        pDFAction2 = pDFAction;
                    }
                    pDFAction = pDFAction.getNext();
                }
                break;
            }
            return n2;
        }

        protected String removeActionType(String string, boolean bl, PDF pDF, OutputProfile outputProfile) {
            String[] stringArray;
            block14: {
                stringArray = null;
                if (string == null || bl) break block14;
                stringArray = new String[]{string};
            }
            int n2 = this.removePDFActions(pDF, bl, stringArray);
            int n3 = this.removePageActions(pDF, stringArray);
            int n4 = this.removeFieldActions(pDF, stringArray);
            int n5 = this.removeAnnotationActions(pDF, stringArray, false);
            int n6 = 0;
            if (!bl) {
                this.removeBookmarkActions(pDF.getBookmarks(), stringArray);
            }
            String string2 = "";
            if (n2 != 0) {
                string2 = string2 + n2 + " pdf, ";
            }
            if (n3 != 0) {
                string2 = string2 + n3 + " page, ";
            }
            if (n4 != 0) {
                string2 = string2 + n4 + " field, ";
            }
            if (n5 != 0) {
                string2 = string2 + n5 + " widget, ";
            }
            if (n6 != 0) {
                string2 = string2 + n6 + " bookmark, ";
            }
            String string3 = string == null ? "" : " " + string;
            string = string3;
            String string4 = string2.length() == 0 ? null : string2.substring(0, string2.length() - 2) + string + " action(s) were removed";
            return string4;
        }

        protected String removeAnnotations(PDF pDF, String string, String string2) {
            int n2 = pDF.getNumberOfPages();
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                PDFPage pDFPage = pDF.getPage(i2);
                List list = pDFPage.getAnnotations();
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    PDFAnnotation pDFAnnotation = (PDFAnnotation)list.get(i3);
                    boolean bl = string.equals("Unknown") ? pDFAnnotation.u() : pDFAnnotation.getType().equals(string);
                    boolean bl2 = bl;
                    if (!bl2) continue;
                    list.remove(i3--);
                    ++n3;
                    if (!(pDFAnnotation instanceof mc)) continue;
                    PDFAnnotation pDFAnnotation2 = ((mc)pDFAnnotation).A();
                    if (pDFAnnotation2 == null) continue;
                    pDFAnnotation2.e("Popup");
                    continue;
                }
            }
            return n3 + " " + string2 + " annotation(s) were removed";
        }

        static {
            a = new ArrayList();
            PDFVersion10 = new Feature("PDF version is 1.0", "The PDF header describes this document as version 1.0", 0, true);
            PDFVersion11 = new Feature("PDF version is 1.1", "The PDF header describes this document as version 1.1", 1, true);
            PDFVersion12 = new Feature("PDF version is 1.2", "The PDF header describes this document as version 1.2", 2, true);
            PDFVersion13 = new Feature("PDF version is 1.3", "The PDF header describes this document as version 1.3", 3, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return "Version number will be downgraded";
                }
            };
            PDFVersion14 = new Feature("PDF version is 1.4", "The PDF header describes this document as version 1.4", 4, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return "Version number will be downgraded";
                }
            };
            PDFVersion15 = new Feature("PDF version is 1.5", "The PDF header describes this document as version 1.5", 5, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return "Version number will be downgraded";
                }
            };
            PDFVersion16 = new Feature("PDF version is 1.6", "The PDF header describes this document as version 1.6", 6, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return "Version number will be downgraded";
                }
            };
            PDFVersion17 = new Feature("PDF version is 1.7", "The PDF header describes this document as version 1.7 with no Extension Level", 7, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return "Version number will be downgraded";
                }
            };
            PDFVersion17e3 = new Feature("PDF version is 1.7e3", "The PDF header describes this document as version 1.7 with Extension Level 3", 8, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return "Version number will be downgraded";
                }
            };
            PDFVersion17e5 = new Feature("PDF version is 1.7e5", "The PDF header describes this document as version 1.7 with Extension Level 5", 9, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return "Version number will be downgraded";
                }
            };
            PDFVersion17e8 = new Feature("PDF version is 1.7e8", "The PDF header describes this document as version 1.7 with Extension Level 8", 10, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return "Version number will be downgraded";
                }
            };
            h = new Feature("PDF version is 2.0", "The PDF header describes this document as version 2.0", 11, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return "Version number will be downgraded";
                }
            };
            HasDocID = new Feature("Document ID is set", "The PDF has a Document ID set. This is the recommended practice for all PDFs", 0, true);
            DocIDMismatch = new Feature("Document ID mismatch between trailers", "The Linearized PDF has mismatching Document IDs in the two trailers.", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return null;
                }
            };
            HasTitle = new Feature("Title set", "The PDF Info Dictionary specifies a Title", 0, true);
            HasAuthor = new Feature("Author set", "The PDF Info Dictionary specifies a document Author", 0, true);
            HasSubject = new Feature("Subject set", "THe PDF Info Dictionary specifies a document Subject", 0, true);
            HasProducer = new Feature("Producer set", "The PDF Info Dictionary specifies the software that produced the PDF", 0, true);
            HasCreator = new Feature("Creator set", "The PDF Info Dictionary specifies the software that created the PDF", 0, true);
            HasCreationDate = new Feature("Creation Date set", "The PDF Info Dictionary specifies the date the PDF was first created", 0, true);
            HasModDate = new Feature("Last Modified Date set", "The PDF Info Dictionary specifies the date the PDF was last modified. This is the recommended practice for all PDFs", 0, true);
            HasTrapped = new Feature("Trapped set", "The PDF Info Dictionary specifies if the PDF has been trapped. This is required for PDF/X and PDF/A", 0, true);
            Linearized = new Feature("Linearized", "The PDF has been Linearized (also known as \"optimized for web\")", 0, true){

                boolean a(OutputProfile outputProfile) {
                    return true;
                }
            };
            MultipleRevisions = new Feature("Multiple Revisions", "The PDF has multiple revisions", 0, true){

                boolean a(OutputProfile outputProfile) {
                    return true;
                }
            };
            UncompressedXRef = new Feature("Regular XRef table", "The PDF has an uncompressed XRef table, suitable for Acrobat 5.0 and earlier", 0, true);
            CompressedXRef = new Feature("Compressed XRef table", "The PDF has a compressed XRef table and cannot be loaded by Acrobat 5.0 or earlier", 5, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    pDF.e("Filter");
                    pDF.e("DecodeParms");
                    return null;
                }
            };
            Bookmarks = new Feature("Bookmarks", "The PDF has a Bookmark tree", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    pDF.j("Root").e("Outlines");
                    return null;
                }

                String d(PDF pDF, OutputProfile outputProfile) {
                    pDF.getBookmarks();
                    return null;
                }
            };
            Thumbnails = new Feature("Thumbnails", "The PDF has thumbnail bitmaps", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    for (int i2 = 0; i2 < pDF.getNumberOfPages(); ++i2) {
                        pDF.getPage(i2).e("Thumb");
                    }
                    return null;
                }
            };
            PageLabels = new Feature("PageLabels", "The PDF has page labels", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    pDF.j("Root").e("PageLabels");
                    return null;
                }
            };
            Articles = new Feature("Document has Articles", "The PDF has \"Articles\" (sometimes called \"Threads\")", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    pDF.j("Root").e("Threads");
                    return null;
                }
            };
            TaggedPDF = new Feature("PDF is Tagged", "The PDF is a \"Tagged PDF\" and contains structural information", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    pDF.j("Root").e("StructTreeRoot");
                    return null;
                }
            };
            LanguageSpecified = new Feature("Document has Language specified", "The PDF has a natural language specified", 0, true);
            ReaderExtensions = new Feature("Reader Extensions", "The PDF contains Reader Extensions. These are usually added by LiveCycle and grant additional rights on the document if used in Acrobat Reader, such as the filling of forms.", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    pDF.j("Root").j("Perms").e("UR");
                    pDF.j("Root").j("Perms").e("UR3");
                    return null;
                }
            };
            XMPMetaData = new Feature("XMP Metadata", "The PDF includes XMP metadata", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    pDF.j("Root").e("Metadata");
                    return null;
                }

                String d(PDF pDF, OutputProfile outputProfile) {
                    pDF.w();
                    return null;
                }
            };
            BadXMPMetaData = new Feature("Metadata does not match XMP format", "The PDF contains XMP metadata that does not match the XMP specification. This is not allowed in PDF/A", 0, true);
            XMPMetaDataIsFiltered = new Feature("Metadata has a Filter key", "The PDF contains XMP metadata that is encoded using a filter. This is not allowed in PDF/A", 0, false);
            XMPMetaDataInfoMismatch = new Feature("Metadata does not match information dictionary", "The PDF contains XMP metadata that does not match the information dictionary. This is not allowed in PDF/A", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    int n2 = 0;
                    if (pDF.c("Title", "dc:title")) {
                        ++n2;
                    }
                    if (pDF.c("Author", "dc:creator")) {
                        ++n2;
                    }
                    if (pDF.c("Subject", "dc:description")) {
                        ++n2;
                    }
                    if (pDF.c("Keywords", "pdf:Keywords")) {
                        ++n2;
                    }
                    if (pDF.c("Creator", "xmp:CreatorTool")) {
                        ++n2;
                    }
                    if (pDF.c("Producer", "pdf:Producer")) {
                        ++n2;
                    }
                    if (pDF.e("CreationDate", "xmp:CreateDate")) {
                        ++n2;
                    }
                    if (pDF.e("ModDate", "xmp:ModifyDate")) {
                        ++n2;
                    }
                    return "" + n2 + " info dictionary entries updated";
                }
            };
            XMPMetaDataXpacketFormatError = new Feature("Metadata contains malformed xpacket header", "The PDF contains XMP metadata with a malformed xpacket header. This is not allowed in PDF/A", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    String string = "No XMP metadata!";
                    if (pDF.r != null) {
                        ic ic2 = pDF.j("Root");
                        StringWriter stringWriter = new StringWriter();
                        try {
                            pDF.r.a(stringWriter);
                            ic2.setMetaData(stringWriter.toString());
                            string = "XMP metadata rewritten";
                        }
                        catch (IOException iOException) {
                            string = iOException.getMessage();
                        }
                    }
                    return string;
                }
            };
            i = new Feature("Metadata xpacket contains deprecated attributes", "The PDF contains XMP metadata with an xpacket header containing the 'bytes' or 'encoding' attribute. This is not allowed in PDF/A", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    ic ic2 = pDF.j("Root");
                    StringWriter stringWriter = new StringWriter();
                    try {
                        pDF.r.a(stringWriter);
                        ic2.setMetaData(stringWriter.toString());
                        return "XMP metadata rewritten";
                    }
                    catch (IOException iOException) {
                        return iOException.getMessage();
                    }
                }
            };
            j = new Feature("Metadata xpacket contains unknown attributes", "The PDF contains XMP metadata with an xpacket header containing an unknown attribute.", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    ic ic2 = pDF.j("Root");
                    StringWriter stringWriter = new StringWriter();
                    try {
                        pDF.r.a(stringWriter);
                        ic2.setMetaData(stringWriter.toString());
                        return "XMP metadata rewritten";
                    }
                    catch (IOException iOException) {
                        return iOException.getMessage();
                    }
                }
            };
            k = new Feature("PDF/A Extension Schema undefined for unknown element in XMP metadata", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    if (pDF.r == null) {
                        return super.c(pDF, outputProfile);
                    }
                    pDF.r.a("http://www.aiim.org/pdfa/ns/id/");
                    OutputProfile outputProfile2 = new OutputProfile(outputProfile);
                    outputProfile2.clear(this);
                    pDF.r.a(outputProfile2);
                    if (outputProfile2.isSet(this)) {
                        return super.c(pDF, outputProfile);
                    }
                    ic ic2 = pDF.j("Root");
                    StringWriter stringWriter = new StringWriter();
                    try {
                        pDF.r.a(stringWriter);
                        ic2.setMetaData(stringWriter.toString());
                        return "PDF/A schema definitions added to metadata";
                    }
                    catch (IOException iOException) {
                        throw (UnsupportedOperationException)new UnsupportedOperationException().initCause(iOException);
                    }
                }
            };
            l = new Feature("PDF/A Extension Schema element has incorrect prefix in XMP metadata", 0, false);
            m = new Feature("PDF/A Extension Schema malformed schema in XMP metadata", 0, false);
            n = new Feature("PDF/A Extension Schema has no valueType for property in XMP metadata", 0, false);
            o = new Feature("PDF/A Extension Schema has no description for property in XMP metadata", 0, false);
            p = new Feature("PDF/A Extension Schema has undefined value type for property in XMP metadata", 0, false);
            q = new Feature("PDF/A Extension Schema defines incompatible value type for property in XMP metadata", 0, false);
            Actions = new nd_("Actions", "The PDF contains Actions (possibly on bookmarks, pages, annotations or the PDF itself). Actions are not allowed under PDF/X", 0, false, null, false);
            AdditionalActions = new nd_("AdditionalActions", "The PDF contains additional actions (possibly on pages, annotations or the PDF itself). Additional Actions are not allowed under PDF/X", 0, false, "Additional", true);
            ActionsOnDocument = new Feature("ActionsOnDocument", "The PDF contains actions on the Document itself", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return this.removePDFActions(pDF, false, null) + " Document action(s) were removed";
                }
            };
            ActionsOnPages = new Feature("ActionsOnPages", "The PDF contains actions that are run when a page is opened, displayed or closed", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return this.removePageActions(pDF, null) + " Document action(s) were removed";
                }
            };
            ActionsOnWidgets = new Feature("ActionsOnWidgets", "The PDF contains actions on a Form Widget Annotation", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return this.removeAnnotationActions(pDF, null, true) + " Widget action(s) were removed";
                }
            };
            ActionsOnFields = new Feature("ActionsOnFields", "The PDF contains actions on a Form Field", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return this.removeFieldActions(pDF, null) + " Field action(s) were removed";
                }
            };
            ActionsInBookmarks = new Feature("Actions in Bookmarks", "The PDF contains actions to be run when a bookmark is activated", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return this.removeBookmarkActions(pDF.getBookmarks(), null) + " action(s) were removed";
                }
            };
            JavaScript = new Feature("JavaScript", "The PDF contains JavaScript. This isn't allowed under PDF/X or PDF/A", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    pDF.setJavaScript(null);
                    return this.removeActionType("FormJavaScript", false, pDF, outputProfile);
                }
            };
            ActionLaunch = new nd_("Launch Action", "The PDF contains a \"Launch\" action, typically used to run an external program", 0, false, "Launch", false);
            ActionSound = new nd_("Sound Action", "The PDF contains a Sound action to play an audio sample", 0, false, "Sound", false);
            ActionMovie = new nd_("Movie Action", "The PDF contains a Movie action, to play an embedded video clip", 0, false, "Movie", false);
            ActionImportData = new nd_("ImportData Action", "The PDF contains an ImportData action, used to import external data from a file into the PDF form", 0, false, "FormImportData", false);
            ActionResetForm = new nd_("ResetForm Action", "The PDF contains an action that resets the internal form", 0, false, "FormReset", false);
            ActionNamedOther = new nd_("Other Named Action", "The PDF contains a named action that is not guaranteed to be supported by all viewers", 0, false, "Named:Other", false);
            ActionUnknown = new nd_("Unknown Action", "The PDF contains an unknown action", 0, false, "Unknown", false);
            ActionGoToBadPage = new nd_("Destination for action specifies invalid page", "The PDF contains a GoTo action that specifies an invalid page destination", 0, false, "GoToBadPage", false);
            Annotations = new Feature("Annotations", "The PDF contains Annotations on one or more page", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    int n2 = pDF.getNumberOfPages();
                    int n3 = 0;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        PDFPage pDFPage = pDF.getPage(i2);
                        List list = pDFPage.getAnnotations();
                        n3 += list.size();
                        list.clear();
                    }
                    return n3 + " annotation(s) were removed";
                }
            };
            AnnotationsInPage = new Feature("Annotations inside PageBox", "The PDF contains annotations inside the visible area of the page. This is not allowed in PDF/X", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    int n2 = pDF.getNumberOfPages();
                    int n3 = 0;
                    int n4 = 0;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        PDFPage pDFPage = pDF.getPage(i2);
                        float[] fArray = pDFPage.getBox("Art");
                        if (fArray == null) {
                            fArray = pDFPage.getBox("Trim");
                        }
                        if (fArray == null) {
                            fArray = pDFPage.getBox("Bleed");
                        }
                        if (fArray == null) {
                            fArray = pDFPage.getBox("Crop");
                        }
                        if (fArray == null) {
                            fArray = pDFPage.getBox("Media");
                        }
                        if (fArray == null) continue;
                        List list = pDFPage.getAnnotations();
                        n4 += list.size();
                        for (int i3 = 0; i3 < list.size(); ++i3) {
                            float f2;
                            PDFAnnotation pDFAnnotation = (PDFAnnotation)list.get(i3);
                            if (pDFAnnotation.getType().equals("TrapNet") || pDFAnnotation.getType().equals("PrinterMark")) continue;
                            float[] fArray2 = pDFAnnotation.getRectangle();
                            if (fArray2[0] > fArray2[2]) {
                                f2 = fArray2[0];
                                fArray2[0] = fArray2[2];
                                fArray2[2] = f2;
                            }
                            if (fArray2[1] > fArray2[3]) {
                                f2 = fArray2[1];
                                fArray2[1] = fArray2[3];
                                fArray2[3] = f2;
                            }
                            if (!(fArray2[2] > fArray[0]) || !(fArray2[0] < fArray[2]) || !(fArray2[3] > fArray[1]) || !(fArray2[1] < fArray[3])) continue;
                            list.remove(i3--);
                            ++n3;
                        }
                    }
                    return n3 + " of " + n4 + " annotation(s) were removed";
                }
            };
            AnnotationMovie = new od_("Movie Annotation", "The PDF contains a Movie annotation", 0, false, "Movie", "Movie");
            AnnotationSound = new od_("Sound Annotation", "The PDF contains an annotation that plays an Audio clip", 0, false, "Sound", "Sound");
            AnnotationNote = new od_("Note Annotation", "The PDF contains a Note annotation", 0, false, "Text", "Note");
            AnnotationLink = new od_("Link Annotation", "The PDF contains a Link annotation", 0, false, "Link", "Link");
            AnnotationText = new od_("Text Annotation", "The PDF contains a Text annotation", 0, false, "FreeText", "Text");
            AnnotationLine = new od_("Line Annotation", "The PDF contains a Line annotation", 0, false, "Line", "Line");
            AnnotationSquare = new od_("Square Annotation", "The PDF contains a Square annotation", 0, false, "Square", "Square");
            AnnotationCircle = new od_("Circle Annotation", "The PDF contains a Circle annotation", 0, false, "Circle", "Circle");
            AnnotationPolygon = new od_("Polygon Annotation", "The PDF contains a Polygon annotation", 0, false, "Polygon", "Polygon");
            AnnotationPolyLine = new od_("PolyLine Annotation", "The PDF contains a PolyLine annotation", 0, false, "PolyLine", "PolyLine");
            AnnotationHighlight = new od_("Highlight Annotation", "The PDF contains a Highlight annotation", 0, false, "Highlight", "Highlight");
            AnnotationUnderline = new od_("Underline Annotation", "The PDF contains an Underline annotation", 0, false, "Underline", "Underline");
            AnnotationSquiggly = new od_("Squiggly Annotation", "The PDF contains a Squiggly annotation", 0, false, "Squiggly", "Squiggly");
            AnnotationStrikeOut = new od_("StrikeOut Annotation", "The PDF contains a StrikeOut annotation", 0, false, "StrikeOut", "StrikeOut");
            AnnotationStamp = new od_("Stamp Annotation", "The PDF contains a Stamp annotation", 0, false, "Stamp", "Stamp");
            AnnotationCaret = new od_("Caret Annotation", "The PDF contains a Caret annotation", 0, false, "Caret", "Caret");
            AnnotationInk = new od_("Ink Annotation", "The PDF contains an Ink annotation", 0, false, "Ink", "Ink");
            AnnotationPopup = new od_("Popup Annotation", "The PDF contains a Popup annotation", 0, false, "Popup", "Popup");
            AnnotationFile = new od_("FileAttachment Annotation ", "The PDF contains a FileAttachment annotation", 0, false, "FileAttachment", "FileAttachment");
            AnnotationWidget = new Feature("Widget Annotation", "The PDF contains a Widget annotation", 0, false);
            AnnotationScreen = new od_("Screen Annotation", "The PDF contains a Screen annotation", 0, false, "Screen", "Screen");
            AnnotationPrinterMark = new od_("PrinterMark Annotation", "The PDF contains a PrinterMark annotation", 0, false, "PrinterMark", "PrinterMark");
            AnnotationTrapNet = new od_("TrapNet Annotation", "The PDF contains a TrapNet annotation", 0, false, "TrapNet", "TrapNet");
            AnnotationWatermark = new od_("Watermark Annotation", "The PDF contains a Watermark annotation", 0, false, "Watermark", "Watermark");
            Annotation3D = new od_("3D Annotation", "The PDF contains a 3D annotation", 0, false, "3D", "3D");
            AnnotationProjection = new od_("Projection Annotation", "The PDF contains a Projection annotation", 0, false, "Projection", "Projection");
            AnnotationRichMedia = new od_("RichMedia Annotation", "The PDF contains a RichMedia annotation", 0, false, "RichMedia", "RichMedia");
            AnnotationUnknown = new od_("Unknown Annotation", "The PDF contains an annotation type that is not defined in the PDF specification", 0, false, "Unknown", "Unknown");
            BadTrapNetAnnotation = new Feature("TrapNet Annotation not OK for PDF/X", "The PDF contains a TrapNet annotation which is invalid for PDF/X", 0, false);
            AnnotationTransparency = new Feature("Annotation Transparency", "The PDF contains annotations that are possibly translucent", 4, false);
            TransparencyGroup = new Feature("Transparency Group", "The PDF contains a Transparency Group", 4, false);
            AnnotationPrintFlagNotSet = new Feature("Annotation Print flag not set", "The PDF contains an annotation that is displays on screen but will not print", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    int n2 = pDF.getNumberOfPages();
                    int n3 = 0;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        PDFPage pDFPage = pDF.getPage(i2);
                        List list = pDFPage.getAnnotations();
                        for (int i3 = 0; i3 < list.size(); ++i3) {
                            PDFAnnotation pDFAnnotation = (PDFAnnotation)list.get(i3);
                            if (pDFAnnotation.b(3)) continue;
                            pDFAnnotation.a(3, true);
                            ++n3;
                        }
                    }
                    return n3 + " annotation(s) PrintFlag were set";
                }
            };
            AnnotationHiddenFlagSet = new Feature("Annotation Hidden flag is set", "The PDF contains an annotaiton that appears in print but not on screen", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    int n2 = pDF.getNumberOfPages();
                    int n3 = 0;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        PDFPage pDFPage = pDF.getPage(i2);
                        List list = pDFPage.getAnnotations();
                        for (int i3 = 0; i3 < list.size(); ++i3) {
                            PDFAnnotation pDFAnnotation = (PDFAnnotation)list.get(i3);
                            if (!pDFAnnotation.b(2)) continue;
                            pDFAnnotation.a(2, false);
                            ++n3;
                        }
                    }
                    return n3 + " annotation(s) HiddenFlag were turned off";
                }
            };
            AnnotationInvisibleFlagSet = new Feature("Annotation Invisible flag is set", "The PDF contains an Annotation that has been marked as invisible", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    int n2 = pDF.getNumberOfPages();
                    int n3 = 0;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        PDFPage pDFPage = pDF.getPage(i2);
                        List list = pDFPage.getAnnotations();
                        for (int i3 = 0; i3 < list.size(); ++i3) {
                            PDFAnnotation pDFAnnotation = (PDFAnnotation)list.get(i3);
                            if (!pDFAnnotation.b(1)) continue;
                            pDFAnnotation.a(1, false);
                            ++n3;
                        }
                    }
                    return n3 + " annotation(s) InvisibleFlag were turned off";
                }
            };
            AnnotationNoViewFlagSet = new Feature("Annoation NoView flag set", "The PDF contains an annotation with the NoView flag set", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    int n2 = pDF.getNumberOfPages();
                    int n3 = 0;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        PDFPage pDFPage = pDF.getPage(i2);
                        List list = pDFPage.getAnnotations();
                        for (int i3 = 0; i3 < list.size(); ++i3) {
                            PDFAnnotation pDFAnnotation = (PDFAnnotation)list.get(i3);
                            if (!pDFAnnotation.b(6)) continue;
                            pDFAnnotation.a(6, false);
                            ++n3;
                        }
                    }
                    return n3 + " annotation(s) NoViewFlag were turned off";
                }
            };
            AnnotationTextNoZoomFlagNotSet = new Feature("Text Annotation NoZoom flag not set", "The PDF contains a Text annotation that zooms to match the page size", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    int n2 = pDF.getNumberOfPages();
                    int n3 = 0;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        PDFPage pDFPage = pDF.getPage(i2);
                        List list = pDFPage.getAnnotations();
                        for (int i3 = 0; i3 < list.size(); ++i3) {
                            PDFAnnotation pDFAnnotation = (PDFAnnotation)list.get(i3);
                            if (!(pDFAnnotation instanceof AnnotationText)) continue;
                            if (pDFAnnotation.b(4)) continue;
                            pDFAnnotation.a(4, true);
                            ++n3;
                        }
                    }
                    return n3 + " text annotation(s) NoZoomFlag were set";
                }
            };
            AnnotationTextNoRotateFlagNotSet = new Feature("Text Annotation NoRotate flag not set", "The PDF contains a Text annotation that rotates to match the page", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    int n2 = pDF.getNumberOfPages();
                    int n3 = 0;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        PDFPage pDFPage = pDF.getPage(i2);
                        List list = pDFPage.getAnnotations();
                        for (int i3 = 0; i3 < list.size(); ++i3) {
                            PDFAnnotation pDFAnnotation = (PDFAnnotation)list.get(i3);
                            if (!(pDFAnnotation instanceof AnnotationText)) continue;
                            if (pDFAnnotation.b(5)) continue;
                            pDFAnnotation.a(5, true);
                            ++n3;
                        }
                    }
                    return n3 + " text annotation(s) NoRotateFlag were set";
                }
            };
            AnnotationWithUnpredictableAppearance = new Feature("Annotation appearance is unpredictable", "The PDF contains an annotation with multiple appearance streams, or that is missing the required 'N' stream", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    int n2 = pDF.getNumberOfPages();
                    int n3 = 0;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        PDFPage pDFPage = pDF.getPage(i2);
                        List list = pDFPage.getAnnotations();
                        for (int i3 = 0; i3 < list.size(); ++i3) {
                            PDFAnnotation pDFAnnotation = (PDFAnnotation)list.get(i3);
                            ic ic2 = pDFAnnotation.j("AP");
                            if (ic2 == null) continue;
                            Object[] objectArray = ic2.q().toArray();
                            if (objectArray.length > 1) {
                                ++n3;
                                for (int i4 = 0; i4 < objectArray.length; ++i4) {
                                    String string = (String)objectArray[i4];
                                    if (string.equals("N")) continue;
                                    ic2.e(string);
                                }
                            }
                            if (ic2.o() == 1) continue;
                            return super.c(pDF, outputProfile);
                        }
                    }
                    return n3 + " annotation(s) had appearance streams removed";
                }
            };
            FreeFormLink = new Feature("Non-rectangular Link annotations", "The PDF contains a Link annotation that is not rectangular", 0, false);
            EmbeddedFiles = new Feature("Embedded Files", "The PDF contains an embedded file, embedded either directly in the PDF or as an Annotation", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    if (pDF.j("Root").f("Names")) {
                        pDF.j("Root").j("Names").e("EmbeddedFiles");
                    }
                    int n2 = pDF.getNumberOfPages();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        PDFPage pDFPage = pDF.getPage(i2);
                        List list = pDFPage.getAnnotations();
                        for (int i3 = 0; i3 < list.size(); ++i3) {
                            if (!(list.get(i3) instanceof AnnotationFile)) continue;
                            list.remove(i3--);
                        }
                    }
                    return "All Embedded files were removed";
                }
            };
            MissingTrimAndArtBox = new Feature("TrimBox/ArtBox is missing", "The PDF is missing both the Art and Trim boxes. This is not allowed in PDF/X", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    int n2 = pDF.getNumberOfPages();
                    int n3 = 0;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        PDFPage pDFPage = pDF.getPage(i2);
                        if (pDFPage.getBox("Trim") != null || pDFPage.getBox("Art") != null) continue;
                        float[] fArray = pDFPage.getBox("Crop");
                        if (fArray == null) {
                            fArray = pDFPage.getBox("Media");
                        }
                        pDFPage.setBox("Trim", fArray[0], fArray[1], fArray[2], fArray[3]);
                        ++n3;
                    }
                    return "TrimBox was created to match Crop or Media Box on " + n3 + " page(s)";
                }
            };
            BothTrimAndArtBox = new Feature("Both ArtBox/TrimBox specified", "The PDF has both the Art and Trim boxes specified. This is not allowed under PDF/X", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    int n2 = pDF.getNumberOfPages();
                    int n3 = 0;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        PDFPage pDFPage = pDF.getPage(i2);
                        if (pDFPage.getBox("Art") == null || pDFPage.getBox("Trim") == null) continue;
                        pDFPage.setBox("Art", 0.0f, 0.0f, 0.0f, 0.0f);
                        ++n3;
                    }
                    return "ArtBox was removed on " + n3 + " page(s)";
                }
            };
            OptionalContent = new Feature("Optional Content", "The PDF has Optional content, which is not allowed under PDF/X or PDF/A", 5, false){};
            BadBoxNesting = new Feature("PageBoxes not nested properly", "The PDF contains a page where the box nesting order is invalid", 0, false);
            PageTemplates = new Feature("Page Templates", "The PDF has named 'Template' pages", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    pDF.j("Root").j("Names").e("Templates");
                    return "Page Templates were removed";
                }
            };
            FilterFlate = new Feature("Flate Compression used", "The PDF contains data compressed with the Flate compression algorithm", 0, false);
            FilterCCITT = new Feature("CCITT Compression used", "The PDF contains data (always 1-bit image data) compressed with the CCITT compression algorithm", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) throws UnsupportedOperationException {
                    int n2 = 0;
                    Iterator iterator = pDF.t().j();
                    while (iterator.hasNext()) {
                        yd.b_ b_2 = (yd.b_)iterator.next();
                        gc gc2 = b_2.i();
                        if (!(gc2 instanceof sc)) continue;
                        for (int i2 = sc.b(((sc)gc2).h("Filter")); i2 > 0; i2 /= 16) {
                            int n3 = i2 & 0xF;
                            if (n3 != 2) continue;
                            ((sc)gc2).b(wc.b("FlateDecode"));
                            ++n2;
                            continue;
                        }
                    }
                    return n2 + " CCITT streams were recompressed with Flate";
                }
            };
            FilterASCII85 = new Feature("ASCII85 Filter used", "The PDF contains ASCII85 encoded data", 0, false);
            FilterASCIIHex = new Feature("ASCIIHEX Filter used", "The PDF contains ASCIIHex encoded data", 0, false);
            FilterRLE = new Feature("RunLength Compression used", "The PDF contains Run-Length compressed data", 0, false);
            FilterLZW = new Feature("LZW Compression used", "The PDF contains LZW compressed data. This is not supported by some workflows and should be replaced by Flate where possible", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) throws UnsupportedOperationException {
                    int n2 = 0;
                    Iterator iterator = pDF.t().j();
                    while (iterator.hasNext()) {
                        yd.b_ b_2 = (yd.b_)iterator.next();
                        gc gc2 = b_2.i();
                        if (!(gc2 instanceof sc)) continue;
                        for (int i2 = sc.b(((sc)gc2).h("Filter")); i2 > 0; i2 /= 16) {
                            int n3 = i2 & 0xF;
                            if (n3 != 6) continue;
                            ((sc)gc2).b(wc.b("FlateDecode"));
                            ++n2;
                            continue;
                        }
                    }
                    return n2 + " LZW streams were recompressed with Flate";
                }
            };
            FilterInlineFlate = new Feature("Flate Compression used in inline image", "The PDF contains inline image data compressed with the Flate compression algorithm", 0, false);
            FilterInlineCCITT = new Feature("CCITT Compression used in inline image", "The PDF contains 1-bit inline image data compressed with the CCITT compression algorithm", 0, false);
            FilterInlineASCII85 = new Feature("ASCII85 encoding used in inline image", "The PDF contains inline image data encoded with the ASCII85 algorithm", 0, false);
            FilterInlineASCIIHex = new Feature("ASCIIHex encoding used in inline image", "The PDF contains inline image data encoded with ASCIIHex algorithm", 0, false);
            FilterInlineRLE = new Feature("Run-Length Encoding used in inline image", "The PDF contains run-length encoded inline image data", 0, false);
            FilterInlineLZW = new Feature("LZW Compression used in inline image", "The PDF contains LZW compressed inline image data.", 0, false);
            FilterInlineDCT = new Feature("JPEG Compression used in inline image", "The PDF contains JPEG (DCT) compressed inline image data.", 0, false);
            FFilter = new Feature("External File Reference", "The PDF contains streams with an external File Reference, not allowed by PDF/A", 0, false);
            FilterDCT = new Feature("JPEG Compression used", "The PDF contains images compressed with the DCT (JPEG) compression", 0, false);
            FilterJPX = new Feature("JPX Compression", "The PDF contains images compressed with JPEG-2000 compression", 5, false){

                String c(PDF pDF, OutputProfile outputProfile) throws UnsupportedOperationException {
                    int n2 = 0;
                    Iterator iterator = pDF.t().j();
                    while (iterator.hasNext()) {
                        yd.b_ b_2 = (yd.b_)iterator.next();
                        gc gc2 = b_2.i();
                        if (!(gc2 instanceof sc)) continue;
                        for (int i2 = sc.b(((sc)gc2).h("Filter")); i2 > 0; i2 /= 16) {
                            int n3 = i2 & 0xF;
                            if (n3 != 9) continue;
                            ((sc)gc2).b(wc.b("FlateDecode"));
                            ++n2;
                            continue;
                        }
                    }
                    return n2 + " JPX streams were recompressed with Flate";
                }
            };
            FilterJBIG2 = new Feature("JBIG2 Compression used", "The PDF contains 1-bit images compressed with JBIG2 compression", 4, false){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                private int a(hc hc2, Set set, boolean bl, sb sb2) throws IOException {
                    ic ic2;
                    ic ic3;
                    int n2 = 0;
                    int n3 = 0;
                    if (set.add(hc2) && (ic3 = (ic2 = hc2 instanceof PDFPage ? ((PDFPage)hc2).u() : hc2.j("Resources")).j("XObject")) != null) {
                        Iterator iterator = ic3.j();
                        while (iterator.hasNext()) {
                            int n4;
                            gc gc2 = (gc)iterator.next();
                            if (!(gc2 instanceof sc)) continue;
                            sc sc2 = (sc)gc2;
                            int n5 = sc.b(sc2.h("Filter"));
                            if (n5 == 2) {
                                int n6 = n4 = sc2.n() == null || sc2.n().t().b(sc2) == null ? 1 : 0;
                                if (n4 == 0 && !bl) continue;
                                if (n4 == 0) {
                                    ++n2;
                                }
                                ++n3;
                                sb2.a(sc2);
                                continue;
                            }
                            n4 = this.a(sc2, set, bl, sb2);
                            n3 += n4 & 0xFFFF;
                            n2 += n4 >> 16 & 0xFFFF;
                        }
                    }
                    return (n2 << 16) + n3;
                }

                String d(PDF pDF, OutputProfile outputProfile) throws UnsupportedOperationException {
                    if (sb.a()) {
                        boolean bl = outputProfile.isRequired(RegularCompression);
                        try {
                            sb sb2 = new sb();
                            int n2 = 0;
                            int n3 = 0;
                            List list = pDF.getPages();
                            HashSet hashSet = new HashSet();
                            for (int i2 = 0; i2 < list.size(); ++i2) {
                                PDFPage pDFPage = pDF.getPage(i2);
                                int n4 = this.a(pDFPage, hashSet, bl, sb2);
                                n3 += n4 & 0xFFFF;
                                n2 += n4 >> 16 & 0xFFFF;
                            }
                            sb2.b();
                            if (n2 != 0) {
                                return n2 + " CCITT streams were recompressed with JBIG2";
                            }
                            return null;
                        }
                        catch (Exception exception) {
                            return "Failed: " + exception.getMessage();
                        }
                    }
                    return null;
                }

                String c(PDF pDF, OutputProfile outputProfile) throws UnsupportedOperationException {
                    int n2 = 0;
                    Iterator iterator = pDF.t().j();
                    while (iterator.hasNext()) {
                        yd.b_ b_2 = (yd.b_)iterator.next();
                        gc gc2 = b_2.i();
                        if (!(gc2 instanceof sc)) continue;
                        for (int i2 = sc.b(((sc)gc2).h("Filter")); i2 > 0; i2 /= 16) {
                            int n3 = i2 & 0xF;
                            if (n3 != 10) continue;
                            ((sc)gc2).b(wc.b("CCITTFaxDecode"));
                            ++n2;
                            continue;
                        }
                    }
                    return n2 + " JBIG2 streams were recompressed with CCITT";
                }
            };
            FilterNoneOnLargeStream = new Feature("Uncompressed Stream > 400 bytes", "The PDF contains large amounts of uncompressed data, and could benefit from recompression", 0, false);
            ImageDepth1 = new Feature("1-bit Images", "The PDF contains 1-bit images", 0, false);
            ImageDepth2 = new Feature("2-bit Images", "The PDF ciobntains 2-bit images", 0, false);
            ImageDepth4 = new Feature("4-bit Images", "The PDF contains 4-bit images", 0, false);
            ImageDepth8 = new Feature("8-bit Images", "The PDF contains 8-bit images", 0, false);
            ImageDepth16 = new Feature("16-Bit Images", "The PDF contains 16-bit images", 5, false);
            ImageTransparency = new Feature("Image Transparency", "The PDF contains images that make use of alpha transparency", 4, false);
            ComplexBlendMode = new Feature("Complex Blend Mode", "The PDF contains images that make use of complex blend mode functions", 4, false);
            CMYKJPEG = new Feature("CMYK JPEG", "The PDF contains a DCT (JPEG) encoded image in the CMYK colorspace. This can cause problems with some older versions of Java", 0, false);
            FullPageImage = new Feature("FullPageImage", "The PDF contains an image that covers an entire page", 0, false);
            Encryption = new Feature("Encryption", "The PDF is encrypted", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    pDF.setEncryptionHandler(null);
                    return "Encryption disabled";
                }
            };
            Acrobat5Encryption = new Feature("128-Bit Encryption", "The PDF is encrypted using 128-bit RC4 encryption and requires Acrobat 5.0 or later to open", 4, true);
            Acrobat6Encryption = new Feature("Acrobat 6.0 Encryption", "The PDF is encrypted using 128-bit RC4 encryption and requires Acrobat 6.0 or later to open", 5, true);
            AESEncryption = new Feature("AES Encryption", "The PDF is encrypted using AES encryption and requires Acrobat 7.0 or later to open", 6, true);
            WeakAES256Encryption = new Feature("Weak AES-256 Encryption", "The PDF is encrypted using AES encryption with a keylength of 256 bits but using a weak hash algorithm, available only in Acrobat 9. It requires Acrobat 9.0 or later to open", 8, true);
            AES256Encryption = new Feature("AES-256 Encryption", "The PDF is encrypted using AES encryption with a keylength of 256 bits, and requires Acrobat X or later to open", 10, true);
            PublicKeyEncryption = new Feature("Public Key Encryption", "The PDF is encrypted using Public Key encryption and can only be opened by recipients with the matching private key", 4, true);
            NonStandardEncryption = new Feature("Non-standard Encryption", "The PDF is encrypted using an Encryption handler not recognised by the PDF library", 0, true);
            ColorSpaceICC = new Feature("ICC ColorSpace", "The PDF contains path operations or images using an embedded ICC colorspace", 0, false);
            ICCProfileVersion4 = new Feature("ICC Profile version 4", "The PDF contains path operations or images using an embedded ICC version 4 colorspace", 0, false);
            ICCProfileVersion3 = new Feature("ICC Profile version 3", "The PDF contains path operations or images using an embedded ICC version 3 colorspace", 0, false);
            ICCProfileVersion2 = new Feature("ICC Profile version 2", "The PDF contains path operations or images using an embedded ICC version 2 colorspace", 0, false);
            ICCProfileVersion1 = new Feature("ICC Profile version 1", "The PDF contains path operations or images using an embedded ICC version 1 colorspace", 0, false);
            ICCProfileNotOutput = new Feature("OutputIntent ICC Profile not of class Output", "The PDF OutputIntent contains an ICC profile which is not an Output profile (class=prtr)", 0, true);
            ICCProfileBadColorComponentCount = new Feature("Wrong number of components in ICC color profile", "The number of color components in the ICC color profile descriptor does not match the number of components in the ICC profile data", 0, false);
            ColorSpaceDeviceGray = new Feature("DeviceGray ColorSpace", "The PDF contains path operations or images in the device-dependent Gray colorspace", 0, false){

                void b(OutputProfile outputProfile) {
                    outputProfile.checkColorMatchesOutputIntent(1, this);
                }
            };
            ColorSpaceDeviceRGB = new Feature("DeviceRGB ColorSpace", "The PDF contains path operations or images in the device-dependent RGB colorspace", 0, false){

                void b(OutputProfile outputProfile) {
                    outputProfile.checkColorMatchesOutputIntent(3, this);
                }
            };
            ColorSpaceDeviceCMYK = new Feature("DeviceCMYK ColorSpace", "The PDF contains path operations or images in the device-dependent CMYK colorspace", 0, false){

                void b(OutputProfile outputProfile) {
                    outputProfile.checkColorMatchesOutputIntent(4, this);
                }
            };
            ColorSpaceCalGray = new Feature("Calibrated Gray ColorSpace", "The PDF contains path operations or images in a calibrated grayscale colorspace", 0, false);
            ColorSpaceCalRGB = new Feature("Calibrated RGB ColorSpace", "The PDF contains path operations or images in a calibrated RGB colorspace", 0, false);
            ColorSpaceDeviceN = new Feature("Device-N ColorSpace", "The PDF contains path operations or images in a Device-N colorspace", 0, false);
            ColorSpaceSeparation = new Feature("Separation ColorSpace", "The PDF contains path operations or images in a \"separation\" or \"spot\" colorspace", 0, false);
            ColorSpaceIndexed = new Feature("Indexed ColorSpace", "The PDF contains path operations or images that use an index into another colorspace", 0, false);
            ColorSpaceLab = new Feature("L*a*b* ColorSpace", "The PDF contains path operations or images that use a L*a*b colorspace", 0, false);
            ColorSpacePattern = new Feature("Patterns", "The PDF contains path operations that use a pattern", 0, false);
            AltColorSpaceDeviceGray = new Feature("DeviceGray Alternate Colorspace", "The PDF contains a separation colorspace that uses device-dependent gray as an alternate space", 0, false){

                void b(OutputProfile outputProfile) {
                    outputProfile.checkColorMatchesOutputIntent(1, this);
                }
            };
            AltColorSpaceDeviceRGB = new Feature("DeviceRGB Alternate Colorspace", "The PDF contains a separation colorspace that uses device-dependent RGB as an alternate space", 0, false){

                void b(OutputProfile outputProfile) {
                    outputProfile.checkColorMatchesOutputIntent(3, this);
                }
            };
            AltColorSpaceDeviceCMYK = new Feature("DeviceCMYK Alternate Colorspace", "The PDF contains a separation colorspace that uses device-dependent CMYK as an alternate space", 0, false){

                void b(OutputProfile outputProfile) {
                    outputProfile.checkColorMatchesOutputIntent(4, this);
                }
            };
            AltColorSpaceCalRGB = new Feature("Calbrated RGB Alternate Colorspace", "The PDF contains a separation colorspace that uses a calibrated RGB colorspace as an alternate", 0, false);
            AltColorSpaceCalGray = new Feature("Calbrated Grayscale Alternate Colorspace", "The PDF contains a separation colorspace that uses a calibrated grayscale colorspace as an alternate", 0, false);
            AltColorSpaceLab = new Feature("L*a*b* Alternate Colorspace", "The PDF contains a separation colorspace that uses a L*a*b colorspace as an alternate", 0, false);
            AltColorSpaceICC = new Feature("ICC Alternate Colorspace", "The PDF contains a separation colorspace that uses an ICC profile based colorspace as an alternate", 0, false);
            RedGreenBlueSeparation = new Feature("Red/Green/Blue Separation Color", "The PDF contains a separation colorspace where the ink is called either \"Red\", \"Green\" or \"Blue\"", 0, false);
            CyanSeparation = new Feature("Cyan Separation Color", "The PDF contains a separation colorspace where the ink is called \"Cyan\"", 0, false);
            MagentaSeparation = new Feature("Magenta Separation Color", "The PDF contains a separation colorspace where the ink is called \"Magenta\"", 0, false);
            YellowSeparation = new Feature("Yellow Separation Color", "The PDF contains a separation colorspace where the ink is called \"Yellow\"", 0, false);
            BlackSeparation = new Feature("Black Separation Color", "The PDF contains a separation colorpsace where the ink is called \"Black\"", 0, false);
            r = new Feature("Annotation contains a color defined in the transparent color space", 0, false);
            s = new Feature("Annotation contains C color in the DeviceGray ColorSpace", 0, false){

                void b(OutputProfile outputProfile) {
                    outputProfile.checkColorMatchesOutputIntent(1, this);
                }
            };
            t = new Feature("Annotation contains C or IC color in the DeviceRGB ColorSpace", 0, false){

                void b(OutputProfile outputProfile) {
                    outputProfile.checkColorMatchesOutputIntent(3, this);
                }
            };
            u = new Feature("Annotation contains C color in the DeviceCMYK ColorSpace", 0, false){

                void b(OutputProfile outputProfile) {
                    outputProfile.checkColorMatchesOutputIntent(4, this);
                }
            };
            DeviceGrayWithRGBIntent = new Feature("Device Gray color used with RGB Output Intent", "The PDF contains a Device Gray Color but an RGB Output Intent", 0, false);
            DeviceGrayWithCMYKIntent = new Feature("Device Gray color used with CMYK Output Intent", "The PDF contains a Device Gray Color but a CMYK Output Intent", 0, false);
            DeviceRGBWithGrayIntent = new Feature("Device RGB color used with Grayscale Output Intent", "The PDF contains a Device RGB Color and a Grayscale Output Intent", 0, false);
            DeviceRGBWithCMYKIntent = new Feature("Device RGB color used with CMYK Output Intent", "The PDF contains a Device RGB Color and a CMYK Output Intent", 0, false);
            DeviceCMYKWithGrayIntent = new Feature("Device CMYK color used with Grayscale Output Intent", "The PDF contains a Device CMYK Color and a Grayscale Output Intent", 0, false);
            DeviceCMYKWithRGBIntent = new Feature("Device CMYK color used with RGB Output Intent", "The PDF contains a Device CMYK Color and an RGB Output Intent", 0, false);
            AnnotationColorMismatchesIntent = new Feature("Annotation Color doesn't match Output Intent", "The PDF contains an Annotation that specifies a device color which doesn't match the OutputIntent", 0, false);
            v = new Feature("Device-dependent Color", "The PDF contains device-dependent Color", 0, false);
            FontStandard14 = new Feature("Standard Font", "The PDF contains one of the standard 14 fonts", 0, false);
            FontCompactEmbedded = new Feature("Embedded Compact Font", "The PDF contains an embedded Compact Type 1 Font", 0, false);
            FontType1Embedded = new Feature("Embedded Type 1 Font", "The PDF contains an embedded old-style Type 1 Font", 0, false);
            FontTrueTypeEmbedded = new Feature("Embedded TrueType Font", "The PDF contains an embedded TrueType font", 0, false);
            FontOpenTypeEmbedded = new Feature("Embedded OpenType Font", "The PDF contains an embedded OpenType font", 0, false);
            FontType3 = new Feature("Type 3 Font", "The PDF contains a Type 3 font", 0, false);
            FontMultipleMaster = new Feature("Multiple Master Font", "The PDF contains a Multiple Master font", 0, false);
            FontType1Unembedded = new Feature("Unembedded Type 1 Font", "The PDF contains an unembedded Type 1 font. Rendering problems may occur if the same font is not available on the viewing platform", 0, false);
            FontTrueTypeUnembedded = new Feature("Unembedded TrueType Font", "The PDF contains an unembedded TrueType font. Rendering problems may occur if the same font is not available on the viewing platform", 0, false);
            w = new Feature("Type 1 Font without ToUnicode", "The PDF contains a Type 1 font without any mapping to Unicode. Text extraction may not be possible", 0, false);
            FontType0 = new Feature("CID Font", "The PDF contains a CID (Type 0) font", 0, false);
            CIDFontType1Embedded = new Feature("Embedded Type 1 CID Font", "The PDF contains an embedded Type 1 CID font", 0, false);
            CIDSystemInfoAndCMapNotCompatible = new Feature("CIDFont without compatible CMap", "The PDF contains an embedded CID Font which has a CMap that doesn't match that contained in the PDF", 0, false);
            UnembeddedCMap = new Feature("CIDFont with an unembedded CMap", "The PDF contains an CID Font with an unembedded CMap", 0, false);
            CIDFontType1Unembedded = new Feature("Unembedded Type 1 CID Font", "The PDF contains an unembedded Type 1 CID font. Rendering problems may occur if the same font is not available on the viewing platform", 0, false);
            CIDFontTrueTypeEmbedded = new Feature("Embedded TrueType CID Font", "The PDF contains en embedded TrueType CID font", 0, false);
            CIDFontTrueTypeUnembedded = new Feature("Unembedded TrueType CID Font", "The PDF contains an unembedded TrueType CID font. Rendering problems may occur if the same font is not available on the viewing platform", 0, false);
            CIDFontCompactEmbedded = new Feature("Embedded Compact CID Font", "The PDF contains an embedded Compact Type 1 CID Font", 0, false);
            CIDFontOpenTypeEmbedded = new Feature("Embedded OpenType CID Font", "The PDF contains an embedded OpenType CID font", 0, false);
            FontEmbeddingRestrictions = new Feature("Font with Embedding restrictions", "The PDF contains an embedded Font that has legal restrictions on embedding", 0, false);
            CMapEmbeddedWithInvalidWMode = new Feature("Embedded CMap without identical WMode", "The PDF contains a CMap that has a non identical WMode entry. This isn't allowed under PDF/A", 0, false);
            FontType1SubsetWithoutCharset = new Feature("Type1 subset without defined Charset", "The PDF contains an embedded Type 1 font without a CharSet string. This is not allowed in PDF/A", 0, false);
            FontWidthsNotConsistent = new Feature("Font with inconsistent widths", "The PDF contains a font where the internal widths do not match those specified in the PDF. This is sometimes used to stretch glyphs, but is not allowed in PDF/A", 0, false);
            NonSymbolicTrueTypeWithoutMacRomanOrWinAnsiEncoding = new Feature("Non-Symbolic TrueType without MacRoman or WinAnsi Encoding", "The PDF contains a TrueType font that is marked as NonSymbolic, but that doesn't use the MacRoman or WinAnsi encoding. This leads to ambiguity and is not allowed in PDF/A", 0, false);
            SymbolicTrueTypeWithEncodingEntry = new Feature("Symbolic TrueType font with an Encoding specified", "The PDF contains a TrueType font that is marked as Synmbolic and also specifies an encoding. This is not allowed under PDF/A", 0, false);
            SymbolicTrueTypeWithoutOneEncoding = new Feature("Symbolic TrueType CMap contains multiple Encodings", "The PDF contains a TrueType font that contains multiple encodings, which is not allowed in PDF/A", 0, false);
            CIDFontSubsetWithoutCIDSet = new Feature("Subset CID Font missing CIDSet stream", "The PDF contains a subset CID font which is missing the recommended CIDSet stream. This is not allowed under PDF/A", 0, false){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                String c(PDF pDF, OutputProfile outputProfile) {
                    int n2 = 0;
                    Iterator iterator = outputProfile.getFontInfo().iterator();
                    while (iterator.hasNext()) {
                        oc oc2;
                        FontInfo fontInfo = (FontInfo)iterator.next();
                        if (!(fontInfo.a() instanceof oc) || !(oc2 = (oc)fontInfo.a()).E() || !oc2.w() || oc2.I().f("CIDSet")) continue;
                        sc sc2 = new sc();
                        y y2 = new y(sc2);
                        try {
                            y2.write(oc2.P());
                            y2.complete();
                            oc2.I().b("CIDSet", sc2);
                            ++n2;
                        }
                        finally {
                            y2.close();
                        }
                    }
                    return "Added " + n2 + " CIDSet structures";
                }
            };
            UTF16Encoding = new Feature("UTF16 Encoding", "The PDF contains an embedded font that requires UTF-16 encoding to access character outside the Basic Multilingual Plane", 5, false);
            FontWithMissingGlyphs = new Feature("Font without all required glyphs", "The PDF contains a Font that is missing some of the glyphs referenced in the PDF. This is not allowed under PDF/A, and the document may not render correctly", 0, false);
            InvalidFont = new Feature("Font is damaged or invalid", "Font is damaged or invalid. THis is not allowed under PDF/A, and the document may not render correctly", 0, false);
            FontWithoutMetadata = new Feature("Font is missing Metadata entry", "The PDF contains a font without any XMP MetaData. This metadata is required by the PDF/A specification, although this requirement is ignored by Acrobat", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    List list = pDF.getPages();
                    int n2 = 0;
                    HashSet hashSet = new HashSet();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        PDFPage pDFPage = (PDFPage)iterator.next();
                        n2 += this.a(pDFPage.u(), hashSet);
                    }
                    return n2 + " font(s) had Metadata created";
                }

                private int a(ic ic2, Set set) {
                    int n2 = 0;
                    if (set.add(ic2)) {
                        Object object;
                        Object object2;
                        ic ic3 = ic2.j("Font");
                        if (ic3 != null) {
                            object2 = ic3.j();
                            while (object2.hasNext()) {
                                object = (PDFFont)object2.next();
                            }
                        }
                        if ((object2 = ic2.j("XObject")) != null) {
                            object = ((hc)object2).j();
                            while (object.hasNext()) {
                                ic ic4 = (ic)object.next();
                                if (ic4.j("Resources") == null) continue;
                                n2 += this.a(ic4.j("Resources"), set);
                            }
                        }
                    }
                    return n2;
                }
            };
            CIDFontTrueTypeWithoutCIDToGIDMap = new Feature("TrueType has no CIDToGIDMap", "The PDF contains a CID TrueType Font without a CID to GID map. This map is required for PDF/A Compatibility", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    List list = pDF.getPages();
                    int n2 = 0;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        PDFPage pDFPage = (PDFPage)iterator.next();
                        ic ic2 = pDFPage.u().j("Font");
                        Iterator iterator2 = ic2.j();
                        while (iterator2.hasNext()) {
                            ic ic3;
                            ic ic4 = (ic)iterator2.next();
                            wc wc2 = ic4.i("Subtype");
                            if (!wc2.d("Type0") || !(wc2 = (ic3 = ic4.k("DescendantFonts").f(0)).i("Subtype")).d("CIDFontType2")) continue;
                            ic3.b("CIDToGIDMap", wc.b("Identity"));
                            ++n2;
                        }
                    }
                    return n2 + " CIDTrueType Font(s) CIDToGIDMap were set to Identity";
                }
            };
            Transparency = new Feature("Transparency", "The PDF contains path operations that use a translucent color", 4, false);
            BXEXOperator = new Feature("BX/EX used in Stream", "The PDF contains a stream including the BX/EX operators, which are used to mark sections of the page that may not display in all viewers", 0, false);
            InlineImage = new Feature("Inline Image", "The PDF contains a stream including Inline Images. These are sometimes used for Type 3 fonts but can be troublesome", 0, false);
            Hairline = new Feature("Hairline", "The PDF contains a stream including a hairline (defined as a line with a thickness of less thatn 0.2pt). It may not display correctly on all output devices", 0, false);
            ZeroWidthLine = new Feature("Zero-width line", "The PDF contains a stream including a line of zero-width. The display of these lines is device-dependent", 0, false);
            ShadingPattern = new Feature("Shading Pattern", "The PDF contains a shading pattern", 0, false);
            PostScriptXObject = new Feature("PostScript XObject", "The PDF contains a PostScript XObject, which is not supported by many viewers", 0, false);
            ReferenceXObject = new Feature("Reference XObject", "The PDF contains a Reference XObject, which is not supported by many viewers", 0, false);
            HalftoneName = new Feature("Halftone Name Object", "The PDF contains a named HalfTone pattern", 0, false);
            HalftoneNot1or5 = new Feature("Halftone Type not 1 or 5", "The PDF contains a HalfTone pattern type that isn't Type 1 or 5", 0, false);
            TransferFunctionIsIdentity = new Feature("Transfer Function = Identity", "The PDF contains Transfer Function that is set to Identity", 0, false);
            TransferFunctionIsDefault = new Feature("Transfer Function = Default", "The PDF contains a Transfer Function that is set to \"Default\", which although the default value is not allowed in the PDF/X specification", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    int n2 = 0;
                    HashSet hashSet = new HashSet();
                    for (int i2 = 0; i2 < pDF.getPages().size(); ++i2) {
                        PDFPage pDFPage = pDF.getPage(i2);
                        n2 += this.a(pDFPage.u(), hashSet);
                    }
                    return "Removed \"Default\" TR from " + n2 + " page(s) and/or XObject(s)";
                }

                private int a(ic ic2, Set set) {
                    int n2 = 0;
                    if (set.add(ic2)) {
                        gc gc2;
                        Object object;
                        Object object2;
                        ic ic3 = ic2.j("ExtGState");
                        if (ic3 != null) {
                            object2 = ic3.j();
                            while (object2.hasNext()) {
                                object = (ic)object2.next();
                                gc2 = ((hc)object).h("TR2");
                                if (!(gc2 instanceof wc) || !((wc)gc2).d("Default")) continue;
                                ((hc)object).e("TR2");
                                ++n2;
                            }
                        }
                        if ((object2 = ic2.j("XObject")) != null) {
                            object = ((hc)object2).j();
                            while (object.hasNext()) {
                                gc2 = (sc)object.next();
                                wc wc2 = ((hc)gc2).i("Subtype");
                                if (wc2 == null || !wc2.d("Form")) continue;
                                n2 += this.a(((hc)gc2).j("Resources"), set);
                            }
                        }
                    }
                    return n2;
                }
            };
            TransferFunctionIsOther = new Feature("Transfer Function != Identity", "The PDF contains a Transfer Function that is not Default or Identity. This may cause problems in some print workflows", 0, false);
            TransferFunction = new Feature("Transfer Function", "The PDF sets a Transfer Function, which allows color components to be modified for nonlinear response in an output device and in the human eye. It's use typically causes problems in PDF/X and PDF/A workflows", 0, false);
            OPI = new Feature("XObject contains OPI comments", "The PDF contains Open Prepress Interface comments", 0, false);
            RenderingIntent = new Feature("Rendering Intent", "The PDF contains operations to set the Rendering Intent", 0, false);
            AlternateImagePrints = new Feature("Alternate Image Prints", "The PDF specifies that an alternate image should be used for printing", 0, false);
            StreamContainsFormXObject = new Feature("FormXObject", "The PDF contains Form XObjects", 0, false);
            StreamContainsPathOperators = new Feature("Path", "The PDF contains basic path operations in a page stream", 0, false);
            StreamContainsText = new Feature("Text", "The PDF contains basic Text operations in a page stream", 0, false);
            RenderingIntentUnknown = new Feature("Rendering Intent is an unknown value", "The PDF contains an unknown Rendering Intent", 0, false);
            UnknownStreamOperator = new Feature("Unknown Operator in Stream", "The PDF contains an unknown operation in the stream. This is usually a sign of a corrupt PDF", 0, false);
            AlternateImage = new Feature("Image has an alternate", "The PDF contains an image with an alternate", 0, false);
            InterpolatedImage = new Feature("Interpolated Image", "The PDF contains an interpolated image", 0, false);
            Form = new Feature("Forms", "The PDF contains a Form", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    pDF.getForm().getElements().clear();
                    pDF.e("AcroForm");
                    return "Form was removed";
                }
            };
            NeedAppearancesNotFalse = new Feature("Need Appearances", "The PDF Form specifies that appearances must be generated by the viewer", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    Form form = pDF.getForm();
                    if (form.f("NeedAppearances")) {
                        form.e("NeedAppearances");
                    }
                    return "Form flag NeedAppearances was removed";
                }
            };
            DigitallySigned = new Feature("Digital Signature", "The PDF is digitally signed by at least one signature", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    Map map = pDF.getForm().getElements();
                    Iterator iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (!(entry.getValue() instanceof FormSignature) || ((FormSignature)entry.getValue()).getState() != 0) continue;
                        iterator.remove();
                    }
                    return "Applied Signatures were removed";
                }
            };
            AuthorSignature = new Feature("Author Signature", "the PDF contains an \"Author\" signature, also known as a certifying signature", 6, true){};
            XFAForm = new Feature("XFA Forms", "The PDF contains an XFA form that overrides the old-style PDF Form.", 5, true);
            XFAForm20 = new Feature("XFA Forms version 2.0", "The PDF contains an XFA form matching version 2.0.", 5, true);
            XFAForm22 = new Feature("XFA Forms version 2.2", "The PDF contains an XFA form matching version 2.2.", 5, true);
            XFAForm24 = new Feature("XFA Forms version 2.4", "The PDF contains an XFA form matching version 2.4.", 5, true);
            XFAForm25 = new Feature("XFA Forms version 2.5", "The PDF contains an XFA form matching version 2.5.", 5, true);
            XFAForm26 = new Feature("XFA Forms version 2.6", "The PDF contains an XFA form matching version 2.6.", 5, true);
            XFAForm27 = new Feature("XFA Forms version 2.7", "The PDF contains an XFA form matching version 2.7.", 5, true);
            XFAForm28 = new Feature("XFA Forms version 2.8", "The PDF contains an XFA form matching version 2.8.", 5, true);
            XFAForm30 = new Feature("XFA Forms version 3.0", "The PDF contains an XFA form matching version 3.0.", 5, true);
            XFAForm31 = new Feature("XFA Forms version 3.1", "The PDF contains an XFA form matching version 3.1.", 5, true);
            HasOutputIntent = new Feature("Output Intent", "The PDF contains an OutputIntent", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    uc uc2 = pDF.j("Root").k("OutputIntents");
                    uc2.p();
                    return null;
                }
            };
            HasOutputIntentGTS_PDFX = new Feature("Output Intent of GTS_PDFX", "The PDF contains an OutputIntent which matches that required for PDF/X", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    uc uc2 = pDF.j("Root").k("OutputIntents");
                    for (int i2 = 0; i2 < uc2.o(); ++i2) {
                        if (!uc2.f(i2).i("S").d("GTS_PDFX")) continue;
                        uc2.b(i2--);
                    }
                    return null;
                }
            };
            HasOutputIntentGTS_PDFA1 = new Feature("Output Intent of GTS_PDFA1", "The PDF contains an OutputIntent which matches that required for PDF/A", 0, true){

                boolean a(OutputProfile outputProfile) {
                    return !outputProfile.isSet(v);
                }

                String c(PDF pDF, OutputProfile outputProfile) {
                    uc uc2 = pDF.j("Root").k("OutputIntents");
                    for (int i2 = 0; i2 < uc2.o(); ++i2) {
                        if (!uc2.f(i2).i("S").d("GTS_PDFA1")) continue;
                        uc2.b(i2--);
                    }
                    return null;
                }
            };
            HasOutputIntentGTS_PDFA = new Feature("Output Intent of GTS_PDFA", "The PDF contains an OutputIntent which matches the PDF/A requirement in AcrobatA, although the specification uses a different value", 0, true){

                boolean a(OutputProfile outputProfile) {
                    return !outputProfile.isSet(v);
                }

                String c(PDF pDF, OutputProfile outputProfile) {
                    uc uc2 = pDF.j("Root").k("OutputIntents");
                    for (int i2 = 0; i2 < uc2.o(); ++i2) {
                        if (!uc2.f(i2).i("S").d("GTS_PDFA")) continue;
                        uc2.b(i2--);
                    }
                    return null;
                }
            };
            HasGrayOutputIntent = new Feature("Output Intent is Grayscale", "The PDF contains an OutputIntent which is in a Grayscale ColorSpace", 0, true);
            HasRGBOutputIntent = new Feature("Output Intent is RGB", "The PDF contains an OutputIntent which is in an RGB ColorSpace", 0, true);
            HasCMYKOutputIntent = new Feature("Output Intent is CMYK", "The PDF contains an OutputIntent which is in a CMYK ColorSpace", 0, true);
            HasUnknownOutputIntent = new Feature("Output Intent is Unknown", "The PDF contains an OutputIntent which in an unknown ColorSpace", 0, true);
            UnknownOutputIntentRegistry = new Feature("Output Intent is not in the http://www.color.org registry", "The PDF contains an OutputIntent which is not in the http://www.color.org registry", 0, true);
            HasUnembeddedOutputIntent = new Feature("Output Intent does not embed an ICC profile", "The PDF contains an OutputIntent which does not embed an ICC profile", 0, true);
            UnknownOutputIntentRegistryWithoutProfile = new Feature("Output Intent is not in the http://www.color.org registry and has no ICC profile", "The PDF contains an OutputIntent which is not in the http://www.color.org registry and does not embed an ICC Profile", 0, true);
            HasMultipleOutputIntents = new Feature("Multiple Output Intents", "The PDF contains multiple Output Intents", 0, true);
            HasMultipleDifferentOutputIntents = new Feature("Multiple Different Output Intents", "The PDF contains multiple Output Intents with different ICC profiles", 0, true);
            InfoMeetsPDFX1a_2001 = new Feature("Info Dictionary meets PDF/X-1a:2001", "The PDF Info Dictionary matches the requirements for PDF/X-1a:2001", 0, true){

                String d(PDF pDF, OutputProfile outputProfile) {
                    pDF.setInfo("GTS_PDFXVersion", "PDF/X-1:2001");
                    pDF.setInfo("GTS_PDFXConformance", "PDF/X-1a:2001");
                    return null;
                }

                String c(PDF pDF, OutputProfile outputProfile) {
                    pDF.setInfo("GTS_PDFXVersion", null);
                    pDF.setInfo("GTS_PDFXConformance", null);
                    return null;
                }
            };
            InfoMeetsPDFX1a_2003 = new Feature("Info Dictionary meets PDF/X-1a:2003", "The PDF Info Dictionary matches the requirements for PDF/X-1a:2003", 0, true){

                String d(PDF pDF, OutputProfile outputProfile) {
                    pDF.setInfo("GTS_PDFXVersion", "PDF/X-1a:2003");
                    return null;
                }

                String c(PDF pDF, OutputProfile outputProfile) {
                    pDF.setInfo("GTS_PDFXVersion", null);
                    pDF.setInfo("GTS_PDFXConformance", null);
                    return null;
                }
            };
            InfoMeetsPDFX3_2002 = new Feature("Info Dictionary meets PDF/X-3:2002", "The PDF Info Dictionary matches the requirements for PDF/X-3:2002", 0, true){

                String d(PDF pDF, OutputProfile outputProfile) {
                    pDF.setInfo("GTS_PDFXVersion", "PDF/X-3:2002");
                    return null;
                }

                String c(PDF pDF, OutputProfile outputProfile) {
                    pDF.setInfo("GTS_PDFXVersion", null);
                    pDF.setInfo("GTS_PDFXConformance", null);
                    return null;
                }
            };
            InfoMeetsPDFX3_2003 = new Feature("Info Dictionary meets PDF/X-3:2003", "The PDF Info Dictionary matches the requirements for PDF/X-3:2003", 0, true){

                String d(PDF pDF, OutputProfile outputProfile) {
                    pDF.setInfo("GTS_PDFXVersion", "PDF/X-3:2003");
                    return null;
                }

                String c(PDF pDF, OutputProfile outputProfile) {
                    pDF.setInfo("GTS_PDFXVersion", null);
                    pDF.setInfo("GTS_PDFXConformance", null);
                    return null;
                }
            };
            InfoMeetsPDFA1b_2005 = new Feature("Info Dictionary meets PDF/A-1b:2005", "The PDF Info Dictionary matches the requirements for PDF/A-1b:2005", 4, false){

                String d(PDF pDF, OutputProfile outputProfile) {
                    pDF.setInfo("xmp:pdfaid:part", "1");
                    pDF.setInfo("xmp:pdfaid:conformance", "B");
                    pDF.setInfo("xmp:pdfaid:amd", null);
                    return null;
                }

                String c(PDF pDF, OutputProfile outputProfile) {
                    pDF.setInfo("xmp:pdfaid:part", null);
                    pDF.setInfo("xmp:pdfaid:conformance", null);
                    pDF.setInfo("xmp:pdfaid:amd", null);
                    return null;
                }
            };
            InfoMeetsPDFA1b_2005_Acrobat7 = new Feature("Info Dictionary meets the incorrect variation of PDF/A-1b:2005 required by Acrobat 7", "The PDF Info Dictionary matches the incorrect requirements for PDF/A-1b:2005 create and required by Acrobat 7. This uses a slightly different namespace to the correct PDF/A namespace. Setting this feature and InfoMeetsPDFA1b_2005 will, unfortunately, cause Acrobat 8 to incorrectly flag the document as not meeting the PDF/A specification, so we recommend not setting it unless you have a specific reason to target Acrobat 7.0", 0, false){

                String d(PDF pDF, OutputProfile outputProfile) {
                    pDF.setInfo("xmp:pdfaidold:part", "1");
                    pDF.setInfo("xmp:pdfaidold:conformance", "B");
                    pDF.setInfo("xmp:pdfaidold:amd", null);
                    return null;
                }

                String c(PDF pDF, OutputProfile outputProfile) {
                    pDF.setInfo("xmp:pdfaidold:part", "1");
                    pDF.setInfo("xmp:pdfaidold:conformance", "B");
                    pDF.setInfo("xmp:pdfaidold:amd", null);
                    return null;
                }
            };
            InfoMeetsPDFA1a_2005 = new Feature("Info Dictionary meets PDF/A-1a:2005", "The PDF Info Dictionary matches the requirements for PDF/A-1a:2005", 0, false){

                String c(PDF pDF, OutputProfile outputProfile) {
                    pDF.setInfo("pdfaid:part", null);
                    pDF.setInfo("pdfaid:amd", null);
                    pDF.setInfo("pdfaid:conformance", null);
                    return null;
                }
            };
            ViewBoxNotBleedBox = new Feature("ViewerPreferences boxes are not Bleed or Media Box", "The PDF Options specify that the box to display is not the Bleed or Media box", 0, false);
            ImagePluginHeader = new Feature("Set Image-Only flags", "The PDF contains flags that cause it to be recognized as a photo for printing in Acrobat 6", 0, false);
            RegularCompression = new Feature("Use Regular Compression", 0, true){

                boolean a(OutputProfile outputProfile) {
                    return true;
                }
            };
            MaximumCompression = new Feature("Use Maximum Compression", 0, true){

                boolean a(OutputProfile outputProfile) {
                    return true;
                }
            };
            MergeResources = new Feature("Consolidate duplicate PDF objects when saving", 0, true){

                boolean a(OutputProfile outputProfile) {
                    return true;
                }
            };
            PurgeResources = new Feature("Purge excess PDF objects when saving", 0, true){

                boolean a(OutputProfile outputProfile) {
                    return true;
                }
            };
            FileIsDamaged = new Feature("PDF is damaged", "The PDF is damaged and does not meet the PDF specification. It has been repaired as best as possible, although depending on the extent of the damage some data may theoretically have been lost (although typically this is unlikely)", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return null;
                }
            };
            ContentIsDamaged = new Feature("PDF content is damaged", "The PDF contains a content stream that is damaged. This is a good indicator of serious damage to the PDF, although the PDF API is unable to determine the exact extent", 0, false);
            ImperfectWhitespace = new Feature("PDF has whitespace which doesn't match the PDF/A requirement", "The PDF contains whitespace which although acceptable, does not match the stricter reuquirements of the PDF/A", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return null;
                }
            };
            StreamLengthIncorrect = new Feature("PDF contains stream with invalid Length", "The PDF contains a stream object with an invalid Length. This is repairable and quite common, but explicitly disallowed in the PDF/A specification and may indicate damage to the PDF", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return null;
                }
            };
            ImageLengthIncorrect = new Feature("PDF contains a truncated image", "The PDF contains an image which has less data than its width and height demand. This is not repairable, although for small differences the effect may be negligable. It's disallowed in the PDF/A specification and may indicate damage to the PDF", 0, true);
            NoEOLStream = new Feature("PDF contains a stream without an EOL character", "The PDF contains a stream without a trailing EOL. This is quite normal, but disallowed in PDF/A", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return null;
                }
            };
            OddHexString = new Feature("PDF contains Hex string with odd length", "The PDF contains a Hex string with an odd length. This is repairable but disallowed in PDF/A", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return null;
                }
            };
            HeaderNotAtStart = new Feature("PDF header not at start", "The PDF contains junk before the header. Although allowed, this is not recommended", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return null;
                }
            };
            TrailerNotAtEnd = new Feature("PDF trailer not at end", "The PDF contains junk after the trailer. Although allowed, this is not recommended", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return null;
                }
            };
            NoFourByteComment = new Feature("PDF missing four-byte binary marker", "The PDF is missing the 4-byte binary marker after the header. This can cause it to be treated as text and therefore corrupted by some invalid Windows-based workflows", 0, true){

                String c(PDF pDF, OutputProfile outputProfile) {
                    return null;
                }
            };
            ArrayOverflow = new Feature("PDF contains an Array greater than 8191 elements", "The PDF contains an Array greater than 8191 elements long, which is officially disallowed by the PDF specification (although many PDF processors will have no trouble with these documents)", 0, true);
            DictionaryOverflow = new Feature("PDF contains a Dictionary with more than 4095 entries", "The PDF contains a Dictionary with more than 4095 entries, which is officially disallowed by the PDF specification (although many PDF processors will have no trouble with these documents)", 0, true);
            IntegerOverflow = new Feature("PDF contains an Integer greater than 2^31-1", "The PDF contains an Integer greater than 2^31-1, which is officially disallowed by the PDF specification", 0, true);
            NameOverflow = new Feature("PDF contains a Name greater than 127 bytes", "The PDF contains an Name greater than 127 bytes, which is officially disallowed by the PDF specification", 0, true);
            StringOverflow = new Feature("PDF contains a String greater than 65535 bytes", "The PDF contains an String greater than 65535 bytes, which is officially disallowed by the PDF specification", 0, true);
            Device9ColorSpace = new Feature("PDF contains a DeviceN ColorSpace with 9 or more components", "The PDF contains a DeviceN ColorSpace with more than 8 components, which is officially disallowed by the PDF specification 1.4", 0, false);
            Device33ColorSpace = new Feature("PDF contains a DeviceN ColorSpace with 33 or more components", "The PDF contains a DeviceN ColorSpace with more than 32 components, which is officially disallowed by the PDF specification 1.7", 0, false);
            InvalidColorProfile = new Feature("PDF contains an invalid ICC color profile", 0, false);
            SinglePixelImage = new Feature("PDF contains Single Pixel image", "The PDF contains a bitmap image made up of a single pixel. This is very inefficient", 0, false);
            x = new Feature("RGB allowed in PDF/X-3", "Allows uncalibrated RGB in PDF/X-3 profiles, as allowed by Acrobat", 0, false){

                String d(PDF pDF, OutputProfile outputProfile) {
                    return null;
                }
            };
            y = new Feature("No Media Box", "The PDF has no MediaBox specified on one or more pages", 0, false);
            z = new Feature("Page is a Separation Plate", 0, false);
            A = new Feature("Marked Properties", 0, false);
            B = new Feature("External File Reference", 0, false);
            C = new Feature("TrueType uses WinAnsi or MacRoman encoding", 0, false);
            D = new Feature("Font is missing ToUnicode entry", 0, false);
            E = new Feature("Annotation has no content", 0, false);
            ALL = a.toArray(new Feature[0]);
            a = null;
        }

        private static class nd_
        extends Feature {
            private final String F;
            private final boolean G;

            nd_(String string, String string2, int n2, boolean bl, String string3, boolean bl2) {
                super(string, string2, n2, bl);
                this.F = string3;
                this.G = bl2;
            }

            String c(PDF pDF, OutputProfile outputProfile) {
                return this.removeActionType(this.F, this.G, pDF, outputProfile);
            }
        }

        private static class od_
        extends Feature {
            private final String F;
            private final String G;

            od_(String string, String string2, int n2, boolean bl, String string3, String string4) {
                super(string, string2, n2, bl);
                this.F = string3;
                this.G = string4;
            }

            String c(PDF pDF, OutputProfile outputProfile) {
                return this.removeAnnotations(pDF, this.F, this.G);
            }
        }
    }

    public static final class FontInfo
    implements Comparable {
        private final String a;
        private final String b;
        private final boolean c;
        private final PDFFont d;

        FontInfo(String string, boolean bl, String string2, PDFFont pDFFont) {
            this.a = string;
            this.c = bl;
            this.b = string2;
            this.d = pDFFont;
        }

        public String getBaseName() {
            return this.a;
        }

        public boolean isEmbedded() {
            return "Unembedded".equals(this.getType());
        }

        public boolean isSubset() {
            return this.isEmbedded() && this.a.length() > 7 && this.a.charAt(6) == '+';
        }

        public boolean isCIDFont() {
            return this.c;
        }

        public String getType() {
            return this.b;
        }

        public int hashCode() {
            return (this.a == null ? 0 : this.a.hashCode()) ^ this.b.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof FontInfo) {
                FontInfo fontInfo = (FontInfo)object;
                return (this.a == null && fontInfo.getBaseName() == null || this.a != null && this.a.equals(fontInfo.getBaseName())) && this.b.equals(fontInfo.getType());
            }
            return false;
        }

        public String toString() {
            return "{" + this.a + ": " + (this.c ? "CID " : "Simple ") + this.b + "}";
        }

        gc a() {
            return this.d;
        }

        public int compareTo(Object object) {
            int n2;
            int n3 = n2 = object == null ? 1 : this.toString().compareTo(object.toString());
            if (n2 == 0 && object != this) {
                n2 = this.hashCode() - object.hashCode();
            }
            return n2;
        }
    }
}

