/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.faceless.pdf2.Form;
import org.faceless.pdf2.FormElement;
import org.faceless.pdf2.OutputProfile;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.PDFSound;
import org.faceless.pdf2.WidgetAnnotation;
import org.faceless.pdf2.bd;
import org.faceless.pdf2.gc;
import org.faceless.pdf2.hb;
import org.faceless.pdf2.ic;
import org.faceless.pdf2.sc;
import org.faceless.pdf2.uc;
import org.faceless.pdf2.vc;
import org.faceless.pdf2.wc;
import org.faceless.pdf2.xc;
import org.faceless.pdf2.y;
import org.faceless.pdf2.yd;

public final class PDFAction
extends ic {
    public static final int METHOD_HTTP_POST = 4;
    public static final int METHOD_HTTP_IMAGEMAP_POST = 20;
    public static final int METHOD_FDF = 0;
    public static final int METHOD_XML = 32;
    public static final int METHOD_XML_WITH_ALL_ANNOTATIONS = 160;
    public static final int METHOD_FDF_WITH_ALL_ANNOTATIONS = 128;
    public static final int METHOD_FDF_WITH_MY_ANNOTATIONS = 1152;
    public static final int METHOD_PDF = 256;
    public static final int METHOD_FLAG_CANONICALDATES = 512;
    public static final int METHOD_FLAG_EMPTYFIELDS = 2;

    PDFAction(ic ic2) {
        super(ic2, "Action");
        if (!this.f("S")) {
            this.b("S", wc.b("GoTo"));
        }
    }

    PDFAction(uc uc2) {
        super("Action");
        this.b("S", wc.b("GoTo"));
        this.b("D", uc2);
    }

    private PDFAction(String string) {
        super("Action");
        this.b("S", wc.b(string));
    }

    public static PDFAction goTo(PDFPage pDFPage) {
        return PDFAction.goTo(pDFPage, Float.NaN, Float.NaN, Float.NaN);
    }

    public static PDFAction goTo(PDFPage pDFPage, float f2, float f3, float f4) {
        uc uc2;
        block14: {
            block13: {
                block12: {
                    float[] fArray;
                    block11: {
                        block10: {
                            block9: {
                                if (pDFPage == null) {
                                    throw new IllegalArgumentException("Page is null");
                                }
                                uc2 = new uc(5);
                                uc2.c(pDFPage);
                                uc2.c(wc.b("XYZ"));
                                fArray = new float[]{f2, f3};
                                pDFPage.A().transform(fArray, 0, fArray, 0, 1);
                                if (!Float.isNaN(fArray[0])) break block9;
                                uc2.c(gc.a);
                                break block10;
                            }
                            uc2.c(xc.a(fArray[0]));
                        }
                        if (!Float.isNaN(fArray[1])) break block11;
                        uc2.c(gc.a);
                        break block12;
                    }
                    uc2.c(xc.a(fArray[1]));
                }
                if (!Float.isNaN(f4)) break block13;
                uc2.c(gc.a);
                break block14;
            }
            uc2.c(xc.a(f4));
        }
        PDFAction pDFAction = new PDFAction(uc2);
        return pDFAction;
    }

    public static PDFAction goToFit(PDFPage pDFPage) {
        if (pDFPage == null) {
            throw new IllegalArgumentException("Page is null");
        }
        uc uc2 = new uc(2);
        uc2.c(pDFPage);
        uc2.c(wc.b("Fit"));
        PDFAction pDFAction = new PDFAction(uc2);
        return pDFAction;
    }

    public static PDFAction goToFitWidth(PDFPage pDFPage, float f2) {
        if (pDFPage == null) {
            throw new IllegalArgumentException("Page is null");
        }
        uc uc2 = new uc(3);
        uc2.c(pDFPage);
        uc2.c(wc.b("FitH"));
        uc2.c(xc.a(f2));
        PDFAction pDFAction = new PDFAction(uc2);
        return pDFAction;
    }

    public static PDFAction goToFitHeight(PDFPage pDFPage, float f2) {
        if (pDFPage == null) {
            throw new IllegalArgumentException("Page is null");
        }
        uc uc2 = new uc(3);
        uc2.c(pDFPage);
        uc2.c(wc.b("FitV"));
        uc2.c(xc.a(f2));
        PDFAction pDFAction = new PDFAction(uc2);
        return pDFAction;
    }

    public static PDFAction goToFitRectangle(PDFPage pDFPage, float f2, float f3, float f4, float f5) {
        if (pDFPage == null) {
            throw new IllegalArgumentException("Page is null");
        }
        uc uc2 = new uc(6);
        float[] fArray = new float[]{f2, f3, f4, f5};
        pDFPage.A().transform(fArray, 0, fArray, 0, 2);
        uc.b(fArray);
        uc2.c(pDFPage);
        uc2.c(wc.b("FitR"));
        uc2.c(xc.a(fArray[0]));
        uc2.c(xc.a(fArray[1]));
        uc2.c(xc.a(fArray[2]));
        uc2.c(xc.a(fArray[3]));
        PDFAction pDFAction = new PDFAction(uc2);
        return pDFAction;
    }

    public static PDFAction goToURL(URL uRL) {
        return PDFAction.goToURL(uRL, false);
    }

    public static PDFAction goToURL(URL uRL, boolean bl) {
        if (uRL == null) {
            throw new IllegalArgumentException("URL is null");
        }
        PDFAction pDFAction = new PDFAction("URI");
        pDFAction.b("URI", new bd(uRL.toString(), hb.PDF));
        if (bl) {
            pDFAction.b("IsMap", vc.g);
        }
        return pDFAction;
    }

    public static PDFAction goToURL(URI uRI, boolean bl) {
        if (uRI == null) {
            throw new IllegalArgumentException("URI is null");
        }
        PDFAction pDFAction = new PDFAction("URI");
        pDFAction.b("URI", new bd(uRI.toString(), hb.PDF));
        return pDFAction;
    }

    public static PDFAction goToRemote(String string, int n2, float f2, float f3, float f4) {
        return PDFAction.goToRemote(string, n2, f2, f3, f4, null);
    }

    public static PDFAction goToRemote(String string, int n2, float f2, float f3, float f4, String string2) {
        PDFAction pDFAction;
        block24: {
            block23: {
                uc uc2;
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        if (string == null) {
                                            throw new IllegalArgumentException("Filename is null");
                                        }
                                        if (n2 < 0) {
                                            throw new IllegalArgumentException("Pagenumber must be >= 0");
                                        }
                                        uc2 = new uc(5);
                                        uc2.c(xc.b(n2));
                                        uc2.c(wc.b("XYZ"));
                                        if (!Float.isNaN(f2)) break block17;
                                        uc2.c(gc.a);
                                        break block18;
                                    }
                                    uc2.c(xc.a(f2));
                                }
                                if (!Float.isNaN(f3)) break block19;
                                uc2.c(gc.a);
                                break block20;
                            }
                            uc2.c(xc.a(f3));
                        }
                        if (!Float.isNaN(f4)) break block21;
                        uc2.c(gc.a);
                        break block22;
                    }
                    uc2.c(xc.a(f4));
                }
                pDFAction = new PDFAction("GoToR");
                pDFAction.b("D", uc2);
                pDFAction.b("F", new bd(string, hb.PDF));
                if (!"true".equalsIgnoreCase(string2)) break block23;
                pDFAction.b("NewWindow", vc.g);
                break block24;
            }
            if ("false".equalsIgnoreCase(string2)) {
                pDFAction.b("NewWindow", vc.h);
            }
        }
        return pDFAction;
    }

    public static PDFAction goToFitRemoteRectangle(String string, int n2, float f2, float f3, float f4, float f5) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Pagenumber must be >= 1");
        }
        uc uc2 = new uc(6);
        uc2.c(xc.b(n2 - 1));
        uc2.c(wc.b("FitR"));
        uc2.c(xc.a(f2));
        uc2.c(xc.a(f3));
        uc2.c(xc.a(f2 + f4));
        uc2.c(xc.a(f3 + f5));
        PDFAction pDFAction = new PDFAction("GoToR");
        pDFAction.b("D", uc2);
        pDFAction.b("F", new bd(string, hb.PDF));
        return pDFAction;
    }

    public static PDFAction launch(String string, String string2) {
        PDFAction pDFAction;
        block6: {
            block5: {
                pDFAction = new PDFAction("Launch");
                pDFAction.b("F", new bd(string, hb.PDF));
                if (!"true".equalsIgnoreCase(string2)) break block5;
                pDFAction.b("NewWindow", vc.g);
                break block6;
            }
            if ("false".equalsIgnoreCase(string2)) {
                pDFAction.b("NewWindow", vc.h);
            }
        }
        return pDFAction;
    }

    public static PDFAction playSound(PDFSound pDFSound) {
        return PDFAction.playSound(pDFSound, 100, false, false);
    }

    public static PDFAction playSound(PDFSound pDFSound, int n2, boolean bl, boolean bl2) {
        PDFAction pDFAction = new PDFAction("Sound");
        pDFAction.b("Sound", pDFSound);
        n2 = Math.max(Math.min(100, n2), 0);
        pDFAction.b("Volume", xc.a((float)n2 / 100.0f));
        if (bl) {
            pDFAction.b("Repeat", vc.g);
        }
        if (bl2) {
            pDFAction.b("Mix", vc.g);
        }
        return pDFAction;
    }

    public static PDFAction named(String string) {
        PDFAction pDFAction = new PDFAction("Named");
        pDFAction.b("N", wc.b(string));
        return pDFAction;
    }

    public static PDFAction showWidget(WidgetAnnotation widgetAnnotation) {
        return PDFAction.a(widgetAnnotation, true);
    }

    public static PDFAction hideWidget(WidgetAnnotation widgetAnnotation) {
        return PDFAction.a(widgetAnnotation, false);
    }

    private static PDFAction a(WidgetAnnotation widgetAnnotation, boolean bl) {
        PDFAction pDFAction = new PDFAction("Hide");
        pDFAction.b("T", widgetAnnotation);
        PDFAction pDFAction2 = pDFAction;
        String string = "H";
        vc vc2 = bl ? vc.h : vc.g;
        pDFAction2.b(string, vc2);
        return pDFAction;
    }

    public static PDFAction formSubmit(String string, int n2) {
        PDFAction pDFAction = new PDFAction("SubmitForm");
        ic ic2 = new ic("URL");
        ic2.b("FS", wc.b("URL"));
        ic2.b("F", new bd(string, hb.PDF));
        pDFAction.b("F", ic2);
        pDFAction.b("Flags", xc.b(n2));
        return pDFAction;
    }

    public static PDFAction formReset() {
        PDFAction pDFAction = new PDFAction("ResetForm");
        return pDFAction;
    }

    public static PDFAction formImportData(String string) {
        PDFAction pDFAction = new PDFAction("ImportData");
        ic ic2 = new ic("URL");
        ic2.b("FS", wc.b("URL"));
        ic2.b("F", new bd(string, hb.PDF));
        pDFAction.b("F", ic2);
        return pDFAction;
    }

    public static PDFAction formJavaScript(String string) {
        PDFAction pDFAction;
        block7: {
            block6: {
                pDFAction = new PDFAction("JavaScript");
                int n2 = string.length();
                if (n2 >= 100) break block6;
                pDFAction.b("JS", new bd(string, hb.UCSNL));
                break block7;
            }
            sc sc2 = new sc();
            y y2 = new y(sc2);
            try {
                try {
                    hb.UCSNL.write(string, y2);
                    y2.complete();
                }
                catch (IOException iOException) {
                    throw gc.a(iOException);
                }
                Object var7_5 = null;
                y2.close();
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                y2.close();
                throw throwable;
            }
            pDFAction.b("JS", sc2);
        }
        return pDFAction;
    }

    public void setNext(PDFAction pDFAction) {
        block3: {
            block2: {
                if (pDFAction != null) break block2;
                this.e("Next");
                break block3;
            }
            this.b("Next", pDFAction);
        }
    }

    public PDFAction getNext() {
        gc gc2 = this.h("Next");
        return PDFAction.a(gc2, this.n());
    }

    public String getType() {
        return this.c(false);
    }

    String t() {
        return this.c(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String c(boolean bl) {
        Object object;
        String string = this.i("S").o();
        if (string.equals("GoTo")) {
            object = this.u();
            string = object != null && ((uc)object).o() > 1 && ((uc)object).d(0) instanceof PDFPage ? ((uc)object).e(1).o() : "GoToBadPage";
        }
        if (string.equals("XYZ")) {
            return "GoTo";
        }
        if (string.equals("FitV")) return "GoToFitHeight";
        if (string.equals("FitBV")) {
            return "GoToFitHeight";
        }
        if (string.equals("FitH")) return "GoToFitWidth";
        if (string.equals("FitBH")) {
            return "GoToFitWidth";
        }
        if (string.equals("Fit")) return "GoToFit";
        if (string.equals("FitB")) {
            return "GoToFit";
        }
        if (string.equals("FitR")) {
            return "GoToFitRectangle";
        }
        if (string.equals("URI")) {
            return "URL";
        }
        if (string.equals("GoToE")) {
            return "GoToE";
        }
        if (string.equals("ResetForm")) {
            return "FormReset";
        }
        if (string.equals("ImportData")) {
            return "FormImportData";
        }
        if (string.equals("SubmitForm")) {
            return "FormSubmit";
        }
        if (string.equals("JavaScript")) {
            return "FormJavaScript";
        }
        if (string.equals("Movie")) {
            return "Movie";
        }
        if (string.equals("Sound")) {
            return "Sound";
        }
        if (string.equals("Launch")) {
            return "Launch";
        }
        if (string.equals("SetOCGState")) {
            return "SetOCGState";
        }
        if (string.equals("Rendition")) {
            return "Rendition";
        }
        if (string.equals("Trans")) {
            return "Trans";
        }
        if (string.equals("GoTo3DView")) {
            return "GoTo3DView";
        }
        if (string.equals("GoToDPart")) {
            return "GoToDPart";
        }
        if (string.equals("RichMediaExecute")) {
            return "RichMediaExecute";
        }
        if (string.equals("Hide")) {
            if (this.o("H") != vc.h) return "HideWidget";
            return "ShowWidget";
        }
        if (string.equals("Named")) {
            object = this.i("N").o();
            if (!bl) return "Named:" + (String)object;
            if (((String)object).equals("NextPage")) return "Named:" + (String)object;
            if (((String)object).equals("PrevPage")) return "Named:" + (String)object;
            if (((String)object).equals("FirstPage")) return "Named:" + (String)object;
            if (((String)object).equals("LastPage")) return "Named:" + (String)object;
            object = "Other";
            return "Named:" + (String)object;
        }
        if (string.equals("GoToBadPage")) {
            return "GoToBadPage";
        }
        if (!bl) return string;
        return "Unknown";
    }

    public PDFPage getPage() {
        block2: {
            uc uc2 = this.u();
            if (uc2 == null || !(uc2.d(0) instanceof PDFPage)) break block2;
            PDFPage pDFPage = (PDFPage)uc2.f(0);
            return pDFPage;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void a(yd yd2) {
        uc uc2 = this.u();
        if (uc2 != null && uc2.d(0) instanceof PDFPage && uc2.f(0).n() != this.n()) {
            PDF.k.warning("AC3", "Page referred to in action is from another PDF - removing");
            uc2.b(0, gc.a);
        }
        super.a(yd2);
    }

    public PDFSound getSound() {
        return (PDFSound)this.n("Sound");
    }

    public WidgetAnnotation getAnnotation() {
        block6: {
            String string = this.getType();
            if (!string.equals("HideWidget") && !string.equals("ShowWidget")) break block6;
            gc gc2 = this.h("T");
            if (gc2 instanceof uc) {
                gc2 = ((uc)gc2).d(0);
            }
            if (gc2 instanceof bd) {
                try {
                    FormElement formElement = this.n().getForm().getElement(((bd)gc2).a(hb.UCS));
                    gc2 = formElement != null ? formElement.getAnnotation(0) : null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return (WidgetAnnotation)gc2;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getJavaScript() {
        gc gc2 = this.h("JS");
        if (gc2 == null) {
            return null;
        }
        if (!(gc2 instanceof bd)) {
            if (!(gc2 instanceof sc)) return null;
        }
        if (!(gc2 instanceof sc)) return ((bd)gc2).a(hb.UCSNL);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = ((sc)gc2).w();
            gc.a(inputStream, (OutputStream)byteArrayOutputStream);
            inputStream.close();
            gc2 = new bd(byteArrayOutputStream.toByteArray());
            return ((bd)gc2).a(hb.UCSNL);
        }
        catch (IOException iOException) {
            throw gc.a("IOException reading JavaScript", iOException);
        }
    }

    public String getURL() {
        String string = null;
        try {
            string = this.m("URI").a(hb.PDF);
        }
        catch (Exception exception) {
            try {
                string = this.h("F") instanceof bd ? this.m("F").a(hb.PDF) : this.j("F").m("F").a(hb.PDF);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        if (string != null) {
            try {
                string = new URL(new URL(this.n().j("Root").i("URI").o()), string).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public int getFormSubmitMethod() {
        int n2;
        block2: {
            n2 = -1;
            gc gc2 = this.h("Flags");
            if (!"FormSubmit".equals(this.getType()) || !(gc2 instanceof xc)) break block2;
            n2 = ((xc)gc2).o() & 0x5BC;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection getFormSubmitFields() {
        ArrayList<Object> arrayList = null;
        if (("FormSubmit".equals(this.getType()) || "FormReset".equals(this.getType())) && this.n() != null) {
            gc gc2;
            int n2;
            uc uc2 = this.k("Fields");
            xc xc2 = this.l("Flags");
            int n3 = xc2 == null ? 0 : xc2.o();
            Form form = this.n().getForm();
            Collection collection = form.getElements().values();
            if (uc2 == null) {
                arrayList = new ArrayList(collection);
            } else if ((n3 & 1) != 0) {
                arrayList = new ArrayList(collection);
                for (n2 = 0; n2 < uc2.o(); ++n2) {
                    gc2 = uc2.d(n2);
                    if (gc2 instanceof bd) {
                        gc2 = form.getElement(((bd)gc2).a(hb.UCS));
                    }
                    arrayList.remove(gc2);
                }
            } else {
                arrayList = new ArrayList();
                for (n2 = 0; n2 < uc2.o(); ++n2) {
                    gc2 = uc2.d(n2);
                    if (gc2 instanceof bd) {
                        gc2 = form.getElement(((bd)gc2).a(hb.UCS));
                    }
                    if (!collection.contains(gc2)) continue;
                    arrayList.add(gc2);
                }
            }
            if ("FormSubmit".equals(this.getType())) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    gc2 = (FormElement)iterator.next();
                    if (((FormElement)gc2).isSubmitted() && (((FormElement)gc2).getValue() != null || (n3 & 2) == 0)) continue;
                    iterator.remove();
                }
            }
        }
        return arrayList;
    }

    public int getFormSubmitFlags() {
        int n2;
        block2: {
            n2 = 0;
            gc gc2 = this.h("Flags");
            if (!"FormSubmit".equals(this.getType()) || !(gc2 instanceof xc)) break block2;
            n2 = ((xc)gc2).o();
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float[] getGoToCoordinates() {
        PDFPage pDFPage;
        uc uc2 = this.u();
        float[] fArray = new float[]{};
        if (uc2 != null) {
            fArray = new float[uc2.o() - 2];
            for (int n2 = 2; n2 < uc2.o(); ++n2) {
                fArray[n2 - 2] = uc2.d(n2) instanceof xc ? uc2.h(n2).p() : Float.NaN;
            }
        }
        if (fArray.length == 3 && Float.isNaN(fArray[2]) && !Float.isNaN(fArray[0])) {
            fArray[2] = 0.0f;
        }
        if ((pDFPage = this.getPage()) == null) return fArray;
        pDFPage.B().transform(fArray, 0, fArray, 0, fArray.length / 2);
        if (fArray.length != 4) return fArray;
        uc.b(fArray);
        return fArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getRemotePageNumber() {
        if (this.getType().equals("GoToR") && this.h("D") instanceof uc) {
            return this.k("D").h(0).o() + 1;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getRemoteFilename() {
        String string = this.getType();
        if ("GoToR".equals(string) || "Launch".equals(string)) {
            gc gc2 = this.h("F");
            if (gc2 instanceof bd) {
                return ((bd)gc2).a(hb.PDF);
            }
            if (gc2 instanceof ic && ((ic)gc2).f("F")) {
                return ((ic)gc2).m("F").a(hb.PDF);
            }
        }
        return null;
    }

    private uc u() {
        uc uc2 = null;
        if (!this.i("S").d("GoToR")) {
            gc gc2 = this.h("D");
            if (gc2 instanceof uc) {
                uc2 = (uc)gc2;
            } else {
                String string = null;
                if (gc2 instanceof bd) {
                    string = ((bd)gc2).a(hb.PDF);
                } else if (gc2 instanceof wc) {
                    string = ((wc)gc2).o();
                }
                if (string != null) {
                    Map map = this.n().getNamedActions();
                    PDFAction pDFAction = (PDFAction)map.get(string);
                    if (pDFAction != null) {
                        uc2 = pDFAction.k("D");
                    } else {
                        PDF.k.warning("AC2", "No named action \"" + string + "\"");
                    }
                }
            }
        }
        return uc2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final PDFAction a(gc gc2, PDF pDF) {
        PDFAction pDFAction;
        block14: {
            pDFAction = null;
            if (gc2 == null) {
                return null;
            }
            if (gc2 instanceof PDFAction) {
                return (PDFAction)gc2;
            }
            if (gc2 instanceof uc) {
                uc uc2 = (uc)gc2;
                if (uc2.o() < 2) return pDFAction;
                if (!(uc2.d(0) instanceof PDFPage)) return pDFAction;
                return new PDFAction(uc2);
            }
            if (!(gc2 instanceof ic) || !((ic)gc2).f("S")) break block14;
            return new PDFAction((ic)gc2);
        }
        if (!(gc2 instanceof wc)) {
            if (!(gc2 instanceof bd)) throw new IllegalArgumentException("Unable to parse action \"" + gc2 + "\"");
        }
        Map map = pDF.getNamedActions();
        String string = gc2 instanceof wc ? ((wc)gc2).o() : ((bd)gc2).a(hb.UCS);
        pDFAction = (PDFAction)map.get(string);
        if (pDFAction != null) return pDFAction;
        PDF.k.warning("AC1", "No named action \"" + string + "\"");
        return pDFAction;
    }

    void a(OutputProfile outputProfile) {
        block20: {
            String string;
            block27: {
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        block19: {
                                            string = this.t();
                                            if (!string.equals("FormJavaScript")) break block19;
                                            outputProfile.set(OutputProfile.Feature.JavaScript);
                                            break block20;
                                        }
                                        if (!string.equals("FormImportData")) break block21;
                                        outputProfile.set(OutputProfile.Feature.ActionImportData);
                                        break block20;
                                    }
                                    if (!string.equals("FormReset")) break block22;
                                    outputProfile.set(OutputProfile.Feature.ActionResetForm);
                                    break block20;
                                }
                                if (!string.equals("Launch")) break block23;
                                outputProfile.set(OutputProfile.Feature.ActionLaunch);
                                break block20;
                            }
                            if (!string.equals("Sound")) break block24;
                            outputProfile.set(OutputProfile.Feature.ActionSound);
                            break block20;
                        }
                        if (!string.equals("Movie")) break block25;
                        outputProfile.set(OutputProfile.Feature.ActionMovie);
                        break block20;
                    }
                    if (!string.equals("Named:Other")) break block26;
                    outputProfile.set(OutputProfile.Feature.ActionNamedOther);
                    break block20;
                }
                if (!string.equals("GoToBadPage")) break block27;
                outputProfile.set(OutputProfile.Feature.ActionGoToBadPage);
                break block20;
            }
            if (string.equals("Unknown")) {
                outputProfile.set(OutputProfile.Feature.ActionUnknown);
            }
        }
    }

    public /* synthetic */ String toString() {
        return super.toString();
    }
}

