/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2;

import java.io.IOException;
import java.io.InputStream;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFImage;
import org.faceless.pdf2.gc;
import org.faceless.tiff.Tiff;
import org.faceless.util.BackedInputStream;

public final class PDFImageSet {
    private final Tiff a;
    private final PDFImage[] b;
    private boolean c;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PDFImageSet(InputStream inputStream) throws IOException {
        BackedInputStream backedInputStream = BackedInputStream.getInstance(inputStream, true);
        if (!backedInputStream.matches(gc.a("II*\u0000")) && !backedInputStream.matches(gc.a("MM\u0000*"))) {
            this.a = null;
            this.b = new PDFImage[1];
            this.b[0] = new PDFImage(backedInputStream);
            return;
        }
        this.a = new Tiff(backedInputStream);
        if (PDF.getPropertyManager().getProperty("TolerateTIFFErrors") != null) {
            try {
                this.a.parse();
            }
            catch (Throwable throwable) {
                PDF.k.warning("IS1", "TIFF failed", throwable);
            }
        } else {
            this.a.parse();
        }
        this.b = new PDFImage[this.a.getNumImages()];
    }

    public int getNumImages() {
        return this.b.length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized PDFImage getImage(int n2) throws IOException {
        if (n2 < 0) throw new ArrayIndexOutOfBoundsException("!(0<=" + n2 + "<" + this.b.length + ")");
        if (n2 >= this.b.length) {
            throw new ArrayIndexOutOfBoundsException("!(0<=" + n2 + "<" + this.b.length + ")");
        }
        if (this.b[n2] != null) return this.b[n2];
        this.b[n2] = new PDFImage(this.a.getImage(n2));
        if (!this.c) return this.b[n2];
        this.b[n2].close();
        return this.b[n2];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        this.c = true;
        int n2 = 0;
        while (n2 < this.b.length) {
            if (this.b[n2] != null) {
                this.b[n2].close();
            }
            ++n2;
        }
        return;
    }
}

