/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2;

import java.awt.Color;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import org.apache.lucene.document.Document;
import org.faceless.pdf2.EncryptionHandler;
import org.faceless.pdf2.OpenTypeFont;
import org.faceless.pdf2.OutputProfile;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.PageExtractor;
import org.faceless.pdf2.PagePainter;
import org.faceless.pdf2.c;
import org.faceless.pdf2.f;
import org.faceless.pdf2.h;
import org.faceless.pdf2.ld;
import org.faceless.pdf2.md;
import org.faceless.pdf2.nb;
import org.faceless.pdf2.yb;
import org.faceless.tiff.Tag;
import org.faceless.tiff.Tiff;
import org.faceless.tiff.TiffImage;

public class PDFParser
implements Pageable {
    private final PDF a;
    private ld b;
    private nb c;
    private volatile int[] d;
    private WeakHashMap e;
    public static final ColorModel BLACKANDWHITE;
    public static final ColorModel GRAYSCALE;
    public static final ColorModel RGB;
    public static final ColorModel RGBA;
    public static final ColorModel CMYK;
    private static final /* synthetic */ Object d$lock;
    static /* synthetic */ Class class$org$faceless$pdf2$PDFParser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDFParser(PDF pDF) {
        if (pDF == null) {
            throw new NullPointerException("PDF is null");
        }
        Class<?> clazz = class$org$faceless$pdf2$PDFParser;
        if (clazz == null) {
            clazz = class$org$faceless$pdf2$PDFParser = new PDFParser[0].getClass().getComponentType();
        }
        PDF.a(clazz);
        this.e = new WeakHashMap();
        this.a = pDF;
        this.c = new nb();
        this.b = new ld(this.c);
        Object object = d$lock;
        synchronized (object) {
            this.d = new int[2];
        }
    }

    public final PDF getPDF() {
        return this.a;
    }

    public PagePainter getPagePainter(int n2) {
        return this.getPagePainter(this.a.getPage(n2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PagePainter getPagePainter(PDFPage pDFPage) {
        PDF pDF = pDFPage.n();
        if (pDF == null) return new PagePainter(pDFPage, this.b, this.isPrintable());
        if (pDF == this.a) return new PagePainter(pDFPage, this.b, this.isPrintable());
        throw new IllegalArgumentException("Page is not part of this PDF");
    }

    public PageExtractor getPageExtractor(int n2) {
        return this.getPageExtractor(this.a.getPage(n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageExtractor getPageExtractor(PDFPage pDFPage) {
        Object object;
        if (pDFPage.n() != this.a) {
            throw new IllegalArgumentException("Page is not part of this PDF");
        }
        if (!this.isExtractable()) {
            boolean bl = false;
            try {
                object = new Exception().getStackTrace();
                int n2 = 0;
                while (true) {
                    if (bl || n2 >= ((StackTraceElement[])object).length) break;
                    bl |= object[n2].getClassName().startsWith("org.faceless.pdf2.viewer2.");
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!bl) {
                throw new SecurityException("You do not have permission to extract data from this Document");
            }
        }
        WeakHashMap weakHashMap = this.e;
        synchronized (weakHashMap) {
            object = (PageExtractor)this.e.get(pDFPage);
            if (object == null) {
                object = new PageExtractor(pDFPage, new md(pDFPage, this.b));
                this.e.put(pDFPage, object);
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetPageExtractor(PDFPage pDFPage) {
        WeakHashMap weakHashMap = this.e;
        synchronized (weakHashMap) {
            this.e.remove(pDFPage);
        }
    }

    public List getPageExtractors() {
        ArrayList<PageExtractor> arrayList = new ArrayList<PageExtractor>(this.getNumberOfPages());
        List list = this.a.getPages();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            PDFPage pDFPage = (PDFPage)list.get(i2);
            arrayList.add(this.getPageExtractor(pDFPage));
        }
        return arrayList;
    }

    public void setFont(String string, Object object) {
        block5: {
            block6: {
                block4: {
                    if (!(object instanceof Font)) break block4;
                    this.c.a(string, (Font)object);
                    break block5;
                }
                if (!(object instanceof OpenTypeFont)) break block6;
                this.c.a(string, new h(((OpenTypeFont)object).H(), null));
                break block5;
            }
            throw new ClassCastException("Can't use " + object.getClass().getName() + " as a font");
        }
    }

    public boolean isPrintable() {
        EncryptionHandler encryptionHandler = this.a.getEncryptionHandler();
        boolean bl = encryptionHandler == null ? true : encryptionHandler.hasRight("Print");
        return bl;
    }

    public boolean isExtractable() {
        EncryptionHandler encryptionHandler = this.a.getEncryptionHandler();
        boolean bl = encryptionHandler == null ? true : encryptionHandler.hasRight("Extract");
        return bl;
    }

    public void writeAsTIFF(OutputStream outputStream, int n2, ColorModel colorModel) throws IOException {
        this.writeAsTIFF(outputStream, n2, colorModel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void writeAsTIFF(OutputStream outputStream, int n2, final ColorModel colorModel, final RenderingHints renderingHints) throws IOException {
        boolean bl;
        final int n3 = this.getNumberOfPages();
        if (n3 == 0) {
            throw new IllegalStateException("No pages in PDF");
        }
        Object object = d$lock;
        // MONITORENTER : object
        // MONITOREXIT : object
        this.d[0] = 0;
        Object object2 = d$lock;
        // MONITORENTER : object2
        // MONITOREXIT : object2
        this.d[1] = n3;
        Tiff tiff = new Tiff(outputStream);
        boolean bl2 = bl = n2 < -2;
        if (n2 == -1) {
            n2 = 0xC400CC;
        }
        if (n2 == -2) {
            n2 = 0x6000CC;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        final int n4 = n2 & 0xFFFF;
        final int n5 = (n2 >> 16 & 0xFFFF) == 0 ? n4 : n2 >> 16 & 0xFFFF;
        int n6 = PDF.t("TIFF");
        if (n6 == 1) {
            for (int i2 = 0; i2 < n3; ++i2) {
                PagePainter pagePainter = this.getPagePainter(i2);
                pagePainter.setRenderingHints(renderingHints);
                if (colorModel.getTransparency() == 3) {
                    pagePainter.setBackground(null);
                }
                TiffImage tiffImage = pagePainter.a(n4, n5, colorModel);
                if (bl) {
                    tiffImage.setTagInt(Tag.Compression, 8);
                }
                tiff.addImage(tiffImage);
                Object object3 = d$lock;
                // MONITORENTER : object3
                // MONITOREXIT : object3
                this.d[0] = this.d[0] + 1;
            }
        } else {
            final Object[] objectArray = new Object[n3];
            int n7 = 0;
            while (n7 < n6) {
                int n8 = n7++;
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     * Converted monitor instructions to comments
                     * Lifted jumps to return sites
                     */
                    public void run() {
                        while (PDFParser.access$000(PDFParser.this)[0] < n3) {
                            Object[] objectArray2;
                            int n2;
                            Object object = PDFParser.access$000(PDFParser.this);
                            // MONITORENTER : object
                            int[] nArray = PDFParser.access$000(PDFParser.this);
                            nArray[0] = nArray[0] + 1;
                            // MONITOREXIT : object
                            object = PDFParser.this.getPagePainter(n2);
                            ((PagePainter)object).setRenderingHints(renderingHints);
                            if (colorModel.getTransparency() == 3) {
                                ((PagePainter)object).setBackground(null);
                            }
                            try {
                                TiffImage tiffImage = ((PagePainter)object).a(n4, n5, colorModel);
                                object = null;
                                if (bl) {
                                    tiffImage.setTagInt(Tag.Compression, 8);
                                }
                                objectArray[n2] = tiffImage;
                                objectArray2 = objectArray;
                                // MONITORENTER : objectArray
                                objectArray.notifyAll();
                                // MONITOREXIT : objectArray2
                            }
                            catch (Throwable throwable) {
                                objectArray[n2] = throwable;
                                objectArray2 = objectArray;
                                // MONITORENTER : objectArray
                                objectArray.notifyAll();
                                // MONITOREXIT : objectArray2
                                return;
                            }
                        }
                    }
                }.start();
            }
            for (n7 = 0; n7 < n3; ++n7) {
                Object[] objectArray2 = objectArray;
                // MONITORENTER : objectArray
                try {
                    objectArray.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object object4 = objectArray[n7];
                objectArray[n7] = null;
                if (object4 instanceof TiffImage) {
                    tiff.addImage((TiffImage)object4);
                } else {
                    if (object4 instanceof IOException) {
                        throw (IOException)object4;
                    }
                    if (object4 instanceof Error) {
                        throw (Error)object4;
                    }
                    if (object4 instanceof RuntimeException) {
                        throw (RuntimeException)object4;
                    }
                }
                // MONITOREXIT : objectArray2
            }
        }
        tiff.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getWriteAsTIFFProgress() {
        float f2;
        block12: {
            int[] nArray;
            int[] nArray2;
            block11: {
                int[] nArray3;
                Object object = d$lock;
                synchronized (object) {
                    nArray3 = this.d;
                }
                if (nArray3[1] != 0) break block11;
                f2 = 1.0f;
                break block12;
            }
            Object object = d$lock;
            synchronized (object) {
                nArray2 = this.d;
            }
            Object object2 = d$lock;
            synchronized (object2) {
                nArray = this.d;
            }
            f2 = (float)nArray2[0] / (float)nArray[1];
        }
        return f2;
    }

    public void setOutputProfile(OutputProfile outputProfile) {
        this.b.a(outputProfile);
    }

    public int getNumberOfPages() {
        return this.a.getNumberOfPages();
    }

    public PageFormat getPageFormat(int n2) {
        PDFPage pDFPage = this.a.getPage(n2);
        float[] fArray = pDFPage.getBox("MediaBox");
        pDFPage.flush();
        float f2 = fArray[2] - fArray[0];
        float f3 = fArray[3] - fArray[1];
        int n3 = 1;
        if (f2 > f3) {
            float f4 = f2;
            f2 = f3;
            f3 = f4;
            n3 = 0;
        }
        PageFormat pageFormat = new PageFormat();
        Paper paper = new Paper();
        paper.setSize(f2, f3);
        paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
        pageFormat.setPaper(paper);
        pageFormat.setOrientation(n3);
        return pageFormat;
    }

    public Printable getPrintable(int n2) {
        return this.getPagePainter(n2);
    }

    public Document getLuceneDocument(boolean bl, boolean bl2, boolean bl3) {
        return new yb(this, bl, bl2, bl3).a();
    }

    public static ColorModel getBlackAndWhiteColorModel(int n2) {
        return new a_(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ int[] access$000(PDFParser pDFParser) {
        int[] nArray;
        Object object = d$lock;
        synchronized (object) {
            nArray = pDFParser.d;
        }
        return nArray;
    }

    static {
        d$lock = new Object();
        byte[] byArray = new byte[]{0, -1};
        BLACKANDWHITE = new IndexColorModel(1, 2, byArray, byArray, byArray);
        GRAYSCALE = new ComponentColorModel(org.faceless.pdf2.c.a(), new int[]{8}, false, false, 1, 0);
        RGB = new ComponentColorModel(Color.red.getColorSpace(), new int[]{8, 8, 8}, false, false, 1, 0);
        RGBA = new ComponentColorModel(Color.red.getColorSpace(), new int[]{8, 8, 8, 8}, true, false, 3, 0);
        CMYK = new ComponentColorModel(f.a(), new int[]{8, 8, 8, 8}, false, false, 1, 0);
    }

    static final class a_
    extends ColorModel {
        private int a;

        a_(int n2) {
            super(8);
            this.a = n2;
        }

        public int getAlpha(int n2) {
            return 0;
        }

        public int getBlue(int n2) {
            return 0;
        }

        public int getRed(int n2) {
            return 0;
        }

        public int getGreen(int n2) {
            return 0;
        }

        int a(BufferedImage bufferedImage) {
            if (this.a == 0) {
                int n2;
                int n3 = 0;
                int n4 = bufferedImage.getWidth();
                int n5 = bufferedImage.getHeight();
                int[] nArray = new int[256];
                for (int i2 = 0; i2 < n4; ++i2) {
                    for (int i3 = 0; i3 < n5; ++i3) {
                        int n6;
                        int n7 = bufferedImage.getRGB(i2, i3);
                        int n8 = n6 = (n7 & 0xFFFFFF) == 0xFFFFFF ? 255 : (n7 & 0xFF0000) / 850 + (n7 << 8 & 0xFF0000) / 432 + (n7 << 16 & 0xFF0000) / 2318 >> 8;
                        nArray[n8] = nArray[n8] + 1;
                    }
                }
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                int n9 = 0;
                this.a = 0;
                for (n2 = 0; n2 < 256; ++n2) {
                    d2 += (double)(n2 * nArray[n2]);
                }
                for (n2 = 0; n2 < 256; ++n2) {
                    double d5;
                    double d6;
                    if ((n9 += nArray[n2]) == 0) continue;
                    int n10 = n4 * n5 - n9;
                    if (n10 == 0) break;
                    double d7 = (d3 += (double)(n2 * nArray[n2])) / (double)n9;
                    if (!((d6 = (d7 - (d5 = (d2 - d3) / (double)n10)) * (d7 - d5) * (double)n9 * (double)n10) > d4)) continue;
                    d4 = d6;
                    n3 = n2;
                }
                return n3;
            }
            return this.a;
        }
    }
}

