/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import org.faceless.pdf2.FormSignature;
import org.faceless.pdf2.LayoutBox;
import org.faceless.pdf2.OutputProfile;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFCanvas;
import org.faceless.pdf2.PDFStyle;
import org.faceless.pdf2.SignatureHandler;
import org.faceless.pdf2.gc;
import org.faceless.pdf2.id;

public abstract class PKCS7SignatureHandler
extends SignatureHandler {
    private static int d;
    protected id pkcs7;
    String e;
    private PDFCanvas f;
    private float[] g;
    private URL h;

    protected PKCS7SignatureHandler() {
        this.setCustomAppearance(new PDFCanvas("logo.Adobe", 1.0f), 0.0f, 35.0f, 100.0f, 65.0f);
    }

    protected abstract String getHashAlgorithm();

    public abstract String getSubFilter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void g() throws CertificateException {
        if (this.pkcs7 != null) {
            return;
        }
        String string = this.getNameValue("SubFilter");
        if ("adbe.pkcs7.detached".equals(string) || "adbe.pkcs7.sha1".equals(string) || "ETSI.CAdES.detached".equals(string)) {
            try {
                byte[] byArray = this.getStringValue("Contents");
                String string2 = PDF.getPropertyManager().getProperty("debug.PKCS7");
                if (string2 != null) {
                    FileOutputStream fileOutputStream = null;
                    try {
                        fileOutputStream = new FileOutputStream(string2 + ++d);
                        fileOutputStream.write(byArray);
                        fileOutputStream.close();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    finally {
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                this.pkcs7 = new id(byArray);
                return;
            }
            catch (Exception exception) {
                CertificateException certificateException;
                if (exception instanceof CertificateException) {
                    certificateException = (CertificateException)exception;
                    throw certificateException;
                }
                certificateException = new CertificateException("Invalid PKCS7 Object");
                try {
                    certificateException.initCause(exception);
                    throw certificateException;
                }
                catch (Throwable throwable) {
                    certificateException = new CertificateException("Invalid PKCS7 object: " + exception);
                }
                throw certificateException;
            }
        }
        if (!"adbe.x509.rsa_sha1".equals(string)) throw new CertificateException("Unknown PKCS#7 SubFilter \"" + string + "\"");
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> collection = certificateFactory.generateCertificates(new ByteArrayInputStream(this.getStringValue("Cert")));
            byte[] byArray = this.getStringValue("Contents");
            X509Certificate[] x509CertificateArray = collection.toArray(new X509Certificate[0]);
            this.pkcs7 = new id(x509CertificateArray, byArray);
            return;
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Exception exception) {
            throw new CertificateException("Unable to recreate PKCS7 object: " + exception);
        }
    }

    protected void prepareToSign(KeyStore keyStore, String string, char[] cArray) throws GeneralSecurityException {
        X509Certificate[] x509CertificateArray;
        int n2;
        block17: {
            String string2;
            block16: {
                super.prepareToSign(keyStore, string, cArray);
                string2 = this.getSubFilter();
                this.putNameValue("SubFilter", this.getSubFilter());
                if ("adbe.pkcs7.sha1".equals(string2)) {
                    n2 = 0;
                } else {
                    if (!"adbe.pkcs7.detached".equals(string2) && !"ETSI.CAdES.detached".equals(string2)) break block16;
                    n2 = 1;
                }
                break block17;
            }
            if ("adbe.x509.rsa_sha1".equals(string2)) {
                n2 = 2;
            } else {
                throw new IllegalArgumentException("Unknown subfilter \"" + string2 + "\"");
            }
        }
        this.pkcs7 = new id(keyStore, string, cArray, this.getHashAlgorithm(), n2);
        if (this.h != null) {
            this.pkcs7.a(this.h);
        }
        if (this.a() == null) {
            x509CertificateArray = this.pkcs7.a();
            this.b((String)id.a(x509CertificateArray.getSubjectX500Principal()).get("CN"));
            this.e = x509CertificateArray.getSubjectDN().getName();
        }
        if ("adbe.x509.rsa_sha1".equals(this.getSubFilter())) {
            try {
                x509CertificateArray = this.pkcs7.b();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
                    byteArrayOutputStream.write(x509CertificateArray[i2].getEncoded());
                }
                byteArrayOutputStream.close();
                this.putStringValue("Cert", byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                throw gc.a(iOException);
            }
        }
        this.pkcs7.c();
    }

    public int getEstimatedContentSize(int n2) {
        return this.pkcs7.a(n2);
    }

    public MessageDigest getMessageDigest() {
        return this.pkcs7.d();
    }

    public byte[] sign() throws GeneralSecurityException, IOException {
        this.pkcs7.f();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if ("adbe.x509.rsa_sha1".equals(this.getSubFilter())) {
            byte[] byArray = this.pkcs7.g();
            byteArrayOutputStream.write(byArray);
        } else {
            this.pkcs7.a(byteArrayOutputStream);
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public final synchronized boolean verify(InputStream inputStream) throws GeneralSecurityException, IOException {
        this.g();
        this.pkcs7.c();
        MessageDigest messageDigest = this.getMessageDigest();
        byte[] byArray = new byte[8192];
        int n2 = 0;
        while ((n2 = inputStream.read(byArray)) >= 0) {
            messageDigest.update(byArray, 0, n2);
        }
        return this.pkcs7.e();
    }

    void a(OutputProfile outputProfile) {
        super.a(outputProfile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public X509Certificate[] getCertificates() throws CertificateException {
        if (this.pkcs7 == null) {
            this.g();
        }
        X509Certificate[] x509CertificateArray = this.pkcs7.b();
        X509Certificate x509Certificate = this.pkcs7.a();
        for (int n2 = 1; n2 < x509CertificateArray.length; ++n2) {
            if (x509CertificateArray[n2] != x509Certificate) continue;
            x509CertificateArray[n2] = x509CertificateArray[0];
            x509CertificateArray[0] = x509Certificate;
            break;
        }
        if (x509CertificateArray[0] != x509Certificate) {
            throw new IllegalStateException("Signing certificate not in list!");
        }
        return x509CertificateArray;
    }

    public String[] getLayerNames() {
        String[] stringArray = new String[]{"n0", "n2"};
        return stringArray;
    }

    public PDFCanvas getLayerAppearance(String string, PDFStyle pDFStyle) {
        PDFCanvas pDFCanvas = null;
        if (string.equals("n0")) {
            pDFCanvas = new PDFCanvas(100.0f, 100.0f);
            pDFCanvas.s("% DSBlank\n");
            pDFCanvas.j("Resources").e("ProcSet");
            pDFCanvas.flush();
        } else if (string.equals("n2")) {
            pDFCanvas = new PDFCanvas(this.f);
            if (this.g != null) {
                this.a(pDFCanvas, this.g[0], this.g[1], this.g[2], this.g[3], pDFStyle);
            }
            pDFCanvas.flush();
        }
        return pDFCanvas;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCustomAppearance(PDFCanvas pDFCanvas, float f2, float f3, float f4, float f5) {
        if (pDFCanvas == null) {
            throw new NullPointerException("Canvas may not be null");
        }
        pDFCanvas.flush();
        this.f = pDFCanvas;
        if (f2 == f4 && f3 == f5) {
            this.g = null;
            return;
        }
        this.g = new float[4];
        this.g[0] = f2;
        this.g[1] = f3;
        this.g[2] = f4;
        this.g[3] = f5;
    }

    void a(URL uRL) {
        this.h = uRL;
    }

    public X509Certificate[] getTimeStampCertificates() throws GeneralSecurityException, IOException {
        this.g();
        return this.pkcs7.h();
    }

    Calendar getSignatureDate() {
        Calendar calendar = null;
        try {
            this.g();
            calendar = this.pkcs7.i();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (calendar == null) {
            calendar = this.e();
        }
        return calendar;
    }

    private void a(PDFCanvas pDFCanvas, float f2, float f3, float f4, float f5, PDFStyle pDFStyle) {
        float f6;
        if (f2 > f4) {
            f6 = f4;
            f4 = f2;
            f2 = f6;
        }
        if (f3 > f5) {
            f6 = f5;
            f5 = f3;
            f3 = f6;
        }
        f6 = f4 - f2;
        float f7 = f5 - f3;
        pDFStyle.setTextAlign(1);
        LayoutBox layoutBox = null;
        for (int i2 = 0; i2 < 12; ++i2) {
            layoutBox = new LayoutBox(f6 * 0.9f);
            pDFStyle.setFont(pDFStyle.getFont(), i2);
            layoutBox.addText("Digitally Signed by " + this.e, pDFStyle, Locale.getDefault());
            layoutBox.flush();
            if (!(layoutBox.getHeight() >= f7 * 0.9f)) continue;
            layoutBox = new LayoutBox(f6 * 0.9f);
            pDFStyle.setFont(pDFStyle.getFont(), i2 - 1);
            layoutBox.addText("Digitally Signed by " + this.e, pDFStyle, Locale.getDefault());
            break;
        }
        pDFCanvas.drawLayoutBox(layoutBox, f2 + f6 * 0.05f, f5 - f7 * 0.05f);
    }

    public String getDefaultName() {
        block4: {
            try {
                X509Certificate[] x509CertificateArray = this.getCertificates();
                if (x509CertificateArray == null || x509CertificateArray.length <= 0) break block4;
                return (String)id.a(x509CertificateArray[0].getSubjectX500Principal()).get("CN");
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return super.getDefaultName();
    }

    static class a_
    extends PKCS7SignatureHandler {
        a_() {
        }

        public String getFilter() {
            return "Adobe.PPKLite";
        }

        public String getHashAlgorithm() {
            return "SHA1";
        }

        public String getSubFilter() {
            return "adbe.x509.rsa_sha1";
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void prepareToSign(KeyStore keyStore, String string, char[] cArray) throws GeneralSecurityException {
            super.prepareToSign(keyStore, string, cArray);
            this.putNumericValue("R", 65539.0f);
            X509Certificate x509Certificate = this.pkcs7.b()[0];
            if (!((Object)x509Certificate.getIssuerDN()).equals(x509Certificate.getSubjectDN())) {
                throw new CertificateException("Must use self-signed certificate with Self-Sign handler");
            }
            if (!x509Certificate.getSigAlgName().equals("MD5withRSA")) {
                throw new CertificateException("Must use MD5withRSA certificate with Self-Sign handler, not " + x509Certificate.getSigAlgName());
            }
            String string2 = FormSignature.getIssuerField(x509Certificate, "C");
            if (string2 != null && string2.length() > 2) {
                throw new CertificateException("Country is longer than 2 letters - not allowed with Self-Sign handler");
            }
        }
    }

    static class b_
    extends PKCS7SignatureHandler {
        protected b_() {
            this.setCustomAppearance(new PDFCanvas("logo.VeriSign", 1.0f), 0.0f, 400.0f, 1000.0f, 700.0f);
        }

        public String getFilter() {
            return "VeriSign.PPKVS";
        }

        public String getHashAlgorithm() {
            return "MD5";
        }

        public String getSubFilter() {
            return "adbe.pkcs7.detached";
        }

        protected void prepareToSign(KeyStore keyStore, String string, char[] cArray) throws GeneralSecurityException {
            super.prepareToSign(keyStore, string, cArray);
            this.putNumericValue("R", 65537.0f);
            if (FormSignature.verifyCertificates(this.getCertificates(), FormSignature.loadDefaultKeyStore(), null, this.getSignatureDate()) != null) {
                PDF.k.warning("SG1", "Certificate expired or not signed by VeriSign CA - PDF may be considered invalid");
            }
        }
    }
}

