/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2;

import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import org.faceless.pdf2.CMap;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFFont;
import org.faceless.pdf2.bd;
import org.faceless.pdf2.cd;
import org.faceless.pdf2.gc;
import org.faceless.pdf2.hb;
import org.faceless.pdf2.hc;
import org.faceless.pdf2.hd;
import org.faceless.pdf2.ic;
import org.faceless.pdf2.lb;
import org.faceless.pdf2.sc;
import org.faceless.pdf2.uc;
import org.faceless.pdf2.wc;
import org.faceless.pdf2.xc;
import org.faceless.util.SemiSeekableInputStream;
import org.faceless.util.SparseArray;

public final class StandardCJKFont
extends PDFFont {
    private static final String[] p = new String[]{"STSong-Light", "MSung-Light", "MHei-Medium", "HeiseiMin-W3", "HeiseiKakuGo-W5", "HYGoThic-Medium", "HYSMyeongJo-Medium", "STSong-Light-SansSerif"};
    private static final String[] q = new String[]{"STSo", "MSun", "MHei", "KaMi", "KaGo", "HyGo", "HySm", "STSo"};
    public static final int STSONG = 0;
    public static final int MSUNG = 1;
    public static final int MHEI = 2;
    public static final int HEISEIMIN = 3;
    public static final int HEISEIKAKUGO = 4;
    public static final int HYGOTHIC = 5;
    public static final int HYSMYEONGJO = 6;
    public static final int REGULAR = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    private static final ic[] r = new ic[p.length];
    private static final SparseArray[] s = new SparseArray[p.length];
    private final int t;
    private final int u;
    private final int v;
    private static final int[] w = new int[]{14098, 17407, 17600, 18845, 18961, 19087};
    private static final int[] x = new int[]{7716, 9896, 22126, 22352, 29063, 30283};
    private static final int[] y = new int[]{8283, 8358, 8719, 9353, 15443, 20316, 23057};
    private static final int[] z = new int[]{9332, 18154, 18351};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StandardCJKFont(int n2, int n3) {
        Object object = r;
        synchronized (r) {
            int[] nArray;
            Object object222;
            ic ic2;
            Object object3;
            Object object4;
            if (n2 < 0) throw new IllegalArgumentException("No such font (" + n2 + ")");
            if (n2 >= p.length) {
                throw new IllegalArgumentException("No such font (" + n2 + ")");
            }
            this.t = n2;
            if (r[this.t] == null) {
                object4 = this.getClass().getResourceAsStream("resources/fontmetrics/" + p[this.t]);
                if (object4 == null) {
                    throw new RuntimeException("Can't initialize " + p[this.t] + ": no resources/fontmetrics/" + p[this.t]);
                }
                try {
                    try {
                        object3 = new hd(new SemiSeekableInputStream((InputStream)object4, 80));
                        StandardCJKFont.r[this.t] = (ic)new cd((hd)object3).a();
                        ((hd)object3).close();
                        StandardCJKFont.s[this.t] = StandardCJKFont.a(r[this.t].k("Widths"));
                    }
                    catch (IOException iOException) {
                        throw gc.a("Can't initialize " + p[this.t], iOException);
                    }
                    ic2 = null;
                    {
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    try {
                        ((InputStream)object4).close();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception object222) {}
                ((InputStream)object4).close();
            }
            // ** MonitorExit[object] (shouldn't be in output)
            object = r[this.t];
            this.a();
            this.u = n3;
            this.v = ((hc)object).l("DW").o();
            object4 = ((hc)object).i("Name").o();
            if (n3 == 1) {
                object4 = (String)object4 + ",Bold";
            } else if (n3 == 2) {
                object4 = (String)object4 + ",Italic";
            } else if (n3 == 3) {
                object4 = (String)object4 + ",BoldItalic";
            } else if (n3 != 0) {
                throw new IllegalArgumentException("Invalid style: " + n3 + " not in range 0-3");
            }
            this.b("Subtype", wc.b("Type0"));
            this.b("BaseFont", wc.b((String)object4));
            object3 = new ic("Font");
            this.a("DescendantFonts", 1).c((gc)object3);
            ((ic)object3).a();
            ((hc)object3).b("Subtype", wc.b("CIDFontType2"));
            ((hc)object3).b("BaseFont", wc.b((String)object4));
            ((hc)object3).b("DW", ((hc)object).l("DW"));
            ((hc)object3).b("W", ((hc)object).k("Widths"));
            ic ic3 = new ic();
            ic3.b("Registry", new bd("Adobe", hb.PDF));
            ic3.b("Ordering", ((hc)object).m("Ordering"));
            ic3.b("Supplement", xc.b(0));
            ((hc)object3).b("CIDSystemInfo", ic3);
            ic2 = ((hc)object3).p("FontDescriptor");
            ic2.a();
            ic2.b("Type", wc.b("FontDescriptor"));
            ic2.b("FontName", wc.b((String)object4));
            ic2.b("ItalicAngle", ((hc)object).h("ItalicAngle"));
            ic2.b("Ascent", ((hc)object).l("Ascent"));
            ic2.b("Descent", ((hc)object).l("Descent"));
            ic2.b("Flags", ((hc)object).h("Flags"));
            ic2.b("StemV", ((hc)object).h("StemV"));
            ic2.b("CapHeight", ((hc)object).h("CapHeight"));
            ic2.b("XHeight", ((hc)object).h("XHeight"));
            ic2.b("FontBBox", ((hc)object).h("FontBBox"));
            ic2.p("Style").b("Panose", ((hc)object).h("Panose"));
            object222 = ((hc)object).i("Encoding").o();
            CMap cMap = CMap.a((String)object222);
            if (cMap == null) {
                throw new IllegalArgumentException("Unknown cmap " + (String)object222);
            }
            String string = ((hc)object).m("Ordering").a(hb.PDF);
            if (string.equals("CNS1")) {
                nArray = w;
            } else if (string.equals("Japan1")) {
                nArray = y;
            } else if (string.equals("GB1")) {
                nArray = x;
            } else {
                if (!string.equals("Korea1")) throw new IllegalStateException("Unknown order '" + string + "'");
                nArray = z;
            }
            this.b(this.a(cMap, nArray));
            return;
        }
    }

    int getCIDWidth(int n2) {
        Short s2 = (Short)s[this.t].get(n2);
        int n3 = s2 == null ? this.v : s2.intValue();
        return n3;
    }

    int getCIDTop(int n2) {
        return (int)this.getAscender() * 1000;
    }

    int getCIDBottom(int n2) {
        return (int)this.getDescender() * 1000;
    }

    int getCIDKerning(int n2, int n3) {
        return 0;
    }

    public float getDefaultLeading() {
        return (float)r[this.t].l("Leading").o() / 1000.0f;
    }

    public float getDescender() {
        return (float)r[this.t].l("Descent").o() / 1000.0f;
    }

    public float getAscender() {
        return (float)r[this.t].l("Ascent").o() / 1000.0f;
    }

    public float getXHeight() {
        return (float)r[this.t].l("XHeight").o() / 1000.0f;
    }

    public float getUnderlinePosition() {
        return (float)r[this.t].l("UnderlinePos").o() / 1000.0f;
    }

    public float getUnderlineThickness() {
        return (float)r[this.t].l("UnderlineWidth").o() / 1000.0f;
    }

    public float getStrikeoutPosition() {
        return (float)r[this.t].l("StrikeoutPos").o() / 1000.0f;
    }

    public float getStrikeoutThickness() {
        return (float)r[this.t].l("StrikeoutWidth").o() / 1000.0f;
    }

    public float getSuperscriptPosition() {
        return 0.5f;
    }

    public float getSubscriptPosition() {
        return 0.0f;
    }

    public float getSubscriptSize() {
        return 0.5f;
    }

    public boolean isMonospace() {
        return false;
    }

    String y() {
        return q[this.t];
    }

    PDFFont z() {
        return this;
    }

    boolean w() {
        return false;
    }

    boolean t() {
        boolean bl = (this.u & 2) == 2;
        return bl;
    }

    boolean u() {
        boolean bl = (this.u & 1) == 1;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean v() {
        if (this.t == 2) return false;
        if (this.t == 4) return false;
        if (this.t == 5) return false;
        return true;
    }

    public PDFFont versionBold() {
        StandardCJKFont standardCJKFont = this.u() ? this : new StandardCJKFont(this.t, this.u | 1);
        return standardCJKFont;
    }

    public PDFFont versionItalic() {
        StandardCJKFont standardCJKFont = this.t() ? this : new StandardCJKFont(this.t, this.u | 2);
        return standardCJKFont;
    }

    public PDFFont versionNonItalic() {
        StandardCJKFont standardCJKFont = !this.t() ? this : new StandardCJKFont(this.t, this.u & 0xFFFFFFFD);
        return standardCJKFont;
    }

    public PDFFont versionNonBold() {
        StandardCJKFont standardCJKFont = !this.u() ? this : new StandardCJKFont(this.t, this.u & 0xFFFFFFFE);
        return standardCJKFont;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PDFFont versionRegular() {
        StandardCJKFont standardCJKFont;
        if (!this.t() && !this.u()) {
            standardCJKFont = this;
            return standardCJKFont;
        }
        standardCJKFont = new StandardCJKFont(this.t, this.u & 0xFFFFFFFC);
        return standardCJKFont;
    }

    sc A() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private lb a(final CMap cMap, final int[] nArray) {
        final int[] nArray2 = new int[nArray[nArray.length - 1] + 1];
        final BitSet bitSet = new BitSet();
        int n2 = 1;
        int n3 = 1;
        while (true) {
            int n4;
            int n5;
            if (n3 >= 195104) {
                lb lb2;
                lb lb3 = lb2 = new lb(cMap, null){

                    boolean b() {
                        if (PDF.p >= 5) {
                            return bitSet.intersects(this.c());
                        }
                        BitSet bitSet2 = (BitSet)bitSet.clone();
                        bitSet2.and(this.c());
                        return bitSet2.length() > 0;
                    }
                };
                lb3.getClass();
                lb2.a(new lb.a_(lb3){

                    int a(int n2) {
                        if (n2 == 160) {
                            n2 = 32;
                        }
                        return cMap.getCID(PDFFont.f(n2));
                    }

                    int b(int n2) {
                        return nArray2[n2];
                    }

                    String b() {
                        return lb2.b() ? cMap.b() : cMap.e().b();
                    }

                    CMap a() {
                        return null;
                    }

                    int[] c() {
                        return nArray;
                    }
                });
                return lb2;
            }
            int n6 = PDFFont.f(n3);
            if (cMap.isCompleteCode(n6, n2) && (n5 = cMap.getCID(n6)) != 0 && ((n4 = nArray2[n5]) == 0 || n6 < n4)) {
                nArray2[n5] = n6;
                if (cMap.e().getCID(n6) == 0) {
                    bitSet.set(n5);
                }
            }
            if (++n3 == 256 && n2 == 1) {
                n3 = 1;
                n2 = 2;
                continue;
            }
            if (n3 == 65536) {
                n3 = 131072;
                n2 = 4;
                continue;
            }
            if (n3 != 173791) continue;
            n3 = 194560;
        }
    }

    private static SparseArray a(uc uc2) {
        SparseArray sparseArray = new SparseArray(256);
        int n2 = 0;
        while (n2 < uc2.o()) {
            int n3 = uc2.h(n2++).o();
            if (uc2.d(n2) instanceof uc) {
                uc uc3 = uc2.g(n2++);
                for (int i2 = 0; i2 < uc3.o(); ++i2) {
                    sparseArray.put(n3 + i2, new Short((short)uc3.h(i2).o()));
                }
                continue;
            }
            int n4 = uc2.h(n2++).o();
            Short s2 = new Short((short)uc2.h(n2++).o());
            for (int i3 = n3; i3 <= n4; ++i3) {
                sparseArray.put(i3, s2);
            }
        }
        return sparseArray;
    }

    static StandardCJKFont s(String string) {
        int n2 = 0;
        while (true) {
            StandardCJKFont standardCJKFont;
            block7: {
                if (n2 >= p.length) break;
                if (!q[n2].equals(string)) break block7;
                standardCJKFont = new StandardCJKFont(n2, 0);
                return standardCJKFont;
            }
            if (string.startsWith(p[n2])) {
                standardCJKFont = new StandardCJKFont(n2, 0);
                if (string.equals(p[n2] + "-" + r[standardCJKFont.t].i("Encoding").o())) {
                    return standardCJKFont;
                }
            }
            ++n2;
        }
        return null;
    }
}

