/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.gc;
import org.faceless.util.Base64;
import org.faceless.util.asn1.ASN1InputStream;
import org.faceless.util.asn1.ASN1Integer;
import org.faceless.util.asn1.ASN1Object;
import org.faceless.util.asn1.ASN1Oid;
import org.faceless.util.asn1.ASN1OutputStream;
import org.faceless.util.asn1.ASN1Sequence;
import org.faceless.util.asn1.ASN1Set;
import org.faceless.util.asn1.ASN1String;
import org.faceless.util.asn1.AttributeSet;
import org.faceless.util.asn1.ContentInfo;
import org.faceless.util.asn1.DistinguishedName;
import org.faceless.util.asn1.SignedData;
import org.faceless.util.asn1.SignerInfo;
import org.faceless.util.asn1.TSTInfo;
import org.faceless.util.asn1.TimeStampRequest;
import org.faceless.util.asn1.TimeStampResponse;

final class id {
    private AttributeSet a;
    private AttributeSet b;
    private X509Certificate[] c;
    private X509Certificate[] d;
    private X509CRL[] e;
    private Calendar f;
    private X509Certificate g;
    private ASN1Oid h;
    private ASN1Oid i;
    private byte[] j;
    private byte[] k;
    private byte[] l;
    private final boolean m;
    private URL n;
    private transient PrivateKey o;
    private Provider p;
    private MessageDigest q;
    private Signature r;

    id(X509Certificate[] x509CertificateArray, byte[] byArray) throws NoSuchAlgorithmException, InvalidKeyException {
        this.g = x509CertificateArray[0];
        this.h = ASN1Oid.ID_SHA1;
        this.i = ASN1Oid.RSAENCRYPTION;
        this.c = (X509Certificate[])x509CertificateArray.clone();
        this.e = null;
        this.b = null;
        this.a = null;
        this.m = true;
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
            ASN1String aSN1String = (ASN1String)aSN1InputStream.readObject();
            this.j = aSN1String.getBytes();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    id(byte[] byArray) throws GeneralSecurityException, IOException {
        X509Certificate x509Certificate;
        int n2;
        int n3;
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        ContentInfo contentInfo = ContentInfo.getInstance(aSN1InputStream.readObject());
        SignedData signedData = (SignedData)contentInfo.getContent();
        SignerInfo signerInfo = signedData.getSignerInfo(0);
        this.c = new X509Certificate[signedData.getNumCertificates()];
        for (n3 = 0; n3 < this.c.length; ++n3) {
            this.c[n3] = signedData.getCertificate(n3);
        }
        this.e = new X509CRL[signedData.getNumCRLs()];
        for (n3 = 0; n3 < this.e.length; ++n3) {
            this.e[n3] = signedData.getCRL(n3);
        }
        X500Principal x500Principal = signerInfo.getIssuer();
        BigInteger bigInteger = signerInfo.getSerialNumber();
        for (n2 = 0; n2 < this.c.length; ++n2) {
            x509Certificate = this.c[n2];
            if (!x509Certificate.getIssuerX500Principal().equals(x500Principal) || !x509Certificate.getSerialNumber().equals(bigInteger)) continue;
            this.g = this.c[n2];
        }
        this.j = signerInfo.getEncryptedDigest();
        this.b = signerInfo.getAuthenticatedAttributes();
        this.a = signerInfo.getUnauthenticatedAttributes();
        this.h = signerInfo.getDigestAlgorithm();
        this.i = signerInfo.getDigestEncryptionAlgorithm();
        n2 = 0;
        if (signedData.getContentInfo().getContent() != null) {
            this.k = ((ASN1String)signedData.getContentInfo().getContent()).getBytes();
        } else {
            Serializable serializable = x509Certificate = this.b == null ? null : this.b.get(ASN1Oid.PKCS_9_AT_MESSAGEDIGEST);
            if (x509Certificate != null) {
                this.k = ((ASN1String)((ASN1Set)((Object)x509Certificate)).get(0)).getBytes();
            } else {
                n2 = 1;
            }
        }
        this.m = n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    id(KeyStore keyStore, String string, char[] cArray, String string2, int n2) throws GeneralSecurityException {
        this.p = keyStore.getProvider();
        this.o = (PrivateKey)keyStore.getKey(string, cArray);
        if (this.o == null) {
            throw new UnrecoverableKeyException("No key \"" + string + "\" in keystore");
        }
        if (this.o.getAlgorithm().equals("RSA")) {
            this.i = ASN1Oid.RSAENCRYPTION;
        } else if (this.o.getAlgorithm().equals("DSA")) {
            this.i = ASN1Oid.ID_DSA;
        } else {
            if (!this.o.getAlgorithm().equals("EC")) {
                if (!this.o.getAlgorithm().equals("ECDSA")) throw new NoSuchAlgorithmException("Unknown Key Algorithm " + this.o.getAlgorithm());
            }
            this.i = ASN1Oid.ID_ECDSA_WITH_SHA1;
        }
        if (n2 == 0) {
            this.h = ASN1Oid.SHA1WITHRSAENCRYPTION;
            this.b = null;
            this.m = false;
        } else if (n2 == 1) {
            if (string2.equalsIgnoreCase("MD5")) {
                this.h = ASN1Oid.MD5;
            } else if (string2.equalsIgnoreCase("SHA1")) {
                this.h = ASN1Oid.ID_SHA1;
            } else if (string2.equalsIgnoreCase("SHA256")) {
                this.h = ASN1Oid.ID_SHA256;
            } else if (string2.equalsIgnoreCase("SHA384")) {
                this.h = ASN1Oid.ID_SHA384;
            } else if (string2.equalsIgnoreCase("SHA512")) {
                this.h = ASN1Oid.ID_SHA512;
            } else {
                if (!string2.equalsIgnoreCase("RIPEMD160")) throw new NoSuchAlgorithmException("Unknown Hash Algorithm " + string2);
                this.h = ASN1Oid.RIPEMD160;
            }
            this.b = new AttributeSet();
            this.m = false;
        } else {
            if (n2 != 2) throw new IllegalArgumentException("Unknown mode");
            this.h = ASN1Oid.ID_SHA1;
            this.b = null;
            this.m = true;
        }
        Certificate[] certificateArray = keyStore.getCertificateChain(string);
        this.c = new X509Certificate[certificateArray.length];
        for (int i2 = 0; i2 < certificateArray.length; ++i2) {
            this.c[i2] = (X509Certificate)certificateArray[i2];
        }
        this.e = null;
        this.g = this.c[0];
        boolean[] blArray = this.g.getKeyUsage();
        if (blArray != null && !blArray[0]) {
            throw new CertificateException("Specified certificate cannot be used for digital signatures");
        }
        block23: while (true) {
            boolean bl = false;
            Object object = keyStore.aliases();
            while (true) {
                X509Certificate x509Certificate;
                Principal principal;
                Principal principal2;
                Serializable serializable;
                Object object2;
                if (object.hasMoreElements()) {
                    object2 = object.nextElement();
                    if (!keyStore.isCertificateEntry((String)object2)) continue;
                    serializable = (X509Certificate)keyStore.getCertificate((String)object2);
                    principal2 = ((X509Certificate)serializable).getSubjectDN();
                } else {
                    if (bl) continue block23;
                    if (this.c[0].getNonCriticalExtensionOIDs() == null) return;
                    if (!this.c[0].getNonCriticalExtensionOIDs().contains(ASN1Oid.ADOBE_TIMESTAMPSERVICE.toNumericString())) return;
                    try {
                        object = this.c[0].getExtensionValue(ASN1Oid.ADOBE_TIMESTAMPSERVICE.toNumericString());
                        object2 = new ASN1InputStream((byte[])object);
                        object = ((ASN1String)((ASN1InputStream)object2).readObject()).getBytes();
                        ((FilterInputStream)object2).close();
                        object2 = new ASN1InputStream((byte[])object);
                        serializable = (ASN1Sequence)((ASN1InputStream)object2).readObject();
                        ((FilterInputStream)object2).close();
                        int n3 = ((ASN1Integer)((ASN1Sequence)serializable).get(0)).intValue();
                        String string3 = ((ASN1String)((ASN1Sequence)serializable).getTaggedObject(6).get()).getString();
                        this.a(new URL(string3));
                        return;
                    }
                    catch (Exception exception) {
                        PDF.k.warning("PK1", "Unable to extract 1.2.830.113583.1.1.9.1 OID from Certificate", exception);
                    }
                    return;
                }
                for (int i3 = 0; !bl && i3 < this.c.length; bl |= ((Object)principal2).equals(principal = (x509Certificate = this.c[i3]).getIssuerDN()) && !Arrays.asList(this.c).contains(serializable), ++i3) {
                }
                if (!bl) continue;
                X509Certificate[] x509CertificateArray = new X509Certificate[this.c.length + 1];
                System.arraycopy(this.c, 0, x509CertificateArray, 0, this.c.length);
                x509CertificateArray[this.c.length] = serializable;
                this.c = x509CertificateArray;
            }
            break;
        }
    }

    private static String a(ASN1Oid aSN1Oid, ASN1Oid aSN1Oid2) {
        String string;
        String string2 = id.a(aSN1Oid);
        if (aSN1Oid2.equals(ASN1Oid.RSAENCRYPTION)) {
            string = "RSA";
        } else if (aSN1Oid2.equals(ASN1Oid.SHA1WITHRSAENCRYPTION)) {
            string = "RSA";
        } else if (aSN1Oid2.equals(ASN1Oid.ID_DSA)) {
            string = "DSA";
        } else if (aSN1Oid2.equals(ASN1Oid.ID_ECDSA_WITH_SHA1)) {
            string = "ECDSA";
        } else {
            throw new IllegalArgumentException("Unknown encryption algorithm \"" + aSN1Oid2 + "\"");
        }
        if ("SHA-256".equals(string2)) {
            string2 = "SHA256";
        } else if ("SHA-384".equals(string2)) {
            string2 = "SHA384";
        } else if ("SHA-512".equals(string2)) {
            string2 = "SHA512";
        }
        String string3 = string2 + "with" + string;
        return string3;
    }

    private static String a(ASN1Oid aSN1Oid) {
        if (aSN1Oid.equals(ASN1Oid.MD5)) {
            return "MD5";
        }
        if (aSN1Oid.equals(ASN1Oid.MD2)) {
            return "MD2";
        }
        if (aSN1Oid.equals(ASN1Oid.ID_SHA1)) {
            return "SHA1";
        }
        if (aSN1Oid.equals(ASN1Oid.ID_SHA256)) {
            return "SHA-256";
        }
        if (aSN1Oid.equals(ASN1Oid.RIPEMD160)) {
            return "RIPEMD160";
        }
        if (aSN1Oid.equals(ASN1Oid.ID_SHA384)) {
            return "SHA-384";
        }
        if (aSN1Oid.equals(ASN1Oid.ID_SHA512)) {
            return "SHA-512";
        }
        throw new IllegalArgumentException("Unknown digest algorithm \"" + aSN1Oid + "\"");
    }

    X509Certificate a() {
        return this.g;
    }

    X509Certificate[] b() {
        return (X509Certificate[])this.c.clone();
    }

    static Map a(X500Principal x500Principal) {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(x500Principal.getEncoded());
            return DistinguishedName.getInstance(aSN1InputStream.readObject()).getFields();
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void c() throws NoSuchAlgorithmException, InvalidKeyException {
        this.q = MessageDigest.getInstance(id.a(this.h));
        this.r = null;
        if (this.p != null) {
            try {
                this.r = Signature.getInstance(id.a(this.h, this.i), this.p);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        if (this.r == null) {
            this.r = Signature.getInstance(id.a(this.h, this.i));
        }
        if (this.o == null) {
            this.r.initVerify(this.g.getPublicKey());
        } else {
            this.r.initSign(this.o);
        }
        if (this.m) {
            final MessageDigest messageDigest = this.q;
            this.q = new MessageDigest(messageDigest.getAlgorithm()){

                protected byte[] engineDigest() {
                    throw new UnsupportedOperationException();
                }

                protected int engineDigest(byte[] byArray, int n2, int n3) {
                    throw new UnsupportedOperationException();
                }

                protected int engineGetDigestLength() {
                    throw new UnsupportedOperationException();
                }

                protected void engineReset() {
                    throw new UnsupportedOperationException();
                }

                protected void engineUpdate(byte by) {
                    throw new UnsupportedOperationException();
                }

                protected void engineUpdate(byte[] byArray, int n2, int n3) {
                    throw new UnsupportedOperationException();
                }

                public void reset() {
                    messageDigest.reset();
                }

                public void update(byte[] byArray) {
                    this.update(byArray, 0, byArray.length);
                }

                public void update(byte[] byArray, int n2, int n3) {
                    messageDigest.update(byArray, n2, n3);
                    try {
                        id.this.r.update(byArray, n2, n3);
                    }
                    catch (SignatureException signatureException) {
                        throw gc.a(signatureException);
                    }
                }

                public void update(byte by) {
                    messageDigest.update(by);
                    try {
                        id.this.r.update(by);
                    }
                    catch (SignatureException signatureException) {
                        throw gc.a(signatureException);
                    }
                }

                public byte[] digest(byte[] byArray) {
                    this.update(byArray);
                    return this.digest();
                }

                public int digest(byte[] byArray, int n2, int n3) throws DigestException {
                    return messageDigest.digest(byArray, n2, n3);
                }

                public byte[] digest() {
                    return messageDigest.digest();
                }
            };
        }
    }

    MessageDigest d() {
        if (this.l != null) {
            throw new IllegalStateException("Cannot update digest after call to setDigest");
        }
        return this.q;
    }

    void a(byte[] byArray) {
        if (this.m) {
            throw new IllegalStateException("Cannot set digest in PKCS#1 mode");
        }
        if (byArray.length != this.q.getDigestLength()) {
            throw new IllegalArgumentException("Digest must be " + this.q.getDigestLength() + " bytes");
        }
        this.l = byArray;
    }

    boolean e() throws SignatureException {
        block10: {
            block12: {
                block11: {
                    block9: {
                        if (!this.m) break block9;
                        break block10;
                    }
                    if (this.b == null) break block11;
                    this.r.update(this.b.getEncoded());
                    break block10;
                }
                if (this.l == null) break block12;
                this.r.update(this.l);
                break block10;
            }
            if (this.q != null) {
                this.r.update(this.q.digest());
            }
        }
        return this.r.verify(this.j);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void f() throws GeneralSecurityException, IOException {
        Object object;
        if (!this.m) {
            object = this.l == null ? this.q.digest() : this.l;
            Object object2 = object;
            if (this.b != null) {
                this.b.put(ASN1Oid.PKCS_9_AT_CONTENTTYPE, new ASN1Set(ASN1Oid.DATA));
                this.b.put(ASN1Oid.PKCS_9_AT_MESSAGEDIGEST, new ASN1Set(new ASN1String((byte[])object)));
                this.r.update(this.b.getEncoded());
            } else {
                this.r.update((byte[])object);
            }
        }
        this.j = this.r.sign();
        if (this.n != null) {
            object = MessageDigest.getInstance(id.a(this.h));
            object.update(this.j);
            ContentInfo contentInfo = this.a(this.h, object.digest(), this.n);
            this.a = new AttributeSet();
            this.a.put(ASN1Oid.ID_AA_SIGNATURETIMESTAMPTOKEN, new ASN1Set(contentInfo));
        }
    }

    byte[] g() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.write(new ASN1String(this.j));
            aSN1OutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    void a(OutputStream outputStream) throws IOException, GeneralSecurityException {
        this.a(outputStream, this.j, this.b, this.a);
    }

    private void a(OutputStream outputStream, byte[] byArray, AttributeSet attributeSet, AttributeSet attributeSet2) throws IOException, GeneralSecurityException {
        SignerInfo signerInfo = new SignerInfo(this.g.getIssuerX500Principal(), this.g.getSerialNumber(), this.h, attributeSet, this.i, byArray, attributeSet2);
        ContentInfo contentInfo = new ContentInfo(ASN1Oid.DATA, (ASN1Object)(attributeSet == null ? new ASN1String(this.k) : null));
        SignedData signedData = new SignedData(contentInfo, this.c, null, signerInfo);
        ContentInfo contentInfo2 = new ContentInfo(ASN1Oid.SIGNEDDATA, (ASN1Object)signedData);
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(outputStream);
        aSN1OutputStream.write(contentInfo2);
        aSN1OutputStream.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int a(int n2) {
        Object object;
        Serializable serializable;
        int n3;
        Object object2;
        if (this.n != null && n2 == 0) {
            return 0;
        }
        if (this.o instanceof RSAPrivateCrtKey) {
            object2 = (RSAPrivateCrtKey)this.o;
            n3 = object2.getPrimeP().multiply(object2.getPrimeQ()).bitLength() / 8;
        } else if (this.o instanceof DSAPrivateKey) {
            object2 = (DSAPrivateKey)this.o;
            serializable = object2.getParams().getQ();
            n3 = new ASN1Sequence(new ASN1Integer((BigInteger)serializable), new ASN1Integer((BigInteger)serializable)).encodedLength();
        } else {
            if (!(this.o instanceof ECPrivateKey)) {
                return 0;
            }
            object2 = (ECPrivateKey)this.o;
            serializable = object2.getParams().getOrder();
            n3 = new ASN1Sequence(new ASN1Integer((BigInteger)serializable), new ASN1Integer((BigInteger)serializable)).encodedLength();
        }
        object2 = new byte[n3];
        serializable = null;
        if (this.b != null) {
            object = new byte[this.q.getDigestLength()];
            serializable = new AttributeSet();
            ((AttributeSet)serializable).put(ASN1Oid.PKCS_9_AT_CONTENTTYPE, new ASN1Set(ASN1Oid.DATA));
            ((AttributeSet)serializable).put(ASN1Oid.PKCS_9_AT_MESSAGEDIGEST, new ASN1Set(new ASN1String((byte[])object)));
        }
        try {
            object = new ByteArrayOutputStream();
            this.a((OutputStream)object, (byte[])object2, (AttributeSet)serializable, null);
            return ((ByteArrayOutputStream)object).size() + n2;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    void a(URL uRL) {
        this.n = uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ContentInfo a(ASN1Oid aSN1Oid, byte[] byArray, URL uRL) throws GeneralSecurityException, IOException {
        TimeStampRequest timeStampRequest = new TimeStampRequest(aSN1Oid, byArray);
        byte[] byArray2 = timeStampRequest.getEncoded();
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/timestamp-query");
        httpURLConnection.setRequestProperty("Accept", "*/*");
        httpURLConnection.setRequestProperty("User-Agent", "Big Faceless PDF Library v" + PDF.VERSION + " (Java " + System.getProperty("java.version") + "/" + System.getProperty("os.name") + ") - http://bfo.com");
        if (uRL.getUserInfo() != null) {
            httpURLConnection.setRequestProperty("Authorization", "Basic " + Base64.encode(uRL.getUserInfo().getBytes("ISO-8859-1")));
        }
        httpURLConnection.setRequestProperty("Content-Length", "" + byArray2.length);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(false);
        OutputStream outputStream = null;
        try {
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray2);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(httpURLConnection.getInputStream());
        try {
            TimeStampResponse timeStampResponse = TimeStampResponse.getInstance(aSN1InputStream.readObject());
            if (timeStampResponse.getStatus() >= 2) throw new GeneralSecurityException("TimeStamp failed with " + timeStampResponse.getStatus() + ": msg=" + timeStampResponse.getStatusString() + " flags=0x" + Integer.toHexString(timeStampResponse.getFailureReason()));
            ContentInfo contentInfo = timeStampResponse.getContentInfo();
            SignedData signedData = (SignedData)contentInfo.getContent();
            TSTInfo tSTInfo = (TSTInfo)signedData.getContentInfo().getContent();
            if (!tSTInfo.matches(timeStampRequest)) throw new GeneralSecurityException("Request does not match response");
            return contentInfo;
        }
        catch (RuntimeException runtimeException) {
            GeneralSecurityException generalSecurityException = new GeneralSecurityException("TimeStamp Failed");
            if (PDF.p < 4) throw generalSecurityException;
            generalSecurityException.initCause(runtimeException);
            throw generalSecurityException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void b(byte[] byArray) throws GeneralSecurityException, IOException {
        if (this.a == null) {
            return;
        }
        ASN1Set aSN1Set = this.a.get(ASN1Oid.ID_AA_SIGNATURETIMESTAMPTOKEN);
        ASN1Set aSN1Set2 = aSN1Set;
        if (aSN1Set2 == null) return;
        ContentInfo contentInfo = ContentInfo.getInstance(aSN1Set2.get(0));
        SignedData signedData = (SignedData)contentInfo.getContent();
        SignerInfo signerInfo = signedData.getSignerInfo(0);
        TSTInfo tSTInfo = (TSTInfo)signedData.getContentInfo().getContent();
        X509Certificate x509Certificate = signedData.getCertificate(signerInfo);
        if (!signerInfo.verify(x509Certificate, byArray, null)) {
            throw new GeneralSecurityException("TimeStamp signature invalid");
        }
        x509Certificate.checkValidity(tSTInfo.getTime().getTime());
        List<String> list = x509Certificate.getExtendedKeyUsage();
        if (list == null) throw new CertificateException("Certificate does not have id_kp_timeStamping in " + list);
        if (list.size() != 1) throw new CertificateException("Certificate does not have id_kp_timeStamping in " + list);
        if (!ASN1Oid.ID_KP_TIMESTAMPING.equals(list.get(0))) {
            throw new CertificateException("Certificate does not have id_kp_timeStamping in " + list);
        }
        this.f = tSTInfo.getTime();
        this.d = new X509Certificate[signedData.getNumCertificates()];
        int n2 = 0;
        while (n2 < this.d.length) {
            this.d[n2] = signedData.getCertificate(n2);
            if (this.d[n2] == x509Certificate && n2 != 0) {
                this.d[n2] = this.d[0];
                this.d[0] = x509Certificate;
            }
            ++n2;
        }
    }

    X509Certificate[] h() throws IOException, GeneralSecurityException {
        if (this.d == null) {
            this.b(this.j);
        }
        return this.d;
    }

    Calendar i() throws IOException, GeneralSecurityException {
        if (this.f == null) {
            this.b(this.j);
        }
        return this.f;
    }
}

