/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.StreamPrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.Sides;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.faceless.pdf2.FormElement;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFAction;
import org.faceless.pdf2.PDFAnnotation;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.PDFParser;
import org.faceless.pdf2.PropertyManager;
import org.faceless.pdf2.viewer2.ActionHandler;
import org.faceless.pdf2.viewer2.AnnotationComponentFactory;
import org.faceless.pdf2.viewer2.DocumentPanelEvent;
import org.faceless.pdf2.viewer2.DocumentPanelListener;
import org.faceless.pdf2.viewer2.DocumentViewport;
import org.faceless.pdf2.viewer2.JSManager;
import org.faceless.pdf2.viewer2.MultiPageDocumentViewport;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.PagePanelEvent;
import org.faceless.pdf2.viewer2.PagePanelListener;
import org.faceless.pdf2.viewer2.SidePanel;
import org.faceless.pdf2.viewer2.SidePanelFactory;
import org.faceless.pdf2.viewer2.SinglePageDocumentViewport;
import org.faceless.pdf2.viewer2.Util;
import org.faceless.pdf2.viewer2.ViewerFeature;
import org.faceless.pdf2.viewer2.feature.ContinuousPageView;
import org.faceless.pdf2.viewer2.feature.SinglePageView;

public class DocumentPanel
extends JPanel {
    private PDF a;
    private JSManager b;
    private PDFParser c;
    private PDFViewer d;
    private DocumentViewport e;
    private JTabbedPane f;
    private JSplitPane g;
    private int h;
    private int i;
    private final Collection j;
    private final Collection k;
    private final Collection l;
    private final Collection m;
    private boolean n;
    private boolean o;
    private boolean p;
    private boolean q;
    private SidePanel r;
    private int s;
    private final int t;
    private static int u;
    private final transient PropertyChangeListener v;
    private final Collection w;

    public DocumentPanel() {
        super(new BorderLayout());
        Util.a();
        this.j = new LinkedHashSet();
        this.k = new LinkedHashSet();
        this.l = new LinkedHashSet();
        this.m = new LinkedHashSet();
        this.w = new LinkedHashSet();
        this.setOpaque(true);
        this.setBackground(Color.gray);
        this.t = u++;
        this.v = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                block11: {
                    int n2;
                    DocumentPanel.this.setDirty(true);
                    if (!"pages".equals(propertyChangeEvent.getPropertyName()) || propertyChangeEvent.getSource() != DocumentPanel.this.a) break block11;
                    PDFPage pDFPage = DocumentPanel.this.getPage();
                    if (pDFPage == null) {
                        pDFPage = DocumentPanel.this.getViewport().getRenderingPage();
                    }
                    if (pDFPage == null || DocumentPanel.this.a.getPages().contains(pDFPage)) break block11;
                    int n3 = DocumentPanel.this.getPDF().getNumberOfPages();
                    for (n2 = Math.max(0, DocumentPanel.this.s); n2 >= n3; --n2) {
                    }
                    if (n2 < 0) {
                        throw new IllegalStateException("Cannot display a PDF with no pages");
                    }
                    DocumentPanel.this.setPage(DocumentPanel.this.getPDF().getPage(n2));
                    DocumentPanel.this.raiseDocumentPanelEvent(DocumentPanelEvent.createRedrawn(DocumentPanel.this));
                }
                DocumentPanel.this.e.propertyChange(propertyChangeEvent);
            }
        };
    }

    static void a(JComponent jComponent, int n2, final DocumentPanel documentPanel) {
        AbstractAction abstractAction = new AbstractAction("pageUp"){

            public boolean isEnabled() {
                PDFPage pDFPage = documentPanel.getViewport().getRenderingPage();
                return pDFPage != null && pDFPage.getPageNumber() > 1;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                PDFPage pDFPage = documentPanel.getViewport().getRenderingPage();
                if (pDFPage.getPageNumber() > 1) {
                    documentPanel.setPage(pDFPage.getPDF().getPage(pDFPage.getPageNumber() - 2));
                }
            }
        };
        AbstractAction abstractAction2 = new AbstractAction("pageDown"){

            public boolean isEnabled() {
                PDFPage pDFPage = documentPanel.getViewport().getRenderingPage();
                return pDFPage != null && pDFPage.getPageNumber() < pDFPage.getPDF().getNumberOfPages();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                PDFPage pDFPage = documentPanel.getViewport().getRenderingPage();
                if (pDFPage != null) {
                    PDF pDF = pDFPage.getPDF();
                    if (pDFPage.getPageNumber() < pDF.getNumberOfPages()) {
                        documentPanel.setPage(pDF.getPage(pDFPage.getPageNumber()));
                    }
                }
            }
        };
        AbstractAction abstractAction3 = new AbstractAction("pageFirst"){

            public void actionPerformed(ActionEvent actionEvent) {
                PDFPage pDFPage = documentPanel.getViewport().getRenderingPage();
                if (pDFPage != null && pDFPage.getPageNumber() != 1) {
                    documentPanel.setPage(pDFPage.getPDF().getPage(0));
                }
            }
        };
        AbstractAction abstractAction4 = new AbstractAction("pageLast"){

            public void actionPerformed(ActionEvent actionEvent) {
                PDFPage pDFPage = documentPanel.getViewport().getRenderingPage();
                if (pDFPage != null) {
                    PDF pDF = pDFPage.getPDF();
                    if (pDFPage.getPageNumber() != pDF.getNumberOfPages()) {
                        documentPanel.setPage(pDF.getPage(pDF.getNumberOfPages() - 1));
                    }
                }
            }
        };
        AbstractAction abstractAction5 = new AbstractAction("debugBindings"){

            public void actionPerformed(ActionEvent actionEvent) {
                for (Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); component != null; component = component.getParent()) {
                    if (component instanceof JComponent) {
                        JComponent jComponent = (JComponent)component;
                        InputMap inputMap = jComponent.getInputMap(0);
                        InputMap inputMap2 = jComponent.getInputMap(1);
                        InputMap inputMap3 = jComponent.getInputMap(2);
                        String string = inputMap.allKeys() == null ? "[]" : Arrays.asList(inputMap.allKeys()).toString();
                        String string2 = inputMap2.allKeys() == null ? "[]" : Arrays.asList(inputMap2.allKeys()).toString();
                        String string3 = inputMap3.allKeys() == null ? "[]" : Arrays.asList(inputMap3.allKeys()).toString();
                        System.out.println("InputMap: c=" + jComponent.getClass().getName() + " f=" + string + " a=" + string2 + " w=" + string3);
                        continue;
                    }
                    System.out.println("InputMap: c=" + component.getClass().getName());
                }
            }
        };
        InputMap inputMap = jComponent.getInputMap(n2);
        ActionMap actionMap = jComponent.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(33, 0), "pageUp");
        inputMap.put(KeyStroke.getKeyStroke(34, 0), "pageDown");
        inputMap.put(KeyStroke.getKeyStroke(36, 0), "pageFirst");
        inputMap.put(KeyStroke.getKeyStroke(35, 0), "pageLast");
        actionMap.put("pageUp", abstractAction);
        actionMap.put("pageDown", abstractAction2);
        actionMap.put("pageFirst", abstractAction3);
        actionMap.put("pageLast", abstractAction4);
        inputMap = jComponent.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ctrl alt shift K"), "debugBindings");
        actionMap.put("debugBindings", abstractAction5);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DocumentViewport a() {
        ViewerFeature[] viewerFeatureArray;
        String string;
        DocumentViewport documentViewport = null;
        if (this.getPDF() != null) {
            string = (String)this.getPDF().getOption("pagelayout");
            if ("OneColumn".equals(string)) {
                documentViewport = new MultiPageDocumentViewport();
            } else if ("SinglePage".equals(string)) {
                documentViewport = new SinglePageDocumentViewport();
            }
        }
        if (documentViewport != null) return documentViewport;
        string = this.a("defaultViewport");
        if (string == null && this.d != null) {
            viewerFeatureArray = this.d.getPreferences();
            string = viewerFeatureArray.get("defaultViewport", null);
        }
        if (string == null && this.d != null) {
            viewerFeatureArray = this.d.getFeatures();
            for (int n2 = 0; string == null && n2 < viewerFeatureArray.length; ++n2) {
                if (viewerFeatureArray[n2] instanceof SinglePageView) {
                    string = "SinglePageDocumentViewport";
                    continue;
                }
                if (!(viewerFeatureArray[n2] instanceof ContinuousPageView)) continue;
                string = "MultiPageDocumentViewport";
            }
        }
        if (string != null) {
            if (string.equals("MultiPageDocumentViewport")) {
                documentViewport = new MultiPageDocumentViewport();
            } else if (string.equals("SinglePageDocumentViewport")) {
                documentViewport = new SinglePageDocumentViewport();
            } else {
                try {
                    documentViewport = (DocumentViewport)Class.forName(string, true, Thread.currentThread().getContextClassLoader()).newInstance();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (documentViewport != null) return documentViewport;
        return new MultiPageDocumentViewport();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setViewport(DocumentViewport documentViewport) {
        String string;
        String string2 = string = documentViewport == null ? null : documentViewport.getClass().getName();
        if ("org.faceless.pdf2.viewer2.SinglePageDocumentViewport".equals(string)) {
            string = "SinglePageDocumentViewport";
        } else if ("org.faceless.pdf2.viewer2.MultiPageDocumentViewport".equals(string)) {
            string = "MultiPageDocumentViewport";
        }
        Preferences preferences = this.d.getPreferences();
        preferences.put("defaultViewport", string);
        DocumentViewport documentViewport2 = this.e;
        PDFPage pDFPage = null;
        double d2 = 0.0;
        if (documentViewport2 != null) {
            pDFPage = this.getPage();
            d2 = this.getZoom();
            documentViewport2.setDocumentPanel(null);
            this.remove(documentViewport2);
        }
        if (documentViewport.getDocumentPanel() != null) {
            throw new IllegalArgumentException("Viewport associated with another DocumentPanel");
        }
        this.e = documentViewport;
        documentViewport.setDocumentPanel(this);
        DocumentPanel.a(documentViewport, 1, this);
        this.raiseDocumentPanelEvent(DocumentPanelEvent.createViewportChanged(this));
        documentViewport.addPagePanelListener(new PagePanelListener(){
            private float a;
            private SoftReference b;

            public void pageUpdated(PagePanelEvent pagePanelEvent) {
                if (pagePanelEvent.getType() == "visible") {
                    DocumentPanel.this.getJSManager().runEventPageOpen(DocumentPanel.this, pagePanelEvent.getPage());
                } else if (pagePanelEvent.getType() == "hidden") {
                    DocumentPanel.this.getJSManager().runEventPageClose(DocumentPanel.this, pagePanelEvent.getPage());
                } else if (pagePanelEvent.getType() == "redrawn") {
                    PDFPage pDFPage;
                    PDFPage pDFPage2 = pDFPage = this.b == null ? null : (PDFPage)this.b.get();
                    if (pagePanelEvent.getPage() != pDFPage || pagePanelEvent.getPagePanel().getDPI() != this.a) {
                        this.b = new SoftReference<PDFPage>(pagePanelEvent.getPage());
                        this.a = pagePanelEvent.getPagePanel().getDPI();
                        DocumentPanel.this.raiseDocumentPanelEvent(DocumentPanelEvent.createRedrawn(DocumentPanel.this));
                    }
                }
            }
        });
        documentViewport.applyComponentOrientation(ComponentOrientation.getOrientation(this.getLocale()));
        documentViewport.requestFocusInWindow();
        if (this.getPDF() != null) {
            if (this.g != null && this.g.getParent() == this) {
                int n2 = this.g.getDividerLocation();
                if (this.f == null) {
                    this.g.setTopComponent(new JPanel());
                } else {
                    this.g.setTopComponent(this.f);
                }
                this.g.setBottomComponent(documentViewport);
                this.g.setDividerLocation(n2);
            } else {
                this.add((Component)documentViewport, "Center");
            }
            if (pDFPage != null) {
                documentViewport.setPage(pDFPage, 0.0, 0.0, d2);
            }
        }
        this.invalidate();
        this.revalidate();
        this.repaint();
        documentViewport.setFocusCycleRoot(true);
    }

    private String a(String string) {
        PropertyManager propertyManager = this.getViewer() == null ? PDF.getPropertyManager() : this.getViewer().getPropertyManager();
        PropertyManager propertyManager2 = propertyManager;
        String string2 = propertyManager2 == null ? null : propertyManager2.getProperty(string);
        return string2;
    }

    public DocumentViewport getViewport() {
        if (this.e == null) {
            this.setViewport(this.a());
        }
        return this.e;
    }

    public JSManager getJSManager() {
        if (this.b == null) {
            this.b = new JSManager(this);
        }
        return this.b;
    }

    public void setJSManager(JSManager jSManager) {
        this.b = jSManager;
    }

    public PDFViewer getViewer() {
        return this.d;
    }

    void a(PDFViewer pDFViewer) {
        this.d = pDFViewer;
        this.setLocale(pDFViewer.getLocale());
        this.setJSManager(pDFViewer.getJSManager());
    }

    public void setSidePanelSize(int n2, int n3) {
        this.i = Math.max(this.i, this.g.getMinimumDividerLocation());
        this.h = n3;
    }

    public void addSidePanelFactory(SidePanelFactory sidePanelFactory) {
        if (sidePanelFactory != null) {
            this.l.add(sidePanelFactory);
        }
    }

    public void addAnnotationComponentFactory(AnnotationComponentFactory annotationComponentFactory) {
        if (annotationComponentFactory != null) {
            this.k.add(annotationComponentFactory);
        }
    }

    Collection b() {
        return Collections.unmodifiableCollection(this.k);
    }

    public void addActionHandler(ActionHandler actionHandler) {
        if (actionHandler != null) {
            this.j.add(actionHandler);
        }
    }

    public boolean runAction(PDFAction pDFAction) {
        boolean bl = false;
        while (pDFAction != null) {
            Iterator iterator = this.j.iterator();
            while (iterator.hasNext()) {
                ActionHandler actionHandler = (ActionHandler)iterator.next();
                if (!actionHandler.matches(this, pDFAction)) continue;
                actionHandler.run(this, pDFAction);
                bl = true;
                break;
            }
            pDFAction = pDFAction.getNext();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocumentPanelListener(DocumentPanelListener documentPanelListener) {
        if (documentPanelListener != null) {
            Collection collection = this.m;
            synchronized (collection) {
                this.m.add(documentPanelListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocumentPanelListener(DocumentPanelListener documentPanelListener) {
        Collection collection = this.m;
        synchronized (collection) {
            this.m.remove(documentPanelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void raiseDocumentPanelEvent(DocumentPanelEvent documentPanelEvent) {
        if (this.a("debug.Event") != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                System.err.println("Raise DocumentPanel#" + this.t + " " + documentPanelEvent);
            } else {
                System.err.println("Raise DocumentPanel#" + this.t + " " + documentPanelEvent + " (not in event thread)");
            }
        }
        DocumentPanelListener[] documentPanelListenerArray = new DocumentPanelListener[]{};
        Collection collection = this.m;
        synchronized (collection) {
            documentPanelListenerArray = this.m.toArray(documentPanelListenerArray);
        }
        int i2 = 0;
        while (i2 < documentPanelListenerArray.length) {
            documentPanelListenerArray[i2].documentUpdated(documentPanelEvent);
            ++i2;
        }
        return;
    }

    public Collection getSidePanels() {
        if (this.f == null) {
            return Collections.EMPTY_SET;
        }
        ArrayList<Component> arrayList = new ArrayList<Component>(this.f.getTabCount());
        for (int i2 = 0; i2 < this.f.getTabCount(); ++i2) {
            arrayList.add(this.f.getComponentAt(i2));
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeSidePanel(SidePanel sidePanel) {
        boolean bl;
        int n3 = this.f.indexOfComponent((Component)((Object)sidePanel));
        if (n3 < 0) return;
        boolean bl2 = bl = this.getSelectedSidePanel() == sidePanel;
        if (bl) {
            sidePanel.panelHidden();
        }
        this.f.remove((Component)((Object)sidePanel));
        sidePanel.setDocumentPanel(null);
        if (this.f.getTabCount() == 0) {
            this.r = null;
            this.g.setDividerLocation(this.g.getMinimumDividerLocation());
            this.add((Component)this.e, "Center");
            return;
        }
        if (!bl) return;
        this.f.setSelectedIndex(n3 == 0 ? 0 : n3 - 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addSidePanel(SidePanel sidePanel) {
        if (this.f.indexOfComponent((Component)((Object)sidePanel)) >= 0) return;
        Icon icon = null;
        try {
            icon = sidePanel.getIcon();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String string = UIManager.getString("PDFViewer." + sidePanel.getName());
        if (icon == null || "true".equals(this.a("useNamedSidePanels"))) {
            this.f.addTab(string, (Component)((Object)sidePanel));
        } else {
            this.f.addTab(null, icon, (Component)((Object)sidePanel), string);
        }
        sidePanel.setDocumentPanel(this);
        ((Component)((Object)sidePanel)).applyComponentOrientation(ComponentOrientation.getOrientation(this.getLocale()));
        if (this.f.getTabCount() != 1) return;
        this.add((Component)this.g, "Center");
        this.g.setBottomComponent(this.e);
        this.r = sidePanel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSelectedSidePanel(SidePanel sidePanel) {
        if (sidePanel == null) {
            this.g.setDividerLocation(this.g.getMinimumDividerLocation());
            return;
        }
        if (this.f.indexOfComponent((Component)((Object)sidePanel)) < 0) return;
        this.f.setSelectedComponent((Component)((Object)sidePanel));
        if (this.g.getDividerLocation() >= this.i) return;
        this.g.setDividerLocation(this.h);
    }

    public SidePanel getSelectedSidePanel() {
        if (this.g.getDividerLocation() != this.g.getMinimumDividerLocation()) {
            return (SidePanel)((Object)this.f.getSelectedComponent());
        }
        return null;
    }

    public void setPDF(PDF pDF) {
        PDF pDF2 = pDF;
        PDFPage pDFPage = pDF == null ? null : pDF.getPage(0);
        this.setPDF(pDF2, pDFPage);
    }

    public void setPDF(PDF pDF, PDFPage pDFPage) {
        PDFParser pDFParser = pDF != null ? new PDFParser(pDF) : null;
        this.setPDF(pDFParser, pDFPage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPDF(PDFParser pDFParser, PDFPage pDFPage) {
        PDF pDF;
        this.n = false;
        this.o = false;
        PDF pDF2 = pDF = pDFParser == null ? null : pDFParser.getPDF();
        if (this.a != pDF && this.a != null) {
            this.getJSManager().runEventDocWillClose(this);
            this.raiseDocumentPanelEvent(DocumentPanelEvent.createClosing(this));
            this.a(this.a);
        }
        this.c = pDFParser;
        this.a = pDF;
        if (pDF == null) {
            if (this.e != null) {
                this.e.setDocumentPanel(null);
            }
            Iterator iterator = this.getSidePanels().iterator();
            while (iterator.hasNext()) {
                this.removeSidePanel((SidePanel)iterator.next());
            }
            this.removeAll();
        } else {
            Object object;
            Object object2;
            if (this.f == null) {
                this.f = new JTabbedPane(1);
                this.f.setMinimumSize(new Dimension(0, 0));
                this.f.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        if (DocumentPanel.this.p) {
                            if (DocumentPanel.this.r != null) {
                                DocumentPanel.this.r.panelHidden();
                            }
                            DocumentPanel.this.r = (SidePanel)((Object)DocumentPanel.this.f.getSelectedComponent());
                            if (DocumentPanel.this.r != null) {
                                DocumentPanel.this.r.panelVisible();
                            }
                        }
                    }
                });
                this.g = new JSplitPane(1);
                this.g.setOneTouchExpandable(true);
                this.g.setDividerSize(8);
                this.g.setResizeWeight(0.0);
                this.g.setContinuousLayout(true);
                this.h = 120;
                try {
                    if (this.a("sidePanelSize") != null) {
                        this.h = Math.max(10, Math.min(300, Integer.parseInt(this.a("sidePanelSize"))));
                    }
                }
                catch (NullPointerException nullPointerException) {
                    try {
                        throw nullPointerException;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.i = Math.min(this.h - 5, 50);
                this.g.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (propertyChangeEvent.getPropertyName().equals("dividerLocation")) {
                            int n2 = (Integer)propertyChangeEvent.getNewValue();
                            if (n2 >= DocumentPanel.this.h) {
                                if (!DocumentPanel.this.p) {
                                    DocumentPanel.this.p = true;
                                    SidePanel sidePanel = (SidePanel)((Object)DocumentPanel.this.f.getSelectedComponent());
                                    if (sidePanel != null) {
                                        sidePanel.panelVisible();
                                    }
                                }
                            } else if (n2 >= DocumentPanel.this.i) {
                                DocumentPanel.this.g.setDividerLocation(Math.min(DocumentPanel.this.g.getMaximumDividerLocation(), DocumentPanel.this.h));
                            } else {
                                DocumentPanel.this.g.setDividerLocation(DocumentPanel.this.g.getMinimumDividerLocation());
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        DocumentPanel.this.g.setLastDividerLocation(DocumentPanel.this.h);
                                    }
                                });
                                if (DocumentPanel.this.p) {
                                    DocumentPanel.this.p = false;
                                    SidePanel sidePanel = (SidePanel)((Object)DocumentPanel.this.f.getSelectedComponent());
                                    if (sidePanel != null) {
                                        sidePanel.panelHidden();
                                    }
                                }
                            }
                        }
                    }
                });
                this.g.setTopComponent(this.f);
                this.g.setDividerLocation(this.g.getMinimumDividerLocation());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DocumentPanel.this.g.setLastDividerLocation(DocumentPanel.this.h);
                    }
                });
            }
            Object object3 = this.getSidePanels().iterator();
            while (object3.hasNext()) {
                this.removeSidePanel((SidePanel)object3.next());
            }
            this.add((Component)this.getViewport(), "Center");
            object3 = this.l.iterator();
            while (object3.hasNext()) {
                object2 = (SidePanelFactory)object3.next();
                if (!((SidePanelFactory)object2).isSidePanelRequired(pDF)) continue;
                this.addSidePanel(((SidePanelFactory)object2).createSidePanel());
            }
            object3 = pDF.getOption("pagemode");
            if (object3 == null) {
                object3 = this.a("defaultPageMode");
            }
            if ("UseOutlines".equals(object3)) {
                object2 = this.getSidePanels().iterator();
                while (object2.hasNext()) {
                    object = (SidePanel)object2.next();
                    if (!object.getName().equals("Bookmarks")) continue;
                    this.setSelectedSidePanel((SidePanel)object);
                }
            } else if ("UseThumbs".equals(object3)) {
                object2 = this.getSidePanels().iterator();
                while (object2.hasNext()) {
                    object = (SidePanel)object2.next();
                    if (!object.getName().equals("Pages")) continue;
                    this.setSelectedSidePanel((SidePanel)object);
                }
            } else if ("UseSignatures".equals(object3)) {
                object2 = this.getSidePanels().iterator();
                while (object2.hasNext()) {
                    object = (SidePanel)object2.next();
                    if (!object.getName().equals("Signatures")) continue;
                    this.setSelectedSidePanel((SidePanel)object);
                }
            } else {
                this.setSelectedSidePanel(null);
            }
            this.b(this.a);
            object2 = this.e;
            ((DocumentViewport)object2).addPagePanelListener(new PagePanelListener((DocumentViewport)object2){
                final /* synthetic */ DocumentViewport val$tviewport;
                {
                    this.val$tviewport = documentViewport;
                }

                public void pageUpdated(PagePanelEvent pagePanelEvent) {
                    if (pagePanelEvent.getType() == "redrawn") {
                        this.val$tviewport.removePagePanelListener(this);
                        pagePanelEvent.getPagePanel().removePagePanelListener(this);
                        if (!DocumentPanel.this.o) {
                            DocumentPanel.this.o = true;
                            DocumentPanel.this.raiseDocumentPanelEvent(DocumentPanelEvent.createLoaded(DocumentPanel.this));
                            if (DocumentPanel.this.d != null) {
                                DocumentPanel.this.raiseDocumentPanelEvent(DocumentPanelEvent.createActivated(DocumentPanel.this));
                            }
                        }
                    }
                }
            });
            this.e.setDocumentPanel(this);
            this.validate();
            object = (File)this.getClientProperty("file");
            this.getJSManager().runEventDocOpen(this, object == null ? null : ((File)object).getName());
            if (!this.n && pDFPage != null) {
                String string2 = this.a("defaultZoom");
                int n2 = this.e.getZoomMode();
                float f2 = Float.NaN;
                if ("fit".equals(string2)) {
                    n2 = 1;
                } else if ("fitwidth".equals(string2)) {
                    n2 = 2;
                } else if ("fitheight".equals(string2)) {
                    n2 = 3;
                } else if ("none".equals(string2)) {
                    n2 = 0;
                } else if (string2 != null) {
                    try {
                        f2 = Math.max(0.125f, Math.min(64.0f, Float.parseFloat(string2) / 100.0f));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (f2 != f2) {
                    f2 = this.e.getTargetZoom(n2, pDFPage);
                }
                this.setPage(pDFPage, 0.0f, 0.0f, f2);
            }
            this.e.requestFocusInWindow();
        }
        this.repaint();
    }

    public PDFParser getParser() {
        return this.c;
    }

    public PDF getPDF() {
        return this.a;
    }

    public PDFPage getPage() {
        return this.getViewport().getPage();
    }

    public void setPageNumber(int n2) {
        this.setPage(this.getPDF().getPage(n2));
    }

    public int getPageNumber() {
        PDFPage pDFPage = this.getPage();
        int n2 = pDFPage == null ? -1 : pDFPage.getPageNumber() - 1;
        return n2;
    }

    public float getZoom() {
        return this.getViewport().getZoom();
    }

    public void setZoom(float f2) {
        this.getViewport().setZoom(f2);
    }

    public void setPage(PDFPage pDFPage) {
        this.setPage(pDFPage, 0.0f, 0.0f, this.getViewport().getTargetZoom(this.getViewport().getZoomMode(), pDFPage));
    }

    public void setPage(PDFPage pDFPage, float f2, float f3, float f4) {
        this.n = true;
        this.s = pDFPage.getPageNumber() - 1;
        this.getViewport().setPage(pDFPage, f2, f3, f4);
    }

    public void redraw(Object object) {
    }

    private void a(PDF pDF) {
        pDF.removePropertyChangeListener(this.v);
        Object object = pDF.getForm().getElements().values().iterator();
        while (object.hasNext()) {
            ((FormElement)object.next()).removePropertyChangeListener(this.v);
        }
        object = pDF.getPages();
        for (int i2 = 0; i2 < object.size(); ++i2) {
            PDFPage pDFPage = (PDFPage)object.get(i2);
            pDFPage.removePropertyChangeListener(this.v);
            List list = pDFPage.getAnnotations();
            for (int i3 = 0; i3 < list.size(); ++i3) {
                PDFAnnotation pDFAnnotation = (PDFAnnotation)list.get(i3);
                pDFAnnotation.removePropertyChangeListener(this.v);
            }
        }
    }

    private void b(PDF pDF) {
        pDF.addPropertyChangeListener(this.v);
        Object object = pDF.getForm().getElements().values().iterator();
        while (object.hasNext()) {
            ((FormElement)object.next()).addPropertyChangeListener(this.v);
        }
        object = pDF.getPages();
        for (int i2 = 0; i2 < object.size(); ++i2) {
            PDFPage pDFPage = (PDFPage)object.get(i2);
            pDFPage.addPropertyChangeListener(this.v);
            List list = pDFPage.getAnnotations();
            for (int i3 = 0; i3 < list.size(); ++i3) {
                PDFAnnotation pDFAnnotation = (PDFAnnotation)list.get(i3);
                pDFAnnotation.addPropertyChangeListener(this.v);
            }
        }
    }

    public void setDirty(boolean bl) {
        if (bl != this.q) {
            this.q = bl;
            SwingUtilities.invokeLater(new Runnable(){
                static /* synthetic */ Class class$javax$swing$JInternalFrame;

                public void run() {
                    JInternalFrame jInternalFrame;
                    Class<?> clazz = class$javax$swing$JInternalFrame;
                    if (clazz == null) {
                        clazz = class$javax$swing$JInternalFrame = new JInternalFrame[0].getClass().getComponentType();
                    }
                    if ((jInternalFrame = (JInternalFrame)SwingUtilities.getAncestorOfClass(clazz, DocumentPanel.this)) != null) {
                        String string = jInternalFrame.getTitle();
                        if (DocumentPanel.this.q && !string.endsWith(" *")) {
                            jInternalFrame.setTitle(string + " *");
                        } else if (!DocumentPanel.this.q && string.endsWith(" *")) {
                            jInternalFrame.setTitle(string.substring(0, string.length() - 2));
                        }
                    }
                }
            });
        }
    }

    public boolean isDirty() {
        return this.q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        Collection collection = this.w;
        synchronized (collection) {
            this.w.add(undoableEditListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        Collection collection = this.w;
        synchronized (collection) {
            this.w.remove(undoableEditListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireUndoableEditEvent(UndoableEditEvent undoableEditEvent) {
        Collection collection = this.w;
        synchronized (collection) {
            if (undoableEditEvent.getSource() != this) {
                throw new IllegalArgumentException("Source of UndoableEditEvent must be docpanel");
            }
            Iterator iterator = this.w.iterator();
            while (iterator.hasNext()) {
                ((UndoableEditListener)iterator.next()).undoableEditHappened(undoableEditEvent);
            }
        }
    }

    public void print(final PrintService printService, final PrintRequestAttributeSet printRequestAttributeSet) throws PrintException, PrinterException {
        if (this.a == null) {
            throw new NullPointerException("Document is null");
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){
                static /* synthetic */ Class class$javax$print$attribute$standard$DocumentName;
                static /* synthetic */ Class class$javax$print$attribute$standard$PageRanges;
                static /* synthetic */ Class class$javax$print$attribute$standard$Sides;
                static /* synthetic */ Class class$javax$print$attribute$standard$MediaSize;
                static /* synthetic */ Class class$javax$print$attribute$standard$Copies;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Object run() throws PrintException, PrinterException {
                    Object object;
                    PrintService printService2 = printService;
                    PrintRequestAttributeSet printRequestAttributeSet2 = printRequestAttributeSet;
                    if (printRequestAttributeSet2 == null) {
                        printRequestAttributeSet2 = new HashPrintRequestAttributeSet();
                    }
                    DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
                    if (printService2 == null) {
                        object = PrintServiceLookup.lookupPrintServices(sERVICE_FORMATTED, printRequestAttributeSet2);
                        if (((PrintService[])object).length > 0) {
                            Class<?> clazz;
                            List list;
                            Class<?> clazz2;
                            Class<?> clazz3;
                            PDFPage pDFPage = DocumentPanel.this.getPage();
                            Class<?> clazz4 = class$javax$print$attribute$standard$MediaSize;
                            if (clazz4 == null) {
                                clazz4 = class$javax$print$attribute$standard$MediaSize = new MediaSize[0].getClass().getComponentType();
                            }
                            if (printRequestAttributeSet2.get(clazz4) == null) {
                                try {
                                    float f3 = (float)pDFPage.getWidth() / 72.0f;
                                    float f2 = (float)pDFPage.getHeight() / 72.0f;
                                    if (f2 > f3) {
                                        printRequestAttributeSet2.add(MediaSize.findMedia(f3, f2, 25400));
                                    } else {
                                        printRequestAttributeSet2.add(MediaSize.findMedia(f2, f3, 25400));
                                        printRequestAttributeSet2.add(OrientationRequested.LANDSCAPE);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if ((clazz3 = class$javax$print$attribute$standard$Sides) == null) {
                                clazz3 = class$javax$print$attribute$standard$Sides = new Sides[0].getClass().getComponentType();
                            }
                            if (printRequestAttributeSet2.get(clazz3) == null && DocumentPanel.this.a.getOption("print.duplex") != null) {
                                String string = (String)DocumentPanel.this.a.getOption("print.duplex");
                                if ("DuplexFlipShortEdge".equals(string)) {
                                    printRequestAttributeSet2.add(Sides.TWO_SIDED_SHORT_EDGE);
                                } else if ("DuplexFlipLongEdge".equals(string)) {
                                    printRequestAttributeSet2.add(Sides.TWO_SIDED_LONG_EDGE);
                                }
                            }
                            if ((clazz2 = class$javax$print$attribute$standard$PageRanges) == null) {
                                clazz2 = class$javax$print$attribute$standard$PageRanges = new PageRanges[0].getClass().getComponentType();
                            }
                            if (printRequestAttributeSet2.get(clazz2) == null && (list = (List)DocumentPanel.this.a.getOption("print.pagerange")) != null) {
                                int[][] nArrayArray = new int[list.size()][];
                                for (int i2 = 0; i2 < list.size(); ++i2) {
                                    nArrayArray[i2] = new int[]{((PDFPage)list.get(i2)).getPageNumber()};
                                }
                                printRequestAttributeSet2.add(new PageRanges(nArrayArray));
                            }
                            if ((clazz = class$javax$print$attribute$standard$Copies) == null) {
                                clazz = class$javax$print$attribute$standard$Copies = new Copies[0].getClass().getComponentType();
                            }
                            if (printRequestAttributeSet2.get(clazz) == null && DocumentPanel.this.a.getOption("print.numcopies") != null) {
                                printRequestAttributeSet2.add(new Copies((Integer)DocumentPanel.this.a.getOption("print.numcopies")));
                            }
                            printService2 = ServiceUI.printDialog(null, 50, 50, (PrintService[])object, PrintServiceLookup.lookupDefaultPrintService(), sERVICE_FORMATTED, printRequestAttributeSet2);
                        } else {
                            JOptionPane.showMessageDialog(DocumentPanel.this, UIManager.getString("PDFViewer.NoPrinters"), UIManager.getString("PDFViewer.Alert"), 2);
                        }
                    }
                    if (printService2 == null) return null;
                    Class<?> clazz = class$javax$print$attribute$standard$DocumentName;
                    if (clazz == null) {
                        clazz = class$javax$print$attribute$standard$DocumentName = new DocumentName[0].getClass().getComponentType();
                    }
                    if (printRequestAttributeSet2.get(clazz) == null) {
                        try {
                            object = DocumentPanel.this.a.getInfo("Title");
                            if (object != null) {
                                printRequestAttributeSet2.add(new DocumentName((String)object, Locale.getDefault()));
                            }
                        }
                        catch (ClassCastException classCastException) {
                            // empty catch block
                        }
                    }
                    object = PrinterJob.getPrinterJob();
                    ((PrinterJob)object).setPrintService(printService2);
                    ((PrinterJob)object).setPageable(new Pageable((PrinterJob)object){
                        final /* synthetic */ PrinterJob val$job;
                        {
                            this.val$job = printerJob;
                        }

                        public int getNumberOfPages() {
                            return DocumentPanel.this.c.getNumberOfPages();
                        }

                        public Printable getPrintable(int n2) {
                            return DocumentPanel.this.c.getPrintable(n2);
                        }

                        public PageFormat getPageFormat(int n2) {
                            PageFormat pageFormat = DocumentPanel.this.c.getPageFormat(n2);
                            Paper paper = this.val$job.defaultPage(pageFormat).getPaper();
                            paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
                            pageFormat.setPaper(paper);
                            return pageFormat;
                        }
                    });
                    DocumentPanel.this.getJSManager().runEventDocWillPrint(DocumentPanel.this);
                    ((PrinterJob)object).print(printRequestAttributeSet2);
                    DocumentPanel.this.getJSManager().runEventDocDidPrint(DocumentPanel.this);
                    if (!(printService2 instanceof StreamPrintService)) return null;
                    ((StreamPrintService)printService2).dispose();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof PrintException) {
                throw (PrintException)privilegedActionException.getException();
            }
            throw (PrinterException)privilegedActionException.getException();
        }
    }
}

