/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.filechooser.FileFilter;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFAction;
import org.faceless.pdf2.PDFParser;
import org.faceless.pdf2.viewer2.DocumentPanelEvent;
import org.faceless.pdf2.viewer2.DocumentPanelListener;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.ViewerFeature;
import org.faceless.pdf2.viewer2.util.LongRunningTask;

public abstract class Importer
extends ViewerFeature {
    protected Importer(String string) {
        super(string);
    }

    public abstract FileFilter getFileFilter();

    public abstract boolean matches(File var1) throws IOException;

    public abstract ImporterTask getImporter(PDFViewer var1, File var2);

    public abstract ImporterTask getImporter(PDFViewer var1, InputStream var2, String var3, File var4);

    public ImporterTask getImporter(PDFViewer pDFViewer, URL uRL) throws IOException {
        if (uRL.getProtocol().equals("file")) {
            File file;
            try {
                file = new File(new URI(uRL.toString()));
            }
            catch (URISyntaxException uRISyntaxException) {
                file = new File(uRL.getPath());
            }
            if (file != null) {
                return this.getImporter(pDFViewer, file);
            }
        }
        return this.getImporter(pDFViewer, uRL.openStream(), uRL.toString(), null);
    }

    protected void processPDF(PDF pDF) {
    }

    protected PDFParser getParser(PDF pDF) {
        return new PDFParser(pDF);
    }

    public abstract class ImporterTask
    extends LongRunningTask {
        protected final PDFViewer viewer;
        protected final File file;
        protected final InputStream in;
        protected String title;
        protected int pagenumber;
        private File i;

        protected ImporterTask(PDFViewer pDFViewer, InputStream inputStream, String string, File file) {
            this.viewer = pDFViewer;
            this.file = file;
            this.i = file;
            this.in = inputStream;
            if (string == null && file != null) {
                string = file.getName();
            }
            this.title = string;
        }

        public boolean isCancellable() {
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() throws IOException {
            final PDF pDF = this.loadPDF();
            Importer.this.processPDF(pDF);
            if (!this.isCancelled() && pDF != null) {
                if ("true".equals(pDF.getOption("view.displayDocTitle"))) {
                    this.title = pDF.getInfo("Title");
                }
                if (this.title == null) {
                    this.title = "BFO";
                }
                if ("true".equals(pDF.getOption("view.fullscreen"))) {
                    this.viewer.addDocumentPanelListener(new DocumentPanelListener(){

                        public void documentUpdated(DocumentPanelEvent documentPanelEvent) {
                            if (documentPanelEvent.getType() == "activated" && documentPanelEvent.getDocumentPanel().getPDF() == pDF) {
                                ImporterTask.this.viewer.getActiveDocumentPanel().runAction(PDFAction.named("FullScreen"));
                                ImporterTask.this.viewer.removeDocumentPanelListener(this);
                            }
                        }
                    });
                }
                this.viewer.a(Importer.this.getParser(pDF), this.title, this.i, this.pagenumber);
            }
        }

        public void setPageNumber(int n2) {
            this.pagenumber = n2;
        }

        public void setFile(File file) {
            this.i = file;
        }

        public abstract PDF loadPDF() throws IOException;
    }
}

