/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2;

import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPasswordField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.faceless.pdf2.FormSignature;
import org.faceless.pdf2.PropertyManager;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.Util;
import org.faceless.pdf2.viewer2.util.DialogPanel;
import org.faceless.pdf2.viewer2.util.X509Util;
import org.faceless.retrotranslator.net.sf.retrotranslator.runtime.java.lang._String;
import org.faceless.retrotranslator.net.sf.retrotranslator.runtime.java.util.regex._Pattern;
import org.faceless.util.Base64;
import org.faceless.util.CombinedKeyStore;
import org.faceless.util.WeakPropertyChangeSupport;

public class KeyStoreManager {
    public static final FileFilter FILTER_KEYSTORE = KeyStoreManager.a("PDFViewer.FilesKeyStore", _Pattern.compile(".*\\.(keystore|jks|p12|pfx|pkcs12)"));
    public static final FileFilter FILTER_KEYSTORE_JKS = KeyStoreManager.a("PDFViewer.FilesJKS", _Pattern.compile(".*\\.(keystore|jks|jceks)"));
    public static final FileFilter FILTER_KEYSTORE_PKCS12 = KeyStoreManager.a("PDFViewer.FilesPKCS12", _Pattern.compile(".*\\.(p12|pfx|pkcs12)"));
    public static final FileFilter FILTER_CERTIFICATE = KeyStoreManager.a("PDFViewer.FilesCertificate", _Pattern.compile(".*\\.(cer|crt|pem)"));
    protected WeakPropertyChangeSupport propertyChangeSupport = new WeakPropertyChangeSupport(this);
    protected KeyStore keystore;
    protected Map params = new LinkedHashMap();
    protected final PropertyManager propertymanager;
    protected boolean changed;
    static /* synthetic */ Class class$java$io$InputStream;

    public KeyStoreManager(PDFViewer pDFViewer) {
        this.propertymanager = pDFViewer == null ? null : pDFViewer.getPropertyManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadKeyStore() throws IOException, GeneralSecurityException {
        KeyStore keyStore;
        String string;
        block31: {
            string = this.getParameter("type");
            String string2 = this.getParameter("provider");
            if ("pkcs11".equalsIgnoreCase(string)) {
                Object object;
                Map.Entry entry;
                StringBuffer stringBuffer = new StringBuffer();
                Object object2 = this.params.entrySet().iterator();
                while (object2.hasNext()) {
                    entry = object2.next();
                    object = (String)entry.getKey();
                    if (!((String)object).equals("library") && !((String)object).equals("name") && !((String)object).equals("description") && !((String)object).equals("slot") && !((String)object).equals("slotListIndex") && !((String)object).equals("enabledMechanisms") && !((String)object).equals("disabledMechanisms") && (!((String)object).startsWith("attributes(") || ((String)object).charAt(((String)object).length() - 1) != ')')) continue;
                    stringBuffer.append((String)object + "=" + entry.getValue() + "\n");
                }
                object2 = stringBuffer.toString().getBytes("ISO-8859-1");
                try {
                    object = Class.forName("sun.security.pkcs11.SunPKCS11");
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$java$io$InputStream;
                    if (clazz == null) {
                        clazz = class$java$io$InputStream = new InputStream[0].getClass().getComponentType();
                    }
                    classArray[0] = clazz;
                    entry = (Provider)((Class)object).getConstructor(classArray).newInstance(new ByteArrayInputStream((byte[])object2));
                }
                catch (Throwable throwable) {
                    throw new IllegalArgumentException("No sun.security.pkcs11.SunPKCS11 implementation on this platform");
                }
                this.keystore = KeyStore.getInstance("pkcs11", (Provider)((Object)entry));
                object = this.getParameter("password");
                this.keystore.load(null, object == null ? null : ((String)object).toCharArray());
                return;
            }
            if ("keychainstore".equalsIgnoreCase(string) && "apple".equalsIgnoreCase(string2)) {
                this.keystore = KeyStore.getInstance("KeychainStore", "Apple");
                this.keystore.load(null, null);
                return;
            }
            String string3 = this.getParameter("password");
            File file = this.a();
            if (!file.canRead()) {
                throw new IOException("File \"" + file + "\" cannot be read");
            }
            if (string == null || string.length() == 0) {
                string = KeyStoreManager.a(file.getPath().toLowerCase());
            }
            keyStore = string2 == null ? KeyStore.getInstance(string) : KeyStore.getInstance(string, string2);
            CombinedKeyStore combinedKeyStore = CombinedKeyStore.newInstance(keyStore);
            combinedKeyStore.addReadStore(FormSignature.loadDefaultKeyStore());
            keyStore = combinedKeyStore;
            BufferedInputStream bufferedInputStream = null;
            try {
                try {
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    ((InputStream)bufferedInputStream).mark(1024);
                    keyStore.load(bufferedInputStream, string3 == null ? null : string3.toCharArray());
                }
                catch (IOException iOException) {
                    if (bufferedInputStream == null) throw iOException;
                    if (!"JKS".equalsIgnoreCase(string)) throw iOException;
                    string = "JCEKS";
                    keyStore = string2 == null ? KeyStore.getInstance(string) : KeyStore.getInstance(string, string2);
                    ((InputStream)bufferedInputStream).reset();
                    keyStore.load(bufferedInputStream, string3 == null ? null : string3.toCharArray());
                    Object var10_14 = null;
                    if (bufferedInputStream != null) {
                        ((InputStream)bufferedInputStream).close();
                    }
                    break block31;
                }
                Object var10_13 = null;
                if (bufferedInputStream == null) break block31;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                if (bufferedInputStream == null) throw throwable;
                ((InputStream)bufferedInputStream).close();
                throw throwable;
            }
            ((InputStream)bufferedInputStream).close();
        }
        this.keystore = keyStore;
        this.changed = false;
        this.params.put("type", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveKeyStore() throws IOException, GeneralSecurityException {
        String string3 = this.getParameter("type");
        String string2 = this.getParameter("provider");
        String string = this.getParameter("password");
        if ("pkcs11".equalsIgnoreCase(string3)) {
            this.keystore.store(null, string == null ? new char[]{} : string.toCharArray());
            return;
        }
        if ("keychainstore".equalsIgnoreCase(string3) && "apple".equalsIgnoreCase(string2)) {
            this.keystore.store(null, null);
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.a());
            this.keystore.store(fileOutputStream, string == null ? new char[]{} : string.toCharArray());
            Object var6_5 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileOutputStream == null) throw throwable;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setParameters(String string) {
        this.params = new LinkedHashMap();
        if (!string.endsWith(";")) {
            string = string + ';';
        }
        int n2 = 0;
        int n3 = -2;
        int n4 = 0;
        int n5 = 0;
        while (n5 < string.length()) {
            int n6 = string.charAt(n5);
            if (n6 == 92 && n5 < string.length() - 1) {
                n6 = string.charAt(++n5);
                switch (n6) {
                    case 110: {
                        n6 = 10;
                        break;
                    }
                    case 114: {
                        n6 = 13;
                        break;
                    }
                    case 116: {
                        n6 = 9;
                        break;
                    }
                }
            } else if (!(n6 != 39 && n6 != 34 || n2 != 0 && n2 != n6)) {
                n2 = n2 == 0 ? n6 : 0;
            } else if (n6 == 61 && n2 == 0) {
                n3 = n5;
            } else if (n6 == 59 && n2 == 0) {
                String string2 = null;
                String string3 = null;
                if (n3 == -2) {
                    string2 = "";
                    string3 = string.substring(n4, n5);
                } else if (n3 > 0) {
                    string2 = string.substring(n4, n3);
                    string3 = string.substring(n3 + 1, n5);
                }
                if (string2 != null) {
                    this.params.put(string2, string3);
                }
                n3 = -1;
                n4 = n5 + 1;
            }
            ++n5;
        }
        return;
    }

    public void setParameter(String string, String string2) {
        block6: {
            block5: {
                if (string == null) {
                    throw new IllegalArgumentException("Parameter is null");
                }
                if (string2 != null) break block5;
                this.params.remove(string);
                break block6;
            }
            this.params.put(string, string2);
        }
    }

    public String getParameter(String string) {
        return (String)this.params.get(string);
    }

    private File a() {
        File file;
        String string = this.getParameter("file");
        if (string == null) {
            string = ".keystore";
        }
        if (!(file = new File(string)).isAbsolute()) {
            file = new File(this.propertymanager.getProperty("user.home"), string);
        }
        return file;
    }

    public void setStoreType(String string) {
        this.setParameter("type", string);
    }

    public String getStoreType() {
        return this.getParameter("type");
    }

    public void setProvider(String string) {
        this.setParameter("provider", string);
    }

    public void setFile(File file, char[] cArray) {
        this.setParameter("file", file.getPath());
        KeyStoreManager keyStoreManager = this;
        String string = "password";
        String string2 = cArray == null ? null : new String(cArray);
        keyStoreManager.setParameter(string, string2);
    }

    public void cancelKeyStore() {
        this.keystore = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String a(String string) {
        if (string.endsWith(".pfx") || string.endsWith(".pkcs12") || string.endsWith(".p12")) {
            return "pkcs12";
        }
        if (string.endsWith(".jks")) {
            return "JKS";
        }
        if (string.endsWith(".jceks")) {
            return "JCEKS";
        }
        return KeyStore.getDefaultType();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createKeyStore() throws GeneralSecurityException {
        try {
            String string2 = this.getParameter("type");
            String string = this.getParameter("provider");
            if (string2 == null) {
                string2 = KeyStore.getDefaultType();
            } else {
                if (string2.equalsIgnoreCase("pkcs11")) throw new IllegalStateException("Cannot create new \"" + string2 + "\" KeyStore");
                if (string2.equalsIgnoreCase("keychainstore")) {
                    throw new IllegalStateException("Cannot create new \"" + string2 + "\" KeyStore");
                }
            }
            KeyStore keyStore = string == null ? KeyStore.getInstance(string2) : KeyStore.getInstance(string2, string);
            CombinedKeyStore combinedKeyStore = CombinedKeyStore.newInstance(keyStore);
            if (Util.hasFilePermission()) {
                combinedKeyStore.addReadStore(FormSignature.loadDefaultKeyStore());
            }
            this.keystore = combinedKeyStore;
            this.keystore.load(null, null);
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isFileBased() {
        String string = this.getParameter("type");
        if (string == null) return true;
        if (string.equalsIgnoreCase("jks")) return true;
        if (string.equalsIgnoreCase("pkcs12")) return true;
        return false;
    }

    public boolean isCancellable() {
        String string = this.getParameter("type");
        boolean bl = !"pkcs11".equals(string);
        return bl;
    }

    public boolean loadKeyStore(JComponent jComponent) {
        while (true) {
            Map map = this.a(jComponent, true);
            if (map == null) {
                return false;
            }
            this.setFile((File)map.get("file"), (char[])map.get("password"));
            try {
                this.loadKeyStore();
                return true;
            }
            catch (Exception exception) {
                Util.displayThrowable(exception, jComponent);
                continue;
            }
            break;
        }
    }

    public boolean saveKeyStore(JComponent jComponent) {
        while (true) {
            Map map = this.a(jComponent, false);
            if (map == null) {
                return false;
            }
            this.setFile((File)map.get("file"), (char[])map.get("password"));
            try {
                this.saveKeyStore();
                return true;
            }
            catch (Exception exception) {
                Util.displayThrowable(exception, jComponent);
                continue;
            }
            break;
        }
    }

    private String a(X509Certificate x509Certificate, String string) throws CertificateException, KeyStoreException {
        if (string == null) {
            string = FormSignature.getSubjectField(x509Certificate, "CN");
            if (string == null) {
                string = FormSignature.getSubjectField(x509Certificate, "O");
            }
            if (string == null) {
                string = x509Certificate.getSerialNumber().toString(16);
            }
        }
        String string2 = string;
        int n2 = 0;
        while (this.keystore.containsAlias(string2)) {
            string2 = string + "-" + ++n2;
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeyStore getKeyStore() throws GeneralSecurityException, IOException {
        if (this.keystore != null) return this.keystore;
        try {
            this.loadKeyStore();
            return this.keystore;
        }
        catch (IOException iOException) {
            this.createKeyStore();
        }
        return this.keystore;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public String importCertificate(String string, X509Certificate x509Certificate) throws GeneralSecurityException {
        if (this.keystore.getCertificateAlias(x509Certificate) == null) {
            string = this.a(x509Certificate, string);
            this.keystore.setCertificateEntry(string, x509Certificate);
            this.propertyChangeSupport.firePropertyChange("alias", null, string);
            this.changed = true;
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String[] importAllCertificates(File file, String string) throws GeneralSecurityException, IOException {
        String[] stringArray;
        String string2;
        FileInputStream fileInputStream;
        block28: {
            block27: {
                block26: {
                    Object object;
                    block29: {
                        block24: {
                            fileInputStream = null;
                            string2 = null;
                            fileInputStream = new FileInputStream(file);
                            object = CertificateFactory.getInstance("X.509");
                            ((CertificateFactory)object).generateCertificate(fileInputStream);
                            string2 = "X.509";
                            Object var7_8 = null;
                            if (fileInputStream == null) break block24;
                            ((InputStream)fileInputStream).close();
                            {
                                catch (IOException iOException) {}
                                break block24;
                            }
                            {
                                catch (IOException iOException) {
                                    Object var7_9 = null;
                                    if (fileInputStream == null) break block24;
                                    ((InputStream)fileInputStream).close();
                                    {
                                        catch (IOException iOException2) {}
                                        break block24;
                                    }
                                }
                                catch (CertificateException certificateException) {
                                    Object var7_10 = null;
                                    if (fileInputStream == null) break block24;
                                    ((InputStream)fileInputStream).close();
                                    {
                                        catch (IOException iOException) {}
                                        break block24;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                block25: {
                                    Object var7_11 = null;
                                    if (fileInputStream == null) break block25;
                                    ((InputStream)fileInputStream).close();
                                    break block25;
                                    {
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                }
                                throw throwable;
                            }
                        }
                        if (string2 != null) break block28;
                        object = file.getName().toLowerCase();
                        if (((String)object).endsWith(".pkcs12")) break block26;
                        if (((String)object).endsWith(".pfx")) break block26;
                        break block29;
                        catch (IOException iOException) {
                            throw iOException;
                        }
                    }
                    if (!((String)object).endsWith(".p12")) break block27;
                }
                string2 = "pkcs12";
                break block28;
            }
            string2 = "JKS";
        }
        try {
            fileInputStream = new FileInputStream(file);
            stringArray = this.importAllCertificates(fileInputStream, null, string2);
            Object var11_18 = null;
        }
        catch (Throwable throwable) {
            Object var11_19 = null;
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {}
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String[] importAllCertificates(InputStream inputStream, String string, String string2) throws GeneralSecurityException, IOException {
        Object object;
        try {
            ArrayList<String> arrayList;
            block25: {
                block26: {
                    block23: {
                        block24: {
                            arrayList = new ArrayList<String>();
                            if (!string2.equals("X.509")) break block23;
                            if (inputStream.markSupported()) break block24;
                            inputStream = new BufferedInputStream(inputStream);
                        }
                        object = CertificateFactory.getInstance("X.509");
                        while (inputStream.available() > 0) {
                            X509Certificate x509Certificate = (X509Certificate)((CertificateFactory)object).generateCertificate(inputStream);
                            String string3 = this.importCertificate(string, x509Certificate);
                            if (string3 == null) continue;
                            arrayList.add(string3);
                        }
                        break block25;
                    }
                    object = null;
                    inputStream = new BufferedInputStream(inputStream);
                    inputStream.mark(1024);
                    object = KeyStore.getInstance(string2);
                    ((KeyStore)object).load(inputStream, null);
                    Object var9_11 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {}
                    break block26;
                    {
                        catch (IOException iOException) {
                            if (string2.equals("JKS")) {
                                inputStream.reset();
                                object = KeyStore.getInstance("JCEKS");
                                ((KeyStore)object).load(inputStream, null);
                            }
                            var9_11 = null;
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                Enumeration<String> enumeration = ((KeyStore)object).aliases();
                while (enumeration.hasMoreElements()) {
                    Certificate certificate;
                    string = enumeration.nextElement();
                    if (((KeyStore)object).isKeyEntry(string)) {
                        Certificate[] certificateArray = ((KeyStore)object).getCertificateChain(string);
                        Certificate certificate2 = certificateArray == null ? null : certificateArray[certificateArray.length - 1];
                        certificate = certificate2;
                    } else {
                        certificate = ((KeyStore)object).getCertificate(string);
                    }
                    if (!(certificate instanceof X509Certificate)) continue;
                    string = this.importCertificate(string, (X509Certificate)certificate);
                    if (string == null) continue;
                    arrayList.add(string);
                }
            }
            object = arrayList.toArray(new String[0]);
            Object var12_17 = null;
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return object;
    }

    public String importPrivateKey(KeyStore keyStore, String string, char[] cArray) throws GeneralSecurityException {
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(string, cArray);
        Certificate[] certificateArray = keyStore.getCertificateChain(string);
        if (certificateArray == null) {
            throw new GeneralSecurityException("No entry for '" + string + "'");
        }
        return this.importPrivateKey(privateKey, certificateArray, string, cArray);
    }

    public String importPrivateKey(PrivateKey privateKey, Certificate[] certificateArray, String string, char[] cArray) throws GeneralSecurityException {
        string = this.a((X509Certificate)certificateArray[0], string);
        this.keystore.setKeyEntry(string, privateKey, cArray, certificateArray);
        this.propertyChangeSupport.firePropertyChange("alias", null, string);
        this.changed = true;
        return string;
    }

    public void exportPKCS12Certificate(OutputStream outputStream, String string, char[] cArray) throws GeneralSecurityException, IOException {
        Key key = this.keystore.getKey(string, cArray);
        KeyStore keyStore = KeyStore.getInstance("pkcs12");
        keyStore.load(null, null);
        Certificate[] certificateArray = this.keystore.getCertificateChain(string);
        keyStore.setKeyEntry(string, key, cArray, certificateArray);
        keyStore.store(outputStream, cArray);
    }

    public boolean contains(Certificate certificate) throws GeneralSecurityException, IOException {
        boolean bl = this.getKeyStore().getCertificateAlias(certificate) != null;
        return bl;
    }

    public void exportCertificate(OutputStream outputStream, String string) throws GeneralSecurityException, IOException {
        outputStream.write("-----BEGIN X509 CERTIFICATE-----\n".getBytes("ISO-8859-1"));
        outputStream.flush();
        OutputStream outputStream2 = Base64.getEncoder(outputStream, false);
        outputStream2.write(this.keystore.getCertificate(string).getEncoded());
        outputStream2.flush();
        outputStream.write("\n-----END X509 CERTIFICATE-----\n".getBytes("ISO-8859-1"));
    }

    public void deleteEntry(String string) throws GeneralSecurityException {
        if (this.keystore.containsAlias(string)) {
            this.keystore.deleteEntry(string);
            this.propertyChangeSupport.firePropertyChange("alias", string, null);
            this.changed = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canStoreSecretKeysOnConversion() {
        String string = this.getStoreType();
        if (string == null) return true;
        if (string.equalsIgnoreCase("jks")) return true;
        if (this.canStoreSecretKeys()) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canStoreSecretKeys() {
        String string = this.getStoreType();
        if (string == null) return true;
        if (string.equalsIgnoreCase("jceks")) return true;
        if (string.equalsIgnoreCase("pkcs11")) return true;
        return false;
    }

    public void putSecret(String string, SecretKey secretKey, char[] cArray) throws GeneralSecurityException, IOException {
        block7: {
            String string2;
            block6: {
                if (secretKey != null) break block6;
                this.keystore.deleteEntry(string);
                break block7;
            }
            if (!this.canStoreSecretKeys()) {
                this.b();
            }
            if (cArray == null && (string2 = this.getParameter("password")) != null) {
                cArray = string2.toCharArray();
            }
            this.keystore.setKeyEntry(string, secretKey, cArray, null);
        }
        this.changed = true;
    }

    public SecretKey getSecret(String string, String string2, char[] cArray) throws GeneralSecurityException {
        Object object;
        if (cArray == null && (object = this.getParameter("password")) != null) {
            cArray = ((String)object).toCharArray();
        }
        object = this.keystore.getKey(string, cArray);
        if (object instanceof SecretKey) {
            return (SecretKey)object;
        }
        return null;
    }

    private void b() throws GeneralSecurityException, IOException {
        if (this.isChanged()) {
            this.saveKeyStore();
        }
        this.setParameter("type", "JCEKS");
        this.loadKeyStore();
    }

    public String createSelfSignedKey(String string, String string2, String string3, String string4, String string5, String string6, String string7, char[] cArray, int n2) throws GeneralSecurityException {
        String string8 = this.getParameter("sigalg");
        if (string8 == null) {
            string8 = "SHA1withRSA";
        }
        int n3 = 2048;
        try {
            n3 = Integer.parseInt(this.getParameter("keylength"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createSelfSignedKey(string, string2, string3, string4, string5, string6, string7, cArray, n2, string8, n3);
    }

    public String createSelfSignedKey(String string, String string2, String string3, String string4, String string5, String string6, String string7, char[] cArray, int n2, String string8, int n3) throws GeneralSecurityException {
        String string9;
        block25: {
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                string9 = "";
                                if (string2 == null || string2.trim().length() <= 0) break block20;
                                string9 = string9 + "CN=" + _String.replaceAll(string2, ",", "\\\\,") + ", ";
                            }
                            if (string3 == null || string3.trim().length() <= 0) break block21;
                            string9 = string9 + "OU=" + _String.replaceAll(string3, ",", "\\\\,") + ", ";
                        }
                        if (string4 == null || string4.trim().length() <= 0) break block22;
                        string9 = string9 + "O=" + _String.replaceAll(string4, ",", "\\\\,") + ", ";
                    }
                    if (string5 == null || string5.trim().length() <= 0) break block23;
                    string9 = string9 + "L=" + _String.replaceAll(string5, ",", "\\\\,") + ", ";
                }
                if (string6 == null || string6.trim().length() <= 0) break block24;
                string9 = string9 + "ST=" + _String.replaceAll(string6, ",", "\\\\,") + ", ";
            }
            if (string7 == null || string7.trim().length() <= 0) break block25;
            string9 = string9 + "C=" + _String.replaceAll(string7, ",", "\\\\,") + ", ";
        }
        if (string9.length() == 0) {
            throw new IllegalArgumentException("No DN keys specified");
        }
        string9 = string9.substring(0, string9.length() - 2);
        String string10 = string8.endsWith("DSA") ? "DSA" : "RSA";
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(string10);
        keyPairGenerator.initialize(n3, SecureRandom.getInstance("SHA1PRNG"));
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        try {
            X509Certificate x509Certificate = new X509Util().generateCertificate(string9, keyPair, n2, string8);
            return this.importPrivateKey(keyPair.getPrivate(), new X509Certificate[]{x509Certificate}, string, cArray);
        }
        catch (AccessControlException accessControlException) {
            throw new GeneralSecurityException("Can't create X.509 Certificate in untrusted environment");
        }
        catch (Error error) {
            throw new GeneralSecurityException("Can't create X.509 Certificate - classes missing");
        }
    }

    public boolean canCreateSelfSignedCertificate() {
        try {
            new X509Util();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map a(JComponent jComponent, final boolean bl) {
        String string = this.getParameter("type");
        String string2 = this.getParameter("password");
        File file = this.a();
        final JFileChooser jFileChooser = new JFileChooser(file);
        if (file != null && file.exists()) {
            jFileChooser.ensureFileIsVisible(file);
        }
        jFileChooser.setControlButtonsAreShown(false);
        if (file != null && file.exists() || !bl) {
            jFileChooser.setSelectedFile(file);
        }
        if (!bl) {
            jFileChooser.setDialogType(1);
        }
        jFileChooser.setFileHidingEnabled(false);
        if ("JKS".equals(string) || "JCEKS".equals(string)) {
            jFileChooser.addChoosableFileFilter(FILTER_KEYSTORE_JKS);
            jFileChooser.setFileFilter(FILTER_KEYSTORE_JKS);
        } else if ("pkcs12".equals(string)) {
            jFileChooser.addChoosableFileFilter(FILTER_KEYSTORE_PKCS12);
            jFileChooser.setFileFilter(FILTER_KEYSTORE_PKCS12);
        } else {
            jFileChooser.addChoosableFileFilter(FILTER_KEYSTORE);
            jFileChooser.setFileFilter(FILTER_KEYSTORE);
        }
        final JPasswordField jPasswordField = string2 == null ? new JPasswordField() : new JPasswordField(string2);
        DialogPanel dialogPanel = new DialogPanel(){

            public String validateDialog() {
                if (!bl && jPasswordField.getPassword().length == 0) {
                    return UIManager.getString("PDFViewer.ChoosePassword");
                }
                if (jFileChooser.getSelectedFile() == null) {
                    return UIManager.getString("PDFViewer.ChooseFile");
                }
                return null;
            }
        };
        dialogPanel.addComponent(jFileChooser);
        dialogPanel.addComponent(UIManager.getString("PDFViewer.Password"), jPasswordField);
        if (!dialogPanel.showDialog(jComponent)) {
            return null;
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("file", jFileChooser.getSelectedFile());
        if (jPasswordField.getPassword().length > 0) {
            linkedHashMap.put("password", jPasswordField.getPassword());
        }
        return linkedHashMap;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private static FileFilter a(final String string, final Pattern pattern) {
        return new FileFilter(){

            public String getDescription() {
                return UIManager.getString(string);
            }

            public boolean accept(File file) {
                return file.isDirectory() || pattern.matcher(file.getName().toLowerCase()).matches();
            }
        };
    }
}

