/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2;

import java.awt.event.ActionEvent;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.faceless.pdf2.PublicKeyEncryptionHandler;
import org.faceless.pdf2.viewer2.KeyStoreManager;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.Util;
import org.faceless.pdf2.viewer2.util.DialogPanel;
import org.faceless.pdf2.viewer2.util.KeyStoreAliasList;

public class PublicKeyPromptEncryptionHandler
extends PublicKeyEncryptionHandler {
    private JComponent q;
    private KeyStoreManager r;
    private transient char[] s;

    public PublicKeyPromptEncryptionHandler(JComponent jComponent, KeyStoreManager keyStoreManager) {
        this.q = jComponent;
        this.r = keyStoreManager;
    }

    public void setAlias(String string, char[] cArray) {
        this.s = cArray;
    }

    protected boolean chooseRecipient(final X500Principal[] x500PrincipalArray, final BigInteger[] bigIntegerArray) {
        final KeyStoreAliasList keyStoreAliasList = new KeyStoreAliasList(this.r, true, false){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean isEnabled(KeyStore keyStore, String string) {
                try {
                    Certificate[] certificateArray = keyStore.getCertificateChain(string);
                    if (certificateArray == null || certificateArray.length <= 0) return false;
                    X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
                    for (int n2 = 0; n2 < x500PrincipalArray.length; ++n2) {
                        if (!x509Certificate.getIssuerX500Principal().equals(x500PrincipalArray[n2]) || !x509Certificate.getSerialNumber().equals(bigIntegerArray[n2])) continue;
                        return true;
                    }
                    return false;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return false;
            }
        };
        final JPasswordField jPasswordField = new JPasswordField();
        if (this.s != null) {
            jPasswordField.setText(new String(this.s));
        }
        DialogPanel dialogPanel = new DialogPanel(){

            public String validateDialog() {
                try {
                    PublicKeyPromptEncryptionHandler.this.setDecryptionKey(keyStoreAliasList.getKeyStoreManager().getKeyStore(), (String)keyStoreAliasList.getSelectedValue(), jPasswordField.getPassword());
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {
                    return UIManager.getString("PDFViewer.WrongPassword");
                }
                catch (Exception exception) {
                    return UIManager.getString("PDFViewer.Error") + ": " + exception;
                }
                return null;
            }
        };
        dialogPanel.addButton(UIManager.getString("PDFViewer.ReloadFile"), null, new AbstractAction(){
            static /* synthetic */ Class class$org$faceless$pdf2$viewer2$PDFViewer;

            public void actionPerformed(ActionEvent actionEvent) {
                Class<?> clazz = class$org$faceless$pdf2$viewer2$PDFViewer;
                if (clazz == null) {
                    clazz = class$org$faceless$pdf2$viewer2$PDFViewer = new PDFViewer[0].getClass().getComponentType();
                }
                PDFViewer pDFViewer = (PDFViewer)SwingUtilities.getAncestorOfClass(clazz, PublicKeyPromptEncryptionHandler.this.q);
                KeyStoreManager keyStoreManager = new KeyStoreManager(pDFViewer);
                try {
                    if (keyStoreManager.loadKeyStore(PublicKeyPromptEncryptionHandler.this.q)) {
                        keyStoreAliasList.setKeyStoreManager(keyStoreManager);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JViewport jViewport = new JViewport();
        jViewport.add(keyStoreAliasList);
        dialogPanel.addComponent(jViewport);
        dialogPanel.addComponent(UIManager.getString("PDFViewer.Password"), jPasswordField);
        if (dialogPanel.showDialog(this.q)) {
            try {
                this.setDecryptionKey(keyStoreAliasList.getKeyStoreManager().getKeyStore(), (String)keyStoreAliasList.getSelectedValue(), jPasswordField.getPassword());
            }
            catch (Exception exception) {
                Util.displayThrowable(exception, dialogPanel);
                return false;
            }
            return true;
        }
        return false;
    }
}

