/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import org.faceless.pdf2.FormSignature;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.ViewerFeature;

public abstract class SignatureProvider
extends ViewerFeature {
    private PDFViewer b;
    static /* synthetic */ Class class$org$faceless$pdf2$viewer2$PDFViewer;

    protected SignatureProvider(String string) {
        super(string);
    }

    public void initialize(PDFViewer pDFViewer) {
        this.b = pDFViewer;
        super.initialize(pDFViewer);
    }

    public final PDFViewer getViewer() {
        return this.b;
    }

    public abstract String getDisplayName();

    public String getDefaultName() {
        return this.getFeatureProperty(this.b, "name");
    }

    public String getDefaultReason() {
        return this.getFeatureProperty(this.b, "reason");
    }

    public String getDefaultLocation() {
        return this.getFeatureProperty(this.b, "location");
    }

    public int getDefaultCertificationType() {
        String string = this.getFeatureProperty(this.b, "certification");
        if ("none".equals(string)) {
            return 0;
        }
        if ("nochanges".equals(string)) {
            return 1;
        }
        if ("forms".equals(string)) {
            return 2;
        }
        if ("annotations".equals(string)) {
            return 3;
        }
        return -1;
    }

    public abstract boolean canSign(FormSignature var1);

    public abstract boolean canVerify(FormSignature var1);

    public abstract void showSignDialog(JComponent var1, FormSignature var2) throws IOException, GeneralSecurityException;

    public abstract void showVerifyDialog(JComponent var1, FormSignature var2);

    public SignatureState verify(JComponent jComponent, FormSignature formSignature) {
        throw new UnsupportedOperationException();
    }

    public static final ImageIcon getIcon(DocumentPanel documentPanel, FormSignature formSignature) {
        SignatureState signatureState = SignatureProvider.getSignatureState(documentPanel, formSignature);
        if (signatureState == null) {
            Class<?> clazz = class$org$faceless$pdf2$viewer2$PDFViewer;
            if (clazz == null) {
                clazz = class$org$faceless$pdf2$viewer2$PDFViewer = new PDFViewer[0].getClass().getComponentType();
            }
            return new ImageIcon(clazz.getResource("resources/icons/help.png"));
        }
        return signatureState.getIcon();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void a(DocumentPanel documentPanel, FormSignature formSignature, JComponent jComponent, Point point, final ActionListener actionListener, final boolean bl) {
        if (formSignature.getState() == 1) {
            JOptionPane.showMessageDialog(documentPanel, UIManager.getString("PDFViewer.PendingSignature"), UIManager.getString("PDFViewer.Alert"), 1);
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        ViewerFeature[] viewerFeatureArray = documentPanel.getViewer().getFeatures();
        int n3 = 0;
        SignatureProvider signatureProvider2 = null;
        for (int i2 = 0; i2 < viewerFeatureArray.length; ++i2) {
            ViewerFeature viewerFeature = viewerFeatureArray[i2];
            if (!(viewerFeature instanceof SignatureProvider)) continue;
            final SignatureProvider signatureProvider3 = (SignatureProvider)viewerFeature;
            if (!(bl ? signatureProvider3.canSign(formSignature) : signatureProvider3.canVerify(formSignature))) continue;
            signatureProvider2 = signatureProvider3;
            ++n3;
            AbstractAction abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    actionListener.actionPerformed(new ActionEvent(signatureProvider3, actionEvent.getID(), bl ? "sign" : "verify"));
                }
            };
            abstractAction.putValue("Name", signatureProvider3.getDisplayName());
            jPopupMenu.add(new JMenuItem(abstractAction));
        }
        if (n3 == 0) {
            JOptionPane.showMessageDialog(documentPanel, UIManager.getString("PDFViewer.NoSignatureProvider"), UIManager.getString("PDFViewer.Alert"), 1);
            return;
        }
        if (n3 != 1) {
            if (point == null) return;
            jPopupMenu.show(jComponent, point.x, point.y);
            return;
        }
        actionListener.actionPerformed(new ActionEvent(signatureProvider2, 0, bl ? "sign" : "verify"));
    }

    public static final void selectSignProvider(DocumentPanel documentPanel, FormSignature formSignature, JComponent jComponent, Point point, ActionListener actionListener) {
        SignatureProvider.a(documentPanel, formSignature, jComponent, point, actionListener, true);
    }

    public static final void selectVerifyProvider(DocumentPanel documentPanel, FormSignature formSignature, JComponent jComponent, Point point, ActionListener actionListener) {
        SignatureProvider.a(documentPanel, formSignature, jComponent, point, actionListener, false);
    }

    public static final SignatureState getSignatureState(DocumentPanel documentPanel, FormSignature formSignature) {
        return (SignatureState)documentPanel.getClientProperty(formSignature);
    }

    public static final void setSignatureState(DocumentPanel documentPanel, FormSignature formSignature, SignatureState signatureState) {
        documentPanel.putClientProperty(formSignature, signatureState);
        documentPanel.repaint();
    }

    public class SignatureState {
        private final FormSignature a;
        private Boolean b;
        private String c;
        private boolean d;
        private Exception e;
        static /* synthetic */ Class class$org$faceless$pdf2$viewer2$PDFViewer;

        public SignatureState(FormSignature formSignature, Boolean bl, String string, boolean bl2, Exception exception) {
            this.b = bl;
            this.c = string;
            this.d = bl2;
            this.e = exception;
            this.a = formSignature;
        }

        public Boolean getValidity() {
            return this.b;
        }

        public String getReason() {
            return this.c;
        }

        public boolean isAlteredSince() {
            return this.d;
        }

        public Exception getException() {
            return this.e;
        }

        public FormSignature getSignature() {
            return this.a;
        }

        public SignatureProvider getSignatureProvider() {
            return SignatureProvider.this;
        }

        public ImageIcon getIcon() {
            ImageIcon imageIcon;
            if (this.getValidity() == null) {
                Class<?> clazz = class$org$faceless$pdf2$viewer2$PDFViewer;
                if (clazz == null) {
                    clazz = class$org$faceless$pdf2$viewer2$PDFViewer = new PDFViewer[0].getClass().getComponentType();
                }
                imageIcon = new ImageIcon(clazz.getResource("resources/icons/help.png"));
            } else if (!this.getValidity().booleanValue()) {
                Class<?> clazz = class$org$faceless$pdf2$viewer2$PDFViewer;
                if (clazz == null) {
                    clazz = class$org$faceless$pdf2$viewer2$PDFViewer = new PDFViewer[0].getClass().getComponentType();
                }
                imageIcon = new ImageIcon(clazz.getResource("resources/icons/cross.png"));
            } else {
                int n2 = this.getSignature().getCertificationType();
                if (n2 == 0) {
                    Class<?> clazz = class$org$faceless$pdf2$viewer2$PDFViewer;
                    if (clazz == null) {
                        clazz = class$org$faceless$pdf2$viewer2$PDFViewer = new PDFViewer[0].getClass().getComponentType();
                    }
                    imageIcon = new ImageIcon(clazz.getResource("resources/icons/tick.png"));
                } else {
                    Class<?> clazz = class$org$faceless$pdf2$viewer2$PDFViewer;
                    if (clazz == null) {
                        clazz = class$org$faceless$pdf2$viewer2$PDFViewer = new PDFViewer[0].getClass().getComponentType();
                    }
                    imageIcon = new ImageIcon(clazz.getResource("resources/icons/rosette.png"));
                }
            }
            return imageIcon;
        }
    }
}

