/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.faceless.pdf2.viewer2.DocumentPanelEvent;
import org.faceless.pdf2.viewer2.DocumentPanelListener;
import org.faceless.pdf2.viewer2.DocumentViewport;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.PagePanel;
import org.faceless.pdf2.viewer2.PagePanelInteractionEvent;
import org.faceless.pdf2.viewer2.PagePanelInteractionListener;
import org.faceless.pdf2.viewer2.ToggleViewerWidget;

public abstract class AbstractRegionSelector
extends ToggleViewerWidget
implements DocumentPanelListener,
PagePanelInteractionListener {
    private JComponent q;
    private Point r;
    private ToggleViewerWidget s;

    protected AbstractRegionSelector(String string) {
        super(string, "Mode");
    }

    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        pDFViewer.addDocumentPanelListener(this);
    }

    public void setSelected(boolean bl) {
        if (bl) {
            ToggleViewerWidget toggleViewerWidget = this.getGroupSelection(this.getGroupName());
            if (!(toggleViewerWidget instanceof AbstractRegionSelector)) {
                this.s = toggleViewerWidget;
            }
            super.setSelected(true);
        } else {
            super.setSelected(false);
            if (this.s != null) {
                this.s.setSelected(true);
            }
        }
    }

    protected void updateViewport(DocumentViewport documentViewport, boolean bl) {
        if (bl) {
            documentViewport.addPagePanelInteractionListener(this);
            if (documentViewport.getPagePanel() != null) {
                documentViewport.getPagePanel().setCursor(Cursor.getPredefinedCursor(1));
            }
        } else {
            documentViewport.removePagePanelInteractionListener(this);
            if (documentViewport.getPagePanel() != null) {
                documentViewport.getPagePanel().setCursor(null);
            }
        }
    }

    public void documentUpdated(DocumentPanelEvent documentPanelEvent) {
        if (this.isSelected() && (documentPanelEvent.getType() == "viewportChanged" || documentPanelEvent.getType() == "activated")) {
            this.updateViewport(documentPanelEvent.getDocumentPanel().getViewport(), true);
        }
    }

    protected JComponent createRubberBoxComponent() {
        return new JPanel(){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                AbstractRegionSelector.this.paintRubberBandComponent(this, (Graphics2D)graphics);
                BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 15.0f, new float[]{4.0f, 4.0f}, (int)(System.currentTimeMillis() / 60L % 8L));
                graphics.setColor(Color.black);
                ((Graphics2D)graphics).setStroke(basicStroke);
                graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        };
    }

    public void pageAction(PagePanelInteractionEvent pagePanelInteractionEvent) {
        PagePanel pagePanel = pagePanelInteractionEvent.getPagePanel();
        if (this.isSelected()) {
            if (pagePanelInteractionEvent.getType() == "mousePressed") {
                this.q = this.createRubberBoxComponent();
                this.r = pagePanelInteractionEvent.getMouseEvent().getPoint();
                this.q.setLocation(this.r);
                this.q.setOpaque(false);
                this.q.setSize(0, 0);
                pagePanel.add(this.q);
                new Thread(){

                    public void run() {
                        while (true) {
                            try {
                                if (AbstractRegionSelector.this.q != null) {
                                    Thread.sleep(60L);
                                    JComponent jComponent = AbstractRegionSelector.this.q;
                                    if (jComponent == null) continue;
                                    jComponent.repaint();
                                    continue;
                                }
                                break;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                                break;
                            }
                        }
                    }
                }.start();
            } else if (pagePanelInteractionEvent.getType() == "mouseDragged" && this.r != null) {
                Point point = pagePanelInteractionEvent.getMouseEvent().getPoint();
                point.x = Math.min(Math.max(0, point.x), pagePanel.getWidth());
                point.y = Math.min(Math.max(0, point.y), pagePanel.getHeight());
                this.q.setLocation(Math.min(point.x, this.r.x), Math.min(point.y, this.r.y));
                this.q.setSize(Math.abs(point.x - this.r.x), Math.abs(point.y - this.r.y));
            } else if (pagePanelInteractionEvent.getType() == "mouseReleased" && this.r != null) {
                Point point = pagePanelInteractionEvent.getMouseEvent().getPoint();
                point.x = Math.min(Math.max(0, point.x), pagePanel.getWidth());
                point.y = Math.min(Math.max(0, point.y), pagePanel.getHeight());
                pagePanel.remove(this.q);
                pagePanel.repaint();
                if (!this.isSelectedAfterAction()) {
                    this.setSelected(false);
                }
                this.action(pagePanel, pagePanel.getPDFPoint(this.r.x, this.r.y), pagePanel.getPDFPoint(point.x, point.y));
                this.r = null;
                this.q = null;
            }
        }
    }

    public void paintRubberBandComponent(JComponent jComponent, Graphics2D graphics2D) {
    }

    public void action(PagePanel pagePanel, Point2D point2D, Point2D point2D2) {
    }

    protected boolean isSelectedAfterAction() {
        return false;
    }
}

