/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.faceless.pdf2.AnnotationStamp;
import org.faceless.pdf2.PDFAnnotation;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.PDFParser;
import org.faceless.pdf2.PagePainter;
import org.faceless.pdf2.viewer2.AnnotationComponentFactory;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.PagePanel;
import org.faceless.retrotranslator.net.sf.retrotranslator.runtime.java.lang._String;

public class AnnotationStampFactory
extends AnnotationComponentFactory {
    private int d = 40;
    private String[] e;
    public static final String[] PREDEFINED = new String[]{"stamp.stencil.Approved", "stamp.stencil.AsIs", "stamp.stencil.Confidential", "stamp.stencil.Departmental", "stamp.stencil.Draft", "stamp.stencil.Experimental", "stamp.stencil.Expired", "stamp.stencil.Final", "stamp.stencil.ForComment", "stamp.stencil.ForPublicRelease", "stamp.stencil.NotApproved", "stamp.stencil.NotForPublicRelease", "stamp.stencil.Sold", "stamp.stencil.TopSecret", "stamp.standard.Approved", "stamp.standard.Completed", "stamp.standard.Confidential", "stamp.standard.Draft", "stamp.standard.Final", "stamp.standard.ForComment", "stamp.standard.ForPublicRelease", "stamp.standard.InformationOnly", "stamp.standard.NotApproved", "stamp.standard.NotForPublicRelease", "stamp.standard.PreliminaryResults", "stamp.standard.Void", "stamp.signhere.Accepted", "stamp.signhere.Rejected", "stamp.signhere.SignHere", "stamp.signhere.InitialHere", "stamp.signhere.Witness"};

    public AnnotationStampFactory() {
        super("AnnotationStamp");
        this.setStampList(PREDEFINED);
    }

    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        String string = this.getFeatureProperty(pDFViewer, "stampList");
        if (string != null) {
            this.setStampList(_String.split(string, ", *"));
        }
        string = this.getFeatureProperty(pDFViewer, "stampHeight");
        if (string != null) {
            try {
                this.setStampHeight(Math.max(10, Integer.parseInt(string)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStampList(String[] stringArray) {
        if (stringArray != null && stringArray.length != 0) {
            this.e = stringArray;
            return;
        }
        throw new IllegalArgumentException("Stamplist length must be > 1");
    }

    public void setStampHeight(int n2) {
        this.d = n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean matches(PDFAnnotation pDFAnnotation) {
        if (pDFAnnotation instanceof AnnotationStamp) {
            String string = pDFAnnotation.getType();
            for (int n2 = 0; n2 < this.e.length; ++n2) {
                if (!this.e[n2].equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public String getAnnotationType() {
        return UIManager.getString("PDFViewer.annot.Stamp");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JComponent createComponent(PagePanel pagePanel, PDFAnnotation pDFAnnotation) {
        AnnotationStamp annotationStamp = (AnnotationStamp)pDFAnnotation;
        JComponent jComponent = super.createComponent(pagePanel, pDFAnnotation);
        if (!annotationStamp.isReadOnly() && !annotationStamp.isPositionLocked()) {
            this.makeComponentDraggable(jComponent, annotationStamp, true);
            return jComponent;
        }
        jComponent.setCursor(Cursor.getPredefinedCursor(12));
        return jComponent;
    }

    public PDFAnnotation createNewAnnotation(float f2, float f3, float f4, float f5) {
        AnnotationStamp annotationStamp = new AnnotationStamp();
        annotationStamp.setRectangle(f2, f3, f4, f5);
        return annotationStamp;
    }

    public JComponent createEditComponent(PDFAnnotation pDFAnnotation, boolean bl, boolean bl2) {
        try {
            final AnnotationStamp annotationStamp = (AnnotationStamp)pDFAnnotation;
            String string = annotationStamp.getType();
            DocumentPanel documentPanel = this.getViewer().getActiveDocumentPanel();
            PDFParser pDFParser = documentPanel.getParser();
            JPanel jPanel = new JPanel(new GridBagLayout());
            this.addStockDetailsToEditComponent(pDFAnnotation, jPanel);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 1;
            final b_ b_2 = new b_(pDFParser, this.d, this.e);
            final JList jList = new JList(this.e){

                public Dimension getPreferredScrollableViewportSize() {
                    return new Dimension(b_2.a(), AnnotationStampFactory.this.d * 4);
                }
            };
            jList.setCellRenderer(b_2);
            jList.setSelectedValue(string, false);
            jList.setFixedCellHeight(this.d);
            jList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    annotationStamp.setType((String)jList.getSelectedValue(), 1.0f);
                }
            });
            jPanel.add((Component)new JScrollPane(jList), gridBagConstraints);
            return jPanel;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return null;
        }
    }

    protected void copyAnnotationState(PDFAnnotation pDFAnnotation, PDFAnnotation pDFAnnotation2) {
        super.copyAnnotationState(pDFAnnotation, pDFAnnotation2);
        AnnotationStamp annotationStamp = (AnnotationStamp)pDFAnnotation;
        AnnotationStamp annotationStamp2 = (AnnotationStamp)pDFAnnotation2;
        annotationStamp2.setType(annotationStamp.getType(), annotationStamp.getOpacity());
    }

    public BufferedImage getStampImage(AnnotationStamp annotationStamp, int n2, PDFParser pDFParser) {
        float f2 = annotationStamp.getRecommendedWidth();
        float f3 = annotationStamp.getRecommendedHeight();
        PDFPage pDFPage = new PDFPage((int)f2, (int)f3);
        annotationStamp.setPage(pDFPage);
        annotationStamp.setRectangle(0.0f, 0.0f, pDFPage.getWidth(), pDFPage.getHeight());
        PagePainter pagePainter = pDFParser.getPagePainter(pDFPage);
        pagePainter.setBackground(null);
        float f4 = (float)n2 / f3 * 72.0f;
        return pagePainter.getImage(f4, PDFParser.RGBA);
    }

    public AnnotationStamp getStamp(String string) {
        return new AnnotationStamp(string, 1.0f);
    }

    private class b_
    extends JLabel
    implements ListCellRenderer {
        private final PDFParser a;
        private Map b = new HashMap();
        private final int c;
        private int d;

        b_(PDFParser pDFParser, int n2, String[] stringArray) {
            this.a = pDFParser;
            this.c = n2;
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                ImageIcon imageIcon = this.a(stringArray[i2], pDFParser);
                this.d = Math.max(this.d, imageIcon.getIconWidth());
            }
        }

        int a() {
            return this.d;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
            this.setIcon(this.a((String)object, this.a));
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            return this;
        }

        synchronized ImageIcon a(String string, PDFParser pDFParser) {
            ImageIcon imageIcon = (ImageIcon)this.b.get(string);
            if (imageIcon == null) {
                imageIcon = new ImageIcon(AnnotationStampFactory.this.getStampImage(AnnotationStampFactory.this.getStamp(string), this.c, pDFParser));
                this.b.put(string, imageIcon);
            }
            return imageIcon;
        }
    }
}

