/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsDevice;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.faceless.pdf2.PDFAction;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.viewer2.DocumentViewport;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.ViewerEvent;
import org.faceless.pdf2.viewer2.ViewerWidget;

public class FullScreenMode
extends ViewerWidget {
    private Container n;
    private int o;

    public FullScreenMode() {
        super("FullScreen");
        this.setMenu("View\tDisplay\tFullScreenMode", 'l');
    }

    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
    }

    public void action(ViewerEvent viewerEvent) {
        this.setFullScreen(this.n == null, viewerEvent.getDocumentPanel().getViewport());
    }

    public void setFullScreen(final boolean bl, final DocumentViewport documentViewport) {
        boolean bl2 = this.n != null;
        GraphicsDevice graphicsDevice = documentViewport.getGraphicsConfiguration().getDevice();
        if (bl2 == bl || !graphicsDevice.isFullScreenSupported()) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FullScreenMode.this.setFullScreen(bl, documentViewport);
                }
            });
            return;
        }
        if (bl) {
            this.n = documentViewport.getParent();
            for (int i2 = 0; i2 < this.n.getComponentCount(); ++i2) {
                if (this.n.getComponent(i2) != documentViewport) continue;
                this.o = i2;
                break;
            }
            JFrame jFrame = new JFrame(graphicsDevice.getDefaultConfiguration());
            jFrame.setUndecorated(true);
            jFrame.setResizable(false);
            jFrame.setContentPane(documentViewport);
            graphicsDevice.setFullScreenWindow(jFrame);
            jFrame.validate();
            InputMap inputMap = documentViewport.getInputMap(1);
            ActionMap actionMap = documentViewport.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke(27, 0), "exitFullScreen");
            actionMap.put("exitFullScreen", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FullScreenMode.this.setFullScreen(false, documentViewport);
                }
            });
            documentViewport.setFocusable(true);
            documentViewport.requestFocusInWindow();
            PDFPage pDFPage = documentViewport.getPage();
            if (pDFPage != null) {
                documentViewport.getDocumentPanel().runAction(PDFAction.goToFit(pDFPage));
            }
        } else {
            InputMap inputMap = documentViewport.getInputMap(1);
            inputMap.remove(KeyStroke.getKeyStroke(27, 0));
            documentViewport.getActionMap().remove("exitFullScreen");
            if (this.o == 0) {
                this.n.add(documentViewport);
            } else {
                this.n.add((Component)documentViewport, this.o);
            }
            graphicsDevice.setFullScreenWindow(null);
            new Thread(){

                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            documentViewport.invalidate();
                            documentViewport.validate();
                            documentViewport.repaint();
                        }
                    });
                }
            }.start();
            this.n = null;
        }
    }
}

