/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFAction;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.viewer2.ActionHandler;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.PagePanel;
import org.faceless.pdf2.viewer2.Util;

public class GoToActionHandler
extends ActionHandler {
    public static GoToActionHandler getInstance() {
        return new GoToActionHandler();
    }

    public GoToActionHandler() {
        super("GoToActionHandler");
    }

    public boolean matches(DocumentPanel documentPanel, PDFAction pDFAction) {
        String string = pDFAction.getType();
        return string.equals("GoToFit") || string.equals("GoTo") || string.equals("GoToFitWidth") || string.equals("GoToFitHeight") || string.equals("GoToFitRectangle") || string.equals("Named:FirstPage") || string.equals("Named:PrevPage") || string.equals("Named:NextPage") || string.equals("Named:LastPage");
    }

    public void run(DocumentPanel documentPanel, PDFAction pDFAction) {
        PDF pDF = documentPanel.getPDF();
        int n2 = documentPanel.getPageNumber();
        PDFPage pDFPage = null;
        float f2 = Float.NaN;
        float f3 = Float.NaN;
        float f4 = 0.0f;
        Rectangle2D rectangle2D = null;
        String string = pDFAction.getType();
        if (string.equals("GoTo")) {
            pDFPage = pDFAction.getPage();
            if (pDFPage != null) {
                rectangle2D = PagePanel.getFullPageView(pDFPage);
                float[] fArray = pDFAction.getGoToCoordinates();
                if (fArray != null && fArray.length >= 3) {
                    f2 = fArray[0];
                    f3 = fArray[1];
                    f4 = fArray[2];
                }
            }
        } else if (string.equals("GoToFit")) {
            pDFPage = pDFAction.getPage();
            if (pDFPage != null) {
                rectangle2D = PagePanel.getFullPageView(pDFPage);
                f4 = documentPanel.getViewport().getTargetZoom(1, pDFPage);
            }
        } else if (string.equals("GoToFitWidth")) {
            pDFPage = pDFAction.getPage();
            if (pDFPage != null) {
                rectangle2D = PagePanel.getFullPageView(pDFPage);
                f4 = documentPanel.getViewport().getTargetZoom(2, pDFPage);
                float[] fArray = pDFAction.getGoToCoordinates();
                if (fArray != null && fArray.length >= 1) {
                    f3 = fArray[0];
                }
            }
        } else if (string.equals("GoToFitHeight")) {
            pDFPage = pDFAction.getPage();
            if (pDFPage != null) {
                rectangle2D = PagePanel.getFullPageView(pDFPage);
                f4 = documentPanel.getViewport().getTargetZoom(3, pDFPage);
                float[] fArray = pDFAction.getGoToCoordinates();
                if (fArray != null && fArray.length >= 1) {
                    f2 = fArray[0];
                }
            }
        } else if (string.equals("GoToFitRectangle")) {
            pDFPage = pDFAction.getPage();
            if (pDFPage != null) {
                rectangle2D = PagePanel.getFullPageView(pDFPage);
                float[] fArray = pDFAction.getGoToCoordinates();
                if (fArray != null && fArray.length >= 4) {
                    Dimension dimension = documentPanel.getViewport().getViewportSize();
                    double d2 = dimension.getWidth() - 4.0;
                    double d3 = dimension.getHeight() - 4.0;
                    int n3 = Util.getScreenResolution(documentPanel);
                    f2 = Math.min(fArray[0], fArray[2]);
                    f3 = Math.max(fArray[1], fArray[3]);
                    float f5 = Math.abs(fArray[2] - fArray[0]);
                    float f6 = Math.abs(fArray[3] - fArray[1]);
                    f4 = (float)Math.min(d2 / (double)f5, d3 / (double)f6) / (float)n3 * 72.0f;
                    f2 = (float)((double)f2 + (double)f5 / 2.0);
                    f3 = (float)((double)f3 - (double)f6 / 2.0);
                }
            }
        } else if (string.equals("Named:NextPage")) {
            if (n2 < pDF.getNumberOfPages() - 1) {
                pDFPage = pDF.getPage(n2 + 1);
            }
        } else if (string.equals("Named:PrevPage")) {
            if (n2 > 0) {
                pDFPage = pDF.getPage(n2 - 1);
            }
        } else if (string.equals("Named:FirstPage")) {
            pDFPage = pDF.getPage(0);
        } else if (string.equals("Named:LastPage")) {
            pDFPage = pDF.getPage(pDF.getNumberOfPages() - 1);
        }
        if (pDFPage != null && pDF.getPages().contains(pDFPage)) {
            if (f2 == f2 && ((f2 = (float)((double)f2 - rectangle2D.getMinX())) < 0.0f || (double)f2 > rectangle2D.getWidth())) {
                f2 = Float.NaN;
            }
            if (f3 == f3 && ((f3 = (float)(rectangle2D.getMaxY() - (double)f3)) < 0.0f || (double)f3 > rectangle2D.getHeight())) {
                f3 = Float.NaN;
            }
            if (f4 < 0.0f || f4 > 64.0f) {
                f4 = Float.NaN;
            }
            documentPanel.setPage(pDFPage, f2, f3, f4);
        }
    }
}

