/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import org.faceless.pdf2.AnnotationMarkup;
import org.faceless.pdf2.PDFAnnotation;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.PagePanel;
import org.faceless.pdf2.viewer2.ViewerFeature;
import org.faceless.pdf2.viewer2.feature.AreaSelectionAction;
import org.faceless.pdf2.viewer2.feature.TextSelection;
import org.faceless.pdf2.viewer2.feature.TextSelectionAction;
import org.faceless.pdf2.viewer2.util.PropertyParser;

public class MarkupSelectionAction
extends ViewerFeature
implements TextSelectionAction,
AreaSelectionAction {
    private Color b = Color.yellow;
    private String c = "Highlight";
    private String d;

    public MarkupSelectionAction(String string) {
        super(string);
    }

    public void setDescription(String string) {
        this.d = string;
    }

    public String getDescription() {
        String string = UIManager.getString(this.d);
        if (string != null) {
            return string;
        }
        return this.d;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setType(String string) {
        if (!("Highlight".equals(string) || "Underline".equals(string) || "StrikeOut".equals(string) || "Squiggly".equals(string))) {
            throw new IllegalArgumentException("Invalid type " + string);
        }
        this.c = string;
    }

    public void setColor(Color color) {
        this.b = color;
    }

    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        this.b = PropertyParser.getColor(this.getFeatureProperty(pDFViewer, "color"), this.b);
        String string = this.getFeatureProperty(pDFViewer, "type");
        if (string != null) {
            this.setType(string);
        }
        string = this.getFeatureProperty(pDFViewer, "description");
        if (string != null) {
            this.setDescription(string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void selectAction(DocumentPanel documentPanel, TextSelection.RangeList rangeList) {
        PDFPage pDFPage = null;
        final LinkedHashMap<AnnotationMarkup, PDFPage> linkedHashMap = new LinkedHashMap<AnnotationMarkup, PDFPage>();
        int n2 = 0;
        while (true) {
            PDFPage pDFPage2;
            if (n2 > rangeList.size()) {
                documentPanel.fireUndoableEditEvent(new UndoableEditEvent(documentPanel, new AbstractUndoableEdit(){

                    public String getPresentationName() {
                        return MarkupSelectionAction.this.getDescription();
                    }

                    public void undo() {
                        super.undo();
                        Iterator iterator = linkedHashMap.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            PDFAnnotation pDFAnnotation = (PDFAnnotation)entry.getKey();
                            pDFAnnotation.setPage(null);
                        }
                    }

                    public void redo() {
                        super.redo();
                        Iterator iterator = linkedHashMap.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            PDFAnnotation pDFAnnotation = (PDFAnnotation)entry.getKey();
                            PDFPage pDFPage = (PDFPage)entry.getValue();
                            pDFAnnotation.setPage(pDFPage);
                        }
                    }
                }));
                return;
            }
            PDFPage pDFPage3 = pDFPage2 = n2 == rangeList.size() ? null : ((TextSelection.Range)rangeList.get(n2)).getPage();
            if (pDFPage2 != pDFPage && pDFPage != null) {
                AnnotationMarkup annotationMarkup = new AnnotationMarkup(this.c);
                annotationMarkup.setColor(this.b);
                annotationMarkup.setCorners(rangeList.getCorners(pDFPage));
                pDFPage.getAnnotations().add(annotationMarkup);
                linkedHashMap.put(annotationMarkup, pDFPage);
            }
            pDFPage = pDFPage2;
            ++n2;
        }
    }

    public void selectArea(PagePanel pagePanel, Rectangle2D rectangle2D) {
        final PDFPage pDFPage = pagePanel.getPage();
        DocumentPanel documentPanel = pagePanel.getDocumentPanel();
        final AnnotationMarkup annotationMarkup = new AnnotationMarkup(this.c);
        annotationMarkup.setColor(this.b);
        annotationMarkup.setRectangle((float)rectangle2D.getMinX(), (float)rectangle2D.getMinY(), (float)rectangle2D.getMaxX(), (float)rectangle2D.getMaxY());
        pDFPage.getAnnotations().add(annotationMarkup);
        documentPanel.fireUndoableEditEvent(new UndoableEditEvent(documentPanel, new AbstractUndoableEdit(){

            public String getPresentationName() {
                return MarkupSelectionAction.this.getDescription();
            }

            public void undo() {
                super.undo();
                annotationMarkup.setPage(null);
            }

            public void redo() {
                super.redo();
                annotationMarkup.setPage(pDFPage);
            }
        }));
    }
}

