/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import org.faceless.pdf2.PDF;
import org.faceless.pdf2.viewer2.DocumentPanelEvent;
import org.faceless.pdf2.viewer2.DocumentPanelListener;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.ViewerEvent;
import org.faceless.pdf2.viewer2.ViewerWidget;

public class PageLast
extends ViewerWidget
implements DocumentPanelListener {
    public PageLast() {
        super("PageLast");
        this.setButton("Navigation.ltr", "resources/icons/LastPage.png", "PDFViewer.tt.PageLast");
        this.setMenu("View\tGoTo\tLastPage");
    }

    public void action(ViewerEvent viewerEvent) {
        viewerEvent.getDocumentPanel().setPageNumber(viewerEvent.getPDF().getNumberOfPages() - 1);
    }

    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        pDFViewer.addDocumentPanelListener(this);
    }

    public void documentUpdated(DocumentPanelEvent documentPanelEvent) {
        if (documentPanelEvent.getType() == "pageChanged" || documentPanelEvent.getType() == "activated") {
            PDF pDF = documentPanelEvent.getDocumentPanel().getPDF();
            boolean bl = pDF != null && documentPanelEvent.getDocumentPanel().getPageNumber() < pDF.getNumberOfPages() - 1;
            documentPanelEvent.getDocumentPanel().getViewer().getNamedComponent("ButtonPageLast").setEnabled(bl);
            documentPanelEvent.getDocumentPanel().getViewer().getNamedComponent("MenuPageLast").setEnabled(bl);
        }
    }
}

