/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.Color;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.swing.UIManager;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.Redactor;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.PagePanel;
import org.faceless.pdf2.viewer2.Util;
import org.faceless.pdf2.viewer2.ViewerFeature;
import org.faceless.pdf2.viewer2.feature.AreaSelectionAction;
import org.faceless.pdf2.viewer2.feature.TextSelection;
import org.faceless.pdf2.viewer2.feature.TextSelectionAction;
import org.faceless.pdf2.viewer2.util.PropertyParser;

public class RedactSelectionAction
extends ViewerFeature
implements TextSelectionAction,
AreaSelectionAction {
    private Color b;

    public RedactSelectionAction() {
        super("RedactSelectionAction");
    }

    public void setColor(Color color) {
        this.b = color;
    }

    public Color getColor() {
        return this.b;
    }

    public String getDescription() {
        return UIManager.getString("PDFViewer.Redact");
    }

    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        this.setColor(PropertyParser.getColor(this.getFeatureProperty(pDFViewer, "color"), this.getColor()));
    }

    private Redactor a() {
        Redactor redactor = new Redactor();
        if (this.b != null) {
            redactor.setRedactionColor(this.b);
        }
        return redactor;
    }

    public void selectAction(DocumentPanel documentPanel, TextSelection.RangeList rangeList) {
        Redactor redactor = this.a();
        Set set = rangeList.getPages();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            PDFPage pDFPage = (PDFPage)iterator.next();
            float[] fArray = rangeList.getCorners(pDFPage);
            Area area = new Area();
            for (int i2 = 0; i2 < fArray.length; i2 += 8) {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(fArray[i2 + 0], fArray[i2 + 1]);
                generalPath.lineTo(fArray[i2 + 2], fArray[i2 + 3]);
                generalPath.lineTo(fArray[i2 + 4], fArray[i2 + 5]);
                generalPath.lineTo(fArray[i2 + 6], fArray[i2 + 7]);
                generalPath.closePath();
                area.add(new Area(generalPath));
            }
            redactor.addArea(pDFPage, area);
        }
        try {
            redactor.redact();
        }
        catch (IOException iOException) {
            Util.displayThrowable(iOException, documentPanel);
        }
    }

    public void selectArea(PagePanel pagePanel, Rectangle2D rectangle2D) {
        PDFPage pDFPage = pagePanel.getPage();
        Redactor redactor = this.a();
        redactor.addArea(pDFPage, new Area(rectangle2D));
        try {
            redactor.redact();
        }
        catch (IOException iOException) {
            Util.displayThrowable(iOException, pagePanel.getDocumentPanel().getViewer());
        }
    }
}

