/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.faceless.pdf2.FormSignature;
import org.faceless.pdf2.OutputProfile;
import org.faceless.pdf2.RemoteSignatureHandlerFactory;
import org.faceless.pdf2.SignatureHandler;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.SignatureProvider;
import org.faceless.pdf2.viewer2.util.DialogPanel;

public class RemoteSignatureProvider
extends SignatureProvider {
    private RemoteSignatureHandlerFactory c;

    public RemoteSignatureProvider() {
        super("RemoteSignatureProvider");
    }

    public String getDisplayName() {
        String string = this.c == null ? null : "Service at " + this.c.getURL();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        String string2 = this.getFeatureProperty(pDFViewer, "url");
        if (string2 == null) return;
        try {
            this.setSignatureHandlerFactory(new RemoteSignatureHandlerFactory(new URL(string2)));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        String string = this.getFeatureProperty(pDFViewer, "digestAlgorithm");
        if (string == null) return;
        if (this.c == null) return;
        this.c.setDigestAlgorithm(string);
    }

    protected String getDefaultAlias() {
        return this.getFeatureProperty(this.getViewer(), "alias");
    }

    public void setSignatureHandlerFactory(RemoteSignatureHandlerFactory remoteSignatureHandlerFactory) {
        this.c = remoteSignatureHandlerFactory;
    }

    public boolean canSign(FormSignature formSignature) {
        boolean bl = this.c != null;
        return bl;
    }

    public boolean canVerify(FormSignature formSignature) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void showSignDialog(JComponent jComponent, FormSignature formSignature) throws IOException, GeneralSecurityException {
        Object object;
        DialogPanel dialogPanel = new DialogPanel();
        String string = this.getDefaultAlias();
        String string2 = this.getDefaultName();
        String string3 = this.getDefaultReason();
        String string4 = this.getDefaultLocation();
        int n2 = this.getDefaultCertificationType();
        JTextField jTextField = new JTextField(string);
        JTextField jTextField2 = new JTextField(string2);
        JTextField jTextField3 = new JTextField(string3);
        JTextField jTextField4 = new JTextField(string4);
        JComboBox<String> jComboBox = null;
        if (string != null) {
            jTextField.setEditable(false);
        }
        if (string2 != null) {
            jTextField2.setEditable(false);
        }
        if (string3 != null) {
            jTextField3.setEditable(false);
        }
        if (string4 != null) {
            jTextField4.setEditable(false);
        }
        if (formSignature.getForm().getPDF().getBasicOutputProfile().isSet(OutputProfile.Feature.DigitallySigned)) {
            n2 = 0;
        }
        if (n2 == -1) {
            object = new String[]{UIManager.getString("PDFViewer.cert.Uncertified"), UIManager.getString("PDFViewer.cert.NoChanges"), UIManager.getString("PDFViewer.cert.ModifyForms"), UIManager.getString("PDFViewer.cert.ModifyComments")};
            jComboBox = new JComboBox<String>((E[])object);
        }
        dialogPanel.addComponent("Alias", jTextField);
        dialogPanel.addComponent("Name", jTextField2);
        dialogPanel.addComponent("Reason", jTextField3);
        dialogPanel.addComponent("Location", jTextField4);
        if (jComboBox != null) {
            dialogPanel.addComponent("Certification", jComboBox);
        }
        if (string == null || string2 == null || string3 == null || string4 == null || n2 == -1) {
            if (!dialogPanel.showDialog(jComponent)) return;
        }
        if (jTextField != null) {
            string = jTextField.getText();
        }
        if (jTextField2 != null) {
            string2 = jTextField2.getText();
        }
        if (jTextField3 != null) {
            string3 = jTextField3.getText();
        }
        if (jTextField4 != null) {
            try {
                string4 = jTextField4.getText();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (jComboBox != null) {
            n2 = jComboBox.getSelectedIndex();
        }
        formSignature.sign(null, string, null, this.c);
        formSignature.setCertificationType(n2, null);
        if (string3.length() > 0) {
            try {
                formSignature.setReason(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string4.length() > 0) {
            try {
                formSignature.setLocation(string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string2.length() == 0) {
            object = formSignature.getSignatureHandler();
            string2 = ((SignatureHandler)object).getDefaultName();
        }
        if (string2 == null) return;
        if (string2.length() <= 0) return;
        try {
            formSignature.setName(string2);
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showVerifyDialog(JComponent jComponent, FormSignature formSignature) {
    }
}

