/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import org.faceless.pdf2.EncryptionHandler;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.DocumentPanelEvent;
import org.faceless.pdf2.viewer2.DocumentPanelListener;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.ViewerEvent;
import org.faceless.pdf2.viewer2.ViewerWidget;

public class RotateClockwise
extends ViewerWidget
implements DocumentPanelListener {
    protected RotateClockwise(String string) {
        super(string);
        this.setButton("Edit", "resources/icons/" + string + ".png", "PDFViewer.tt." + string);
        this.setMenu("View\t" + string);
    }

    public RotateClockwise() {
        this("RotateClockwise");
    }

    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        pDFViewer.addDocumentPanelListener(this);
        this.getComponent().setEnabled(false);
    }

    public void documentUpdated(DocumentPanelEvent documentPanelEvent) {
        if (documentPanelEvent.getType() == "activated" || documentPanelEvent.getType() == "redrawn") {
            PDF pDF = documentPanelEvent.getDocumentPanel().getPDF();
            EncryptionHandler encryptionHandler = pDF == null ? null : pDF.getEncryptionHandler();
            this.getComponent().setEnabled(encryptionHandler == null || encryptionHandler.hasRight("Assemble"));
        } else if (documentPanelEvent.getType() == "deactivated") {
            this.getComponent().setEnabled(false);
        }
    }

    public void action(ViewerEvent viewerEvent) {
        this.rotate(viewerEvent, 90);
    }

    protected void rotate(ViewerEvent viewerEvent, final int n2) {
        DocumentPanel documentPanel = viewerEvent.getDocumentPanel();
        final PDFPage pDFPage = viewerEvent.getDocumentPanel().getPage();
        pDFPage.setPageOrientation(pDFPage.getPageOrientation() + n2);
        documentPanel.fireUndoableEditEvent(new UndoableEditEvent(documentPanel, new AbstractUndoableEdit(){

            public String getPresentationName() {
                return UIManager.getString("PDFViewer.RotateClockwise");
            }

            public void undo() {
                super.undo();
                this.a(-n2);
            }

            public void redo() {
                super.redo();
                this.a(n2);
            }

            private void a(int n22) {
                pDFPage.setPageOrientation(pDFPage.getPageOrientation() + n22);
            }
        }));
    }

    public boolean isButtonEnabledByDefault() {
        return false;
    }
}

