/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.faceless.pdf2.EncryptionHandler;
import org.faceless.pdf2.OutputProfile;
import org.faceless.pdf2.PDF;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.DocumentPanelEvent;
import org.faceless.pdf2.viewer2.DocumentPanelListener;
import org.faceless.pdf2.viewer2.Exporter;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.Util;
import org.faceless.pdf2.viewer2.ViewerEvent;
import org.faceless.pdf2.viewer2.ViewerFeature;
import org.faceless.pdf2.viewer2.ViewerWidget;
import org.faceless.pdf2.viewer2.feature.PDFExporter;
import org.faceless.pdf2.viewer2.util.DialogPanel;

public class Save
extends ViewerWidget
implements DocumentPanelListener {
    private boolean n = false;

    public Save() {
        super("Save");
        this.setButton("Document", "resources/icons/disk.png", "PDFViewer.tt.Save");
        this.setMenu("File\tSave", 's');
    }

    public boolean isEnabledByDefault() {
        return Util.hasFilePermission();
    }

    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        String string = this.getFeatureProperty(pDFViewer, "promptOnOverwrite");
        if (string != null) {
            this.setPromptOnOverwrite("true".equals(string));
        }
        pDFViewer.addDocumentPanelListener(this);
    }

    public void documentUpdated(DocumentPanelEvent documentPanelEvent) {
        if (documentPanelEvent.getType() == "activated" && documentPanelEvent.getDocumentPanel().getPDF() != null) {
            EncryptionHandler encryptionHandler = documentPanelEvent.getDocumentPanel().getPDF().getEncryptionHandler();
            boolean bl = encryptionHandler == null || encryptionHandler.hasRight("Save");
            documentPanelEvent.getDocumentPanel().getViewer().getNamedComponent("ButtonSave").setEnabled(bl);
            documentPanelEvent.getDocumentPanel().getViewer().getNamedComponent("MenuSave").setEnabled(bl);
        }
    }

    public void setPromptOnOverwrite(boolean bl) {
        this.n = bl;
    }

    public void action(ViewerEvent viewerEvent) {
        Save.save(viewerEvent, null, null, true, this.n);
    }

    public static void save(final ViewerEvent viewerEvent, final Exporter exporter, final String string, boolean bl, final boolean bl2) {
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object run() {
                boolean bl;
                Serializable serializable;
                Object object;
                Object object2;
                DocumentPanel documentPanel = viewerEvent.getDocumentPanel();
                PDFViewer pDFViewer = viewerEvent.getViewer();
                final Exporter[] exporterArray = new Exporter[]{exporter};
                final LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>();
                File file = null;
                file = string != null ? new File(string) : (File)documentPanel.getClientProperty("file");
                if (file == null) {
                    try {
                        file = new File(System.getProperty("user.dir"));
                    }
                    catch (SecurityException securityException) {
                        file = File.listRoots()[0];
                    }
                }
                final JFileChooser jFileChooser = new JFileChooser(file);
                FileFilter fileFilter = null;
                PDF pDF = viewerEvent.getPDF();
                ViewerFeature[] viewerFeatureArray = viewerEvent.getViewer().getFeatures();
                for (int i2 = 0; i2 < viewerFeatureArray.length; ++i2) {
                    if (!(viewerFeatureArray[i2] instanceof Exporter) || !((Exporter)(object2 = (Exporter)viewerFeatureArray[i2])).isEnabled(pDF)) continue;
                    object = ((Exporter)object2).getFileFilter();
                    if (fileFilter == null || object2 == exporter || exporter == null && object2 instanceof PDFExporter) {
                        fileFilter = object;
                    }
                    jFileChooser.addChoosableFileFilter((FileFilter)object);
                    linkedHashMap.put(object, object2);
                }
                if (linkedHashMap.size() == 0) {
                    PDFExporter pDFExporter = new PDFExporter();
                    fileFilter = ((Exporter)pDFExporter).getFileFilter();
                    jFileChooser.addChoosableFileFilter(fileFilter);
                    linkedHashMap.put(pDFExporter, fileFilter);
                }
                jFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        Exporter exporter;
                        if (propertyChangeEvent.getPropertyName().equals("fileFilterChanged") && (exporter = (Exporter)linkedHashMap.get(jFileChooser.getFileFilter())) != null) {
                            exporterArray[0] = exporter;
                            if (jFileChooser.getUI() instanceof BasicFileChooserUI) {
                                int n2;
                                BasicFileChooserUI basicFileChooserUI = (BasicFileChooserUI)jFileChooser.getUI();
                                String string = basicFileChooserUI.getFileName();
                                int n3 = n2 = string == null ? -1 : string.lastIndexOf(".");
                                if (n2 > 0 && string.length() - n2 < 5) {
                                    string = string.substring(0, n2 + 1) + exporter.getFileSuffix();
                                    basicFileChooserUI.setFileName(string);
                                    if (jFileChooser.getSelectedFile() != null) {
                                        jFileChooser.setSelectedFile(new File(jFileChooser.getSelectedFile(), string));
                                    }
                                }
                            } else {
                                File file = jFileChooser.getSelectedFile();
                                if (file != null) {
                                    int n4;
                                    String string = file.getName();
                                    int n5 = n4 = string == null ? -1 : string.lastIndexOf(".");
                                    if (n4 > 0 && string.length() - n4 < 5) {
                                        string = string.substring(0, n4 + 1) + exporter.getFileSuffix();
                                        jFileChooser.setSelectedFile(new File(file, string));
                                    }
                                }
                            }
                        }
                    }
                });
                jFileChooser.setFileFilter(fileFilter);
                jFileChooser.setSelectedFile(file);
                if (jFileChooser.showSaveDialog(pDFViewer) != 0) return null;
                File file2 = jFileChooser.getSelectedFile();
                if (file2.exists() && !file2.canWrite()) {
                    object2 = Util.getUIString("PDFViewer.ReadOnly", file2.getName());
                    JOptionPane.showMessageDialog(pDFViewer, object2, UIManager.getString("PDFViewer.Error"), 0);
                    return null;
                }
                if (file2.exists() && bl2) {
                    if (JOptionPane.showConfirmDialog(pDFViewer, UIManager.getString("PDFViewer.OverwriteFile"), UIManager.getString("PDFViewer.OverwriteFile"), 0) != 0) return null;
                }
                if ((object = ((Exporter)(object2 = exporterArray[0])).getComponent()) != null) {
                    serializable = new DialogPanel((Exporter)object2, (JComponent)object){
                        final /* synthetic */ Exporter val$exporter;
                        final /* synthetic */ JComponent val$secondarycomp;
                        {
                            this.val$exporter = exporter;
                            this.val$secondarycomp = jComponent;
                        }

                        public String validateDialog() {
                            return this.val$exporter.validateComponent(this.val$secondarycomp);
                        }
                    };
                    ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                    ((DialogPanel)serializable).addComponent((JComponent)object);
                    ((DialogPanel)serializable).setButtonText("ok", UIManager.getString("PDFViewer.Save"));
                    bl = ((DialogPanel)serializable).showDialog(pDFViewer, Util.getUIString("PDFViewer.SavingFile", "PDF"));
                } else {
                    bl = true;
                }
                if (!bl) return null;
                try {
                    Object object3;
                    pDF.getBasicOutputProfile().clearRequired(OutputProfile.Feature.MultipleRevisions);
                    if (file2.exists()) {
                        object3 = file2.getName();
                        object3 = ((String)object3).substring(0, ((String)object3).lastIndexOf(".") + 1);
                        serializable = File.createTempFile((String)object3, null, file2.getParentFile());
                        if (file2.getCanonicalFile().equals(file.getCanonicalFile())) {
                            pDF.getBasicOutputProfile().setRequired(OutputProfile.Feature.MultipleRevisions);
                        }
                    } else {
                        serializable = file2;
                    }
                    object3 = new FileOutputStream((File)serializable);
                    Exporter.ExporterTask exporterTask = exporterArray[0].getExporter(documentPanel, documentPanel.getPDF(), (JComponent)object, (OutputStream)object3);
                    exporterTask.addPropertyChangeListener(new PropertyChangeListener((File)serializable, file2, (OutputStream)object3, pDFViewer, documentPanel){
                        final /* synthetic */ File val$tempfile;
                        final /* synthetic */ File val$targetfile;
                        final /* synthetic */ OutputStream val$out;
                        final /* synthetic */ PDFViewer val$viewer;
                        final /* synthetic */ DocumentPanel val$docpanel;
                        {
                            this.val$tempfile = file;
                            this.val$targetfile = file2;
                            this.val$out = outputStream;
                            this.val$viewer = pDFViewer;
                            this.val$docpanel = documentPanel;
                        }

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            if (!propertyChangeEvent.getPropertyName().equals("state")) return;
                            if (!"running".equals(propertyChangeEvent.getOldValue())) return;
                            if (this.val$tempfile == this.val$targetfile) return;
                            if ("cancelled".equals(propertyChangeEvent.getNewValue())) {
                                try {
                                    this.val$out.close();
                                }
                                catch (IOException iOException) {
                                    Util.displayThrowable(iOException, this.val$viewer);
                                }
                                if (this.val$tempfile.delete()) return;
                                this.val$tempfile.deleteOnExit();
                                return;
                            }
                            if (!"completed".equals(propertyChangeEvent.getNewValue())) return;
                            this.val$docpanel.getPDF().close();
                            boolean bl = System.getProperty("os.name").startsWith("Windows");
                            if (!bl || this.val$targetfile.delete()) {
                                if (this.val$tempfile.renameTo(this.val$targetfile)) return;
                            }
                            IOException iOException = new IOException("Couldn't rename \"" + this.val$tempfile + "\" to \"" + this.val$targetfile + "\"");
                            Util.displayThrowable(iOException, this.val$viewer);
                        }
                    });
                    exporterTask.start(pDFViewer, Util.getUIString("PDFViewer.SavingFile", file2.toString()));
                    return null;
                }
                catch (IOException iOException) {
                    Util.displayThrowable(iOException, pDFViewer);
                }
                return null;
            }
        });
    }
}

