/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.faceless.pdf2.PDFParser;
import org.faceless.pdf2.PageExtractor;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.DocumentPanelEvent;
import org.faceless.pdf2.viewer2.DocumentPanelListener;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.SidePanel;
import org.faceless.pdf2.viewer2.SidePanelFactory;
import org.faceless.pdf2.viewer2.Util;
import org.faceless.pdf2.viewer2.feature.TextTool;

public class SearchPanel
extends SidePanelFactory {
    private boolean b = true;
    private TextTool c;

    public SearchPanel() {
        super("SearchPanel");
    }

    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        String string = this.getFeatureProperty(pDFViewer, "createSearchField");
        if (string != null) {
            this.setCreateSearchField("true".equals(string));
        }
    }

    public void setCreateSearchField(boolean bl) {
        this.b = bl;
    }

    public void setTextTool(TextTool textTool) {
        this.c = textTool;
    }

    public SidePanel createSidePanel() {
        final Results results = new Results();
        if (this.c != null) {
            results.setTextTool(this.c);
        }
        if (this.b) {
            final Field field = new Field();
            results.add((Component)field, "North");
            results.addChangeListener(field);
            field.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    results.search(field.getText());
                }
            });
            field.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke("ESCAPE"), new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    field.setText("");
                    results.cancel();
                }
            });
        }
        return results;
    }

    public static class Field
    extends JTextField
    implements ChangeListener {
        private float a;
        private Paint b = new Color(0x20000000, true);
        private GeneralPath c = new GeneralPath();
        private Insets d;

        public Field() {
            this(15);
        }

        public Field(int n2) {
            super(n2);
            this.c.moveTo(1.0f, 1.0f);
            this.c.lineTo(0.683f, 0.683f);
            this.c.append(new Ellipse2D.Float(0.0f, 0.0f, 0.8f, 0.8f), false);
            this.d = this.getInsets();
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n2 = (int)((float)(this.getWidth() - this.d.left - this.d.right) * this.a);
            int n3 = this.getHeight() - this.d.top - this.d.bottom;
            ((Graphics2D)graphics).setPaint(this.b);
            graphics.fillRect(this.d.left, this.d.top, n2, n3);
            ((Graphics2D)graphics).setColor(new Color(0x40000000, true));
            ((Graphics2D)graphics).setStroke(new BasicStroke(2.0f));
            double d2 = this.getFont().getSize2D() - 2.0f;
            if (this.getComponentOrientation().isLeftToRight()) {
                ((Graphics2D)graphics).draw(this.c.createTransformedShape(new AffineTransform(d2, 0.0, 0.0, d2, (double)(this.getWidth() - this.d.right) - d2 - 2.0, (double)this.d.top + ((double)n3 - d2) / 2.0)));
            } else {
                ((Graphics2D)graphics).draw(this.c.createTransformedShape(new AffineTransform(d2, 0.0, 0.0, d2, (double)(this.d.left + 2), (double)this.d.top + ((double)n3 - d2) / 2.0)));
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() instanceof Results) {
                this.a = Math.max(0.0f, Math.min(1.0f, ((Results)changeEvent.getSource()).getSearchProgress()));
                this.repaint();
            }
        }
    }

    public static class Results
    extends JPanel
    implements SidePanel,
    DocumentPanelListener,
    PropertyChangeListener {
        private TextTool a;
        private DocumentPanel b;
        private PageExtractor[] c;
        private f_ d;
        private e_ e;
        private DefaultListModel f;
        private Collection g;
        private float h;
        private Icon i;
        static /* synthetic */ Class class$org$faceless$pdf2$viewer2$feature$TextTool;
        static /* synthetic */ Class class$org$faceless$pdf2$viewer2$PDFViewer;

        public Results() {
            this.setLayout(new BorderLayout());
            this.g = new ArrayList(1);
            this.f = new DefaultListModel();
            Class<?> clazz = class$org$faceless$pdf2$viewer2$PDFViewer;
            if (clazz == null) {
                clazz = class$org$faceless$pdf2$viewer2$PDFViewer = new PDFViewer[0].getClass().getComponentType();
            }
            this.i = new ImageIcon(clazz.getResource("resources/icons/searchresults.png"));
            final JList jList = new JList(this.f);
            jList.setSelectionMode(0);
            jList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    g_ g_2;
                    if (!listSelectionEvent.getValueIsAdjusting() && jList.getSelectedIndex() != 0 && (g_2 = (g_)jList.getSelectedValue()) != null) {
                        Results.this.a.select(g_2.a);
                    }
                }
            });
            jList.setCellRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
                    if (n2 == 0) {
                        JLabel jLabel = new JLabel(object.toString());
                        jLabel.setForeground(Color.gray);
                        return jLabel;
                    }
                    g_ g_2 = (g_)object;
                    g_2.setComponentOrientation(jList.getComponentOrientation());
                    g_2.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
                    g_2.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
                    g_2.setEnabled(jList.isEnabled());
                    g_2.setFont(jList.getFont());
                    g_2.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : BorderFactory.createEmptyBorder(1, 1, 1, 1));
                    return g_2;
                }
            });
            this.add(new JScrollPane(jList));
        }

        public String getName() {
            return "Find";
        }

        public Icon getIcon() {
            return this.i;
        }

        public void setTextTool(TextTool textTool) {
            this.a = textTool;
        }

        public void addResult(final PageExtractor.Text text) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (Results.this.f.size() == 0) {
                        Results.this.f.addElement(Util.getUIString("PDFViewer.nResults", "1") + "\u2026");
                    } else {
                        Results.this.f.set(0, Util.getUIString("PDFViewer.nResults", Integer.toString(Results.this.f.size())) + "\u2026");
                    }
                    Results.this.f.addElement(new g_(text));
                }
            });
        }

        public void clearResults() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Results.this.f.clear();
                }
            });
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.g.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.g.remove(changeListener);
        }

        public void search(String string) {
            this.cancel();
            this.clearResults();
            this.b.setSelectedSidePanel(this);
            this.e = new e_(this.b.getParser(), this.c);
            this.d = new f_(string, this.c);
            this.e.start();
            this.d.start();
        }

        public void cancel() {
            if (this.e != null) {
                this.e.a();
                this.e = null;
            }
            if (this.d != null) {
                this.d.a();
                this.d = null;
            }
        }

        public float getSearchProgress() {
            return this.h;
        }

        protected synchronized void indexPage(int n2, PageExtractor pageExtractor) {
        }

        protected boolean mayContain(int n2, String string) {
            return true;
        }

        public void setDocumentPanel(DocumentPanel documentPanel) {
            if (this.b != documentPanel) {
                this.cancel();
                this.clearResults();
                if (documentPanel == null) {
                    this.b.removeDocumentPanelListener(this);
                    if (this.b.getPDF() != null) {
                        this.b.getPDF().removePropertyChangeListener(this);
                    }
                } else {
                    documentPanel.addDocumentPanelListener(this);
                }
                if (documentPanel == null || documentPanel.getPDF() == null) {
                    this.c = null;
                } else {
                    this.c = new PageExtractor[documentPanel.getPDF().getNumberOfPages()];
                    if (this.a == null) {
                        if (documentPanel.getViewer() != null) {
                            PDFViewer pDFViewer = documentPanel.getViewer();
                            Class<?> clazz = class$org$faceless$pdf2$viewer2$feature$TextTool;
                            if (clazz == null) {
                                clazz = class$org$faceless$pdf2$viewer2$feature$TextTool = new TextTool[0].getClass().getComponentType();
                            }
                            this.a = (TextTool)pDFViewer.getFeature(clazz);
                        }
                        if (this.a == null) {
                            this.a = new TextTool();
                        }
                        this.setTextTool(this.a);
                    }
                    documentPanel.getPDF().addPropertyChangeListener(this);
                }
                this.b = documentPanel;
            }
        }

        public void documentUpdated(DocumentPanelEvent documentPanelEvent) {
            if (documentPanelEvent.getType() == "loaded") {
                documentPanelEvent.getDocumentPanel().getPDF().addPropertyChangeListener(this);
            } else if (documentPanelEvent.getType() == "closing") {
                documentPanelEvent.getDocumentPanel().getPDF().removePropertyChangeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("pages")) {
                if (this.d != null) {
                    this.d.a();
                    this.d = null;
                }
                if (this.e != null) {
                    this.e.a();
                    this.e = null;
                }
                this.clearResults();
                this.c = new PageExtractor[this.b.getPDF().getNumberOfPages()];
            }
        }

        public void panelVisible() {
        }

        public void panelHidden() {
            if (this.d != null) {
                this.d.a();
                this.d = null;
            }
        }

        private void a(float f2) {
            this.h = f2;
            ChangeEvent changeEvent = new ChangeEvent(this);
            Iterator iterator = this.g.iterator();
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged(changeEvent);
            }
        }

        private class e_
        extends Thread {
            private PDFParser a;
            private PageExtractor[] b;
            private volatile boolean c;
            private static final /* synthetic */ Object c$lock;

            e_(PDFParser pDFParser, PageExtractor[] pageExtractorArray) {
                this.a = pDFParser;
                this.b = pageExtractorArray;
                this.setDaemon(true);
                this.setName("SearchExtractor");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void a() {
                Object object = c$lock;
                synchronized (object) {
                    this.c = true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void run() {
                int n2 = 0;
                while (true) {
                    Object object = c$lock;
                    // MONITORENTER : object
                    // MONITOREXIT : object
                    if (this.c) return;
                    if (n2 >= this.b.length) return;
                    this.b[n2] = this.a.getPageExtractor(n2);
                    Object object2 = c$lock;
                    // MONITORENTER : object2
                    // MONITOREXIT : object2
                    if (!this.c) {
                        this.b[n2].getTextUnordered();
                    }
                    Object object3 = c$lock;
                    // MONITORENTER : object3
                    // MONITOREXIT : object3
                    if (!this.c) {
                        Results.this.indexPage(n2, this.b[n2]);
                    }
                    Object object4 = c$lock;
                    // MONITORENTER : object4
                    // MONITOREXIT : object4
                    if (!this.c) {
                        PageExtractor[] pageExtractorArray = this.b;
                        // MONITORENTER : this.b
                        this.b.notifyAll();
                        // MONITOREXIT : pageExtractorArray
                    }
                    ++n2;
                }
            }

            static {
                c$lock = new Object();
            }
        }

        private class f_
        extends Thread {
            private String a;
            private PageExtractor[] b;
            private volatile boolean c;
            private static final /* synthetic */ Object c$lock;

            f_(String string, PageExtractor[] pageExtractorArray) {
                this.a = string;
                this.b = pageExtractorArray;
                this.setDaemon(true);
                this.setName("SearchSearcher");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void a() {
                Object object = c$lock;
                synchronized (object) {
                    this.c = true;
                }
                PageExtractor[] pageExtractorArray = this.b;
                synchronized (this.b) {
                    this.b.notifyAll();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void run() {
                int n2 = 0;
                while (true) {
                    Object object = c$lock;
                    // MONITORENTER : object
                    // MONITOREXIT : object
                    if (this.c || n2 >= this.b.length) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                if (Results.this.f.size() == 0) {
                                    Results.this.f.addElement(Util.getUIString("PDFViewer.nResults", "0"));
                                } else {
                                    Results.this.f.set(0, Util.getUIString("PDFViewer.nResults", Integer.toString(Results.this.f.size() - 1)));
                                }
                            }
                        });
                        Results.this.a(0.0f);
                        return;
                    }
                    PageExtractor pageExtractor = null;
                    Object object2 = this.b;
                    // MONITORENTER : this.b
                    while (true) {
                        Object object3 = c$lock;
                        // MONITORENTER : object3
                        // MONITOREXIT : object3
                        if (this.c || (pageExtractor = this.b[n2]) != null) break;
                        try {
                            this.b.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    // MONITOREXIT : object2
                    Object object4 = c$lock;
                    // MONITORENTER : object4
                    // MONITOREXIT : object4
                    if (this.c || !Results.this.mayContain(n2, this.a)) continue;
                    object2 = pageExtractor.getMatchingText(new String[]{this.a}, true);
                    Iterator iterator = object2.iterator();
                    while (true) {
                        Object object5 = c$lock;
                        // MONITORENTER : object5
                        // MONITOREXIT : object5
                        if (this.c || !iterator.hasNext()) break;
                        PageExtractor.Text text = (PageExtractor.Text)iterator.next();
                        Object object6 = c$lock;
                        // MONITORENTER : object6
                        // MONITOREXIT : object6
                        if (this.c) continue;
                        Results.this.addResult(text);
                    }
                    Results.this.a((float)(++n2) / (float)this.b.length);
                }
            }

            static {
                c$lock = new Object();
            }
        }

        private static class g_
        extends JPanel {
            final PageExtractor.Text a;
            private String b = null;
            private String c = null;
            private int d;

            g_(PageExtractor.Text text) {
                this.a = text;
                this.setOpaque(true);
            }

            public Dimension getPreferredSize() {
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont().deriveFont(1));
                FontMetrics fontMetrics2 = this.getFontMetrics(this.getFont().deriveFont(2));
                int n2 = SwingUtilities.computeStringWidth(fontMetrics, this.a.getText());
                return new Dimension(n2 += SwingUtilities.computeStringWidth(fontMetrics2, " p" + this.a.getPage().getPDF().getNumberOfPages()), fontMetrics.getHeight());
            }

            public void paintComponent(Graphics graphics) {
                String string;
                PageExtractor.Text text;
                super.paintComponent(graphics);
                if (this.d != this.getWidth()) {
                    this.d = this.getWidth();
                    this.c = null;
                    this.b = null;
                }
                Font font = this.getFont();
                Font font2 = this.getFont().deriveFont(1);
                Font font3 = this.getFont().deriveFont(2);
                int n2 = this.getFont().getSize();
                FontMetrics fontMetrics = this.getFontMetrics(font);
                FontMetrics fontMetrics2 = this.getFontMetrics(font2);
                FontMetrics fontMetrics3 = this.getFontMetrics(font3);
                String string2 = " p" + this.a.getPage().getPageNumber();
                int n3 = SwingUtilities.computeStringWidth(fontMetrics2, this.a.getText());
                int n4 = SwingUtilities.computeStringWidth(fontMetrics3, string2) + 4;
                int n5 = (this.d - n3 - n4) / 2;
                if (this.b == null) {
                    this.b = "";
                    text = this.a.getRowPrevious();
                    String string3 = string = text == null ? "" : text.getText();
                    while (string.length() > 0 && SwingUtilities.computeStringWidth(fontMetrics, "\u2026\u2026" + this.b) < n5) {
                        this.b = string.charAt(string.length() - 1) + this.b;
                        if ((string = string.substring(0, string.length() - 1)).length() != 0 || (text = text.getRowPrevious()) == null) continue;
                        string = text.getText();
                    }
                    if (text != null) {
                        this.b = "\u2026" + this.b;
                    }
                }
                if (this.c == null) {
                    this.c = "";
                    text = this.a.getRowNext();
                    String string4 = string = text == null ? "" : text.getText();
                    while (string.length() > 0 && SwingUtilities.computeStringWidth(fontMetrics, this.c + "\u2026\u2026") < n5) {
                        this.c = this.c + string.charAt(0);
                        if ((string = string.substring(1)).length() != 0 || (text = text.getRowNext()) == null) continue;
                        string = text.getText();
                    }
                    if (text != null) {
                        this.c = this.c + "\u2026";
                    }
                }
                int n6 = 0;
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics.setColor(this.getForeground());
                graphics.setFont(font);
                graphics.drawString(this.b, 0, n2);
                graphics.setFont(font2);
                graphics.drawString(this.a.getText(), n6 += SwingUtilities.computeStringWidth(fontMetrics, this.b), n2);
                graphics.setFont(font);
                graphics.drawString(this.c, n6 += n3, n2);
                graphics.setFont(font3);
                graphics.drawString(string2, this.d - n4, n2);
            }
        }
    }
}

