/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.pdf2.viewer2.feature;

import org.faceless.pdf2.PDFAction;
import org.faceless.pdf2.PDFPage;
import org.faceless.pdf2.viewer2.DocumentPanel;
import org.faceless.pdf2.viewer2.DocumentPanelEvent;
import org.faceless.pdf2.viewer2.DocumentPanelListener;
import org.faceless.pdf2.viewer2.PDFViewer;
import org.faceless.pdf2.viewer2.ToggleViewerWidget;
import org.faceless.pdf2.viewer2.ViewerEvent;

public class ZoomFitHeight
extends ToggleViewerWidget
implements DocumentPanelListener {
    public ZoomFitHeight() {
        super("FitHeight", "Zoom");
        this.setMenu("View\tZoom\tZoomFitHeight");
    }

    public void initialize(PDFViewer pDFViewer) {
        super.initialize(pDFViewer);
        pDFViewer.addDocumentPanelListener(this);
    }

    public void documentUpdated(DocumentPanelEvent documentPanelEvent) {
        String string = documentPanelEvent.getType();
        if (string == "redrawn" || string == "activated" || string == "viewportChanged") {
            int n2 = documentPanelEvent.getDocumentPanel().getViewport().getZoomMode();
            this.setSelected(n2 == 3);
        }
    }

    public void action(ViewerEvent viewerEvent) {
        DocumentPanel documentPanel = viewerEvent.getDocumentPanel();
        PDFPage pDFPage = null;
        if (documentPanel != null && (pDFPage = documentPanel.getPage()) != null) {
            super.action(viewerEvent);
            if (this.isSelected()) {
                documentPanel.getViewport().setZoomMode(3);
                documentPanel.runAction(PDFAction.goToFitHeight(pDFPage, Float.NaN));
            } else {
                documentPanel.getViewport().setZoomMode(0);
            }
        }
    }
}

