/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.report;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import org.faceless.pdf2.AnnotationLink;
import org.faceless.pdf2.Event;
import org.faceless.pdf2.FormButton;
import org.faceless.pdf2.LayoutBox;
import org.faceless.pdf2.PDFAction;
import org.faceless.pdf2.PDFCanvas;
import org.faceless.pdf2.PDFImage;
import org.faceless.pdf2.PDFStyle;
import org.faceless.pdf2.WidgetAnnotation;
import org.faceless.report.Action;
import org.faceless.report.Atts;
import org.faceless.report.LayoutBoxWrapper;
import org.faceless.report.ListElement;
import org.faceless.report.MyURL;
import org.faceless.report.Node;
import org.faceless.report.Page;
import org.faceless.report.Paragraph;
import org.faceless.report.Span;
import org.faceless.report.Td;
import org.faceless.report.VisibleInlineNode;
import org.xml.sax.SAXException;

abstract class AbstractBlock
extends Node
implements VisibleInlineNode {
    protected float ocw = Float.NaN;
    protected float mcw = Float.NaN;
    protected float x;
    protected float y;
    protected float w;
    protected float h;
    protected float pt = Float.NaN;
    protected float pb;
    protected float pl;
    protected float pr;
    protected float mt = Float.NaN;
    protected float mb;
    protected float ml = Float.NaN;
    protected float mr;
    protected float bt;
    protected float bb;
    protected float bl;
    protected float br;
    private float o;
    private float p = Float.NaN;
    private float q = Float.NaN;
    private float r = Float.NaN;
    protected Paragraph paragraph;
    protected LayoutBoxWrapper layoutbox;

    public AbstractBlock(Map map) throws SAXException {
        super(map);
    }

    void draw() throws SAXException {
        if (this.debug) {
            this.a("in ABlock.draw " + this.thisrect());
        }
        this.squash();
        if (this.drawBackground()) {
            super.draw();
        }
        this.postDrawBackground();
        if (this.debug) {
            this.a("out ABlock.draw");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean drawBackground() throws SAXException {
        boolean bl;
        float f2 = this.getNumAttribute(Atts.ROTATE);
        boolean bl2 = this.getStringAttribute(Atts.OVERFLOW) == "hidden";
        boolean bl3 = bl = this.getStringAttribute(Atts.VISIBILITY) != "hidden";
        if (f2 != 0.0f || bl2) {
            this.m.save();
        }
        this.setPos();
        if (bl) {
            boolean bl4;
            if (this.debug) {
                this.a("in drawBackground");
            }
            MyURL myURL = this.getURLAttribute(Atts.BACKGROUND_PDF);
            Object object = this.getURLAttribute(Atts.BACKGROUND_IMAGE);
            if (object != null) {
                object = this.document.a((MyURL)object);
            }
            boolean bl5 = bl4 = this.bb == this.bt && this.bt == this.br && this.bt == this.bl;
            if (bl4 && this.bb != 0.0f) {
                Object object2 = this.getAttribute(Atts.COLOR);
                for (int i2 = 1; bl4 && i2 < 3; ++i2) {
                    Object object3;
                    Object object4 = this.getAttribute(Atts.BORDER_LEFT_COLOR + 1 - 1);
                    if (object4 == null) {
                        object4 = object2;
                    }
                    if ((object3 = this.getAttribute(Atts.BORDER_LEFT_COLOR + 1)) == null) {
                        object3 = object2;
                    }
                    if (!object4.equals(object3)) {
                        bl4 = false;
                    }
                    if ((object4 = this.getAttribute(Atts.BORDER_LEFT_STYLE + 1 - 1)) == null) {
                        object4 = "solid";
                    }
                    if ((object3 = this.getAttribute(Atts.BORDER_LEFT_STYLE + 1)) == null) {
                        object3 = "solid";
                    }
                    if (object4.equals(object3)) continue;
                    bl4 = false;
                }
            }
            if (f2 != 0.0f) {
                this.m.rotate(this.x + this.w / 2.0f, this.y + this.h / 2.0f, f2);
            }
            if (this.hasAttribute(Atts.BACKGROUND_COLOR) || object != null || myURL != null || !bl4 || this.bt != 0.0f) {
                float f3 = this.x + this.ml + this.bl / 2.0f;
                float f4 = this.y + this.mt + this.bt / 2.0f;
                float f5 = this.x + this.w - this.mr - this.br / 2.0f;
                float f6 = this.y + this.h - this.mb - this.bb / 2.0f;
                PDFStyle pDFStyle = this.getGraphicsStyle(bl4 ? this.bl : 0.0f, 0, null);
                if (pDFStyle.getFillColor() != null || pDFStyle.getLineColor() != null) {
                    if (!(f3 != f5 && f4 != f6 || pDFStyle.getFillColor() != null && !(pDFStyle.getFillColor() instanceof Color))) {
                        if (pDFStyle.getLineColor() == null) {
                            pDFStyle.setLineColor((Color)pDFStyle.getFillColor());
                            pDFStyle.setFillColor(null);
                        }
                        this.m.setStyle(pDFStyle);
                        this.m.drawLine(f3, f4, f5, f6);
                    } else {
                        this.m.setStyle(pDFStyle);
                        this.m.drawRoundedRectangle(f3, f4, f5, f6, this.o);
                    }
                }
                if (!bl4) {
                    if (this.bt > 0.0f) {
                        pDFStyle = this.getGraphicsStyle(this.bt, 2, pDFStyle);
                        this.m.setStyle(pDFStyle);
                        if (pDFStyle.getLineColor() != null) {
                            this.m.drawLine(f3, f4, f5, f4);
                        }
                    }
                    if (this.br > 0.0f) {
                        pDFStyle = this.getGraphicsStyle(this.br, 1, pDFStyle);
                        this.m.setStyle(pDFStyle);
                        if (pDFStyle.getLineColor() != null) {
                            this.m.drawLine(f5, f4, f5, f6);
                        }
                    }
                    if (this.bb > 0.0f) {
                        pDFStyle = this.getGraphicsStyle(this.bb, 3, pDFStyle);
                        this.m.setStyle(pDFStyle);
                        if (pDFStyle.getLineColor() != null) {
                            this.m.drawLine(f3, f6, f5, f6);
                        }
                    }
                    if (this.bl > 0.0f) {
                        pDFStyle = this.getGraphicsStyle(this.bl, 0, pDFStyle);
                        this.m.setStyle(pDFStyle);
                        if (pDFStyle.getLineColor() != null) {
                            this.m.drawLine(f3, f4, f3, f6);
                        }
                    }
                }
                if (object != null || myURL != null) {
                    this.m.save();
                    this.m.clipRoundedRectangle(f3 += this.bl / 2.0f, f4 += this.bt / 2.0f, f5 -= this.br / 2.0f, f6 -= this.bb / 2.0f, this.o);
                    if (object != null) {
                        this.a(f3, f4, f5, f6, (PDFImage)object);
                    }
                    if (myURL != null) {
                        this.a(f3, f4, f5, f6, myURL);
                    }
                    this.m.restore();
                }
            }
            if (bl2) {
                this.m.clipRoundedRectangle(this.x + this.ml + this.pl + this.bl, this.y + this.mt + this.pt + this.bt, this.x + this.w - this.mr - this.pr - this.bt, this.y + this.h - this.mb - this.pb - this.bb, this.o);
            }
        }
        if (!this.debug) return bl;
        this.a("out drawBackground");
        return bl;
    }

    public final boolean drawBackgroundImage(float f2, float f3, float f4, float f5) throws SAXException {
        MyURL myURL = this.getURLAttribute(Atts.BACKGROUND_IMAGE);
        if (myURL != null) {
            PDFImage pDFImage = this.document.a(myURL);
            if (pDFImage != null) {
                this.a(f2, f3, f4, f5, pDFImage);
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void a(float f2, float f3, float f4, float f5, PDFImage pDFImage) throws SAXException {
        String string = this.getStringAttribute(Atts.BACKGROUND_POSITION);
        if (string == "stretch" || string == null) {
            this.m.drawImage(pDFImage, f2, f3, f4, f5);
            return;
        }
        float[] fArray = this.getImageSize(Atts.BACKGROUND_IMAGE_DPI, Atts.BACKGROUND_IMAGE_WIDTH, Atts.BACKGROUND_IMAGE_HEIGHT, pDFImage);
        if (string != "repeat") {
            float f6;
            float f7 = string.indexOf("right") >= 0 ? f4 - fArray[0] : (f6 = string.indexOf("center") >= 0 ? f2 + (f4 - f2 - fArray[0]) / 2.0f : 0.0f);
            float f8 = string.indexOf("bottom") >= 0 ? f5 - fArray[1] : (string.indexOf("middle") >= 0 ? f3 + (f5 - f3 - fArray[1]) / 2.0f : 0.0f);
            this.m.drawImage(pDFImage, f6, f8, f6 + fArray[0], f8 + fArray[1]);
            return;
        }
        float f9 = f2;
        while (f9 < f4) {
            for (float f10 = f3; f10 < f5; f10 += fArray[1]) {
                this.m.drawImage(pDFImage, f9, f10, f9 + fArray[0], f10 + fArray[1]);
            }
            f9 += fArray[0];
        }
    }

    private final boolean a(float f2, float f3, float f4, float f5, MyURL myURL) throws SAXException {
        Node node = this;
        while (true) {
            if (node == null || node instanceof Page) break;
            node = node.getParent();
        }
        PDFCanvas pDFCanvas = this.document.a(myURL, ((Page)node).pagenumber);
        if (pDFCanvas != null) {
            this.m.drawCanvas(pDFCanvas, f2, f3, f4, f5);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void postDrawBackground() throws SAXException {
        if (this.getNumAttribute(Atts.ROTATE) != 0.0f || this.getStringAttribute(Atts.OVERFLOW) == "hidden") {
            this.m.restore();
        }
        this.layoutbox = null;
        this.paragraph = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void postdraw() throws SAXException {
        String string4 = this.getId();
        if (string4 != null && this.m != null) {
            Action.parse("#" + string4, this.document);
        }
        if (this.m != null) {
            String string3 = this.getStringAttribute(Atts.HREF);
            if (string3 == null) {
                string3 = this.getStringAttribute(Atts.ONCLICK);
            }
            String string2 = this.getStringAttribute(Atts.ONMOUSEOVER);
            String string = this.getStringAttribute(Atts.ONMOUSEOUT);
            if (string3 != null && string2 == null && string == null) {
                PDFAction pDFAction4 = Action.parse(string3, this.document);
                AnnotationLink annotationLink = new AnnotationLink();
                annotationLink.setAction(pDFAction4);
                annotationLink.setRectangle(this.x + this.ml, (float)this.m.getHeight() - (this.y + this.mt), this.x + this.w - this.ml - this.mr, (float)this.m.getHeight() - (this.y + this.h - this.mt - this.mb));
                this.m.getAnnotations().add(annotationLink);
            } else if (string3 != null || string2 != null || string != null) {
                PDFAction pDFAction3 = null;
                PDFAction pDFAction2 = null;
                PDFAction pDFAction = null;
                if (string3 != null) {
                    pDFAction3 = Action.parse(string3, this.document);
                }
                if (string2 != null) {
                    pDFAction2 = Action.parse(string2, this.document);
                }
                if (string != null) {
                    pDFAction = Action.parse(string, this.document);
                }
                FormButton formButton = new FormButton(this.m, this.x + this.ml, (float)this.m.getHeight() - (this.y + this.mt), this.x + this.w - this.ml - this.mr, (float)this.m.getHeight() - (this.y + this.h - this.mt - this.mb));
                formButton.setSubmitted(false);
                PDFStyle pDFStyle = new PDFStyle();
                pDFStyle.setLineColor(null);
                pDFStyle.setFillColor(null);
                WidgetAnnotation widgetAnnotation = formButton.getAnnotation(0);
                widgetAnnotation.setBackgroundStyle(pDFStyle);
                widgetAnnotation.setRectangle(this.x + this.ml, (float)this.m.getHeight() - (this.y + this.mt), this.x + this.w - this.ml - this.mr, (float)this.m.getHeight() - (this.y + this.h - this.mt - this.mb));
                widgetAnnotation.setAction(Event.MOUSEUP, pDFAction3);
                widgetAnnotation.setAction(Event.MOUSEOVER, pDFAction2);
                widgetAnnotation.setAction(Event.MOUSEOUT, pDFAction);
                this.document.getPDF().getForm().addElement("bforeportlinks." + this.document.J++, formButton);
            }
        }
        super.postdraw();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float setEdges(float f2) throws SAXException {
        float f3;
        if (this.debug) {
            this.a("in AbstractBlock.setEdges: maxwidth=" + f2);
        }
        if (this.hasAttribute(Atts.WIDTH)) {
            f2 = this.getNumAttribute(Atts.WIDTH, f2);
            f3 = 0.0f;
        } else {
            f3 = f2;
        }
        if (Float.isNaN(this.pt)) {
            float f4 = this.guessHeight();
            this.mt = this.getNumAttribute(Atts.MARGIN_TOP, f4);
            this.pt = this.getNumAttribute(Atts.PADDING_TOP, f4);
            this.mb = this.getNumAttribute(Atts.MARGIN_BOTTOM, f4);
            this.pb = this.getNumAttribute(Atts.PADDING_BOTTOM, f4);
            this.ml = this.getNumAttribute(Atts.MARGIN_LEFT, f3);
            this.pl = this.getNumAttribute(Atts.PADDING_LEFT, f3);
            this.mr = this.getNumAttribute(Atts.MARGIN_RIGHT, f3);
            this.pr = this.getNumAttribute(Atts.PADDING_RIGHT, f3);
            if (this.getAttribute(Atts.BORDER_TOP_STYLE) == "none") {
                this.setAttribute(Atts.BORDER_TOP_WIDTH, 0.0f);
            }
            if (this.getAttribute(Atts.BORDER_LEFT_STYLE) == "none") {
                this.setAttribute(Atts.BORDER_LEFT_WIDTH, 0.0f);
            }
            if (this.getAttribute(Atts.BORDER_RIGHT_STYLE) == "none") {
                this.setAttribute(Atts.BORDER_RIGHT_WIDTH, 0.0f);
            }
            if (this.getAttribute(Atts.BORDER_BOTTOM_STYLE) == "none") {
                this.setAttribute(Atts.BORDER_BOTTOM_WIDTH, 0.0f);
            }
            this.bt = this.getNumAttribute(Atts.BORDER_TOP_WIDTH, f4);
            this.br = this.getNumAttribute(Atts.BORDER_RIGHT_WIDTH, f3);
            this.bb = this.getNumAttribute(Atts.BORDER_BOTTOM_WIDTH, f4);
            this.bl = this.getNumAttribute(Atts.BORDER_LEFT_WIDTH, f3);
            this.o = this.getNumAttribute(Atts.CORNER_RADIUS, f3);
            if (!(this instanceof Td) && this.getPrevSibling() != null && this.getPrevSibling() instanceof AbstractBlock) {
                AbstractBlock abstractBlock = (AbstractBlock)this.getPrevSibling();
                this.mt = abstractBlock.mb > this.mt ? 0.0f : (this.mt -= abstractBlock.mb);
            }
            if (this.debug) {
                this.a("setting LR margins based on " + f3 + ", height to " + this.guessHeight());
            }
        }
        if (!this.debug) return f2;
        this.a("out AbstractBlock.setEdges: returning maxwidth=" + f2 + " edgew=" + this.edgew() + " edgeh=" + this.edgeh());
        return f2;
    }

    public final float edgew() {
        return this.pl + this.ml + this.bl + this.pr + this.mr + this.br;
    }

    public final float edgeh() {
        return this.pt + this.mt + this.bt + this.pb + this.mb + this.bb;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float setWidth(float f2) throws SAXException {
        if (this.w != 0.0f && f2 == this.q) {
            return this.w;
        }
        this.q = f2;
        if (this.debug) {
            this.a("in AbstractBlock.setWidth(): maxwidth=" + f2);
        }
        f2 = this.setEdges(f2) - this.edgew();
        this.w = this.hasAttribute(Atts.WIDTH) ? f2 : 0.0f;
        for (int i2 = 0; i2 < this.kids.size(); ++i2) {
            AbstractBlock abstractBlock = (AbstractBlock)this.kids.get(i2);
            float f4 = abstractBlock.setWidth(f2);
            if (abstractBlock.isAbsolute() || !(f4 > this.w)) continue;
            this.w = f4;
        }
        if (this.debug) {
            this.a("out AbstractBlock.setWidth: w=" + this.w);
        }
        this.w += this.edgew();
        return this.w;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float setHeight() throws SAXException {
        if (this.h != 0.0f && this.w == this.p) {
            return this.h;
        }
        this.p = this.w;
        if (this.debug) {
            this.a("in AbstractBlock.setHeight");
        }
        this.h = 0.0f;
        for (int i2 = 0; i2 < this.kids.size(); ++i2) {
            AbstractBlock abstractBlock = (AbstractBlock)this.kids.get(i2);
            float f2 = abstractBlock.setHeight();
            if (abstractBlock.isAbsolute()) continue;
            this.h += f2;
        }
        this.h += this.edgeh();
        float f3 = this.guessHeight();
        if (f3 > this.h) {
            this.h = f3;
        }
        this.h = Math.max(this.h, this.getNumAttribute(Atts.MIN_HEIGHT, 0.0f));
        if (!this.debug) return this.h;
        this.a("out AbstractBlock.setHeight: h=" + this.h);
        return this.h;
    }

    protected final float guessHeight() throws SAXException {
        if (!Float.isNaN(this.r)) {
            return this.r;
        }
        if (this.debug) {
            this.a("in AbstractBlock.guessHeight");
        }
        this.r = 0.0f;
        if (this.hasAttribute(Atts.HEIGHT)) {
            Node node = this.getParent();
            this.r = node instanceof AbstractBlock ? this.getNumAttribute(Atts.HEIGHT, ((AbstractBlock)node).guessHeight() - ((AbstractBlock)node).edgeh()) : this.getNumAttribute(Atts.HEIGHT, 0.0f);
        }
        if (this.debug) {
            this.a("out AbstractBlock.guessHeight: guess=" + this.r);
        }
        return this.r;
    }

    public final String thisrect() {
        return (this.x == 0.0f ? "0" : "" + this.x) + "," + (this.y == 0.0f ? "0" : "" + this.y) + "," + (this.w == 0.0f ? "0" : "" + this.w) + "," + (this.h == 0.0f ? "0" : "" + this.h) + " : t=" + (this.mt == 0.0f ? "0" : "" + this.mt) + "," + (this.bt == 0.0f ? "0" : "" + this.bt) + "," + (this.pt == 0.0f ? "0" : "" + this.pt) + " r=" + (this.mr == 0.0f ? "0" : "" + this.mr) + "," + (this.br == 0.0f ? "0" : "" + this.br) + "," + (this.pr == 0.0f ? "0" : "" + this.pr) + " b=" + (this.mb == 0.0f ? "0" : "" + this.mb) + "," + (this.bb == 0.0f ? "0" : "" + this.bb) + "," + (this.pb == 0.0f ? "0" : "" + this.pb) + " l=" + (this.ml == 0.0f ? "0" : "" + this.ml) + "," + (this.bl == 0.0f ? "0" : "" + this.bl) + "," + (this.pl == 0.0f ? "0" : "" + this.pl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setPos() throws SAXException {
        if (this instanceof Page) {
            return;
        }
        String string = this.getStringAttribute(Atts.DISPLAY);
        if (this.debug) {
            this.a("in Block.setPos(): display=" + string + " layoutbox=" + this.layoutbox);
        }
        if (string != "inline" || this.layoutbox != null) {
            if (string == "inline" && this.layoutbox != null) {
                if (this.w == 0.0f) {
                    this.w = this.layoutbox.getWidth();
                }
                if (this.h == 0.0f) {
                    this.h = this.layoutbox.getHeight();
                }
                this.x = this.paragraph.x + this.paragraph.pl + this.paragraph.ml + this.paragraph.bl + this.layoutbox.getLeft() + this.x;
                this.y = this.paragraph.y + this.paragraph.pt + this.paragraph.mt + this.paragraph.bt - this.layoutbox.getTop() + this.y;
                if (this instanceof Span) {
                    this.w += this.edgew();
                    this.h += this.edgeh();
                    this.x -= this.pl + this.ml + this.bl;
                    this.y -= this.pt + this.mt + this.bt;
                }
            } else {
                AbstractBlock abstractBlock = (AbstractBlock)this.getParent();
                AbstractBlock abstractBlock2 = (AbstractBlock)this.getPrevSibling();
                this.y = 0.0f;
                this.x = 0.0f;
                if (this.isAbsolute()) {
                    this.x = abstractBlock.x + abstractBlock.pl + abstractBlock.ml + abstractBlock.bl;
                    this.y = abstractBlock.y + abstractBlock.pt + abstractBlock.mt + abstractBlock.bt;
                } else {
                    this.x = abstractBlock.x + abstractBlock.pl + abstractBlock.ml + abstractBlock.bl;
                    if (abstractBlock2 == null) {
                        this.y = abstractBlock.y + abstractBlock.pt + abstractBlock.mt + abstractBlock.bt;
                    } else {
                        this.y = abstractBlock2.y + abstractBlock2.h;
                        float f2 = abstractBlock.h - abstractBlock.edgeh();
                        float f3 = abstractBlock2.getNumAttribute(Atts.Y, f2);
                        this.y -= f3;
                    }
                    if (this.parent instanceof Td) {
                        this.setAttribute(Atts.ALIGN, this.parent, Atts.ALIGN);
                    }
                    if (this.parent instanceof Td) {
                        this.setAttribute(Atts.VERTICAL_ALIGN, this.parent, Atts.VERTICAL_ALIGN);
                    }
                    String string2 = this.getStringAttribute(Atts.ALIGN);
                    String string3 = this.getStringAttribute(Atts.VERTICAL_ALIGN);
                    if ((string2 == "right" || "center" == string2 || "bottom" == string3 || "middle" == string3) && this.debug) {
                        this.a("pre alignment: align=" + string2 + " valign=" + string3 + " rect=" + this.thisrect() + " pw=" + abstractBlock.w + " p.edgew=" + abstractBlock.edgew());
                    }
                    if ("right" == string2) {
                        this.x += abstractBlock.w - abstractBlock.edgew() - this.w;
                    } else if ("center" == string2) {
                        this.x += (abstractBlock.w - abstractBlock.edgew() - this.w) / 2.0f;
                    }
                    if (("bottom" == string3 || "middle" == string3) && this == abstractBlock.kids.get(0)) {
                        float f4 = 0.0f;
                        for (int i2 = 0; i2 < abstractBlock.kids.size(); f4 += ((AbstractBlock)abstractBlock.kids.get((int)i2)).h, ++i2) {
                        }
                        if ("bottom" == string3) {
                            this.y += abstractBlock.h - abstractBlock.edgeh() - f4;
                        } else if ("middle" == string3) {
                            this.y += (abstractBlock.h - abstractBlock.edgeh() - f4) / 2.0f;
                        }
                    }
                }
                this.x += this.getNumAttribute(Atts.X, abstractBlock.w - abstractBlock.edgew());
                this.y += this.getNumAttribute(Atts.Y, abstractBlock.h - abstractBlock.edgeh());
            }
        }
        if (!this.debug) return;
        this.a("out Block.setPos(): rect=" + this.thisrect());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AbstractBlock split(float f2) throws SAXException {
        int n2;
        AbstractBlock abstractBlock;
        if (this.kids.size() < 2) {
            return this;
        }
        if (this.debug) {
            this.a("in AbstractBlock.SPLIT: size=" + f2 + " this=" + this + " parent=" + this.getParent());
        }
        AbstractBlock[] abstractBlockArray = new AbstractBlock[]{(AbstractBlock)this.clone(), (AbstractBlock)this.clone()};
        abstractBlockArray[0].kids = new ArrayList();
        abstractBlockArray[1].kids = new ArrayList();
        abstractBlockArray[0].h = abstractBlockArray[1].h = this.edgeh();
        f2 -= this.mt + this.pt + this.bt;
        for (n2 = 0; n2 < this.kids.size(); abstractBlockArray[n3].h += abstractBlock.h, f2 -= abstractBlock.h, ++n2) {
            int n3;
            abstractBlock = (AbstractBlock)this.kids.get(n2);
            if (abstractBlock.h > f2 && f2 > 0.0f && abstractBlock.getAttribute(Atts.PAGE_BREAK_INSIDE) != "avoid") {
                abstractBlock = abstractBlock.split(f2);
            }
            int n4 = n3 = abstractBlock.h <= f2 ? 0 : 1;
            if (n3 == 1 && n2 == 0) break;
            if (this.debug) {
                this.a("--> kid " + n2 + "/" + this.kids.size() + " [" + abstractBlock + "] goes to " + n3 + " h=" + abstractBlock.h + " size=" + f2);
            }
            abstractBlockArray[n3].addKid(abstractBlock);
        }
        if (abstractBlockArray[0].kids.size() == 0) {
            abstractBlockArray[0] = null;
        }
        if (abstractBlockArray[1].kids.size() == 0) {
            abstractBlockArray[1] = null;
        }
        if (abstractBlockArray[0] == null || abstractBlockArray[1] == null) {
            if (!this.debug) return this;
            this.a("out AbstractBlock.SPLIT: half is null, returning myself");
            return this;
        }
        if (this.debug) {
            this.a("replacing self: has " + this.kids.size() + " kids, h=" + this.h + ", prev=" + this.getPrevSibling() + " next=" + this.getNextSibling() + " par=" + this.getParent());
        }
        this.replaceWith(abstractBlockArray[0], abstractBlockArray[1]);
        for (n2 = 0; n2 < 2; ++n2) {
            if (!this.debug) continue;
            this.a("split[" + n2 + "]=" + abstractBlockArray[n2] + " has " + abstractBlockArray[n2].kids.size() + " kids, h=" + abstractBlockArray[n2].h + ", prev=" + abstractBlockArray[n2].getPrevSibling() + " next=" + abstractBlockArray[n2].getNextSibling() + " par=" + abstractBlockArray[n2].getParent());
        }
        if (this instanceof ListElement) {
            ((ListElement)abstractBlockArray[1]).b();
        }
        if (!this.debug) return abstractBlockArray[0];
        this.a("out AbstractBlock.SPLIT: both OK, returning " + abstractBlockArray[0]);
        return abstractBlockArray[0];
    }

    public Object clone() {
        AbstractBlock abstractBlock = (AbstractBlock)super.clone();
        return abstractBlock;
    }

    public float getOCW(float f2) throws SAXException {
        if (this.debug) {
            this.a("in AbstractBlock.getOCW maxwidth=" + f2);
        }
        if (Float.isNaN(this.ocw)) {
            f2 = this.setEdges(f2);
            float f3 = this.hasAttribute(Atts.WIDTH) ? f2 - this.edgew() : 0.0f;
            this.ocw = f3;
            for (int i2 = 0; i2 < this.kids.size(); ++i2) {
                AbstractBlock abstractBlock = (AbstractBlock)this.kids.get(i2);
                if (abstractBlock.isAbsolute()) continue;
                float f4 = abstractBlock.getOCW(f2 - this.edgew());
                if (!(f4 > this.ocw)) continue;
                this.ocw = f4;
                continue;
            }
            this.ocw += this.edgew();
        }
        if (this.debug) {
            this.a("out AbstractBlock.getOCW: " + this.ocw);
        }
        return this.ocw;
    }

    public float getMCW(float f2) throws SAXException {
        if (this.debug) {
            this.a("in AbstractBlock.getMCW maxwidth=" + f2);
        }
        if (Float.isNaN(this.mcw)) {
            f2 = this.setEdges(f2);
            this.mcw = this.document.getBooleanAttribute(Atts._BFG_USE_WIDTH_FOR_MIN_WIDTH) ? this.getNumAttribute(Atts.WIDTH, f2 - this.edgew()) : this.getNumAttribute(Atts.MIN_WIDTH, f2 - this.edgew());
            for (int i2 = 0; i2 < this.kids.size(); ++i2) {
                AbstractBlock abstractBlock = (AbstractBlock)this.kids.get(i2);
                if (abstractBlock.isAbsolute()) continue;
                float f3 = abstractBlock.getMCW(f2 - this.edgew());
                if (this.debug) {
                    this.a("MCW was " + this.mcw + " TMCW=" + f3);
                }
                if (!(f3 > this.mcw)) continue;
                this.mcw = f3;
                continue;
            }
            this.mcw += this.edgew();
        }
        if (this.debug) {
            this.a("out AbstractBlock.getMCW: " + this.mcw);
        }
        return this.mcw;
    }

    public boolean addToParagraph(Paragraph paragraph) throws SAXException {
        LayoutBox.Box box;
        int n2;
        String string;
        block19: {
            int n3;
            String string2;
            block20: {
                block18: {
                    this.paragraph = paragraph;
                    string = this.getStringAttribute(Atts.FLOAT);
                    string2 = this.getStringAttribute(Atts.CLEAR);
                    if (string2 != "left") break block18;
                    n3 = 1;
                    break block19;
                }
                if (string2 != "right") break block20;
                n3 = 2;
                break block19;
            }
            n3 = n2 = string2 == "both" ? 3 : 0;
        }
        if (string == "_block") {
            box = paragraph.b().addBoxFullWidth(this.h);
        } else if (string == "left") {
            box = paragraph.b().addBoxLeft(this.w, this.h, n2);
        } else if (string == "right") {
            box = paragraph.b().addBoxRight(this.w, this.h, n2);
        } else {
            int n4;
            block22: {
                String string3;
                block23: {
                    block21: {
                        string3 = this.getStringAttribute(Atts.VERTICAL_ALIGN);
                        if (string3 != "top") break block21;
                        n4 = 16;
                        break block22;
                    }
                    if (string3 != "middle") break block23;
                    n4 = 32;
                    break block22;
                }
                n4 = string3 == "bottom" ? 64 : 0;
            }
            n2 = n4;
            box = paragraph.b().addBoxInline(this.w, this.h, n2);
        }
        this.layoutbox = new LayoutBoxWrapper(box);
        return false;
    }

    public LayoutBoxWrapper[] sizeAndSplitInlines() {
        throw new Error("Not implemented");
    }

    public void moveLayoutBox(float f2, float f3, int n2) {
        if (this.debug) {
            this.a("in moveLayout(" + f2 + "," + f3 + "," + n2 + "): got " + this.kids.size() + " kids");
        }
        this.layoutbox.moveBy(f2, f3, n2);
        for (int i2 = 0; i2 < this.kids.size(); ++i2) {
            Node node = (Node)this.kids.get(i2);
            if (node instanceof AbstractBlock && ((AbstractBlock)node).layoutbox != null) {
                ((AbstractBlock)node).moveLayoutBox(f2, f3, n2);
                continue;
            }
            if (!this.debug) continue;
            this.a("Skipping kid " + node + " " + (node instanceof AbstractBlock ? "lb=null" : "not AB"));
        }
        if (this.debug) {
            this.a("out moveLayout");
        }
    }
}

