/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.report;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.color.ColorSpace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.StringTokenizer;
import org.faceless.pdf2.CMYKColorSpace;
import org.faceless.pdf2.PDFFont;
import org.faceless.pdf2.PDFPattern;
import org.faceless.pdf2.SpotColorSpace;
import org.faceless.report.AttHolder;
import org.faceless.report.Atts;
import org.faceless.report.Bookmark;
import org.faceless.report.CSS;
import org.faceless.report.CSSEntry;
import org.faceless.report.Document;
import org.faceless.report.GraphCurve;
import org.faceless.report.GraphData;
import org.faceless.report.Image;
import org.faceless.report.MyURL;
import org.faceless.report.Node;
import org.faceless.report.Page;
import org.xml.sax.SAXException;

final class Attributes {
    public static final int DIRECT = 0x3FFFFFFF;
    public static final int IMPORTANT = 0x40000000;
    private static final ColorSpace a = CMYKColorSpace.getInstance();
    private static final ColorSpace b = Color.red.getColorSpace();
    private static final Color c;
    private static final ResourceBundle d;
    private boolean e = false;
    private Node f;
    private AttHolder g;
    private AttHolder h;
    private final CSS i;
    private static final String[] j;

    private Attributes(Node node, CSS cSS, boolean bl) {
        this.f = node;
        this.i = cSS;
    }

    public Attributes(Node node, CSS cSS) throws SAXException {
        this(node, cSS, false);
        this.g = new AttHolder();
    }

    private void a() throws SAXException {
        this.e = true;
        SortedSet sortedSet = this.i.getPermAttributes(this.f);
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            CSSEntry cSSEntry = (CSSEntry)iterator.next();
            int n2 = cSSEntry.score();
            Map map = cSSEntry.getAttributes();
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                this.a(string, map.get(string), n2, this.g);
            }
        }
    }

    public void reset() {
        this.h = null;
    }

    public void setInline(Map map) throws SAXException {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.a(string, map.get(string), 0x3FFFFFFF, this.g);
        }
    }

    public void set(String string, String string2) throws SAXException {
        this.a(string, string2, 0x3FFFFFFF, this.g);
    }

    public void set(int n2, float f2) {
        try {
            this.set(n2, new ExtNumber(f2), 0x3FFFFFFF);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void set(int n2, Object object, int n3) throws SAXException {
        if (n2 >= Atts.GROUP_NUM_START && n2 <= Atts.GROUP_NUM_END && object instanceof String) {
            object = this.c((String)object);
        }
        this.g.set(n2, object, n3);
    }

    public void set(int n2, Object object) throws SAXException {
        this.set(n2, object, 0x3FFFFFFF);
    }

    public final boolean hasKey(int n2) throws SAXException {
        boolean bl = this.getObject(n2) != null;
        return bl;
    }

    public Object getDirectObject(int n2) {
        if (this.g != null) {
            Object object = this.g.get(n2);
            Object object2 = (this.g.getWeight(n2) & 0x3FFFFFFF) == 0x3FFFFFFF ? object : null;
            return object2;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getObject(int n2) throws SAXException {
        Object object;
        if (!this.e) {
            this.a();
        }
        if (this.h == null && (this.f.getParent() != null || this.f instanceof Document)) {
            this.b();
        }
        Object object2 = this.g.get(n2);
        Object object3 = object = this.h == null ? null : this.h.get(n2);
        if (object == null && object2 != null) {
            return object2;
        }
        if (object2 == null && object != null) {
            return object;
        }
        if (object2 != null && object != null) {
            Object object4;
            int n3;
            int n4 = this.g.getWeight(n2);
            if (n4 > (n3 = this.h.getWeight(n2))) {
                object4 = object2;
                return object4;
            }
            object4 = object;
            return object4;
        }
        if (this.h == null) return null;
        if (this.h.get(n2) != null) return null;
        if (this.h.getWeight(n2) == -1) {
            return null;
        }
        Node node = this.f.getParent();
        if (node == null) return object;
        if (!(!Atts.isInheritable(n2) || this.f instanceof GraphData || this.f instanceof GraphCurve || n2 == Atts.COLORSPACE && this.f instanceof Image || this.f instanceof Bookmark)) {
            object = node.getAttribute(n2);
        }
        this.h.set(n2, object, -1);
        return object;
    }

    public int getObjectWeight(int n2) {
        int n3 = this.g.getWeight(n2);
        int n4 = this.h == null ? 0 : this.h.getWeight(n2);
        int n5 = n4;
        int n6 = n3 > n5 ? n3 : n5;
        return n6;
    }

    public final boolean isDirect(int n2) {
        boolean bl = (this.g.getWeight(n2) & 0x3FFFFFFF) == 0x3FFFFFFF;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isInherited(int n2) {
        if (this.g.get(n2) != null) return false;
        if (this.h == null) return false;
        if (this.h.getWeight(n2) != -1) return false;
        return true;
    }

    public final boolean isTransient(int n2) {
        boolean bl = this.h.get(n2) != null;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String getString(int n2) throws SAXException {
        if (n2 >= Atts.GROUP_TEXT_START && n2 <= Atts.GROUP_TEXT_END) {
            return (String)this.getObject(n2);
        }
        throw new InternalError("'" + Atts.attToString(n2) + "' is not a string");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getBoolean(int n2) throws SAXException {
        if (n2 < Atts.GROUP_BOOL_START) throw new InternalError("'" + Atts.attToString(n2) + "' is not a boolean");
        if (n2 > Atts.GROUP_BOOL_END) {
            throw new InternalError("'" + Atts.attToString(n2) + "' is not a boolean");
        }
        Boolean bl = (Boolean)this.getObject(n2);
        if (bl == null) {
            return false;
        }
        boolean bl2 = bl;
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float getNumber(int n2, float f2) throws SAXException {
        float f3;
        if (n2 < Atts.GROUP_NUM_START) throw new InternalError("'" + Atts.attToString(n2) + "' is not a number");
        if (n2 > Atts.GROUP_NUM_END) {
            throw new InternalError("'" + Atts.attToString(n2) + "' is not a number");
        }
        ExtNumber extNumber = (ExtNumber)this.getObject(n2);
        if (extNumber == null) {
            return 0.0f;
        }
        if (extNumber.type == 1) {
            return extNumber.val;
        }
        if (extNumber.type == 5) {
            if (n2 != Atts.FONT_SIZE) return 0.6f;
            float f4 = this.f.getParent().getTextStyle(0.0f).getFontSize() * this.f.getParent().getTextStyle(0.0f).getFont().getSubscriptSize();
            return f4;
        }
        if (extNumber.type == 2) {
            float f5;
            float f6 = extNumber.val;
            if (n2 == Atts.FONT_SIZE) {
                f5 = this.f.getParent().getTextStyle(0.0f).getFontSize();
                return f6 * f5 / 100.0f;
            }
            f5 = f2;
            return f6 * f5 / 100.0f;
        }
        if (extNumber.type == 3) {
            float f7;
            float f8 = extNumber.val;
            if (n2 == Atts.FONT_SIZE) {
                f7 = this.f.getParent().getTextStyle(0.0f).getFontSize();
                return f8 * f7;
            }
            f7 = this.f.getTextStyle(0.0f).getFontSize();
            return f8 * f7;
        }
        if (extNumber.type != 4) return extNumber.val;
        float f9 = extNumber.val;
        if (n2 == Atts.FONT_SIZE) {
            f3 = this.f.getParent().getTextStyle(0.0f).getFont().getAscender();
            return f9 * f3 / 2000.0f;
        }
        f3 = this.f.getTextStyle(0.0f).getFont().getAscender();
        return f9 * f3 / 2000.0f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte getNumberType(int n2) throws SAXException {
        if (n2 < Atts.GROUP_NUM_START || n2 > Atts.GROUP_NUM_END) {
            throw new InternalError("'" + Atts.attToString(n2) + "' is not a number");
        }
        ExtNumber extNumber = (ExtNumber)this.getObject(n2);
        if (extNumber == null) {
            return 0;
        }
        return extNumber.type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Paint getColor(int n2) throws SAXException {
        if (n2 >= Atts.GROUP_COLOR_START && n2 <= Atts.GROUP_COLOR_END) {
            return (Paint)this.getObject(n2);
        }
        throw new InternalError("'" + Atts.attToString(n2) + "' is not a color");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MyURL getURL(int n2) throws SAXException {
        if (n2 < Atts.GROUP_URL_START) throw new InternalError("'" + Atts.attToString(n2) + "' is not a URL");
        if (n2 > Atts.GROUP_URL_END) {
            throw new InternalError("'" + Atts.attToString(n2) + "' is not a URL");
        }
        MyURL myURL = null;
        String string = (String)this.getObject(n2);
        if (string == null) return myURL;
        if ("none".equals(string)) return myURL;
        return this.f.toURL(string);
    }

    private void b() throws SAXException {
        this.h = new AttHolder();
        SortedSet sortedSet = this.i.getTransientAttributes(this.f);
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            CSSEntry cSSEntry = (CSSEntry)iterator.next();
            int n2 = cSSEntry.score();
            Map map = cSSEntry.getAttributes();
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                this.a(string, map.get(string), n2, this.h);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(String string, Object object, int n2, AttHolder attHolder) throws SAXException {
        block249: {
            char c2;
            int n3;
            String string2;
            block248: {
                int n4;
                block251: {
                    block252: {
                        block259: {
                            block258: {
                                block257: {
                                    block256: {
                                        block255: {
                                            block254: {
                                                block253: {
                                                    block250: {
                                                        block247: {
                                                            if (string.startsWith("__")) {
                                                                return;
                                                            }
                                                            string = string.toLowerCase().trim().intern();
                                                            if (n2 == 0x3FFFFFFF && string == "style") {
                                                                if (((String)(object = ((String)object).trim())).endsWith(" !important")) {
                                                                    n2 += 0x40000000;
                                                                    object = ((String)object).substring(0, ((String)object).length() - 11);
                                                                } else if (((String)object).endsWith(" !unimportant")) {
                                                                    n2 = 0;
                                                                    object = ((String)object).substring(0, ((String)object).length() - 13);
                                                                }
                                                                String[] stringArray = Attributes.split((String)object, this.f, ';');
                                                                int n5 = 0;
                                                                while (n5 < stringArray.length) {
                                                                    int n6 = stringArray[n5].indexOf(":");
                                                                    if (n6 > 0) {
                                                                        string = stringArray[n5].substring(0, n6);
                                                                        String string3 = stringArray[n5].substring(n6 + 1).trim();
                                                                        if (string3.length() > 0) {
                                                                            if ((string3.charAt(0) == '\'' || string3.charAt(0) == '\"') && string3.charAt(0) == string3.charAt(string3.length() - 1)) {
                                                                                string3 = string3.substring(1, string3.length() - 1);
                                                                            }
                                                                            this.a(string, string3, n2, attHolder);
                                                                        }
                                                                    }
                                                                    ++n5;
                                                                }
                                                                return;
                                                            }
                                                            if (string != "font") break block247;
                                                            string2 = (String)object;
                                                            n3 = -1;
                                                            while (n3 < string2.length() - 1 && (c2 = string2.charAt(++n3)) != ',' && c2 != '\"' && c2 != '\'') {
                                                            }
                                                            break block248;
                                                        }
                                                        if (string == "border" || string == "border-style" || string == "border-width" || string == "border-color" || string == "cellborder" || string == "cellborder-style" || string == "cellborder-width" || string == "cellborder-color") {
                                                            String string4;
                                                            String string5;
                                                            if (string == "border" || string == "cellborder") {
                                                                string5 = string;
                                                                string4 = "";
                                                            } else {
                                                                int n7 = string.indexOf(45);
                                                                string5 = string.substring(0, n7);
                                                                string4 = string.substring(n7);
                                                            }
                                                            StringBuffer stringBuffer = new StringBuffer(string5.length() + 7 + string4.length());
                                                            stringBuffer.append(string5);
                                                            stringBuffer.append('-');
                                                            int n8 = stringBuffer.length();
                                                            stringBuffer.append("top");
                                                            stringBuffer.append(string4);
                                                            this.a(stringBuffer.toString(), object, n2, attHolder);
                                                            stringBuffer.setLength(n8);
                                                            stringBuffer.append("right");
                                                            stringBuffer.append(string4);
                                                            this.a(stringBuffer.toString(), object, n2, attHolder);
                                                            stringBuffer.setLength(n8);
                                                            stringBuffer.append("bottom");
                                                            stringBuffer.append(string4);
                                                            this.a(stringBuffer.toString(), object, n2, attHolder);
                                                            stringBuffer.setLength(n8);
                                                            stringBuffer.append("left");
                                                            stringBuffer.append(string4);
                                                            this.a(stringBuffer.toString(), object, n2, attHolder);
                                                            stringBuffer.setLength(n8);
                                                            return;
                                                        }
                                                        if (string == "border-left" || string == "border-right" || string == "border-top" || string == "border-bottom" || string == "cellborder-left" || string == "cellborder-right" || string == "cellborder-top" || string == "cellborder-bottom") {
                                                            String[] stringArray = Attributes.split((String)object, this.f, ' ');
                                                            if (stringArray.length > 0) {
                                                                if (stringArray[0].equals("none") || stringArray[0].equals("solid") || stringArray[0].equals("dotted") || stringArray[0].equals("bevel") || stringArray[0].equals("inset")) {
                                                                    String[] stringArray2 = new String[stringArray.length + 1];
                                                                    stringArray2[0] = "1";
                                                                    stringArray2[1] = stringArray[0];
                                                                    if (stringArray.length > 1) {
                                                                        stringArray2[2] = stringArray[1];
                                                                    }
                                                                    stringArray = stringArray2;
                                                                }
                                                                this.a(string + "-width", stringArray[0], n2, attHolder);
                                                            }
                                                            if (stringArray.length > 1) {
                                                                this.a(string + "-style", stringArray[1], n2, attHolder);
                                                            }
                                                            if (stringArray.length <= 2) return;
                                                            this.a(string + "-color", stringArray[2], n2, attHolder);
                                                            return;
                                                        }
                                                        if (string == "padding" || string == "margin" || string == "cellpadding" || string == "cellmargin") {
                                                            int n9;
                                                            Object[] objectArray = new Object[4];
                                                            int n10 = ((String)object).indexOf(32);
                                                            if (n10 < 0) {
                                                                objectArray[2] = objectArray[3] = object;
                                                                objectArray[1] = objectArray[3];
                                                                objectArray[0] = objectArray[3];
                                                            } else {
                                                                n9 = ((String)object).indexOf(32, n10 + 1);
                                                                if (n9 < 0) {
                                                                    objectArray[0] = objectArray[2] = ((String)object).substring(0, n10);
                                                                    objectArray[1] = objectArray[3] = ((String)object).substring(n10 + 1);
                                                                } else {
                                                                    int n11 = ((String)object).indexOf(32, n9 + 1);
                                                                    if (n11 < 0) {
                                                                        objectArray[0] = ((String)object).substring(0, n10);
                                                                        objectArray[1] = objectArray[3] = ((String)object).substring(n10 + 1, n9);
                                                                        objectArray[2] = ((String)object).substring(n9 + 1);
                                                                    } else {
                                                                        objectArray[0] = ((String)object).substring(0, n10);
                                                                        objectArray[1] = ((String)object).substring(n10 + 1, n9);
                                                                        objectArray[2] = ((String)object).substring(n9 + 1, n11);
                                                                        objectArray[3] = ((String)object).substring(n11 + 1);
                                                                    }
                                                                }
                                                            }
                                                            n9 = 0;
                                                            while (n9 < 4) {
                                                                StringBuffer stringBuffer = new StringBuffer(string.length() + 7);
                                                                stringBuffer.append(string);
                                                                stringBuffer.append("-");
                                                                stringBuffer.append(j[n9]);
                                                                this.a(stringBuffer.toString(), objectArray[n9], n2, attHolder);
                                                                ++n9;
                                                            }
                                                            return;
                                                        }
                                                        if (string == "background") break block249;
                                                        if (string == "size") {
                                                            object = this.f((String)object);
                                                            this.a("width", ((String)object).substring(0, ((String)object).indexOf(" ")), n2, attHolder);
                                                            this.a("height", ((String)object).substring(((String)object).lastIndexOf(" ") + 1), n2, attHolder);
                                                            return;
                                                        }
                                                        if (string != "font-weight") break block250;
                                                        if (object.toString().length() > 0 && ((String)object).charAt(0) > '4' && ((String)object).charAt(0) < '9' || "bolder".equals(object)) {
                                                            object = "bold";
                                                        }
                                                        break block251;
                                                    }
                                                    if (string != "font-size") break block252;
                                                    if (!(object.toString().length() > 0 & Character.isLetter(((String)object).charAt(0)))) break block251;
                                                    if (!object.equals("larger")) break block253;
                                                    object = "1.2em";
                                                    break block251;
                                                }
                                                if (!object.equals("smaller")) break block254;
                                                object = "0.8em";
                                                break block251;
                                            }
                                            if (!object.equals("xx-small")) break block255;
                                            object = "5.6pt";
                                            break block251;
                                        }
                                        if (!object.equals("x-small")) break block256;
                                        object = "7pt";
                                        break block251;
                                    }
                                    if (!object.equals("small")) break block257;
                                    object = "8.8pt";
                                    break block251;
                                }
                                if (!object.equals("medium")) break block258;
                                object = "11pt";
                                break block251;
                            }
                            if (!object.equals("large")) break block259;
                            object = "13.2pt";
                            break block251;
                        }
                        if (object.equals("x-large")) {
                            object = "15.8pt";
                            break block251;
                        } else if (object.equals("xx-large")) {
                            object = "19pt";
                        }
                        break block251;
                    }
                    if (string == "background-image-position") {
                        string = "background-position";
                    } else if (string == "protocol") {
                        string = "alias";
                    } else if (string == "host") {
                        string = "keystore";
                    } else if (string == "valign") {
                        string = "vertical-align";
                    } else if (string == "white-space") {
                        string = "whitespace";
                    } else if (string == "left") {
                        string = "x";
                    } else if (string == "outputprofile") {
                        string = "compress";
                    } else if (string == "top") {
                        string = "y";
                    } else if (string == "marker-hierarchy-seperator") {
                        string = "marker-hierarchy-separator";
                    } else if (string == "line-height" && object.equals("normal")) {
                        object = "-98145";
                    } else {
                        if (string == "azimuth") return;
                        if (string == "background-attachment") return;
                        if (string == "background-repeat") return;
                        if (string == "border-collapse") return;
                        if (string == "border-spacing") return;
                        if (string == "caption-side") return;
                        if (string == "clip") return;
                        if (string == "content") return;
                        if (string == "counter-increment") return;
                        if (string == "nter-reset") return;
                        if (string == "cue") return;
                        if (string == "cue-after") return;
                        if (string == "cue-before") return;
                        if (string == "cursor") return;
                        if (string == "elevation") return;
                        if (string == "empty-cells") return;
                        if (string == "font-size-adjust") return;
                        if (string == "list-style-image") return;
                        if (string == "list-style-position") return;
                        if (string == "list-style") return;
                        if (string == "list-style-type") return;
                        if (string == "marks") return;
                        if (string == "max-width") return;
                        if (string == "max-height") return;
                        if (string == "pause") return;
                        if (string == "pause-after") return;
                        if (string == "pause-before") return;
                        if (string == "pitch") return;
                        if (string == "pitch-range") return;
                        if (string == "play-during") return;
                        if (string == "quotes") return;
                        if (string == "richness") return;
                        if (string == "right") return;
                        if (string.startsWith("speak")) return;
                        if (string == "speech-rate") return;
                        if (string == "stress") return;
                        if (string == "text-shadow") return;
                        if (string == "voice_family") return;
                        if (string == "volume") {
                            return;
                        }
                    }
                }
                if (string == "border-left-width" || string == "border-right-width" || string == "border-bottom-width" || string == "border-top-width" || string == "cellborder-left-width" || string == "cellborder-right-width" || string == "cellborder-bottom-width" || string == "cellborder-top-width") {
                    if (object.equals("thin")) {
                        object = "0.5";
                    } else if (object.equals("medium")) {
                        object = "1";
                    } else if (object.equals("thick")) {
                        object = "2";
                    }
                }
                if (!Atts.attToString(n4 = Atts.stringToAtt(string)).equals(string)) {
                    this.f.document.warning("Unknown attribute \"" + string + "\"");
                    return;
                }
                if (n4 == Atts.FLOAT) {
                    this.a("display", "inline", n2 - 1, attHolder);
                }
                if (this.g.getWeight(n4) != 0 && n2 < this.g.getWeight(n4)) {
                    return;
                }
                if (attHolder == this.h && this.h.getWeight(n4) != 0 && n2 < this.h.getWeight(n4)) {
                    return;
                }
                if ("inherit".equals(object)) {
                    attHolder.set(n4, null, n2);
                    return;
                }
                if (n4 >= Atts.GROUP_TEXT_START && n4 < Atts.GROUP_TEXT_END) {
                    object = ((String)object).intern();
                } else if (n4 >= Atts.GROUP_COLOR_START && n4 < Atts.GROUP_COLOR_END) {
                    object = this.e((String)object);
                } else if (n4 >= Atts.GROUP_NUM_START && n4 < Atts.GROUP_NUM_END && !this.f.getTag().equals("sample")) {
                    String string6 = (String)object;
                    object = this.c(string6);
                    if (this.f instanceof Page && (n4 == Atts.WIDTH || n4 == Atts.HEIGHT) && (string6.endsWith("mm") || string6.endsWith("in") || string6.endsWith("cm") || string6.endsWith("pc") || string6.endsWith("px"))) {
                        ((ExtNumber)object).val = (int)((ExtNumber)object).val;
                    }
                } else if (n4 >= Atts.GROUP_BOOL_START && n4 < Atts.GROUP_BOOL_END) {
                    object = this.b((String)object);
                } else if (n4 >= Atts.GROUP_URL_START && n4 < Atts.GROUP_URL_END) {
                    if (object != null) {
                        object = this.a((String)object);
                    }
                } else if (n4 == Atts.DEFAULT_COLORS) {
                    String[] stringArray = Attributes.split((String)object, this.f, ',');
                    ArrayList<Paint> arrayList = new ArrayList<Paint>();
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        arrayList.add(this.e(stringArray[i2]));
                    }
                    object = arrayList.toArray(new Paint[0]);
                } else if (n4 == Atts.COLORSPACE && (object = this.f.document.getColorSpaceResource((String)object)) == null) {
                    object = b;
                }
                if (object == null) return;
                attHolder.set(n4, object, n2);
                return;
            }
            while (n3 > 0) {
                if ((c2 = string2.charAt(--n3)) == ' ') {
                    ++n3;
                    break;
                }
                if (c2 != '\"' && c2 != '\'') continue;
                while (string2.charAt(--n3) != c2) {
                }
            }
            String string7 = string2.substring(n3);
            String string8 = "normal";
            String string9 = "inherit";
            String string10 = "normal";
            String string11 = "normal";
            String string12 = "normal";
            if (n3 > 0) {
                int n12;
                String[] stringArray = Attributes.split(string2.substring(0, n3), this.f, ' ');
                for (n12 = 0; n12 < stringArray.length; ++n12) {
                    if (stringArray[n12].equals("italic") || stringArray[n12].equals("oblique")) {
                        string10 = "italic";
                        continue;
                    }
                    if (stringArray[n12].equals("small-caps")) {
                        string12 = "small-caps";
                        continue;
                    }
                    if (!stringArray[n12].equals("bold") && !stringArray[n12].equals("bolder") && !stringArray[n12].equals("500") && !stringArray[n12].equals("600") && !stringArray[n12].equals("700") && !stringArray[n12].equals("800") && !stringArray[n12].equals("900")) continue;
                    string11 = "bold";
                }
                if (stringArray.length > 0) {
                    string2 = stringArray[stringArray.length - 1];
                    if (string2.indexOf("/") > 0) {
                        n12 = string2.indexOf(47);
                        string8 = string2.substring(n12 + 1);
                        string9 = string2.substring(0, n12);
                    } else if (Character.isDigit(string2.charAt(0)) || string2.indexOf("large") >= 0 || string2.indexOf("small") >= 0 || string2.indexOf("medium") >= 0) {
                        string9 = string2;
                    }
                }
            }
            this.a("font-family", string7, n2, attHolder);
            this.a("font-size", string9, n2, attHolder);
            this.a("font-weight", string11, n2, attHolder);
            this.a("font-style", string10, n2, attHolder);
            this.a("font-variant", string12, n2, attHolder);
            this.a("line-height", string8, n2, attHolder);
            return;
        }
        String string13 = "transparent";
        String string14 = null;
        String string15 = "repeat";
        String string16 = "0% 0%";
        String string17 = null;
        boolean bl = true;
        StringTokenizer stringTokenizer = new StringTokenizer((String)object, " ");
        while (true) {
            block261: {
                block263: {
                    block262: {
                        block260: {
                            if (!stringTokenizer.hasMoreTokens()) {
                                this.a("background-color", string13, n2, attHolder);
                                this.a("background-image", string14, n2, attHolder);
                                this.a("background-repeat", string15, n2, attHolder);
                                this.a("background-position", string16, n2, attHolder);
                                return;
                            }
                            if (bl) {
                                string17 = stringTokenizer.nextToken();
                            }
                            if (!string17.startsWith("url(") && !string17.startsWith("http")) break block260;
                            string14 = string17;
                            break block261;
                        }
                        if (!string17.startsWith("repeat") && !string17.equals("no-repeat")) break block262;
                        string15 = string17;
                        break block261;
                    }
                    if (!string17.equals("top") && !string17.equals("left") && !string17.equals("bottom") && !string17.equals("right") && !string17.equals("center") && (string17.charAt(0) < '0' || string17.charAt(0) > '9')) break block263;
                    string16 = string17;
                    if (stringTokenizer.hasMoreTokens()) {
                        string17 = stringTokenizer.nextToken();
                        boolean bl2 = bl = string17.equals("top") || string17.equals("left") || string17.equals("bottom") || string17.equals("right") || string17.equals("center") || string17.charAt(0) >= '0' && string17.charAt(0) <= '9';
                        if (bl) {
                            string16 = string16 + " " + string17;
                        }
                    }
                    break block261;
                }
                if (!(string17.equals("scroll") || string17.equals("fixed") || string17.equals("inherit"))) {
                    string13 = string17;
                }
            }
            bl = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String a(String string) {
        if (string.startsWith("url(") && string.endsWith(")")) {
            string = string.substring(4, string.length() - 1);
        }
        if ((string = string.trim()).charAt(0) != '\'') {
            if (string.charAt(0) != '\"') return string;
        }
        if (string.charAt(string.length() - 1) != string.charAt(0)) return string;
        return string.substring(1, string.length() - 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Boolean b(String string) {
        if (!((string = string.toLowerCase()).equals("no") || string.equals("false") || string.equals("n"))) {
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    private ExtNumber c(String string) throws SAXException {
        if (string.length() == 0) {
            return new ExtNumber(0.0f, 1);
        }
        if (string.equals("subscript")) {
            return new ExtNumber(0.0f, 5);
        }
        try {
            if (string.charAt(string.length() - 1) == '%') {
                float f2 = Float.parseFloat(string.substring(0, string.length() - 1));
                return new ExtNumber(f2, 2);
            }
            if (string.length() > 2 && !Character.isDigit(string.charAt(string.length() - 1))) {
                String string2 = string.substring(string.length() - 2);
                float f3 = Float.parseFloat(string.substring(0, string.length() - 2));
                int n2 = 1;
                if (string2.equalsIgnoreCase("mm")) {
                    f3 = (float)((double)f3 * 2.834645669);
                } else if (string2.equalsIgnoreCase("cm")) {
                    f3 = (float)((double)f3 * 28.34645669);
                } else if (string2.equalsIgnoreCase("pc")) {
                    f3 *= 12.0f;
                } else if (string2.equalsIgnoreCase("px")) {
                    f3 = (float)((double)f3 * 0.8);
                } else if (string2.equalsIgnoreCase("in")) {
                    f3 *= 72.0f;
                } else if (string2.equalsIgnoreCase("em")) {
                    n2 = 3;
                } else if (string2.equalsIgnoreCase("ex")) {
                    n2 = 4;
                }
                return new ExtNumber(f3, (byte)n2);
            }
            return new ExtNumber(Float.parseFloat(string), 1);
        }
        catch (NumberFormatException numberFormatException) {
            this.f.document.warning("Unable to parse numeric value \"" + string + "\"");
            return null;
        }
    }

    static final float a(String string, float f2, float f3, PDFFont pDFFont) {
        float f4;
        block17: {
            f4 = 0.0f;
            if (string.charAt(string.length() - 1) == '%') {
                f4 = Float.parseFloat(string.substring(0, string.length() - 1)) * f2 / 100.0f;
            } else {
                if (string.length() <= 2 || Character.isDigit(string.charAt(string.length() - 1))) break block17;
                String string2 = string.substring(string.length() - 2);
                f4 = Float.parseFloat(string.substring(0, string.length() - 2));
                if (string2.equalsIgnoreCase("mm")) {
                    f4 = (float)((double)f4 * 2.834645669);
                } else if (string2.equalsIgnoreCase("cm")) {
                    f4 = (float)((double)f4 * 28.34645669);
                } else if (string2.equalsIgnoreCase("pc")) {
                    f4 *= 12.0f;
                } else if (string2.equalsIgnoreCase("px")) {
                    f4 = (float)((double)f4 * 0.8);
                } else if (string2.equalsIgnoreCase("in")) {
                    f4 *= 72.0f;
                } else if (string2.equalsIgnoreCase("em")) {
                    f4 *= f3;
                } else if (string2.equalsIgnoreCase("ex")) {
                    f4 *= f3 * pDFFont.getAscender() / 2000.0f;
                }
            }
        }
        return f4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Color a(String object, float f2) throws SAXException {
        Color color = null;
        if (Float.isNaN(f2)) {
            if (((String)object).startsWith("alpha(")) {
                String[] stringArray = Attributes.split(((String)object).substring(6, ((String)object).length() - 1), this.f, ',');
                f2 = this.d(stringArray[0]);
                if (f2 < 0.0f || f2 > 1.0f) {
                    this.f.document.warning("Illegal Alpha Value \"" + stringArray[0] + "\"");
                }
                object = stringArray[1];
            } else {
                f2 = 1.0f;
            }
        }
        if (((String)object).equals("none")) {
            return null;
        }
        if (((String)object).equals("transparent")) {
            return c;
        }
        if (((String)object).startsWith("rgb(") || ((String)object).startsWith("#")) {
            float[] fArray = new float[3];
            try {
                Object object2;
                if (((String)object).startsWith("rgb")) {
                    object2 = Attributes.split(((String)object).substring(4, ((String)object).length() - 1), this.f, ',');
                    if (((String[])object2).length != 3) {
                        fArray[0] = 1 / 0;
                    }
                    fArray[0] = this.d(object2[0]);
                    fArray[1] = this.d(object2[1]);
                    fArray[2] = this.d(object2[2]);
                } else {
                    if (((String)object).length() == 4) {
                        object = "" + ((String)object).charAt(0) + ((String)object).charAt(1) + ((String)object).charAt(1) + ((String)object).charAt(2) + ((String)object).charAt(2) + ((String)object).charAt(3) + ((String)object).charAt(3);
                    }
                    fArray[0] = (float)Integer.parseInt(((String)object).substring(1, 3), 16) / 255.0f;
                    fArray[1] = (float)Integer.parseInt(((String)object).substring(3, 5), 16) / 255.0f;
                    fArray[2] = (float)Integer.parseInt(((String)object).substring(5, 7), 16) / 255.0f;
                }
                object2 = (ColorSpace)this.f.getAttribute(Atts.COLORSPACE);
                if (object2 == null || ((ColorSpace)object2).getNumComponents() != 3) {
                    object2 = b;
                }
                if (object2 != b) return new Color((ColorSpace)object2, fArray, f2);
                return new Color(fArray[0], fArray[1], fArray[2], f2);
            }
            catch (SAXException sAXException) {
                throw sAXException;
            }
            catch (Exception exception) {
                this.f.document.warning("Illegal RGB color \"" + (String)object + "\"");
                return color;
            }
        }
        if (((String)object).startsWith("cmyk(")) {
            float[] fArray = new float[4];
            try {
                String[] stringArray = Attributes.split(((String)object).substring(5, ((String)object).length() - 1), this.f, ',');
                if (stringArray.length != 4) {
                    fArray[0] = 1 / 0;
                }
                fArray[0] = this.d(stringArray[0]);
                fArray[1] = this.d(stringArray[1]);
                fArray[2] = this.d(stringArray[2]);
                fArray[3] = this.d(stringArray[3]);
                ColorSpace colorSpace = (ColorSpace)this.f.getAttribute(Atts.COLORSPACE);
                if (colorSpace != null) {
                    if (colorSpace.getNumComponents() == 4) return new Color(colorSpace, fArray, f2);
                }
                colorSpace = a;
                return new Color(colorSpace, fArray, f2);
            }
            catch (SAXException sAXException) {
                throw sAXException;
            }
            catch (Exception exception) {
                this.f.document.warning("Illegal CMYK color '" + (String)object + "'");
                return color;
            }
        }
        if (((String)object).startsWith("gray(") || ((String)object).startsWith("grey(")) {
            float[] fArray = new float[1];
            try {
                fArray[0] = this.d(((String)object).substring(5, ((String)object).length() - 1));
                ColorSpace colorSpace = (ColorSpace)this.f.getAttribute(Atts.COLORSPACE);
                if (colorSpace == null) return CMYKColorSpace.getColor(0.0f, 0.0f, 0.0f, 1.0f - fArray[0], f2);
                if (colorSpace.getNumComponents() != 1) return CMYKColorSpace.getColor(0.0f, 0.0f, 0.0f, 1.0f - fArray[0], f2);
                return new Color(colorSpace, fArray, f2);
            }
            catch (SAXException sAXException) {
                throw sAXException;
            }
            catch (Exception exception) {
                this.f.document.warning("Illegal GrayScale color '" + (String)object + "'");
                return color;
            }
        }
        try {
            int n2 = (int)(f2 * 255.0f) << 24;
            color = new Color(n2 + Integer.parseInt(d.getString((String)object), 16), true);
        }
        catch (MissingResourceException missingResourceException) {
            this.f.document.warning("Unknown color '" + (String)object + "'");
        }
        ColorSpace colorSpace = (ColorSpace)this.f.getAttribute(Atts.COLORSPACE);
        if (colorSpace == null) return color;
        if (colorSpace == b) return color;
        if (colorSpace.getNumComponents() != 3) return color;
        return new Color(colorSpace, color.getColorComponents(null), f2);
    }

    private float d(String string) throws SAXException {
        try {
            string = string.trim();
            if (string.endsWith("%")) {
                return (float)Integer.parseInt(string.substring(0, string.length() - 1)) / 100.0f;
            }
            return (float)Integer.parseInt(string) / 255.0f;
        }
        catch (NumberFormatException numberFormatException) {
            this.f.document.warning("Illegal Color Component \"" + string + "\"");
            return 0.0f;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Paint e(String string) throws SAXException {
        void var2_18;
        String[] stringArray;
        Object var2_2 = null;
        float f2 = 1.0f;
        if (string.startsWith("alpha(")) {
            stringArray = Attributes.split(string.substring(6, string.length() - 1), this.f, ',');
            f2 = this.d(stringArray[0]);
            if (f2 < 0.0f || f2 > 1.0f) {
                this.f.document.warning("Illegal Alpha Value \"" + stringArray[0] + "\"");
            }
            string = stringArray[1];
        }
        if (string.startsWith("pattern(")) {
            if (f2 != 1.0f) {
                this.f.document.warning("Can't set alpha value on pattern, only on pattern components - ignoring");
                f2 = 1.0f;
            }
            string = string.toLowerCase();
            stringArray = Attributes.split(string.substring(8, string.length() - 1), this.f, ',');
            try {
                void var2_10;
                String string2 = stringArray[0];
                Color color = this.a(stringArray[1], Float.NaN);
                Color color2 = this.a(stringArray[2], Float.NaN);
                float f3 = Float.parseFloat(stringArray[3]);
                float f4 = 0.0f;
                float f5 = 0.0f;
                if (stringArray.length > 4) {
                    f4 = Float.parseFloat(stringArray[4]);
                }
                if (stringArray.length > 5) {
                    f5 = Float.parseFloat(stringArray[5]);
                }
                if (string2.endsWith("s")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if (string2.equals("stripe")) {
                    PDFPattern pDFPattern = new PDFPattern("Stripe" + (int)f5, 0.0f, 0.0f, f3, f4, color2, color);
                } else if (string2.equals("brick")) {
                    PDFPattern pDFPattern = new PDFPattern("Brick", 0.0f, 0.0f, f3, f4 * 2.0f, color2, color);
                } else if (string2.equals("check")) {
                    PDFPattern pDFPattern = new PDFPattern("Check", 0.0f, 0.0f, f3 * 2.0f, f3 * 2.0f, color2, color);
                } else if (string2.equals("grid")) {
                    PDFPattern pDFPattern = new PDFPattern("Grid", 0.0f, 0.0f, f3 + f4, f3 + f4, color2, color);
                } else if (string2.equals("spot")) {
                    PDFPattern pDFPattern = new PDFPattern("Spot", 0.0f, 0.0f, f3 * 2.0f, f3 * 2.0f, color2, color);
                } else if (string2.equals("polka")) {
                    PDFPattern pDFPattern = new PDFPattern("Polka", 0.0f, 0.0f, f3 * 2.0f, f3 * 2.0f, color2, color);
                } else if (string2.equals("star")) {
                    PDFPattern pDFPattern = new PDFPattern("Star", 0.0f, 0.0f, f3 * 2.0f, f3 * 2.0f, color2, color);
                } else {
                    this.f.document.warning("Unknown color pattern '" + string2 + "'");
                }
                Paint paint = (Paint)this.f.getDocument().a(string, var2_10);
                return var2_18;
            }
            catch (SAXException sAXException) {
                throw sAXException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.f.document.warning("Illegal color pattern '" + string + "'");
                return var2_18;
            }
        }
        if (string.startsWith("spot(")) {
            try {
                stringArray = Attributes.split(string.substring(5, string.length() - 1), this.f, ',');
                String string3 = stringArray[0];
                if (string3.charAt(0) == '\'' && string3.charAt(string3.length() - 1) == '\'' || string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"') {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                Color color = this.a(stringArray[1].toLowerCase(), 1.0f);
                float f6 = 1.0f;
                if (stringArray.length == 3) {
                    f6 = this.d(stringArray[2]);
                }
                Color color3 = new SpotColorSpace(string3, color).getColor(f6, f2);
                Paint paint = (Paint)this.f.getDocument().a(string, color3);
                return var2_18;
            }
            catch (SAXException sAXException) {
                throw sAXException;
            }
            catch (Exception exception) {
                this.f.document.warning("Illegal spot color '" + string + "'");
                return var2_18;
            }
        }
        if (!string.startsWith("gradient(")) {
            string = string.toLowerCase();
            Color color = this.a(string, f2);
            return var2_18;
        }
        if (f2 != 1.0f) {
            this.f.document.warning("Can't set alpha value on gradient - ignoring");
            f2 = 1.0f;
        }
        stringArray = Attributes.split(string.substring(9, string.length() - 1), this.f, ',');
        Color color = this.a(stringArray[0].toLowerCase(), 1.0f);
        Color color4 = this.a(stringArray[1].toLowerCase(), 1.0f);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 0.0f, 0.0f, color4);
        Paint paint = (Paint)this.f.getDocument().a(string, gradientPaint);
        return var2_18;
    }

    private String f(String string) throws SAXException {
        if (string.indexOf(" ") > 0) {
            return string;
        }
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("org.faceless.report.resources.Sizes");
            return resourceBundle.getString(string.toLowerCase());
        }
        catch (MissingResourceException missingResourceException) {
            this.f.document.warning("Unknown size '" + string + "'");
            return "0 0";
        }
    }

    public Attributes clone(Node node) {
        Attributes attributes = new Attributes(node, this.i, false);
        attributes.g = (AttHolder)this.g.clone();
        if (this.h != null) {
            attributes.h = (AttHolder)this.h.clone();
        }
        return attributes;
    }

    public void squash() {
        this.g.squash(this.h);
    }

    public String dump() {
        String string = "";
        for (int i2 = 0; i2 < Atts.TOTAL_ATTS; ++i2) {
            Object object;
            block9: {
                Object object2 = this.g.get(i2);
                Object object3 = this.h != null ? this.h.get(i2) : null;
                Object object4 = object3;
                int n2 = this.g.getWeight(i2);
                int n3 = this.h != null ? this.h.getWeight(i2) : 0;
                int n4 = n3;
                Object object5 = n2 > n4 ? object2 : object4;
                object = object5;
                if (object == null) continue;
                if (!(object instanceof Color)) break block9;
                object = this.a((Color)object);
            }
            string = string + " " + Atts.attToString(i2) + "=\"" + object + "\"";
        }
        return string;
    }

    private String a(Color color) {
        String string;
        block5: {
            char[] cArray;
            block4: {
                cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
                if (color != null) break block4;
                string = "null";
                break block5;
            }
            string = color == c ? "transparent" : "#" + cArray[color.getRed() >> 4] + cArray[color.getRed() & 0xF] + cArray[color.getGreen() >> 4] + cArray[color.getGreen() & 0xF] + cArray[color.getBlue() >> 4] + cArray[color.getBlue() & 0xF];
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] split(String string, Node node, char c2) throws SAXException {
        if (string.length() == 0) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = string = string.trim();
        if (string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'' || string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"' || string.charAt(0) == '(' && string.charAt(string.length() - 1) == ')') {
            string = string.substring(1, string.length() - 1).trim();
        }
        while (string.charAt(0) == c2) {
            string = string.substring(1, string.length()).trim();
        }
        while (string.charAt(string.length() - 1) == c2) {
            string = string.substring(0, string.length() - 1).trim();
        }
        for (n3 = 0; n3 < string.length(); ++n3) {
            char c3 = string.charAt(n3);
            if (!(bl2 || n4 != 0 || c3 != '\'' || n3 != 0 && string.charAt(n3 - 1) == '\\')) {
                boolean bl4 = bl = !bl;
                if (!bl3) continue;
                bl3 = false;
                n2 = n3;
                continue;
            }
            if (!(bl || n4 != 0 || c3 != '\"' || n3 != 0 && string.charAt(n3 - 1) == '\\')) {
                boolean bl5 = bl2 = !bl2;
                if (!bl3) continue;
                bl3 = false;
                n2 = n3;
                continue;
            }
            if (!(bl || bl2 || c3 != '(' || n3 != 0 && string.charAt(n3 - 1) == '\\')) {
                ++n4;
                if (!bl3) continue;
                bl3 = false;
                n2 = n3;
                continue;
            }
            if (!(bl || bl2 || c3 != ')' || n3 != 0 && string.charAt(n3 - 1) == '\\')) {
                --n4;
                if (!bl3) continue;
                bl3 = false;
                n2 = n3;
                continue;
            }
            if (bl || bl2 || n4 != 0) continue;
            if (c3 == c2) {
                arrayList.add(string.substring(n2, n3));
                bl3 = true;
                continue;
            }
            if (c3 == ' ' || !bl3) continue;
            bl3 = false;
            n2 = n3;
        }
        arrayList.add(string.substring(n2, n3));
        if (n4 > 0) {
            node.document.warning("Missing closing brace on attribute value \"" + string2 + "\"");
        }
        if (bl) {
            node.document.warning("Missing closing quote (') on attribute value \"" + string2 + "\"");
        }
        if (!bl2) return arrayList.toArray(new String[0]);
        node.document.warning("Missing closing quote (\") on attribute value \"" + string2 + "\"");
        return arrayList.toArray(new String[0]);
    }

    static {
        d = ResourceBundle.getBundle("org.faceless.report.resources.Colors");
        c = new Color(255, 128, 0, 0);
        j = new String[]{"top", "right", "bottom", "left"};
    }

    private class ExtNumber {
        public float val;
        public byte type;

        public ExtNumber(float f2) {
            this.val = f2;
        }

        public ExtNumber(float f2, byte by) {
            this.val = f2;
            this.type = by;
        }

        public String toString() {
            return "" + this.val + (this.type == 5 ? "subscript" : (this.type == 2 ? "%" : (this.type == 3 ? "em" : (this.type == 4 ? "ex" : ""))));
        }

        public boolean equals(Object object) {
            return object instanceof ExtNumber ? ((ExtNumber)object).val == this.val && ((ExtNumber)object).type == this.type : false;
        }
    }
}

