/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.report;

import java.util.HashMap;
import java.util.Map;
import org.faceless.pdf2.Event;
import org.faceless.pdf2.PDFStyle;
import org.faceless.report.AbstractBlock;
import org.faceless.report.Action;
import org.faceless.report.Atts;
import org.faceless.report.Div;
import org.faceless.report.Macro;
import org.faceless.report.Node;
import org.xml.sax.SAXException;

final class Page
extends AbstractBlock {
    public final int pagenumber;
    Node s = null;
    Node t = null;
    Node u = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Page(Map map, PDFStyle pDFStyle) throws SAXException {
        super(map);
        int n2;
        Div div;
        HashMap<String, Object> hashMap;
        this.setAttributes(map);
        if (this.debug) {
            this.a("in new Page(): parent=" + this.getParent());
        }
        this.pagenumber = (Integer)map.get("pagenumber");
        map.remove("pagenumber");
        this.w = this.getNumAttribute(Atts.WIDTH, 0.0f);
        this.h = this.getNumAttribute(Atts.HEIGHT, 0.0f);
        if (this.w == 0.0f || this.h == 0.0f) {
            this.document.error("No size specified for page " + map.get("pagenumber"));
        }
        this.m = this.document.getPDF().newPage(this.w + "x" + this.h);
        this.m.setUnits(1.0f, 1);
        if (pDFStyle != null) {
            this.m.setStyle(pDFStyle);
        }
        if (this.hasAttribute(Atts.HEADER) && !"none".equalsIgnoreCase(this.getStringAttribute(Atts.HEADER)) && this.getStringAttribute(Atts.HEADER).length() > 0) {
            this.s = this.document.getNodeByID(this.getStringAttribute(Atts.HEADER));
            if (this.s == null || !(this.s instanceof Macro)) {
                this.document.warning("Page Header macro '" + this.getStringAttribute(Atts.HEADER) + "' not found: ignoring");
                this.s = null;
            } else {
                this.setAttribute(Atts.PADDING_TOP, this.getNumAttribute(Atts.PADDING_TOP, this.h) + this.getNumAttribute(Atts.HEADER_HEIGHT, this.h));
            }
        }
        if (this.hasAttribute(Atts.FOOTER) && !"none".equalsIgnoreCase(this.getStringAttribute(Atts.FOOTER)) && this.getStringAttribute(Atts.FOOTER).length() > 0) {
            this.t = this.document.getNodeByID(this.getStringAttribute(Atts.FOOTER));
            if (this.t == null || !(this.t instanceof Macro)) {
                this.document.warning("Page Footer macro '" + this.getStringAttribute(Atts.FOOTER) + "' not found: ignoring");
                this.t = null;
            } else {
                this.setAttribute(Atts.PADDING_BOTTOM, this.getNumAttribute(Atts.PADDING_BOTTOM, this.h) + this.getNumAttribute(Atts.FOOTER_HEIGHT, this.h));
            }
        }
        if (this.hasAttribute(Atts.BACKGROUND_MACRO) && !"none".equalsIgnoreCase(this.getStringAttribute(Atts.BACKGROUND_MACRO)) && this.getStringAttribute(Atts.BACKGROUND_MACRO).length() > 0) {
            this.u = this.document.getNodeByID(this.getStringAttribute(Atts.BACKGROUND_MACRO));
            if (this.u == null || !(this.u instanceof Macro)) {
                this.document.warning("Page Background macro '" + this.getStringAttribute(Atts.BACKGROUND_MACRO) + "' not found: ignoring");
                this.u = null;
            }
        }
        this.setEdges(0.0f);
        if (this.u != null) {
            hashMap = new HashMap<String, Object>();
            hashMap.put("__tag", "div");
            hashMap.put("__document", this.document);
            hashMap.put("position", "absolute");
            hashMap.put("x", "-" + (this.pl + this.ml - this.bl));
            hashMap.put("y", "-" + (this.pt + this.mt - this.bt));
            hashMap.put("width", "" + this.m.getWidth());
            hashMap.put("height", "" + this.m.getHeight());
            div = new Div(hashMap);
            div.setAttributes(hashMap);
            for (n2 = 0; n2 < this.u.kids.size(); ++n2) {
                div.addKid(((Node)this.u.kids.get(n2)).deepclone());
            }
            this.addKid(div);
            div.setWidth(this.w);
            div.setHeight();
        }
        if (this.s != null) {
            hashMap = new HashMap();
            hashMap.put("__tag", "div");
            hashMap.put("__document", this.document);
            hashMap.put("position", "absolute");
            hashMap.put("x", "0");
            hashMap.put("y", "-" + this.getNumAttribute(Atts.HEADER_HEIGHT, this.h));
            hashMap.put("width", "100%");
            hashMap.put("height", "" + this.getNumAttribute(Atts.HEADER_HEIGHT, this.h));
            div = new Div(hashMap);
            div.setAttributes(hashMap);
            for (n2 = 0; n2 < this.s.kids.size(); ++n2) {
                div.addKid(((Node)this.s.kids.get(n2)).deepclone());
            }
            this.addKid(div);
            div.setWidth(this.w - this.edgew());
            div.setHeight();
        }
        if (this.t != null) {
            hashMap = new HashMap();
            hashMap.put("__tag", "div");
            hashMap.put("__document", this.document);
            hashMap.put("position", "absolute");
            hashMap.put("x", "0");
            hashMap.put("y", "" + (this.h - this.edgeh()));
            hashMap.put("width", "100%");
            hashMap.put("height", "" + this.getNumAttribute(Atts.FOOTER_HEIGHT, this.h));
            div = new Div(hashMap);
            div.setAttributes(hashMap);
            for (n2 = 0; n2 < this.t.kids.size(); ++n2) {
                div.addKid(((Node)this.t.kids.get(n2)).deepclone());
            }
            this.addKid(div);
            div.setWidth(this.w - this.edgew());
            div.setHeight();
        }
        if (!this.debug) return;
        this.a("out new Page(): " + this.thisrect() + " attribs=" + this.getOrigAttributes());
    }

    public float getHeight() {
        return (float)this.m.getHeight() - this.edgeh();
    }

    public void addKid(Node node) throws SAXException {
        super.addKid(node);
        node.setPage(this.m);
    }

    public void postdraw() throws SAXException {
        if (this.hasAttribute(Atts.ONOPEN)) {
            this.m.setAction(Event.OPEN, Action.parse(this.getStringAttribute(Atts.ONOPEN), this.document));
        }
        if (this.hasAttribute(Atts.ONCLOSE)) {
            this.m.setAction(Event.CLOSE, Action.parse(this.getStringAttribute(Atts.ONCLOSE), this.document));
        }
        super.postdraw();
    }

    final void b() {
    }

    public void setXMP(String string) {
        if (string != null && string.length() > 0) {
            this.m.setMetaData(string);
        }
    }
}

