/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.report;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.faceless.pdf2.PDFStyle;
import org.faceless.report.AbstractBlock;
import org.faceless.report.Atts;
import org.faceless.report.Node;
import org.faceless.report.ShapeElement;
import org.xml.sax.SAXException;

class Shape
extends AbstractBlock {
    public float cx;
    public float cy;
    public float cw;
    public float ch;
    private float s = Float.NaN;
    private List t = new ArrayList();
    private int u;

    public Shape(Map map) throws SAXException {
        super(map);
    }

    public AbstractBlock split(float f2) {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addKid(Node node) throws SAXException {
        boolean bl = node.hasAttribute(Atts._SHAPEPATH);
        if (this.u == 0 && bl) {
            this.u = 1;
        } else if (this.u == 1 && !bl) {
            this.u = 2;
        }
        if (this.u == 0) {
            this.document.error("<shape> must define a <shapepath> first, not <" + node.getTag() + ">: ignoring");
            return;
        }
        if (this.u == 1) {
            if (node instanceof ShapeElement) {
                this.t.add(node);
                node.setParent(this);
                return;
            }
            this.document.error("<shapepath> child <" + node.getTag() + "> is not instance of <moveto>, <lineto>, <arcto> or <bezierto>");
            return;
        }
        if (node instanceof AbstractBlock) {
            super.addKid(node);
            return;
        }
        this.document.warning("<shape> child <" + node.getTag() + "> not a block element. Ignoring");
    }

    private void b() throws SAXException {
        if (Float.isNaN(this.s)) {
            float f2 = this.edgew();
            this.s = this.getNumAttribute(Atts.BORDER_TOP_WIDTH);
            this.setAttribute(Atts.BORDER_TOP_WIDTH, 0.0f);
            this.setAttribute(Atts.BORDER_LEFT_WIDTH, 0.0f);
            this.setAttribute(Atts.BORDER_RIGHT_WIDTH, 0.0f);
            this.setAttribute(Atts.BORDER_BOTTOM_WIDTH, 0.0f);
            this.br = 0.0f;
            this.bl = 0.0f;
            this.bt = 0.0f;
            this.bb = 0.0f;
            if (this.debug) {
                this.a("doShape: edgew was " + f2 + " now " + this.edgew());
            }
        }
    }

    public float setWidth(float f2) throws SAXException {
        this.b();
        return super.setWidth(f2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void draw() throws SAXException {
        int n2;
        if (this.debug) {
            this.a("in Shape.draw");
        }
        this.setPos();
        PDFStyle pDFStyle = this.getGraphicsStyle(this.s, 0, null);
        if ((pDFStyle == null || pDFStyle.getFillColor() == null && (pDFStyle.getLineColor() == null || this.s == 0.0f)) && this.getAttribute(Atts.BACKGROUND_IMAGE) == null) {
            return;
        }
        this.cx = this.x + this.ml;
        if ("hidden".equals((String)this.getAttribute(Atts.OVERFLOW)) || this.getNumAttribute(Atts.ROTATE) != 0.0f) {
            this.m.save();
            if (this.getNumAttribute(Atts.ROTATE) != 0.0f) {
                this.m.rotate(this.x + this.w / 2.0f, this.y + this.h / 2.0f, this.getNumAttribute(Atts.ROTATE));
            }
        }
        this.cy = this.y + this.mt;
        this.cw = this.w - this.edgew();
        this.ch = this.h - this.edgeh();
        if (this.hasAttribute(Atts.BACKGROUND_IMAGE)) {
            this.m.save();
            this.m.pathMove(this.cx, this.cy);
            for (n2 = 0; n2 < this.t.size(); ++n2) {
                ((ShapeElement)this.t.get(n2)).draw(this);
            }
            this.m.pathClip();
            if (this.drawBackgroundImage(this.cx, this.cy, this.cx + this.cw, this.cy + this.ch) && pDFStyle != null) {
                pDFStyle.setFillColor(null);
            }
            this.m.restore();
        }
        if (pDFStyle != null) {
            this.m.setStyle(pDFStyle);
            if (this.t.size() > 0 && !((ShapeElement)this.t.get(0)).getTag().equals("moveto")) {
                this.m.pathMove(this.cx, this.cy);
            }
            for (n2 = 0; n2 < this.t.size(); ++n2) {
                ((ShapeElement)this.t.get(n2)).draw(this);
            }
            if (pDFStyle.getLineColor() == null && pDFStyle.getFillColor() == null) {
                if ("hidden".equals((String)this.getAttribute(Atts.OVERFLOW))) {
                    this.m.pathClip();
                }
            } else if ("hidden".equals((String)this.getAttribute(Atts.OVERFLOW))) {
                this.m.pathClipAndPaint();
            } else {
                this.m.pathPaint();
            }
            for (n2 = 0; n2 < this.kids.size(); ++n2) {
                ((AbstractBlock)this.kids.get(n2)).draw();
            }
        }
        if ("hidden".equals((String)this.getAttribute(Atts.OVERFLOW)) || this.getNumAttribute(Atts.ROTATE) != 0.0f) {
            this.m.restore();
        }
        if (!this.debug) return;
        this.a("out Shape.draw");
    }
}

