/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.report;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.faceless.report.AbstractBlock;
import org.faceless.report.Atts;
import org.faceless.report.CellMatrix;
import org.faceless.report.Node;
import org.faceless.report.Paragraph;
import org.faceless.report.Tbody;
import org.faceless.report.Td;
import org.faceless.report.Tfoot;
import org.faceless.report.Tgroup;
import org.faceless.report.Thead;
import org.faceless.report.Tr;
import org.xml.sax.SAXException;

final class Table
extends AbstractBlock {
    private float[] s;
    private float[] t;
    private float[] u;
    private float[] v;
    private boolean z;
    private int A;
    private CellMatrix B;
    private float C = Float.NaN;

    public Table(Map map) throws SAXException {
        super(map);
    }

    public void addKid(Node node) throws SAXException {
        block9: {
            block8: {
                if (node instanceof Tgroup) break block8;
                this.document.warning("<table> kid is <" + node.getTag() + "> not <thead>, <tbody> or <tfoot>: ignored");
                break block9;
            }
            boolean bl = true;
            int n2 = 0;
            while (true) {
                block10: {
                    if (n2 >= this.kids.size()) break;
                    if (((Node)this.kids.get(n2)).getTag() != node.getTag()) break block10;
                    this.document.warning("<table> may only contain one <" + node.getTag() + ">: ignoring duplicate");
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                super.addKid(node);
            }
        }
    }

    private Tbody b() {
        for (int i2 = 0; i2 < this.kids.size(); ++i2) {
            if (!(this.kids.get(i2) instanceof Tbody)) continue;
            return (Tbody)this.kids.get(i2);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AbstractBlock split(float f2) throws SAXException {
        Tr tr;
        int n2;
        int n3;
        int n4;
        float f9;
        Thead thead = null;
        Tbody tbody = null;
        Tfoot tfoot = null;
        for (int n5 = 0; n5 < this.kids.size(); ++n5) {
            if (this.kids.get(n5) instanceof Thead && thead == null) {
                thead = (Thead)this.kids.get(n5);
                continue;
            }
            if (this.kids.get(n5) instanceof Tbody && tbody == null) {
                tbody = (Tbody)this.kids.get(n5);
                continue;
            }
            if (!(this.kids.get(n5) instanceof Tfoot) || tfoot != null) continue;
            tfoot = (Tfoot)this.kids.get(n5);
        }
        float f5 = thead == null ? 0.0f : thead.h;
        float f4 = tfoot == null ? 0.0f : tfoot.h;
        float f3 = this.edgeh();
        if (tbody == null) return this;
        if (f5 + f4 + f3 > f2) {
            return this;
        }
        if (this.debug) {
            this.a("in Table.SPLIT: must=" + this.d() + " size=" + f2 + " head=" + f5 + " foot=" + f5 + " pad=" + f3 + " body=" + tbody.kids.size() + " rows, bodyh=" + tbody.h);
        }
        f2 -= f3 + f4 + f5;
        ArrayList arrayList = new ArrayList();
        float f8 = 0.0f;
        for (n3 = 0; n3 < tbody.kids.size(); f8 += f9, n3 += n4) {
            n4 = 0;
            f9 = 0.0f;
            n2 = 0;
            while (n3 + n4 < tbody.kids.size()) {
                tr = (Tr)tbody.kids.get(n3 + n4);
                if (this.debug) {
                    this.a("Comparing row " + n3 + "+" + n4 + ", h=" + f9 + ", toth=" + f8 + " to " + f2);
                }
                f9 += tr.h;
                ++n4;
                n2 = tr.canSplitAfter();
                if (n2 == 1) continue;
            }
            if (f8 + f9 > f2) break;
        }
        if (n3 == tbody.kids.size()) {
            return this;
        }
        if (n3 > 0) {
            Table table = (Table)this.clone();
            table.kids = new ArrayList();
            if (thead != null) {
                table.addKid(thead.deepclone());
            }
            Tbody tbody2 = (Tbody)tbody.clone();
            table.addKid(tbody2);
            tbody2.kids = new ArrayList();
            for (n2 = n3; n2 < tbody.kids.size(); ++n2) {
                tr = (Tr)tbody.kids.get(n2);
                tbody2.addKid(tr);
                for (int i2 = 0; i2 < tr.kids.size(); td2.v -= n3, ++i2) {
                    Td td2 = (Td)tr.kids.get(i2);
                }
            }
            tbody2.h = tbody.h - f8;
            table.h = tbody2.h + f3 + f5 + f4;
            if (tfoot != null) {
                table.addKid(tfoot.deepclone());
            }
            if (this.debug) {
                this.a("splitting table: at " + n3 + "/" + tbody.kids.size() + ": rowh=" + f8 + " new (h=" + table.h + " body.h=" + tbody2.h + " body.kids=" + tbody2.kids.size() + ")");
            }
            tbody.kids = tbody.kids.subList(0, n3);
            tbody.h = f8;
            this.h -= tbody2.h;
            this.kids = new ArrayList();
            if (thead != null) {
                this.addKid(thead);
            }
            this.addKid(tbody);
            if (tfoot != null) {
                this.addKid(tfoot);
            }
            this.addNodeAfter(table);
        }
        if (!this.debug) return this;
        this.a("out Table.SPLIT - returning this (h=" + this.h + " body.h=" + tbody.h + " body.kids=" + tbody.kids.size() + ")");
        return this;
    }

    public float getCellX(int n2) {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            f2 += this.s[i2];
        }
        return f2;
    }

    public float getCellWidth(int n2, int n3) {
        float f2 = 0.0f;
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            f2 += this.s[i2];
        }
        return f2;
    }

    private void c() throws SAXException {
        this.B = new CellMatrix();
        int n2 = this.kids.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.B.append(((Tgroup)this.kids.get(i2)).b());
        }
        this.s = new float[this.B.getWidth()];
        this.u = new float[this.B.getWidth()];
        this.t = new float[this.B.getWidth()];
        this.v = new float[this.B.getWidth()];
    }

    public float getMCW(float f2) throws SAXException {
        if (this.debug) {
            this.a("in Table.getMCW: maxwidth=" + f2);
        }
        if (Float.isNaN(this.mcw)) {
            this.a(f2);
        }
        if (this.debug) {
            this.a("out Table.getMCW: mcw=" + this.mcw);
        }
        return this.mcw;
    }

    public float getOCW(float f2) throws SAXException {
        if (this.debug) {
            this.a("in Table.getOCW: maxwidth=" + f2);
        }
        if (Float.isNaN(this.ocw)) {
            this.a(f2);
        }
        if (this.debug) {
            this.a("out Table.getOCW: ocw=" + this.ocw);
        }
        return this.ocw;
    }

    private void a(float f2) throws SAXException {
        if (this.debug) {
            this.a("in Table.calcMOCW: maxwidth=" + f2);
        }
        f2 = this.setEdges(f2);
        float f3 = this.hasAttribute(Atts.WIDTH) ? f2 - this.edgew() : 0.0f;
        float f4 = f3;
        if (this.B == null) {
            this.c();
        }
        if (!this.z) {
            this.b(f4);
        }
        this.ocw = 0.0f;
        this.mcw = 0.0f;
        for (int i2 = 0; i2 < this.s.length; ++i2) {
            this.mcw += this.t[i2];
            this.ocw += this.u[i2];
        }
        this.mcw += this.edgew();
        this.ocw += this.edgew();
        if (this.getParent() instanceof Paragraph) {
            float f5 = this.getNumAttribute(Atts.WIDTH, f2);
            if (this.mcw < f5) {
                this.mcw = f5;
            }
            if (this.ocw < f5) {
                this.ocw = f5;
            }
        }
        if (this.debug) {
            this.a("out Table.calcMOCW - mcw=" + this.mcw + " ocw=" + this.ocw);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float setWidth(float f2) throws SAXException {
        int n2;
        float f3;
        if (f2 == this.C) {
            return this.w;
        }
        this.C = f2;
        if (this.debug) {
            this.a("in Table.setWidth(): maxwidth=" + f2);
        }
        f2 = this.setEdges(f2) - this.edgew();
        float f4 = f3 = this.hasAttribute(Atts.WIDTH) ? f2 : 0.0f;
        if (f3 == 0.0f) {
            this.setAttribute(Atts.TABLE_LAYOUT, (Object)"auto");
        }
        if (this.B == null) {
            this.c();
        }
        if (this.getStringAttribute(Atts.TABLE_LAYOUT) == "fixed" && f3 != 0.0f) {
            this.a(this.B, f3);
        } else {
            if (!this.z) {
                this.b(f3);
            }
            this.a(this.B, f2, f3);
        }
        this.w = 0.0f;
        for (n2 = 0; n2 < this.s.length; ++n2) {
            this.w += this.s[n2];
            if (!this.debug) continue;
            this.a("WIDTHS[" + n2 + "]: " + this.s[n2]);
        }
        n2 = 0;
        block13: while (true) {
            if (n2 >= this.kids.size()) {
                this.w += this.edgew();
                if (!this.debug) return this.w;
                this.a("out Table.setWidth " + this.thisrect() + " w=" + this.w);
                return this.w;
            }
            Tgroup tgroup = (Tgroup)this.kids.get(n2);
            tgroup.setEdges(this.w);
            tgroup.w = this.w;
            int i2 = 0;
            while (true) {
                Td td2;
                Tr tr;
                if (i2 < tgroup.kids.size()) {
                    tr = (Tr)tgroup.kids.get(i2);
                    tr.setEdges(this.w);
                    tr.w = this.w;
                } else {
                    ++n2;
                    continue block13;
                }
                for (int i3 = 0; i3 < tr.kids.size(); td2.w += td2.edgew(), ++i3) {
                    td2 = (Td)tr.kids.get(i3);
                    td2.setEdges(this.w);
                    td2.w = this.getCellWidth(td2.u, td2.t) - td2.edgew();
                    for (int i4 = 0; i4 < td2.kids.size(); ++i4) {
                        ((AbstractBlock)td2.kids.get(i4)).setWidth(td2.w);
                    }
                }
                ++i2;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(CellMatrix cellMatrix, float f2) throws SAXException {
        if (this.debug) {
            this.a("in Table.doFixedLayout (maxw=" + f2 + ")");
        }
        int n2 = 0;
        float f3 = f2;
        int n3 = 0;
        while (n3 < cellMatrix.getWidth()) {
            Td td2 = cellMatrix.getCell(n3, 0);
            if (td2 != null) {
                td2.setEdges(f2);
                if (td2.hasAttribute(Atts.WIDTH)) {
                    while (n3 < td2.u + td2.t) {
                        this.s[n3++] = td2.getNumAttribute(Atts.WIDTH, f2) / (float)td2.t;
                    }
                    f3 -= td2.getNumAttribute(Atts.WIDTH, f2);
                    ++n2;
                    td2.setAttribute(Atts.WIDTH, null);
                    continue;
                }
                ++n3;
                continue;
            }
            ++n3;
        }
        f3 /= (float)(cellMatrix.getWidth() - n2);
        for (n3 = 0; n3 < cellMatrix.getWidth(); ++n3) {
            if (this.s[n3] != 0.0f) continue;
            this.s[n3] = f3;
        }
        f3 = 0.0f;
        for (n3 = 0; n3 < cellMatrix.getWidth(); f3 += this.s[n3], ++n3) {
        }
        f3 = (f2 - f3) / (float)cellMatrix.getWidth();
        n3 = 0;
        while (true) {
            if (n3 >= cellMatrix.getWidth()) {
                if (!this.debug) return;
                this.a("out Table.doFixedLayout");
                return;
            }
            int n4 = n3++;
            this.s[n4] = this.s[n4] + f3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void b(float f2) throws SAXException {
        int n2;
        float f3;
        Iterator iterator;
        if (this.debug) {
            this.a("in Table.calcColumnMOCW (width=" + f2 + ")");
        }
        this.z = true;
        HashSet<Td> hashSet = new HashSet<Td>();
        int n3 = 0;
        while (true) {
            if (n3 < this.B.getWidth()) {
                this.v[n3] = 2.1474836E9f;
            } else {
                if (this.debug) {
                    for (n3 = 0; n3 < this.s.length; ++n3) {
                        this.a("--> PASS1 col " + n3 + "/" + this.s.length + ": mcw=" + this.t[n3] + " ocw=" + this.u[n3] + " max=" + this.v[n3]);
                    }
                }
                iterator = hashSet.iterator();
                break;
            }
            for (int i2 = 0; i2 < this.B.getHeight(); ++i2) {
                Td td2 = this.B.getCell(n3, i2);
                if (td2 != null && td2.t == 1) {
                    f3 = td2.getMCW(f2);
                    if (f3 > this.t[n3]) {
                        this.t[n3] = f3;
                    }
                    if ((f3 = td2.getOCW(f2)) > this.u[n3]) {
                        this.u[n3] = f3;
                    }
                    if (!td2.hasAttribute(Atts.WIDTH) || !((f3 = td2.getNumAttribute(Atts.WIDTH, f2) + td2.edgew()) < this.v[n3])) continue;
                    this.v[n3] = f3;
                    continue;
                }
                if (td2 == null) continue;
                hashSet.add(td2);
            }
            ++n3;
        }
        while (iterator.hasNext()) {
            int n4;
            Td td3 = (Td)iterator.next();
            float f4 = td3.getMCW(f2);
            f3 = td3.getOCW(f2);
            float f5 = 0.0f;
            float f6 = 0.0f;
            for (n4 = td3.u; n4 < td3.u + td3.t; f5 += this.t[n4], f6 += this.u[n4], ++n4) {
            }
            f5 = Math.max(0.0f, (f4 - f5) / (float)td3.t);
            f6 = Math.max(0.0f, (f3 - f6) / (float)td3.t);
            n4 = td3.u;
            while (n4 < td3.u + td3.t) {
                int n5 = n4;
                this.t[n5] = this.t[n5] + f5;
                int n6 = n4++;
                this.u[n6] = this.u[n6] + f6;
            }
        }
        for (n2 = 0; n2 < this.B.getWidth(); ++n2) {
            if (!(this.t[n2] > this.v[n2]) && !(this.u[n2] > this.v[n2])) continue;
            this.v[n2] = 2.1474836E9f;
        }
        if (this.debug) {
            for (n2 = 0; n2 < this.s.length; ++n2) {
                this.a("--> FINISH col " + n2 + "/" + this.s.length + ": mcw=" + this.t[n2] + " ocw=" + this.u[n2] + " max=" + this.v[n2]);
            }
        }
        if (!this.debug) return;
        this.a("out Table.calcColumnMOCW");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(CellMatrix cellMatrix, float f2, float f3) throws SAXException {
        block27: {
            int n2;
            float f4;
            float f5;
            block26: {
                int n5;
                int n3;
                if (this.debug) {
                    this.a("in Table.doAutoLayout (maxwidth=" + f2 + " specwidth=" + f3 + ")");
                }
                f5 = 0.0f;
                f4 = 0.0f;
                for (n2 = 0; n2 < this.t.length; f5 += this.t[n2], f4 += this.u[n2], ++n2) {
                }
                if (f4 > f2) {
                    f3 = f2;
                }
                if (f3 == 0.0f) break block26;
                float f6 = Math.min(1.0f, (f3 - f5) / Math.max(1.0f, f4 - f5));
                if (this.debug) {
                    this.a("Stretching/Shrinking: tot mcw=" + f5 + " ocw=" + f4 + " diff=" + f6);
                }
                if (f6 > 0.0f) {
                    f5 = 0.0f;
                    for (n3 = 0; n3 < this.s.length; f5 += this.t[n3], ++n3) {
                        int n4 = n3;
                        this.t[n4] = this.t[n4] + (this.u[n3] - this.t[n3]) * f6;
                        if (!this.debug) continue;
                        this.a("--> INCREASING MCWS TOWARDS OCW col " + n3 + "/" + this.s.length + ": mcw now=" + this.t[n3]);
                    }
                }
                n3 = 0;
                float f7 = 0.0f;
                for (n5 = 0; n5 < this.s.length; f7 += this.s[n5], ++n5) {
                    this.s[n5] = Math.min(this.v[n5], this.t[n5] + (f3 - f5) / (float)this.s.length);
                    if (this.debug) {
                        this.a("--> INCREASING W TOWARDS MAX col " + n5 + "/" + this.s.length + ": w now=" + this.s[n5]);
                    }
                    if (this.s[n5] == this.v[n5]) continue;
                    ++n3;
                }
                if (f7 < f3) {
                    for (n5 = 0; n5 < this.s.length; ++n5) {
                        if (this.s[n5] == this.v[n5]) continue;
                        int n6 = n5;
                        this.s[n6] = this.s[n6] + (f3 - f7) / (float)n3;
                    }
                }
                break block27;
            }
            if (f4 < f2) {
                for (n2 = 0; n2 < this.s.length; ++n2) {
                    this.s[n2] = this.u[n2];
                }
            } else {
                for (n2 = 0; n2 < this.s.length; ++n2) {
                    this.s[n2] = this.t[n2] + (f2 - f5) / (float)this.s.length;
                }
            }
        }
        if (!this.debug) return;
        this.a("out Table.doAutoLayout");
    }

    boolean d() throws SAXException {
        if (this.A == 0) {
            Tbody tbody = this.b();
            this.A = 1;
            for (int i2 = 0; i2 < tbody.kids.size(); ++i2) {
                Tr tr = (Tr)tbody.kids.get(i2);
                int n2 = tr.canSplitAfter();
                if (n2 <= 1) continue;
                this.A = 2;
                break;
            }
        }
        boolean bl = this.A == 2;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float setHeight() throws SAXException {
        float f8;
        if (this.debug) {
            this.a("IN Table.setHeight()");
        }
        float f2 = super.setHeight();
        Thead thead = null;
        Tbody tbody = null;
        Tfoot tfoot = null;
        for (int n3 = 0; n3 < this.kids.size(); ++n3) {
            if (this.kids.get(n3) instanceof Thead && thead == null) {
                thead = (Thead)this.kids.get(n3);
                continue;
            }
            if (this.kids.get(n3) instanceof Tbody && tbody == null) {
                tbody = (Tbody)this.kids.get(n3);
                continue;
            }
            if (!(this.kids.get(n3) instanceof Tfoot) || tfoot != null) continue;
            tfoot = (Tfoot)this.kids.get(n3);
        }
        float f4 = thead == null ? 0.0f : thead.h;
        float f6 = tbody == null ? 0.0f : tbody.h;
        float f3 = f8 = tfoot == null ? 0.0f : tfoot.h;
        if ((double)(f4 + f6 + f8 + this.edgeh()) < (double)this.h - 0.1 && tbody != null) {
            Tr tr;
            int n2;
            int n4 = 0;
            float f9 = this.h - this.edgeh() - f8 - f4;
            for (n2 = 0; n2 < tbody.kids.size(); ++n2) {
                tr = (Tr)tbody.kids.get(n2);
                if (!tr.hasAttribute(Atts.HEIGHT)) {
                    ++n4;
                    continue;
                }
                f9 -= tr.getNumAttribute(Atts.HEIGHT, (float)this.m.getHeight() - tr.edgeh());
            }
            if (this.debug) {
                this.a("headh=" + f4 + " bodyh=" + f6 + " footh=" + f8 + " edgeh()=" + this.edgeh() + " but h=" + this.h + " - spreading " + f9 + " over " + n4 + " rows");
            }
            for (n2 = 0; n2 < tbody.kids.size(); ++n2) {
                tr = (Tr)tbody.kids.get(n2);
                if (tr.hasAttribute(Atts.HEIGHT)) continue;
                tr.setAttribute(Atts.HEIGHT, f9 / (float)n4);
            }
            tbody.setHeight();
        }
        if (!this.debug) return f2;
        this.a("OUT Table.setHeight() - ret=" + f2);
        return f2;
    }
}

