/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.retrotranslator.net.sf.retrotranslator.runtime.format;

import java.text.DecimalFormatSymbols;
import org.faceless.retrotranslator.net.sf.retrotranslator.runtime.format.Conversion;
import org.faceless.retrotranslator.net.sf.retrotranslator.runtime.format.FormatContext;
import org.faceless.retrotranslator.net.sf.retrotranslator.runtime.java.lang._StringBuffer;

abstract class NumericConversion
extends Conversion {
    NumericConversion() {
    }

    protected static void appendNumber(StringBuffer builder, String number, boolean groupingUsed, DecimalFormatSymbols symbols) {
        for (int i2 = 0; i2 < number.length(); ++i2) {
            if (groupingUsed && i2 > 0 && (number.length() - i2) % 3 == 0) {
                builder.append(symbols.getGroupingSeparator());
            }
            builder.append((char)(symbols.getZeroDigit() - 48 + number.charAt(i2)));
        }
    }

    protected static boolean printSpecialNumber(FormatContext context, double argument) {
        if (Double.isNaN(argument)) {
            context.writePadded("NaN");
            return true;
        }
        if (argument == Double.POSITIVE_INFINITY) {
            context.writePadded(context.isFlag('+') ? "+Infinity" : "Infinity");
            return true;
        }
        if (argument == Double.NEGATIVE_INFINITY) {
            context.writePadded(context.isFlag('(') ? "(Infinity)" : "-Infinity");
            return true;
        }
        return false;
    }

    protected static void printNumber(FormatContext context, boolean negative, String prefix, StringBuffer argument, DecimalFormatSymbols symbols) {
        StringBuffer builder = new StringBuffer();
        if (negative) {
            if (context.isFlag('(')) {
                builder.append('(');
                argument.append(')');
            } else {
                builder.append('-');
            }
        } else if (context.isFlag('+')) {
            builder.append('+');
        } else if (context.isFlag(' ')) {
            builder.append(' ');
        }
        if (prefix != null) {
            builder.append(prefix);
        }
        if (context.isFlag('0')) {
            int count = context.getWidth() - builder.length() - argument.length();
            for (int i2 = 0; i2 < count; ++i2) {
                builder.append(symbols.getZeroDigit());
            }
        }
        context.writePadded(_StringBuffer.append(builder, argument).toString());
    }
}

