/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.retrotranslator.net.sf.retrotranslator.runtime.java.lang;

public class _Math {
    private static final double LOG10 = Math.log(10.0);

    public static double cbrt(double a2) {
        if (a2 > 0.0) {
            return Math.pow(a2, 0.3333333333333333);
        }
        if (a2 < 0.0) {
            return -Math.pow(Math.abs(a2), 0.3333333333333333);
        }
        return a2;
    }

    public static double cosh(double x2) {
        return (Math.exp(x2) + Math.exp(-x2)) / 2.0;
    }

    public static double expm1(double x2) {
        return x2 == 0.0 ? x2 : Math.exp(x2) - 1.0;
    }

    public static double log10(double a2) {
        double exactResult = Math.log(a2) / LOG10;
        double fixedResult = Math.ceil(exactResult);
        double fixedArgument = Math.pow(10.0, fixedResult);
        return fixedArgument <= a2 ? fixedResult : exactResult;
    }

    public static double log1p(double x2) {
        return x2 == 0.0 ? x2 : Math.log(1.0 + x2);
    }

    public static double signum(double d2) {
        return d2 > 0.0 ? 1.0 : (d2 < 0.0 ? -1.0 : (d2 == 0.0 ? d2 : Double.NaN));
    }

    public static float signum(float f2) {
        return f2 > 0.0f ? 1.0f : (f2 < 0.0f ? -1.0f : (f2 == 0.0f ? f2 : Float.NaN));
    }

    public static double sinh(double x2) {
        return x2 == 0.0 ? x2 : (Math.exp(x2) - Math.exp(-x2)) / 2.0;
    }

    public static double tanh(double x2) {
        if (x2 == 0.0) {
            return x2;
        }
        if (x2 == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (x2 == Double.NEGATIVE_INFINITY) {
            return -1.0;
        }
        double p2 = Math.exp(x2);
        double q2 = Math.exp(-x2);
        return (p2 - q2) / (p2 + q2);
    }
}

