/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.retrotranslator.net.sf.retrotranslator.runtime.java.lang;

import java.util.HashMap;
import java.util.Map;
import org.faceless.retrotranslator.net.sf.retrotranslator.runtime.impl.WeakIdentityTable;
import org.faceless.retrotranslator.net.sf.retrotranslator.runtime.java.lang.Thread_State_;
import org.faceless.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Thread_UncaughtExceptionHandler;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _Thread {
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private static final WeakIdentityTable<Thread, _Thread> threads = new WeakIdentityTable<Thread, _Thread>(){

        @Override
        protected _Thread initialValue() {
            return new _Thread();
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.initialValue();
        }
    };
    private static long lastId;
    private static Object defaultHandler;
    private volatile long id;
    private volatile boolean started;
    private Object handler;

    public static void handleUncaughtException(Throwable throwable) {
        _Thread.processException(throwable);
    }

    protected static void processException(Throwable throwable) {
        if (new Exception().getStackTrace().length <= 4) {
            Thread thread = Thread.currentThread();
            Object handler = threads.obtain(thread).getHandler();
            if (handler == null) {
                handler = _Thread.getDefaultUncaughtExceptionHandler();
            }
            if (handler != null) {
                _Thread_UncaughtExceptionHandler.uncaughtException(handler, thread, throwable);
                return;
            }
        }
        try {
            throw throwable;
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Error e3) {
            throw e3;
        }
        catch (Throwable t2) {
            throw new Error(t2);
        }
    }

    public static Runnable convertConstructorArguments(Runnable target) {
        return RunnableWrapper.wrap(target);
    }

    public static BasicThreadBuilder createInstanceBuilder(ThreadGroup group, Runnable target) {
        return new BasicThreadBuilder(group, RunnableWrapper.wrap(target));
    }

    public static AdvancedThreadBuilder createInstanceBuilder(Runnable target, String name) {
        return new AdvancedThreadBuilder(null, RunnableWrapper.wrap(target), name, 0L);
    }

    public static AdvancedThreadBuilder createInstanceBuilder(ThreadGroup group, Runnable target, String name) {
        return new AdvancedThreadBuilder(group, RunnableWrapper.wrap(target), name, 0L);
    }

    public static AdvancedThreadBuilder createInstanceBuilder(ThreadGroup group, Runnable target, String name, long stackSize) {
        return new AdvancedThreadBuilder(group, RunnableWrapper.wrap(target), name, stackSize);
    }

    public static synchronized Object getDefaultUncaughtExceptionHandler() {
        return defaultHandler;
    }

    public static synchronized void setDefaultUncaughtExceptionHandler(Object handler) {
        defaultHandler = handler;
    }

    public static long getId(Thread thread) {
        return threads.obtain(thread).getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getId() {
        if (this.id == 0L) {
            WeakIdentityTable<Thread, _Thread> weakIdentityTable = threads;
            synchronized (weakIdentityTable) {
                while (this.id == 0L) {
                    this.id = ++lastId;
                }
            }
        }
        return this.id;
    }

    public static StackTraceElement[] getStackTrace(Thread thread) {
        return thread == Thread.currentThread() ? _Thread.getStackTrace() : EMPTY_STACK_TRACE;
    }

    private static StackTraceElement[] getStackTrace() {
        return new Throwable().getStackTrace();
    }

    public static Object getUncaughtExceptionHandler(Thread thread) {
        Object handler = threads.obtain(thread).getHandler();
        return handler != null ? handler : thread.getThreadGroup();
    }

    public static void setUncaughtExceptionHandler(Thread thread, Object handler) {
        threads.obtain(thread).setHandler(handler);
    }

    private synchronized Object getHandler() {
        return this.handler;
    }

    private synchronized void setHandler(Object handler) {
        this.handler = handler;
    }

    public static void start(Thread thread) {
        thread.start();
        _Thread.threads.obtain((Thread)thread).started = true;
    }

    public static Thread_State_ getState(Thread thread) {
        if (thread.isAlive()) {
            return Thread_State_.RUNNABLE;
        }
        if (_Thread.threads.obtain((Thread)thread).started) {
            return Thread_State_.TERMINATED;
        }
        return Thread_State_.NEW;
    }

    public static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        ThreadGroup parent;
        HashMap<Thread, StackTraceElement[]> result = new HashMap<Thread, StackTraceElement[]>();
        Thread currentThread = Thread.currentThread();
        ThreadGroup group = currentThread.getThreadGroup();
        while ((parent = group.getParent()) != null) {
            group = parent;
        }
        Thread[] threads = new Thread[group.activeCount() + 1];
        int count = group.enumerate(threads);
        while (count == threads.length) {
            threads = new Thread[threads.length * 2];
            count = group.enumerate(threads);
        }
        for (int i2 = 0; i2 < count; ++i2) {
            Thread thread = threads[i2];
            if (!thread.isAlive()) continue;
            result.put(thread, thread == currentThread ? _Thread.getStackTrace() : EMPTY_STACK_TRACE);
        }
        return result;
    }

    private static class RunnableWrapper
    implements Runnable {
        private Runnable target;

        private RunnableWrapper(Runnable target) {
            this.target = target;
        }

        public void run() {
            try {
                this.target.run();
            }
            catch (Throwable e2) {
                _Thread.processException(e2);
            }
        }

        protected static Runnable wrap(Runnable target) {
            return target == null || target instanceof RunnableWrapper ? target : new RunnableWrapper(target);
        }
    }

    public static class AdvancedThreadBuilder {
        private ThreadGroup group;
        private Runnable target;
        private String name;
        private long stackSize;

        protected AdvancedThreadBuilder(ThreadGroup group, Runnable target, String name, long stackSize) {
            this.group = group;
            this.target = target;
            this.name = name;
            this.stackSize = stackSize;
        }

        public ThreadGroup argument1() {
            return this.group;
        }

        public Runnable argument2() {
            return this.target;
        }

        public String argument3() {
            return this.name;
        }

        public long argument4() {
            return this.stackSize;
        }
    }

    public static class BasicThreadBuilder {
        private ThreadGroup group;
        private Runnable target;

        protected BasicThreadBuilder(ThreadGroup group, Runnable target) {
            this.group = group;
            this.target = target;
        }

        public ThreadGroup argument1() {
            return this.group;
        }

        public Runnable argument2() {
            return this.target;
        }
    }
}

