/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.retrotranslator.net.sf.retrotranslator.runtime.java.math;

import java.math.BigDecimal;
import java.math.BigInteger;

public class _BigDecimal {
    public static final BigDecimal ZERO = BigDecimal.valueOf(0L);
    public static final BigDecimal ONE = BigDecimal.valueOf(1L);
    public static final BigDecimal TEN = BigDecimal.valueOf(10L);
    private static final BigInteger[] FIVE_POWERS = new BigInteger[32];

    public static BigInteger convertConstructorArguments(int value) {
        return BigInteger.valueOf(value);
    }

    public static BigInteger convertConstructorArguments(long value) {
        return BigInteger.valueOf(value);
    }

    public static String convertConstructorArguments(char[] in, int offset, int len) {
        return new String(in, offset, len);
    }

    public static String convertConstructorArguments(char[] in) {
        return new String(in);
    }

    public static BigDecimal divide(BigDecimal dividend, BigDecimal divisor) {
        int y2;
        int x2;
        BigInteger p2 = dividend.unscaledValue();
        BigInteger q2 = divisor.unscaledValue();
        if (q2.signum() == 0) {
            throw new ArithmeticException("Division by zero");
        }
        long preferredScale = (long)dividend.scale() - (long)divisor.scale();
        if (p2.signum() == 0) {
            return _BigDecimal.getZero(preferredScale);
        }
        BigInteger gcd = p2.gcd(q2);
        p2 = p2.divide(gcd);
        if ((q2 = q2.divide(gcd)).signum() < 0) {
            p2 = p2.negate();
            q2 = q2.negate();
        }
        BigInteger value = (x2 = q2.getLowestSetBit()) > (y2 = _BigDecimal.log5(q2.shiftRight(x2))) ? _BigDecimal.multiplyBy5Power(p2, x2 - y2) : p2.shiftLeft(y2 - x2);
        int scale = _BigDecimal.castScaleToInt(preferredScale + (long)Math.max(x2, y2));
        return scale >= 0 ? new BigDecimal(value, scale) : new BigDecimal(value, 0).movePointLeft(scale);
    }

    public static BigDecimal[] divideAndRemainder(BigDecimal dividend, BigDecimal divisor) {
        BigDecimal quotient = _BigDecimal.divideToIntegralValue(dividend, divisor);
        BigDecimal[] result = new BigDecimal[]{quotient, dividend.subtract(quotient.multiply(divisor))};
        return result;
    }

    public static BigDecimal divideToIntegralValue(BigDecimal dividend, BigDecimal divisor) {
        BigDecimal quotient = dividend.divide(divisor, 0, 1);
        if (dividend.scale() > divisor.scale()) {
            quotient = quotient.setScale(dividend.scale() - divisor.scale());
        }
        return quotient;
    }

    public static BigDecimal pow(BigDecimal bigDecimal, int n2) {
        if (n2 == 0) {
            return ONE;
        }
        if (n2 < 0 || n2 > 999999999) {
            throw new ArithmeticException("Invalid operation");
        }
        long scale = (long)bigDecimal.scale() * (long)n2;
        return bigDecimal.signum() == 0 ? _BigDecimal.getZero(scale) : new BigDecimal(bigDecimal.unscaledValue().pow(n2), _BigDecimal.castScaleToInt(scale));
    }

    public static BigDecimal remainder(BigDecimal dividend, BigDecimal divisor) {
        return dividend.subtract(_BigDecimal.divideToIntegralValue(dividend, divisor).multiply(divisor));
    }

    public static BigDecimal setScale(BigDecimal bigDecimal, int newScale, int roundingMode) {
        if (newScale >= 0) {
            return bigDecimal.setScale(newScale, roundingMode);
        }
        return bigDecimal.movePointRight(newScale).setScale(0, roundingMode).movePointLeft(newScale);
    }

    public static BigDecimal stripTrailingZeros(BigDecimal bigDecimal) {
        long perfectScale = 0L;
        while ((long)bigDecimal.scale() > perfectScale) {
            long newScale = ((long)bigDecimal.scale() + perfectScale) / 2L;
            try {
                bigDecimal = bigDecimal.setScale((int)newScale);
            }
            catch (ArithmeticException e2) {
                perfectScale = newScale + 1L;
            }
        }
        return bigDecimal;
    }

    public static String toPlainString(BigDecimal bigDecimal) {
        return bigDecimal.toString();
    }

    public static BigDecimal valueOf(double val) {
        return new BigDecimal(Double.toString(val));
    }

    public static BigDecimal valueOf(long val) {
        return BigDecimal.valueOf(val, 0);
    }

    private static int castScaleToInt(long scale) {
        if (scale > Integer.MAX_VALUE) {
            throw new ArithmeticException("Underflow");
        }
        if (scale < Integer.MIN_VALUE) {
            throw new ArithmeticException("Overflow");
        }
        return (int)scale;
    }

    private static BigDecimal getZero(long scale) {
        return BigDecimal.valueOf(0L, (int)Math.max(0L, Math.min(Integer.MAX_VALUE, scale)));
    }

    private static int log5(BigInteger x2) {
        int result = 0;
        int power = 1;
        while (true) {
            BigInteger[] quotientAndReminder;
            if ((quotientAndReminder = x2.divideAndRemainder(FIVE_POWERS[power - 1]))[1].signum() == 0) {
                x2 = quotientAndReminder[0];
                result += power;
                power = Math.min(power + 1, FIVE_POWERS.length);
                continue;
            }
            if (power <= 1) break;
            power /= 2;
        }
        if (x2.bitLength() == 1) {
            return result;
        }
        throw new ArithmeticException("Non-terminating decimal expansion");
    }

    private static BigInteger multiplyBy5Power(BigInteger x2, int power) {
        return power <= FIVE_POWERS.length ? x2.multiply(FIVE_POWERS[power - 1]) : x2.multiply(FIVE_POWERS[0].pow(power));
    }

    static {
        _BigDecimal.FIVE_POWERS[0] = BigInteger.valueOf(5L);
        for (int i2 = 1; i2 < FIVE_POWERS.length; ++i2) {
            _BigDecimal.FIVE_POWERS[i2] = FIVE_POWERS[i2 - 1].multiply(FIVE_POWERS[0]);
        }
    }
}

