/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.retrotranslator.net.sf.retrotranslator.runtime.java.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.faceless.retrotranslator.net.sf.retrotranslator.runtime.format.FormatContext;
import org.faceless.retrotranslator.net.sf.retrotranslator.runtime.java.io.Closeable_;
import org.faceless.retrotranslator.net.sf.retrotranslator.runtime.java.io.Flushable_;
import org.faceless.retrotranslator.net.sf.retrotranslator.runtime.java.io._Closeable;
import org.faceless.retrotranslator.net.sf.retrotranslator.runtime.java.io._Flushable;
import org.faceless.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Appendable;
import org.faceless.retrotranslator.net.sf.retrotranslator.runtime.java.util.Formattable_;
import org.faceless.retrotranslator.net.sf.retrotranslator.runtime.java.util.FormatterClosedException_;

public class Formatter_
implements Closeable_,
Flushable_ {
    private Object out;
    private Locale locale;
    private IOException ioException;

    public Formatter_() {
        this(null, Locale.getDefault());
    }

    public Formatter_(Object a2) {
        this(a2, Locale.getDefault());
    }

    public Formatter_(Locale l2) {
        this(null, l2);
    }

    public Formatter_(Object a2, Locale l2) {
        this.out = a2 != null ? a2 : new StringBuffer();
        this.locale = l2;
    }

    public Formatter_(String fileName) throws FileNotFoundException {
        this(new FileOutputStream(fileName));
    }

    public Formatter_(String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(fileName, csn, Locale.getDefault());
    }

    public Formatter_(String fileName, String csn, Locale l2) throws FileNotFoundException, UnsupportedEncodingException {
        this(new FileOutputStream(fileName), csn, l2);
    }

    public Formatter_(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public Formatter_(File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(file, csn, Locale.getDefault());
    }

    public Formatter_(File file, String csn, Locale l2) throws FileNotFoundException, UnsupportedEncodingException {
        this(new FileOutputStream(file), csn, l2);
    }

    public Formatter_(PrintStream ps) {
        this(Formatter_.assertNotNull(ps), Locale.getDefault());
    }

    public Formatter_(OutputStream os) {
        this(new BufferedWriter(new OutputStreamWriter(os)));
    }

    public Formatter_(OutputStream os, String csn) throws UnsupportedEncodingException {
        this(os, csn, Locale.getDefault());
    }

    public Formatter_(OutputStream os, String csn, Locale l2) throws UnsupportedEncodingException {
        this(new BufferedWriter(new OutputStreamWriter(os, csn)), l2);
    }

    public Locale locale() {
        this.assertOpen();
        return this.locale;
    }

    public Object out() {
        this.assertOpen();
        return this.out;
    }

    public String toString() {
        this.assertOpen();
        return this.out.toString();
    }

    public void flush() {
        this.assertOpen();
        if (_Flushable.executeInstanceOfInstruction(this.out)) {
            try {
                _Flushable.flush(_Flushable.executeCheckCastInstruction(this.out));
            }
            catch (IOException e2) {
                this.ioException = e2;
            }
        }
    }

    public void close() {
        if (this.out == null) {
            return;
        }
        if (_Closeable.executeInstanceOfInstruction(this.out)) {
            try {
                _Closeable.close(_Closeable.executeCheckCastInstruction(this.out));
            }
            catch (IOException e2) {
                this.ioException = e2;
            }
        }
        this.out = null;
    }

    public IOException ioException() {
        return this.ioException;
    }

    public Formatter_ format(String format, Object[] args) {
        return this.format(this.locale, format, args);
    }

    public Formatter_ format(Locale locale, String format, Object[] args) {
        this.assertOpen();
        new FormatterContext(locale).printf(format, args);
        return this;
    }

    private static Object assertNotNull(Object appendable) {
        if (appendable == null) {
            throw new NullPointerException();
        }
        return appendable;
    }

    private void assertOpen() {
        if (this.out == null) {
            throw new FormatterClosedException_();
        }
    }

    private class FormatterContext
    extends FormatContext {
        public FormatterContext(Locale locale) {
            super(locale);
        }

        public void append(char c2) {
            try {
                _Appendable.append(Formatter_.this.out, c2);
            }
            catch (IOException e2) {
                Formatter_.this.ioException = e2;
            }
        }

        public void append(String s2) {
            try {
                _Appendable.append(Formatter_.this.out, s2);
            }
            catch (IOException e2) {
                Formatter_.this.ioException = e2;
            }
        }

        public void append(String s2, int start, int end) {
            try {
                _Appendable.append(Formatter_.this.out, s2, start, end);
            }
            catch (IOException e2) {
                Formatter_.this.ioException = e2;
            }
        }

        public boolean writeFormattable() {
            if (!(this.getArgument() instanceof Formattable_)) {
                return false;
            }
            Formatter_ formatter = Formatter_.this;
            if (this.getLocale() != formatter.locale) {
                formatter = new Formatter_(Formatter_.this.out, this.getLocale());
            }
            int formatFlags = 0;
            if (this.isFlag('-')) {
                formatFlags |= 1;
            }
            if (this.isUpperCase()) {
                formatFlags |= 2;
            }
            if (this.isFlag('#')) {
                formatFlags |= 4;
            }
            ((Formattable_)this.getArgument()).formatTo(formatter, formatFlags, this.getWidth(), this.getPrecision());
            return true;
        }
    }
}

